/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.server;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import COM.ibm.raleigh.ddnssgui.common.TraceServer;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Authorize;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConfigData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConnectionStatus;
import COM.ibm.raleigh.tcp.tcpcfg2.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.HostsData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookProfile;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ResolvData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ServerProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SetupData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpstartData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TimedData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;

public class ServerDaemon {
    public static final String cStmt1 = new String("Licensed Materials = Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n");
    public static final String cStmt2 = new String("US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.");
    public static final String appVersion = new String("TCP/IP Configuration Notebook Tcpcfg2 version 1.0");
    public static final String modVersion = new String("This Class Version 1.0");
    public static final String RESPOND_TO_SAVE = new String(String.valueOf(ServerProxy.BNB_tag) + "," + "SAVE_FINISHED" + "," + ServerProxy.ENB_tag + ",");
    public static final int TRACE_FILE_SIZE = 1000000;
    private String theETCpath;
    private String traceFileName;
    private static final String TCPCFG2_TRACE_FILE_NAME = "tcpcfg2";
    private static final String Notebook_BNB_tag = "Bnb";
    private ServerProxy myServerProxy;
    private NotebookProfile myNotebookProfile;
    private SetupData mySetupData;
    private SocksData mySocksData;
    private ConfigData myConfigData;
    private ResolvData myResolvData;
    private HostsData myHostsData;
    private TcpstartData myTcpstartData;
    private UserData myUserData;
    private NFSData myNFSData;
    private TimedData myTimedData;
    private ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private String lastAction;
    private Authorize myAuthorize;
    private ConnectionStatus myConnectionStatus;
    private boolean authRequired = true;
    private boolean rebootServer = false;
    private TraceClient myServerTraceClient;
    private TraceServer myTraceServer;
    private boolean myTrace = false;

    public ServerDaemon(ResourceBundle resourceBundle) {
        this.initSelf();
        this.myBundle = resourceBundle;
        this.myTrace = Utility.isTraceOn();
        NativeData.getPaths();
        NativeData.getLprPortdPorts();
        this.theETCpath = NativeData.getEtcPath();
        this.initTrace();
        this.myErrorListController = new ErrorListController();
        this.myErrorListController.setLoadMessages(true);
    }

    public boolean initSelf() {
        if (this.mySetupData != null) {
            this.mySetupData.closeOOCS();
        }
        if (this.mySocksData != null) {
            this.mySocksData.closeOOCS();
        }
        if (this.myConfigData != null) {
            this.myConfigData.closeOOCS();
        }
        if (this.myResolvData != null) {
            this.myResolvData.closeOOCS();
        }
        if (this.myHostsData != null) {
            this.myHostsData.closeOOCS();
        }
        if (this.myTcpstartData != null) {
            this.myTcpstartData.closeOOCS();
        }
        if (this.myUserData != null) {
            this.myUserData.closeOOCS();
        }
        this.myServerProxy = null;
        this.myNotebookProfile = null;
        this.mySetupData = null;
        this.mySocksData = null;
        this.myConfigData = null;
        this.myResolvData = null;
        this.myHostsData = null;
        this.myTcpstartData = null;
        this.myUserData = null;
        this.myAuthorize = null;
        this.myConnectionStatus = null;
        this.myErrorListController = new ErrorListController();
        this.myErrorListController.setLoadMessages(true);
        this.lastAction = "";
        if (this.rebootServer) {
            if (this.myTrace) {
                System.out.println("REBOOT SERVER CALL - ServerDaemon.initSelf() - CALL setBoot()");
            }
            NativeData.rebootServer();
            return false;
        }
        return true;
    }

    private void initTrace() {
        this.traceFileName = new String(String.valueOf(this.theETCpath) + TCPCFG2_TRACE_FILE_NAME);
        this.myTraceServer = new TraceServer(15223, this.traceFileName, 1000000);
        this.myTraceServer.start();
        this.myServerTraceClient = new TraceClient("ServerDaemon", "In constructor - Setting up TraceClient", false, 15223, null);
    }

    public void sendAcrossNetwork(String string) {
        this.recFromNetwork(string);
    }

    public String getLastAction() {
        return this.lastAction;
    }

    public boolean isAuthorizationRequired() {
        return true;
    }

    public ConnectionStatus getConnectionStatusHandle() {
        return this.myConnectionStatus;
    }

    public String recFromNetwork(String string) {
        DDNSNetworkStringParser dDNSNetworkStringParser = new DDNSNetworkStringParser(string, this.myServerTraceClient);
        ParsedVector parsedVector = dDNSNetworkStringParser.getParsed();
        ParsedObject parsedObject = parsedVector.getFirstElement();
        if (parsedObject.getKey().equals(Notebook_BNB_tag)) {
            if (this.myTrace) {
                System.out.println("in ServerDaemon.recFromNetwork - calling handleNotebookActions");
            }
            this.lastAction = this.handleNotebookActions(parsedVector, parsedObject, string);
        } else if (parsedObject.getKey().equals(Authorize.BDS_tag)) {
            this.lastAction = this.handleSecurityActions(parsedVector, parsedObject, string);
        } else if (parsedObject.getKey().equals(ConnectionStatus.BCS_tag)) {
            this.lastAction = this.handleConnectionStatus(parsedVector, parsedObject, string);
        } else if (this.myTrace) {
            System.out.println("POSSIBLE ERROR - ServerDaemon recFromNetwork() - Key is " + parsedObject.getKey());
        }
        return this.lastAction;
    }

    private String handleConnectionStatus(ParsedVector parsedVector, ParsedObject parsedObject, String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (parsedObject.getValue().equals(ConnectionStatus.DATA_ID)) {
            stringBuffer = this.setConnectionStatus(parsedVector);
            bl = true;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    private String handleSecurityActions(ParsedVector parsedVector, ParsedObject parsedObject, String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (parsedObject.getValue().equals(Authorize.SAVE_ID)) {
            stringBuffer = this.saveNotebookPassword(parsedVector);
            bl = true;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    private String handleNotebookActions(ParsedVector parsedVector, ParsedObject parsedObject, String string) {
        StringBuffer stringBuffer = null;
        boolean bl = false;
        String string2 = new String("SAVE_");
        String string3 = (String)parsedObject.getValue();
        try {
            if (this.myTrace) {
                System.out.println("Serverdaemon.handleNotebookActions - substring = " + string3.substring(0, 5));
            }
            if (string3.substring(0, 5).equals(string2)) {
                if (this.myTrace) {
                    System.out.println("in ServerDaemon.handleNotebookActions - save tag");
                }
                stringBuffer = new StringBuffer(RESPOND_TO_SAVE);
                if (this.myErrorListController.isLoadMessages()) {
                    this.myErrorListController = new ErrorListController();
                    this.myErrorListController.setLoadMessages(false);
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringBuffer = new StringBuffer();
        }
        if (this.myTrace) {
            if (stringBuffer == null) {
                System.out.println("in ServerDaemon.handleNotebookActions - rtnString is null");
            } else {
                System.out.println("in ServerDaemon.handleNotebookActions - rtnString is not null = " + stringBuffer.toString());
            }
        }
        if (parsedObject.getValue().equals(SetupData.LOAD_ID)) {
            stringBuffer = this.loadSetupData();
            bl = true;
        } else if (parsedObject.getValue().equals(SocksData.LOAD_ID)) {
            stringBuffer = this.loadSocksData();
            bl = true;
        } else if (parsedObject.getValue().equals(ConfigData.LOAD_ID)) {
            stringBuffer = this.loadConfigData();
            bl = true;
        } else if (parsedObject.getValue().equals(ResolvData.LOAD_ID)) {
            stringBuffer = this.loadResolvData();
            bl = true;
        } else if (parsedObject.getValue().equals(HostsData.LOAD_ID)) {
            stringBuffer = this.loadHostsData();
            bl = true;
        } else if (parsedObject.getValue().equals(TcpstartData.LOAD_ID)) {
            stringBuffer = this.loadTcpstartData();
            bl = true;
        } else if (parsedObject.getValue().equals(UserData.LOAD_ID)) {
            stringBuffer = this.loadUserData();
            bl = true;
        } else if (parsedObject.getValue().equals(NFSData.LOAD_ID)) {
            stringBuffer = this.loadNFSData();
            bl = true;
        } else if (parsedObject.getValue().equals(TimedData.LOAD_ID)) {
            stringBuffer = this.loadTimedData();
            bl = true;
        } else if (parsedObject.getValue().equals(ConfigData.SAVE_ID)) {
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(SetupData.SAVE_ID)) {
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(SocksData.SAVE_ID)) {
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(ResolvData.SAVE_ID)) {
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(HostsData.SAVE_ID)) {
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(TcpstartData.SAVE_ID)) {
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(UserData.SAVE_ID)) {
            if (this.myTrace) {
                System.out.println("ServerDaemon.handleNotebookActions - tag is UserData.SAVE_ID");
            }
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(NFSData.SAVE_ID)) {
            System.out.println("tag in ServerDaemon is NFSData.SAVE_ID");
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(TimedData.SAVE_ID)) {
            System.out.println("tag in ServerDaemon is TimedData.SAVE_ID");
            this.fromString(parsedVector);
            bl = true;
        } else if (parsedObject.getValue().equals(ErrorListController.PROCESS_ID)) {
            stringBuffer = this.processErrorList();
            bl = true;
        } else if (parsedObject.getValue().equals(ErrorListController.GET_ID)) {
            stringBuffer = this.getErrorList();
            bl = true;
        } else if (parsedObject.getValue().equals(ServerProxy.REBOOT_tag)) {
            stringBuffer = new StringBuffer(RESPOND_TO_SAVE);
            this.rebootServer = true;
            bl = true;
        } else if (parsedObject.getValue().equals("DISCONNECT")) {
            bl = true;
        }
        if (this.myTrace) {
            if (stringBuffer == null) {
                System.out.println("finishing ServerDaemon.handleNotebookActions - rtnString is null");
            } else {
                System.out.println("finishing ServerDaemon.handleNotebookActions - rtnString is not null = " + stringBuffer.toString());
            }
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    private StringBuffer setConnectionStatus(ParsedVector parsedVector) {
        this.myConnectionStatus = new ConnectionStatus(parsedVector);
        this.myConnectionStatus.setFileSeparator(System.getProperty("file.separator"));
        StringBuffer stringBuffer = new StringBuffer(this.myConnectionStatus.toString());
        return stringBuffer;
    }

    private StringBuffer saveNotebookPassword(ParsedVector parsedVector) {
        Object object;
        this.myAuthorize = new Authorize(parsedVector);
        String string = NativeData.getEtcPath();
        String string2 = String.valueOf(string) + File.separator + "adminpw.pub";
        String string3 = String.valueOf(string) + File.separator + "adminpw.pvt";
        TcpError tcpError = null;
        try {
            object = new FileOutputStream(string2);
            ((FileOutputStream)object).write(this.myAuthorize.getPubPw());
            ((FileOutputStream)object).close();
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            fileOutputStream.write(this.myAuthorize.getPvtPw());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            tcpError = new TcpError(this.myBundle.getString("ERROR_WRITING_PASSWORD"), 0);
            this.myErrorListController.addError(tcpError);
        }
        object = new StringBuffer(this.myAuthorize.toString());
        return object;
    }

    private StringBuffer getErrorList() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + ErrorListController.DATA_ID + "," + this.myErrorListController.toString() + "," + ServerProxy.ENB_tag + ",");
        return stringBuffer;
    }

    private StringBuffer processErrorList() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    private StringBuffer loadSetupData() {
        this.mySetupData = new SetupData(true, this.myErrorListController);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + SetupData.DATA_ID + "," + this.mySetupData.toString() + "," + ServerProxy.ENB_tag + ",");
        return stringBuffer;
    }

    private StringBuffer loadSocksData() {
        this.mySocksData = new SocksData(true, this.myErrorListController);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + SocksData.DATA_ID + "," + this.mySocksData.toString() + "," + ServerProxy.ENB_tag + ",");
        return stringBuffer;
    }

    private StringBuffer loadConfigData() {
        this.myConfigData = new ConfigData(true, this.myErrorListController);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + ConfigData.DATA_ID + "," + this.myConfigData.toString() + "," + ServerProxy.ENB_tag + ",");
        return stringBuffer;
    }

    private StringBuffer loadResolvData() {
        this.myResolvData = new ResolvData(true, this.myErrorListController);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + ResolvData.DATA_ID + "," + this.myResolvData.toString() + "," + ServerProxy.ENB_tag + ",");
        return stringBuffer;
    }

    private StringBuffer loadHostsData() {
        this.myHostsData = new HostsData(true, this.myErrorListController);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + HostsData.DATA_ID + "," + this.myHostsData.toString() + "," + ServerProxy.ENB_tag + ",");
        return stringBuffer;
    }

    private StringBuffer loadTcpstartData() {
        this.myTcpstartData = new TcpstartData(true, this.myErrorListController);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + TcpstartData.DATA_ID + "," + this.myTcpstartData.toString() + "," + ServerProxy.ENB_tag + ",");
        return stringBuffer;
    }

    private StringBuffer loadNFSData() {
        this.myNFSData = new NFSData(true, this.myErrorListController);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + NFSData.DATA_ID + "," + this.myNFSData.toString() + "," + ServerProxy.ENB_tag + ",");
        return stringBuffer;
    }

    private StringBuffer loadTimedData() {
        this.myTimedData = new TimedData(true, this.myErrorListController);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + TimedData.DATA_ID + "," + this.myTimedData.toString() + "," + ServerProxy.ENB_tag + ",");
        System.out.println("In ServerDaemon.loadTimedData - string = " + this.myTimedData.toString());
        return stringBuffer;
    }

    private StringBuffer loadUserData() {
        if (this.myUserData == null) {
            if (this.myTrace) {
                System.out.println("ServerDaemon.loadUserData - first time, create UserData");
            }
            this.myUserData = new UserData(true, this.myErrorListController);
            if (this.myTrace) {
                System.out.println("NEW UserData master - myUserData.getLastUserLoaded() = " + this.myUserData.getLastUserLoaded() + " myUserData.getUsersOnDiskCnt() = " + this.myUserData.getUsersOnDiskCnt());
            }
        }
        StringBuffer stringBuffer = null;
        if (this.myUserData.getUsersOnDiskCnt() <= 50) {
            stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + UserData.DATA_ID + "," + this.myUserData.toString() + "," + ServerProxy.ENB_tag + ",");
        } else {
            int n = 0;
            int n2 = this.myUserData.getLastUserLoaded();
            int n3 = this.myUserData.getUsersOnDiskCnt() - n2;
            n = n3 > 50 ? 50 : n3;
            UserData userData = new UserData();
            if (this.myTrace) {
                System.out.println("remainder = " + n3 + " numberOfUsersToLoad = " + n + " lastUserLoaded = " + n2);
            }
            int n4 = 0;
            while (n4 < n) {
                userData.addUserEntry(this.myUserData.getUserEntry(n2 + n4));
                ++n4;
            }
            this.myUserData.setLastUserLoadedCnt(n2 + n);
            userData.setUsersOnDiskCnt(this.myUserData.getUsersOnDiskCnt());
            stringBuffer = new StringBuffer(String.valueOf(ServerProxy.BNB_tag) + "," + UserData.DATA_ID + "," + userData.toString() + "," + ServerProxy.ENB_tag + ",");
            if (this.myTrace) {
                System.out.println("Creating user chunks from  UserData master - myUserData.getLastUserLoaded() = " + this.myUserData.getLastUserLoaded() + " myUserData.getUsersOnDiskCnt() = " + this.myUserData.getUsersOnDiskCnt());
            }
        }
        return stringBuffer;
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            ParsedVector parsedVector2;
            ParsedObject parsedObject;
            if (stringArray[n].equals(SetupData.BSE_tag)) {
                parsedObject = parsedVector.getElement(SetupData.BSE_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.mySetupData.fromString(parsedVector2);
                    this.mySetupData.saveToOOCS();
                }
            } else if (stringArray[n].equals(SocksData.BSO_tag)) {
                parsedObject = parsedVector.getElement(SocksData.BSO_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.mySocksData.fromString(parsedVector2);
                    this.mySocksData.saveToOOCS();
                }
            } else if (stringArray[n].equals(ConfigData.BCO_tag)) {
                parsedObject = parsedVector.getElement(ConfigData.BCO_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.myConfigData.fromString(parsedVector2);
                    this.myConfigData.saveToOOCS();
                }
            } else if (stringArray[n].equals(ResolvData.BRE_tag)) {
                parsedObject = parsedVector.getElement(ResolvData.BRE_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.myResolvData.fromString(parsedVector2);
                    this.myResolvData.saveToOOCS();
                }
            } else if (stringArray[n].equals(HostsData.BHD_tag)) {
                parsedObject = parsedVector.getElement(HostsData.BHD_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.myHostsData.fromString(parsedVector2);
                    this.myHostsData.saveToOOCS();
                }
            } else if (stringArray[n].equals(TcpstartData.BTC_tag)) {
                parsedObject = parsedVector.getElement(TcpstartData.BTC_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.myTcpstartData.fromString(parsedVector2);
                    this.myTcpstartData.saveToOOCS();
                }
            } else if (stringArray[n].equals(NFSData.BNO_tag)) {
                parsedObject = parsedVector.getElement(NFSData.BNO_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.myNFSData.fromString(parsedVector2);
                    this.myNFSData.saveToOOCS();
                }
            } else if (stringArray[n].equals(TimedData.BTD_tag)) {
                parsedObject = parsedVector.getElement(TimedData.BTD_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.myTimedData.fromString(parsedVector2);
                    this.myTimedData.saveToOOCS();
                }
            } else if (stringArray[n].equals(UserData.BUD_tag)) {
                if (this.myTrace) {
                    System.out.println("key = BUD_tag in ServerDaemon.fromString");
                }
                parsedObject = parsedVector.getElement(UserData.BUD_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                boolean bl = true;
                if (parsedVector2 != null) {
                    if (this.myUserData != null && this.myUserData.getUserEntryListSize() == this.myUserData.getUsersOnDiskCnt()) {
                        if (this.myTrace) {
                            System.out.println("deleting user entry list in ServerDaemon.fromString");
                        }
                        this.myUserData.deleteUserEntryList();
                        this.myUserData.fromString(parsedVector2);
                    } else {
                        bl = false;
                    }
                    if (this.myTrace) {
                        System.out.println("SAVE0 - user chunks from  UserData master - myUserData.getUserEntryListSize() = " + this.myUserData.getUserEntryListSize() + " myUserData.getUsersOnDiskCnt() = " + this.myUserData.getUsersOnDiskCnt());
                    }
                    if (!bl) {
                        UserData userData = new UserData();
                        userData.fromString(parsedVector2);
                        int n2 = userData.getUserEntryListSize();
                        int n3 = 0;
                        while (n3 < n2) {
                            this.myUserData.addUserEntry(userData.getUserEntry(n3));
                            ++n3;
                        }
                    }
                    if (this.myTrace) {
                        System.out.println("SAVE1 - user chunks from  UserData master - myUserData.getUserEntryListSize() = " + this.myUserData.getUserEntryListSize() + " myUserData.getUsersOnDiskCnt() = " + this.myUserData.getUsersOnDiskCnt());
                    }
                    if (this.myUserData.getUserEntryListSize() == this.myUserData.getUsersOnDiskCnt()) {
                        this.myUserData.saveToOOCS();
                    }
                }
            }
            ++n;
        }
    }

    public String getETCpath() {
        return this.theETCpath;
    }

    public void setETCpath(String string) {
        this.theETCpath = new String(string);
    }

    public void startTrace() {
        this.myServerTraceClient.setTraceState(true);
    }

    public void traceThis(String string) {
        this.myServerTraceClient.traceTime("ServerDaemon", string);
    }
}

