/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    private byte[] buf = null;

    public BinaryRefAddr(String string, byte[] byArray) {
        this(string, byArray, 0, byArray.length);
    }

    public BinaryRefAddr(String string, byte[] byArray, int n, int n2) {
        super(string);
        this.buf = new byte[n2];
        System.arraycopy(byArray, n, this.buf, 0, n2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BinaryRefAddr) {
            BinaryRefAddr binaryRefAddr = (BinaryRefAddr)object;
            if (this.addrType.compareTo(binaryRefAddr.addrType) == 0) {
                if (this.buf == null && binaryRefAddr.buf == null) {
                    return true;
                }
                if (this.buf == null || binaryRefAddr.buf == null || this.buf.length != binaryRefAddr.buf.length) {
                    return false;
                }
                int n = 0;
                while (n < this.buf.length) {
                    if (this.buf[n] != binaryRefAddr.buf[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public Object getContent() {
        return this.buf;
    }

    public int hashCode() {
        int n = this.addrType.hashCode();
        int n2 = 0;
        while (n2 < this.buf.length) {
            n += this.buf[n2];
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Address Type: " + this.addrType + "\n");
        stringBuffer.append("AddressContents: ");
        int n = 0;
        while (n < this.buf.length && n < 32) {
            stringBuffer.append(String.valueOf(Integer.toHexString(this.buf[n])) + " ");
            ++n;
        }
        if (this.buf.length >= 32) {
            stringBuffer.append(" ...\n");
        }
        return stringBuffer.toString();
    }
}

