/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class BasicAttributes
implements Attributes {
    private boolean ignoreCase = false;
    transient Hashtable attrs = new Hashtable(11);

    public BasicAttributes() {
    }

    public BasicAttributes(String string, Object object) {
        this();
        this.put(new BasicAttribute(string, object));
    }

    public BasicAttributes(String string, Object object, boolean bl) {
        this(bl);
        this.put(new BasicAttribute(string, object));
    }

    public BasicAttributes(boolean bl) {
        this.ignoreCase = bl;
    }

    public Object clone() {
        BasicAttributes basicAttributes;
        try {
            basicAttributes = (BasicAttributes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            basicAttributes = new BasicAttributes(this.ignoreCase);
        }
        basicAttributes.attrs = (Hashtable)this.attrs.clone();
        return basicAttributes;
    }

    public Attribute get(String string) {
        Attribute attribute = (Attribute)this.attrs.get(this.ignoreCase ? string.toLowerCase() : string);
        return attribute;
    }

    public NamingEnumeration getAll() {
        return new AttrEnumImpl();
    }

    public NamingEnumeration getIDs() {
        return new IDEnumImpl();
    }

    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    public Attribute put(String string, Object object) {
        return this.put(new BasicAttribute(string, object));
    }

    public Attribute put(Attribute attribute) {
        String string = attribute.getID();
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        return this.attrs.put(string, attribute);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.attrs = n >= 1 ? new Hashtable(n * 2) : new Hashtable(2);
        while (--n >= 0) {
            this.put((Attribute)objectInputStream.readObject());
        }
    }

    public Attribute remove(String string) {
        String string2 = this.ignoreCase ? string.toLowerCase() : string;
        return (Attribute)this.attrs.remove(string2);
    }

    public int size() {
        return this.attrs.size();
    }

    public String toString() {
        if (this.attrs.size() == 0) {
            return "No attributes";
        }
        return this.attrs.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.attrs.size());
        Enumeration enumeration = this.attrs.elements();
        while (enumeration.hasMoreElements()) {
            objectOutputStream.writeObject(enumeration.nextElement());
        }
    }

    class AttrEnumImpl
    implements NamingEnumeration {
        Enumeration elements;

        public AttrEnumImpl() {
            this.elements = BasicAttributes.this.attrs.elements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.elements.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            return this.elements.nextElement();
        }
    }

    class IDEnumImpl
    implements NamingEnumeration {
        Enumeration elements;

        public IDEnumImpl() {
            this.elements = BasicAttributes.this.attrs.elements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.elements.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            Attribute attribute = (Attribute)this.elements.nextElement();
            return attribute.getID();
        }
    }
}

