/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.iiop;

import com.sun.rmi.IOR;
import com.sun.rmi.MarshalOutputStream;
import com.sun.rmi.ServerGIOP;
import com.sun.rmi.iiop.ConnectionTable;
import com.sun.rmi.iiop.IIOPInputStream;
import com.sun.rmi.iiop.IIOPOutputStream;
import com.sun.rmi.iiop.LocateReplyMessage;
import com.sun.rmi.iiop.LocateRequestMessage;
import com.sun.rmi.iiop.ORB;
import com.sun.rmi.util.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;

public abstract class Connection {
    public static final int CONN_ABORT = 1;
    public static final int CONN_REBIND = 2;
    protected boolean debug = false;
    protected ORB orb;
    protected Socket socket;
    protected long timeStamp;
    protected boolean isServer = false;
    protected ConnectionTable connectionTable;
    protected static String localHostString = null;

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    void dprint(String string) {
        Utility.dprint(this, string);
    }

    public ORB getORB() {
        return this.orb;
    }

    Socket getSocket() {
        return this.socket;
    }

    public static Socket newSocket(ORB oRB, String string, int n) throws IOException {
        return new Socket(string, n);
    }

    public abstract IIOPInputStream invoke(IIOPOutputStream var1) throws SystemException;

    public abstract void delete();

    public abstract InputStream getInputStream();

    public abstract ServerGIOP getServerGIOP();

    public abstract IIOPInputStream send(IIOPOutputStream var1, boolean var2);

    public abstract void sendReply(MarshalOutputStream var1) throws Exception;

    public abstract IIOPInputStream createInputStream() throws Exception;

    public abstract void cleanUp() throws Exception;

    public abstract boolean isBusy();

    public abstract void requestBegins();

    public abstract void requestEnds();

    public abstract void print();

    public abstract void setConnection(Socket var1, ConnectionTable var2) throws Exception;

    public abstract void abortConnection();

    public abstract boolean isPostInitialContexts();

    public abstract void setPostInitialContexts();

    public IOR locate(int n, byte[] byArray) {
        LocateRequestMessage locateRequestMessage = new LocateRequestMessage(n, byArray);
        IIOPOutputStream iIOPOutputStream = this.orb.newOutputStream(this);
        locateRequestMessage.write(iIOPOutputStream);
        iIOPOutputStream.setMessage(locateRequestMessage);
        IIOPInputStream iIOPInputStream = this.send(iIOPOutputStream, false);
        LocateReplyMessage locateReplyMessage = (LocateReplyMessage)iIOPInputStream.getMessage();
        switch (locateReplyMessage.getRequestStatus()) {
            case 0: {
                throw new OBJECT_NOT_EXIST(1, CompletionStatus.COMPLETED_NO);
            }
            case 1: {
                return null;
            }
            case 2: {
                IOR iOR = new IOR(this.orb);
                iOR.read(iIOPInputStream);
                return iOR;
            }
        }
        throw new INTERNAL(9, CompletionStatus.COMPLETED_NO);
    }

    public static String getLocalHost() {
        if (localHostString != null) {
            return localHostString;
        }
        try {
            localHostString = InetAddress.getLocalHost().getHostAddress();
            return localHostString;
        }
        catch (Exception exception) {
            throw new INTERNAL(7, CompletionStatus.COMPLETED_NO);
        }
    }

    public void stampTime() {
        this.connectionTable.stampTime(this);
    }
}

