/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.iiop;

import com.sun.rmi.ServerGIOP;
import com.sun.rmi.iiop.Connection;
import com.sun.rmi.iiop.ConnectionKey;
import com.sun.rmi.iiop.IIOPConnection;
import com.sun.rmi.iiop.ORB;
import com.sun.rmi.util.Utility;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class ConnectionTable {
    protected ORB orb;
    protected Hashtable connectionCache = new Hashtable();
    protected long globalCounter;
    private int MAX_SOCKET_RETRIES = 5;
    protected ServerGIOP server;
    private static final int LOW_WATER_MARK = 100;
    private static final int HIGH_WATER_MARK = 240;
    private static final int NCLEAN = 5;

    public ConnectionTable(ORB oRB, ServerGIOP serverGIOP) {
        this.orb = oRB;
        this.server = serverGIOP;
    }

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public ConnectionKey createKey(String string, int n) {
        return new ConnectionKey(string, n);
    }

    public Connection get(String string, int n) {
        ConnectionKey connectionKey = this.createKey(string, n);
        Connection connection = (Connection)this.connectionCache.get(connectionKey);
        if (connection != null) {
            return connection;
        }
        Object object = this;
        synchronized (object) {
            connection = (Connection)this.connectionCache.get(connectionKey);
            if (connection != null) {
                Connection connection2 = connection;
                Object var7_9 = null;
                return connection2;
            }
            connection = new IIOPConnection(this.orb, this.server, this, string, n);
            this.stampTime(connection);
            this.connectionCache.put(connectionKey, connection);
        }
        int n2 = 0;
        while (true) {
            try {
                object = Connection.newSocket(this.orb, string, n);
                try {
                    ((Socket)object).setTcpNoDelay(true);
                }
                catch (Exception exception) {}
                connection.setConnection((Socket)object, this);
                this.checkConnectionTable();
            }
            catch (SocketException socketException) {
                if (socketException instanceof BindException || socketException instanceof ConnectException || socketException instanceof NoRouteToHostException) {
                    connection.abortConnection();
                    throw new COMM_FAILURE(1, CompletionStatus.COMPLETED_NO);
                }
                if (n2 == this.MAX_SOCKET_RETRIES || !this.cleanUp()) {
                    connection.abortConnection();
                    throw new COMM_FAILURE(1, CompletionStatus.COMPLETED_NO);
                }
                ++n2;
                continue;
            }
            catch (Exception exception) {
                connection.abortConnection();
                throw new COMM_FAILURE(1, CompletionStatus.COMPLETED_NO);
            }
            break;
        }
        return connection;
    }

    public synchronized Connection get(Socket socket) {
        try {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = socket.getInputStream();
                outputStream = socket.getOutputStream();
            }
            catch (Exception exception) {
                throw new COMM_FAILURE(1, CompletionStatus.COMPLETED_NO);
            }
            String string = socket.getInetAddress().getHostName();
            int n = socket.getPort();
            IIOPConnection iIOPConnection = new IIOPConnection(this.orb, this.server, string, n, socket, inputStream, outputStream, this);
            ConnectionKey connectionKey = this.createKey(string, n);
            this.connectionCache.put(connectionKey, iIOPConnection);
            this.stampTime(iIOPConnection);
            return iIOPConnection;
        }
        catch (Exception exception) {
            try {
                socket.close();
            }
            catch (Exception exception2) {}
            return null;
        }
    }

    public void deleteConn(String string, int n) {
        ConnectionKey connectionKey = this.createKey(string, n);
        this.connectionCache.remove(connectionKey);
    }

    public boolean cleanUp() {
        if (this.connectionCache.size() < 100) {
            return false;
        }
        int n = 0;
        while (n < 5) {
            Connection connection = null;
            long l = Long.MAX_VALUE;
            Enumeration enumeration = this.connectionCache.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection2 = (Connection)enumeration.nextElement();
                if (connection2.isBusy() || connection2.timeStamp >= l) continue;
                connection = connection2;
                l = connection2.timeStamp;
            }
            if (connection == null) {
                return false;
            }
            try {
                connection.cleanUp();
            }
            catch (Exception exception) {}
            ++n;
        }
        return true;
    }

    public void checkConnectionTable() {
        if (this.connectionCache.size() > 240) {
            this.cleanUp();
        }
    }

    public synchronized void stampTime(Connection connection) {
        connection.timeStamp = this.globalCounter++;
    }

    public synchronized void print() {
        System.out.println("***ConnectionTable***");
        int n = this.connectionCache.size();
        System.out.println("  SIZE=" + n);
        if (n < 10) {
            Enumeration enumeration = this.connectionCache.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                connection.print();
            }
        }
    }
}

