/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.security.AccessControlContextSecurityManager;
import com.ibm.security12.java.security.AccessControlException;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.Policy;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.security.ProtectionDomain;
import com.ibm.security12.sun.security.util.Debug;
import java.util.Vector;

public final class AccessControlContext {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private AccessControlContext privilegedContext;
    static AccessControlContextSecurityManager cSM = new AccessControlContextSecurityManager();
    private static boolean debugAccessInit;
    private static Debug debug;

    static Debug getDebug() {
        if (debugAccessInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugAccessInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray.length == 1) {
            this.context = (ProtectionDomain[])protectionDomainArray.clone();
            return;
        }
        Vector<ProtectionDomain> vector = new Vector<ProtectionDomain>(protectionDomainArray.length);
        int n = 0;
        while (n < protectionDomainArray.length) {
            if (protectionDomainArray[n] != null && !vector.contains(protectionDomainArray[n])) {
                vector.addElement(protectionDomainArray[n]);
            }
            ++n;
        }
        this.context = new ProtectionDomain[vector.size()];
        vector.copyInto(this.context);
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl) {
        this.context = protectionDomainArray;
        this.isPrivileged = bl;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        if (AccessControlContext.getDebug() != null) {
            if (Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    int n = 0;
                    while (n < this.context.length) {
                        debug.println("domain " + n + " " + this.context[n]);
                        ++n;
                    }
                }
            }
        }
        if (this.context == null) {
            return;
        }
        if (this.context.length == 0) {
            return;
        }
        Class[] classArray = cSM.getClassContext();
        int n = 3;
        if (classArray.length >= 8) {
            while (true) {
                String string;
                boolean bl = false;
                boolean bl2 = false;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    while (classArray[n] == securityManager.getClass()) {
                        if (bl) {
                            bl2 = true;
                        } else {
                            bl = true;
                        }
                        ++n;
                    }
                }
                if (!bl2 || classArray.length - n < 3) break;
                if (classArray[n].getName().equals("java.lang.System")) {
                    if (classArray[n + 1].getClassLoader() != null || (string = classArray[n + 1].getName()).indexOf("java.") != 0 && string.indexOf("sun.") != 0) break;
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                if (classArray[n].getName().equals("java.lang.Integer") || classArray[n].getName().equals("java.lang.Boolean") || classArray[n].getName().equals("java.lang.Long")) {
                    if (classArray[n + 1].getClassLoader() != null || (string = classArray[n + 1].getName()).indexOf("java.") != 0 && string.indexOf("sun.") != 0) break;
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                if (classArray[n].getName().equals("java.io.File")) {
                    if (classArray[n + 1].getClassLoader() != null) break;
                    string = classArray[n + 1].getName();
                    if (string.indexOf("java.") == 0 || string.indexOf("sun.") == 0) {
                        if (debug != null) {
                            debug.println("access allowed " + permission);
                        }
                        return;
                    }
                    if (string.indexOf("com.ibm.security12.sun.") != 0) break;
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                if (classArray[n].getName().equals("java.io.FileInputStream")) {
                    if (classArray[n + 1].getClassLoader() != null || (string = classArray[n + 1].getName()).indexOf("java.") != 0 && string.indexOf("sun.") != 0) break;
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                if (classArray[n].getName().equals("java.io.FileOutputStream")) {
                    if (classArray[n + 1].getClassLoader() != null || (string = classArray[n + 1].getName()).indexOf("java.") != 0 && string.indexOf("sun.") != 0) break;
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                if (classArray[n].getName().equals("java.lang.Runtime") && classArray[n + 1].getName().equals("java.lang.System")) {
                    if (classArray[n + 2].getClassLoader() != null || (string = classArray[n + 2].getName()).indexOf("java.") != 0 && string.indexOf("sun.") != 0) break;
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                if (classArray[n].getName().equals("java.lang.ThreadGroup") && classArray[n + 1].getName().equals("java.lang.ThreadGroup")) {
                    if (classArray[n + 2].getClassLoader() != null || (string = classArray[n + 2].getName()).indexOf("sun.awt.") != 0) break;
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                if (classArray[n].getName().equals("java.net.Socket") && classArray[n + 1].getName().equals("java.net.Socket")) {
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                if (classArray[n].getName().equals("java.lang.ClassLoader") && classArray[n + 1].getName().equals("java.util.SystemClassLoader")) {
                    if (debug != null) {
                        debug.println("access allowed " + permission);
                    }
                    return;
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.context.length) {
            if (this.context[n] != null && !this.context[n].implies(permission)) {
                if (debug != null) {
                    debug.println("access denied " + permission);
                    if (Debug.isOn("failure")) {
                        Thread.currentThread();
                        Thread.dumpStack();
                        ProtectionDomain protectionDomain = this.context[n];
                        Debug debug = AccessControlContext.debug;
                        AccessController.doPrivileged(new 1(debug, protectionDomain));
                    }
                }
                throw new AccessControlException("access denied " + permission, permission);
            }
            ++n;
        }
        if (debug != null) {
            debug.println("access allowed " + permission);
        }
    }

    AccessControlContext combineWithPrivilegedContext() {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4;
        boolean bl2;
        boolean bl3 = this.context == null;
        AccessControlContext accessControlContext = this.privilegedContext;
        boolean bl4 = bl2 = accessControlContext.context == null;
        if (bl2 && bl3) {
            return this;
        }
        int n5 = n4 = bl3 ? 0 : this.context.length;
        if (bl2 && n4 <= 2) {
            return this;
        }
        int n6 = n3 = bl2 ? 0 : accessControlContext.context.length;
        if (bl3 && n3 <= 2) {
            return accessControlContext;
        }
        if (n4 == 1 && n3 == 1 && this.context[0] == accessControlContext.context[0]) {
            return this;
        }
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n4 + n3];
        int n7 = 0;
        if (!bl3) {
            n2 = 0;
            while (n2 < this.context.length) {
                bl = true;
                n = 0;
                while (n < n7 && bl) {
                    bl = this.context[n2] != null && this.context[n2] != protectionDomainArray[n];
                    ++n;
                }
                if (bl) {
                    protectionDomainArray[n7++] = this.context[n2];
                }
                ++n2;
            }
        }
        if (!bl2) {
            n2 = 0;
            while (n2 < accessControlContext.context.length) {
                bl = true;
                n = 0;
                while (n < n7 && bl) {
                    bl = accessControlContext.context[n2] != null && accessControlContext.context[n2] != protectionDomainArray[n];
                    ++n;
                }
                if (bl) {
                    protectionDomainArray[n7++] = accessControlContext.context[n2];
                }
                ++n2;
            }
        }
        if (n7 != protectionDomainArray.length) {
            if (n7 == 0) {
                protectionDomainArray = null;
            } else {
                ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n7];
                System.arraycopy(protectionDomainArray, 0, protectionDomainArray2, 0, n7);
                protectionDomainArray = protectionDomainArray2;
            }
        }
        return new AccessControlContext(protectionDomainArray, true);
    }

    AccessControlContext optimize() {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4;
        AccessControlContext accessControlContext;
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = this.context == null;
        if (this.isPrivileged) {
            if (this.privilegedContext != null) {
                return this.combineWithPrivilegedContext();
            }
            bl2 = true;
            accessControlContext = null;
        } else {
            accessControlContext = AccessController.getInheritedAccessControlContext();
            boolean bl5 = bl2 = accessControlContext == null || accessControlContext.context == null;
        }
        if (bl2 && bl3) {
            return this;
        }
        int n5 = n4 = bl3 ? 0 : this.context.length;
        if (bl2 && n4 <= 2) {
            return this;
        }
        int n6 = n3 = bl2 ? 0 : accessControlContext.context.length;
        if (bl3 && n3 <= 2) {
            return accessControlContext;
        }
        if (n4 == 1 && n3 == 1 && this.context[0] == accessControlContext.context[0]) {
            return this;
        }
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n4 + n3];
        int n7 = 0;
        if (!bl3) {
            n2 = 0;
            while (n2 < this.context.length) {
                bl = true;
                n = 0;
                while (n < n7 && bl) {
                    bl = this.context[n2] != null && this.context[n2] != protectionDomainArray[n];
                    ++n;
                }
                if (bl) {
                    protectionDomainArray[n7++] = this.context[n2];
                }
                ++n2;
            }
        }
        if (!bl2) {
            n2 = 0;
            while (n2 < accessControlContext.context.length) {
                bl = true;
                n = 0;
                while (n < n7 && bl) {
                    bl = accessControlContext.context[n2] != null && accessControlContext.context[n2] != protectionDomainArray[n];
                    ++n;
                }
                if (bl) {
                    protectionDomainArray[n7++] = accessControlContext.context[n2];
                }
                ++n2;
            }
        }
        if (n7 != protectionDomainArray.length) {
            if (n7 == 0) {
                protectionDomainArray = null;
            } else {
                ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n7];
                System.arraycopy(protectionDomainArray, 0, protectionDomainArray2, 0, n7);
                protectionDomainArray = protectionDomainArray2;
            }
        }
        boolean bl6 = !bl2 && accessControlContext.isPrivileged;
        return new AccessControlContext(protectionDomainArray, this.isPrivileged || bl6);
    }

    public boolean equals(Object object) {
        int n;
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (this.context == null) {
            return accessControlContext.context == null;
        }
        if (accessControlContext.context == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.context.length) {
            bl = false;
            n = 0;
            while (n < accessControlContext.context.length && !bl) {
                bl = this.context[n2] == null && accessControlContext.context[n] == null || this.context[n2].equals(accessControlContext.context[n]);
                ++n;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        bl = false;
        n = 0;
        while (n < accessControlContext.context.length) {
            bl = false;
            int n3 = 0;
            while (n3 < this.context.length && !bl) {
                bl = accessControlContext.context[n] == null && this.context[n3] == null || accessControlContext.context[n].equals(this.context[n3]);
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.context == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.context.length) {
            if (this.context[n2] != null) {
                n ^= this.context[n2].hashCode();
            }
            ++n2;
        }
        return n;
    }

    static {
        debug = null;
    }

    private static final class 1
    implements PrivilegedAction {
        private final /* synthetic */ ProtectionDomain val$pd;
        private final /* synthetic */ Debug val$db;

        public Object run() {
            this.val$db.println("domain that failed " + this.val$pd);
            return null;
        }

        /* synthetic */ 1(Debug debug, ProtectionDomain protectionDomain) {
            this.val$db = debug;
            this.val$pd = protectionDomain;
        }
    }
}

