/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.net.www;

import com.ibm.security12.java.io.FilePermission;
import com.ibm.security12.java.net.SocketPermission;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.AllPermission;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.sun.security.action.GetPropertyAction;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import sun.net.www.protocol.doc.DocURLConnection;
import sun.net.www.protocol.file.FileURLConnection;
import sun.net.www.protocol.ftp.FtpURLConnection;
import sun.net.www.protocol.mailto.MailToURLConnection;
import sun.net.www.protocol.systemresource.SystemResourceConnection;

public final class URLConnection12 {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";

    private URLConnection12() {
    }

    public static final Permission getPermission(URL uRL, URLConnection uRLConnection) throws IOException {
        if (uRLConnection instanceof FileURLConnection || uRLConnection instanceof DocURLConnection) {
            if (File.separatorChar == '/') {
                return new FilePermission(uRL.getFile(), "read");
            }
            return new FilePermission(uRL.getFile().replace('/', File.separatorChar), "read");
        }
        if (uRLConnection instanceof sun.net.www.protocol.http.HttpURLConnection || uRLConnection instanceof HttpURLConnection) {
            int n = uRL.getPort();
            n = n < 0 ? 80 : n;
            String string = String.valueOf(uRL.getHost()) + ":" + n;
            return new SocketPermission(string, "connect");
        }
        if (uRLConnection instanceof FtpURLConnection) {
            int n;
            String string = uRL.getHost();
            int n2 = string.indexOf(64);
            if (n2 > -1) {
                string = string.substring(++n2);
            }
            n = (n = uRL.getPort()) < 0 ? 21 : n;
            string = String.valueOf(string) + ":" + n;
            return new SocketPermission(string, "connect");
        }
        if (uRLConnection instanceof MailToURLConnection) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("mail.host"));
            if (string == null) {
                string = "localhost";
            }
            String string2 = String.valueOf(string) + ":" + 25;
            return new SocketPermission(string2, "connect");
        }
        if (uRLConnection instanceof SystemResourceConnection) {
            URL uRL2 = null;
            URLConnection uRLConnection2 = null;
            try {
                uRL2 = URLConnection12.makeDelegateUrl(uRL);
                uRLConnection2 = uRL2.openConnection();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
            return URLConnection12.getPermission(uRL2, uRLConnection2);
        }
        return new AllPermission();
    }

    private static URL makeDelegateUrl(URL uRL) throws MalformedURLException {
        boolean bl = false;
        String string = uRL.getFile();
        if (string.startsWith("/FILE")) {
            bl = true;
        }
        int n = bl ? 5 : 4;
        int n2 = string.lastIndexOf("/+/");
        if (n2 < 0) {
            throw new MalformedURLException("no /+/ found in URL");
        }
        string = bl ? "file:" + string.substring(n, n2) + File.separatorChar + string.substring(n2 + 3, string.length()) : "jar:file:" + string.substring(n, n2) + "!/" + string.substring(n2 + 3, string.length());
        return new URL(string);
    }
}

