/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.net.www.protocol.jar;

import com.ibm.security12.java.io.FilePermission;
import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.net.SocketPermission;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PrivilegedActionException;
import com.ibm.security12.java.security.PrivilegedExceptionAction;
import com.ibm.security12.java.util.HashMap;
import com.ibm.security12.java.util.Hashtable;
import com.ibm.security12.java.util.Map;
import com.ibm.security12.java.util.jar.JarFile;
import com.ibm.security12.sun.net.www.URLConnection12;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

class JarFileFactory {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static Map cache = new Hashtable();
    private static int BUF_SIZE = 2048;
    private HashMap permissions = new HashMap();
    private HashMap connections = new HashMap();
    private HashMap fileCache = new HashMap();

    private boolean isFileURL(URL uRL) {
        return uRL.getProtocol().equalsIgnoreCase("file");
    }

    public URLConnection getConnection(JarFile jarFile) {
        return (URLConnection)this.connections.get(jarFile);
    }

    public void cacheConnection(JarFile jarFile, URLConnection uRLConnection) {
        this.connections.put(jarFile, uRLConnection);
    }

    public Permission getPermission(JarFile jarFile) {
        return (Permission)this.permissions.get(jarFile);
    }

    public void cachePermission(JarFile jarFile, Permission permission) {
        this.permissions.put(jarFile, permission);
    }

    public synchronized JarFile get(URL uRL) throws IOException {
        JarFile jarFile = null;
        if (this.isFileURL(uRL)) {
            jarFile = (JarFile)this.fileCache.get(uRL);
            if (jarFile == null) {
                jarFile = new JarFile(uRL.getFile());
                this.fileCache.put(uRL, jarFile);
            }
            URLConnection uRLConnection = uRL.openConnection();
            Permission permission = URLConnection12.getPermission(uRL, uRLConnection);
            this.cachePermission(jarFile, permission);
            this.cacheConnection(jarFile, uRLConnection);
        } else {
            jarFile = this.getCachedJarFile(uRL);
            if (jarFile == null) {
                jarFile = this.retrieve(uRL);
                this.cacheJarFile(uRL, jarFile);
            }
            if (jarFile == null) {
                throw new FileNotFoundException(uRL.toString());
            }
        }
        return jarFile;
    }

    void cacheJarFile(URL uRL, JarFile jarFile) {
        cache.put(uRL, jarFile);
    }

    JarFile getCachedJarFile(URL uRL) {
        SecurityManager12 securityManager12;
        Permission permission;
        JarFile jarFile = (JarFile)cache.get(uRL);
        if (jarFile != null && (permission = this.getPermission(jarFile)) != null && (securityManager12 = (SecurityManager12)System.getSecurityManager()) != null) {
            try {
                securityManager12.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager12.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager12.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
        return jarFile;
    }

    public JarFile retrieve(URL uRL) throws IOException {
        JarFile jarFile = null;
        URLConnection uRLConnection = uRL.openConnection();
        Permission permission = null;
        permission = URLConnection12.getPermission(uRL, uRLConnection);
        uRLConnection.getContentLength();
        try {
            jarFile = (JarFile)AccessController.doPrivileged(new 1(uRLConnection));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        if (jarFile != null) {
            this.cachePermission(jarFile, permission);
            this.cacheConnection(jarFile, uRLConnection);
        }
        return jarFile;
    }

    JarFileFactory() {
    }

    private static final class 1
    implements PrivilegedExceptionAction {
        private final /* synthetic */ URLConnection val$connection;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object run() throws IOException {
            JarFile jarFile;
            File file;
            OutputStream outputStream;
            block4: {
                InputStream inputStream = null;
                outputStream = null;
                file = null;
                try {
                    inputStream = this.val$connection.getInputStream();
                    file = new File("jar_cache");
                    outputStream = new FileOutputStream(file);
                    int n = 0;
                    byte[] byArray = new byte[BUF_SIZE];
                    while ((n = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n);
                    }
                    jarFile = new JarFile(file);
                    Object var6_7 = null;
                    if (inputStream == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream == null) throw throwable;
                    outputStream.close();
                    file.delete();
                    throw throwable;
                }
                inputStream.close();
            }
            if (outputStream == null) return jarFile;
            outputStream.close();
            file.delete();
            return jarFile;
        }

        /* synthetic */ 1(URLConnection uRLConnection) {
            this.val$connection = uRLConnection;
        }
    }
}

