/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.pkcs;

import com.ibm.security12.java.security.CertificateFactory;
import com.ibm.security12.java.security.cert.CRLException;
import com.ibm.security12.java.security.cert.CertificateException;
import com.ibm.security12.java.security.cert.X509CRL;
import com.ibm.security12.java.security.cert.X509Certificate;
import com.ibm.security12.sun.security.pkcs.ContentInfo;
import com.ibm.security12.sun.security.pkcs.SignerInfo;
import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerEncoder;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AlgorithmId;
import com.ibm.security12.sun.security.x509.X500Name;
import com.ibm.security12.sun.security.x509.X509CRLImpl;
import com.ibm.security12.sun.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Vector;
import sun.security.pkcs.ParsingException;

public class PKCS7 {
    private ObjectIdentifier contentType;
    private BigInt version;
    private AlgorithmId[] digestAlgorithmIds;
    private ContentInfo contentInfo;
    private X509Certificate[] certificates;
    private X509CRL[] crls;
    private SignerInfo[] signerInfos;
    private boolean oldStyle = false;

    public PKCS7(InputStream inputStream) throws ParsingException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        this.parse(new DerInputStream(byArray));
    }

    public PKCS7(DerInputStream derInputStream) throws ParsingException {
        this.parse(derInputStream);
    }

    public PKCS7(byte[] byArray) throws ParsingException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.parse(derInputStream);
    }

    private void parse(DerInputStream derInputStream) throws ParsingException {
        try {
            derInputStream.mark(derInputStream.available());
            this.parse(derInputStream, false);
            return;
        }
        catch (IOException iOException) {
            try {
                derInputStream.reset();
                this.parse(derInputStream, true);
                this.oldStyle = true;
                return;
            }
            catch (IOException iOException2) {
                ParsingException parsingException = new ParsingException("IOException: " + iOException2.getMessage());
                parsingException.fillInStackTrace();
                throw parsingException;
            }
        }
    }

    private void parse(DerInputStream derInputStream, boolean bl) throws IOException {
        this.contentInfo = new ContentInfo(derInputStream, bl);
        this.contentType = this.contentInfo.contentType;
        DerValue derValue = this.contentInfo.getContent();
        if (this.contentType.equals(ContentInfo.SIGNED_DATA_OID)) {
            this.parseSignedData(derValue);
            return;
        }
        if (this.contentType.equals(ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(derValue);
            return;
        }
        if (this.contentType.equals(ContentInfo.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(derValue);
            return;
        }
        throw new ParsingException("content type " + this.contentType + " not supported.");
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Certificate[] x509CertificateArray, SignerInfo[] signerInfoArray) {
        this.version = new BigInt(1);
        this.digestAlgorithmIds = algorithmIdArray;
        this.contentInfo = contentInfo;
        this.certificates = x509CertificateArray;
        this.signerInfos = signerInfoArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseNetscapeCertChain(DerValue derValue) throws ParsingException, IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        this.certificates = new X509Certificate[derValueArray.length];
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {}
        int n = 0;
        while (true) {
            block13: {
                Object var8_7;
                if (n >= derValueArray.length) {
                    return;
                }
                InputStream inputStream = null;
                try {
                    try {
                        if (certificateFactory == null) {
                            this.certificates[n] = new X509CertImpl(derValueArray[n]);
                        } else {
                            byte[] byArray = derValueArray[n].toByteArray();
                            inputStream = new ByteArrayInputStream(byArray);
                            this.certificates[n] = (X509Certificate)certificateFactory.generateCertificate(inputStream);
                            inputStream.close();
                            inputStream = null;
                        }
                    }
                    catch (CertificateException certificateException) {
                        throw new ParsingException("CertificateException: " + certificateException.getMessage());
                    }
                    catch (IOException iOException) {
                        throw new ParsingException("CertificateException: " + iOException.getMessage());
                    }
                    var8_7 = null;
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSignedData(DerValue derValue) throws ParsingException, IOException {
        Object object;
        Object object2;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getInteger();
        DerValue[] derValueArray = derInputStream.getSet(1);
        int n = derValueArray.length;
        this.digestAlgorithmIds = new AlgorithmId[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                object2 = derValueArray[n2];
                this.digestAlgorithmIds[n2] = AlgorithmId.parse((DerValue)object2);
                ++n2;
            }
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Error parsing digest AlgorithmId IDs: " + iOException.getMessage());
            parsingException.fillInStackTrace();
            throw parsingException;
        }
        this.contentInfo = new ContentInfo(derInputStream);
        if ((byte)derInputStream.peekByte() == -96) {
            DerValue[] derValueArray2 = derInputStream.getSet(2, true);
            n = derValueArray2.length;
            this.certificates = new X509Certificate[n];
            object2 = null;
            try {
                object2 = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {}
            int n3 = 0;
            while (n3 < n) {
                block22: {
                    Object var10_19;
                    object = null;
                    try {
                        try {
                            if (object2 == null) {
                                this.certificates[n3] = new X509CertImpl(derValueArray2[n3]);
                            } else {
                                byte[] byArray = derValueArray2[n3].toByteArray();
                                object = new ByteArrayInputStream(byArray);
                                this.certificates[n3] = (X509Certificate)((CertificateFactory)object2).generateCertificate((InputStream)object);
                                ((InputStream)object).close();
                                object = null;
                            }
                        }
                        catch (CertificateException certificateException) {
                            throw new ParsingException("CertificateException: " + certificateException.getMessage());
                        }
                        catch (IOException iOException) {
                            throw new ParsingException("CertificateException: " + iOException.getMessage());
                        }
                        var10_19 = null;
                        if (object == null) break block22;
                    }
                    catch (Throwable throwable) {
                        var10_19 = null;
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                        throw throwable;
                    }
                    ((InputStream)object).close();
                }
                ++n3;
            }
        }
        if ((byte)derInputStream.peekByte() == -95) {
            DerValue[] derValueArray3 = derInputStream.getSet(1, true);
            n = derValueArray3.length;
            this.crls = new X509CRL[n];
            int n4 = 0;
            while (n4 < n) {
                try {
                    X509CRLImpl x509CRLImpl = new X509CRLImpl(derValueArray3[n4]);
                    this.crls[n4] = x509CRLImpl;
                }
                catch (CRLException cRLException) {
                    object = new ParsingException("CRLException: " + cRLException.getMessage());
                    ((Throwable)object).fillInStackTrace();
                    throw object;
                }
                ++n4;
            }
        }
        DerValue[] derValueArray4 = derInputStream.getSet(1);
        n = derValueArray4.length;
        this.signerInfos = new SignerInfo[n];
        int n5 = 0;
        while (n5 < n) {
            DerInputStream derInputStream2 = derValueArray4[n5].toDerInputStream();
            this.signerInfos[n5] = new SignerInfo(derInputStream2);
            ++n5;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseOldSignedData(DerValue derValue) throws ParsingException, IOException {
        DerInputStream derInputStream;
        Object object;
        DerValue[] derValueArray;
        DerInputStream derInputStream2 = derValue.toDerInputStream();
        this.version = derInputStream2.getInteger();
        DerValue[] derValueArray2 = derInputStream2.getSet(1);
        int n = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                derValueArray = derValueArray2[n2];
                this.digestAlgorithmIds[n2] = AlgorithmId.parse((DerValue)derValueArray);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new ParsingException("Error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(derInputStream2, true);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {}
        derValueArray = derInputStream2.getSet(2);
        n = derValueArray.length;
        this.certificates = new X509Certificate[n];
        int n3 = 0;
        while (true) {
            block17: {
                if (n3 >= n) break;
                object = null;
                try {
                    try {
                        if (certificateFactory == null) {
                            this.certificates[n3] = new X509CertImpl(derValueArray[n3]);
                        } else {
                            byte[] byArray = derValueArray[n3].toByteArray();
                            object = new ByteArrayInputStream(byArray);
                            this.certificates[n3] = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                            ((InputStream)object).close();
                            object = null;
                        }
                    }
                    catch (CertificateException certificateException) {
                        throw new ParsingException("CertificateException: " + certificateException.getMessage());
                    }
                    catch (IOException iOException) {
                        throw new ParsingException("CertificateException: " + iOException.getMessage());
                    }
                    derInputStream = null;
                    if (object == null) break block17;
                }
                catch (Throwable throwable) {
                    derInputStream = null;
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                    throw throwable;
                }
                ((InputStream)object).close();
            }
            ++n3;
        }
        derInputStream2.getSet(0);
        object = derInputStream2.getSet(1);
        n = ((DerValue[])object).length;
        this.signerInfos = new SignerInfo[n];
        int n4 = 0;
        while (n4 < n) {
            derInputStream = object[n4].toDerInputStream();
            this.signerInfos[n4] = new SignerInfo(derInputStream, true);
            ++n4;
        }
        return;
    }

    public void encodeSignedData(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encodeSignedData(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void encodeSignedData(DerOutputStream derOutputStream) throws IOException {
        DerEncoder[] derEncoderArray;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        derOutputStream2.putOrderedSetOf((byte)49, this.digestAlgorithmIds);
        this.contentInfo.encode(derOutputStream2);
        if (this.certificates != null && this.certificates.length != 0) {
            derEncoderArray = new X509CertImpl[this.certificates.length];
            int n = 0;
            while (n < this.certificates.length) {
                if (this.certificates[n] instanceof X509CertImpl) {
                    derEncoderArray[n] = (X509CertImpl)this.certificates[n];
                } else {
                    try {
                        byte[] byArray = this.certificates[n].getEncoded();
                        derEncoderArray[n] = new X509CertImpl(byArray);
                    }
                    catch (CertificateException certificateException) {
                        throw new IOException(certificateException.getMessage());
                    }
                }
                ++n;
            }
            derOutputStream2.putOrderedSetOf((byte)-96, derEncoderArray);
        }
        derOutputStream2.putOrderedSetOf((byte)49, this.signerInfos);
        derEncoderArray = new DerValue(48, derOutputStream2.toByteArray());
        ContentInfo contentInfo = new ContentInfo(ContentInfo.SIGNED_DATA_OID, (DerValue)derEncoderArray);
        contentInfo.encode(derOutputStream);
    }

    public SignerInfo verify(SignerInfo signerInfo, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        return signerInfo.verify(this, byArray);
    }

    public SignerInfo[] verify(byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < this.signerInfos.length) {
            object = this.verify(this.signerInfos[n], byArray);
            if (object != null) {
                vector.addElement((Object[])object);
            }
            ++n;
        }
        if (vector.size() != 0) {
            object = new SignerInfo[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInt getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        return (X509Certificate[])this.certificates.clone();
    }

    public X509CRL[] getCRLs() {
        return this.crls;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInt bigInt, X500Name x500Name) {
        if (this.certificates != null) {
            int n = 0;
            while (n < this.certificates.length) {
                X509Certificate x509Certificate = this.certificates[n];
                X500Name x500Name2 = (X500Name)x509Certificate.getIssuerDN();
                BigInteger bigInteger = x509Certificate.getSerialNumber();
                BigInt bigInt2 = new BigInt(bigInteger);
                if (bigInt.equals(bigInt2) && x500Name.equals(x500Name2)) {
                    return x509Certificate;
                }
                ++n;
            }
        }
        return null;
    }

    public String toString() {
        int n;
        String string = "";
        string = String.valueOf(string) + this.contentInfo + "\n";
        if (this.version != null) {
            string = String.valueOf(string) + "PKCS7 :: version: " + this.version + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            string = String.valueOf(string) + "PKCS7 :: digest AlgorithmIds: \n";
            n = 0;
            while (n < this.digestAlgorithmIds.length) {
                string = String.valueOf(string) + "\t" + this.digestAlgorithmIds[n] + "\n";
                ++n;
            }
        }
        if (this.certificates != null) {
            string = String.valueOf(string) + "PKCS7 :: certificates: \n";
            n = 0;
            while (n < this.certificates.length) {
                string = String.valueOf(string) + "\t" + n + ".   " + this.certificates[n] + "\n";
                ++n;
            }
        }
        if (this.crls != null) {
            string = String.valueOf(string) + "PKCS7 :: crls: \n";
            n = 0;
            while (n < this.crls.length) {
                string = String.valueOf(string) + "\t" + n + ".   " + this.crls[n] + "\n";
                ++n;
            }
        }
        if (this.signerInfos != null) {
            string = String.valueOf(string) + "PKCS7 :: signer infos: \n";
            n = 0;
            while (n < this.signerInfos.length) {
                string = String.valueOf(string) + "\t" + n + ".  " + this.signerInfos[n] + "\n";
                ++n;
            }
        }
        return string;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }
}

