/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.provider;

import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.Identity;
import com.ibm.security12.java.security.IdentityScope;
import com.ibm.security12.java.security.MessageDigest;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.security.Security;
import com.ibm.security12.java.security.Signer;
import com.ibm.security12.java.util.Hashtable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.PublicKey;
import java.util.Enumeration;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    static File sourceFile;
    Hashtable identities = new Hashtable();

    IdentityDatabase() throws InvalidParameterException {
        this("restoring...");
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    public static sun.security.provider.IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        sun.security.provider.IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            identityDatabase = (sun.security.provider.IdentityDatabase)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.debug("This should not be happening.", classNotFoundException);
            IdentityDatabase.error("The version of the database is obsolete. Cannot initialize.");
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.debug("This should not be happening.", invalidClassException);
            IdentityDatabase.error("Unable to initialize system identity scope:  InvalidClassException. \nThis is most likely due to a serialization versioning problem: a class used in key management was obsoleted");
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.debug("The serialization stream is corrupted. Unable to load.", streamCorruptedException);
            IdentityDatabase.error("Unable to initialize system identity scope. StreamCorrputedException.");
        }
        if (identityDatabase == null) {
            identityDatabase = new sun.security.provider.IdentityDatabase("uninitialized");
        }
        return identityDatabase;
    }

    public static sun.security.provider.IdentityDatabase fromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        sun.security.provider.IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        IdentityDatabase.setSourceFile(file);
        return identityDatabase;
    }

    public int size() {
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.localCheck("get.signer");
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.keyEqual(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.localCheck("get.signer");
            }
            return identity;
        }
        return null;
    }

    private boolean keyEqual(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        this.localCheck("add.identity");
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = "name conflict";
        }
        if (identity3 != null) {
            string = "key conflict";
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        this.localCheck("remove.identity");
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException("there is no identity named " + string + " in " + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        return this.identities.elements();
    }

    static void setSourceFile(File file) {
        sourceFile = file;
    }

    File getSourceFile() {
        return sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            return;
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.debug("This should not be happening.", invalidClassException);
            return;
        }
    }

    void save(File file) throws IOException {
        IdentityDatabase.setSourceFile(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (sourceFile == null) {
            throw new IOException("this database has no source file");
        }
        this.save(sourceFile);
    }

    private static File systemDatabaseFile() {
        String string = Security.getProperty("identity.database");
        if (string == null) {
            string = String.valueOf(System.getProperty("user.home")) + File.separatorChar + "identitydb.obj";
        }
        return new File(string);
    }

    private static void initializeSystem() {
        File file = IdentityDatabase.systemDatabaseFile();
        try {
            sun.security.provider.IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.debug("loading system database from file: " + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new sun.security.provider.IdentityDatabase(file);
            }
            IdentityDatabase.debug("System database initialized: " + identityDatabase);
            return;
        }
        catch (IOException iOException) {
            IdentityDatabase.debug("Error initializing identity database: " + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.debug("Error trying to instantiate a system identities db in " + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        return "com.ibm.security12.sun.security.provider.IdentityDatabase, source file: " + sourceFile;
    }

    private static void debug(String string) {
    }

    private static void debug(String string, Throwable throwable) {
    }

    private static void error(String string) {
        System.err.println(string);
    }

    void localCheck(String string) {
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            string = String.valueOf(this.getClass().getName()) + "." + string + "." + this.localFullName();
            securityManager12.checkSecurityAccess(string);
        }
    }

    String localFullName() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = String.valueOf(string) + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.localCheck("serialize.identity.database");
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(sourceFile);
    }

    static {
        AccessController.doPrivileged(new 1());
    }

    private final class 1
    implements PrivilegedAction {
        public Object run() {
            IdentityDatabase.initializeSystem();
            return null;
        }

        /* synthetic */ 1() {
        }
    }
}

