/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.tools;

import com.ibm.security12.sun.security.tools.PolicyTool;
import com.ibm.security12.sun.security.tools.ToolDialog;
import com.ibm.security12.sun.security.tools.ToolWindow;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;

class FileMenuListener
implements ActionListener {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private PolicyTool tool;
    private ToolWindow tw;

    FileMenuListener(PolicyTool policyTool, ToolWindow toolWindow) {
        this.tool = policyTool;
        this.tw = toolWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Exit")) {
            ToolDialog toolDialog = new ToolDialog("Save Changes", this.tool, this.tw, true);
            toolDialog.displayUserSave(1);
            return;
        }
        if (actionEvent.getActionCommand().equals("New")) {
            ToolDialog toolDialog = new ToolDialog("Save Changes", this.tool, this.tw, true);
            toolDialog.displayUserSave(2);
            return;
        }
        if (actionEvent.getActionCommand().equals("Open")) {
            ToolDialog toolDialog = new ToolDialog("Save Changes", this.tool, this.tw, true);
            toolDialog.displayUserSave(3);
            return;
        }
        if (actionEvent.getActionCommand().equals("Save")) {
            String string = ((TextField)this.tw.getComponent(2)).getText();
            try {
                this.tool.savePolicy(string);
                this.tw.displayStatusDialog(null, "Policy successfully written to " + string);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (string == null || string.equals("")) {
                    this.tw.displayErrorDialog(null, new FileNotFoundException("null filename"));
                    return;
                }
                this.tw.displayErrorDialog(null, new FileNotFoundException(String.valueOf(string) + " not found"));
                return;
            }
            catch (Exception exception) {
                this.tw.displayErrorDialog(null, exception);
                return;
            }
        }
        if (actionEvent.getActionCommand().equals("Save As")) {
            ToolDialog toolDialog = new ToolDialog("Save As", this.tool, this.tw, true);
            toolDialog.displaySaveAsDialog(0);
            return;
        }
        if (actionEvent.getActionCommand().equals("View Warning Log")) {
            this.tw.displayWarningLog(null);
        }
    }
}

