/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.tools;

import com.ibm.security12.java.security.CodeSource;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.UnrecoverableKeyException;
import com.ibm.security12.java.security.cert.CertificateException;
import com.ibm.security12.sun.security.provider.PolicyParser;
import com.ibm.security12.sun.security.tools.PolicyTool;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;

class PolicyEntry {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private CodeSource codesource;
    private PolicyTool tool;
    private PolicyParser.GrantEntry grantEntry;
    private boolean testing = false;

    PolicyEntry(PolicyTool policyTool, PolicyParser.GrantEntry grantEntry) throws MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.tool = policyTool;
        URL uRL = null;
        if (grantEntry.codeBase != null) {
            uRL = new URL(grantEntry.codeBase);
        }
        this.codesource = new CodeSource(uRL, null);
        if (this.testing) {
            System.out.println("Adding Policy Entry:");
            System.out.println("    CodeBase = " + uRL);
            System.out.println("    Signers = " + grantEntry.signedBy);
        }
        this.grantEntry = grantEntry;
    }

    CodeSource getCodeSource() {
        return this.codesource;
    }

    PolicyParser.GrantEntry getGrantEntry() {
        return this.grantEntry;
    }

    String codebaseToString() {
        String string = new String();
        if (this.grantEntry.codeBase != null && !this.grantEntry.codeBase.equals("")) {
            string = string.concat("CodeBase \"" + this.grantEntry.codeBase + "\"");
        }
        if (this.grantEntry.signedBy != null && !this.grantEntry.signedBy.equals("")) {
            String string2 = string = string.length() > 0 ? string.concat(", SignedBy \"" + this.grantEntry.signedBy + "\"") : string.concat("SignedBy \"" + this.grantEntry.signedBy + "\"");
        }
        if (string.length() == 0) {
            return new String("CodeBase <ALL>");
        }
        return string;
    }

    PolicyParser.PermissionEntry toPermissionEntry(Permission permission) {
        String string = null;
        if (permission.getActions() != null && permission.getActions().trim() != "") {
            string = permission.getActions();
        }
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(permission.getClass().getName(), permission.getName(), string);
        return permissionEntry;
    }
}

