/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.tools;

import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.sun.security.action.GetPropertyAction;
import com.ibm.security12.sun.security.provider.PolicyParser;
import com.ibm.security12.sun.security.tools.CancelButtonListener;
import com.ibm.security12.sun.security.tools.ErrorOKButtonListener;
import com.ibm.security12.sun.security.tools.FileMenuListener;
import com.ibm.security12.sun.security.tools.MainWindowListener;
import com.ibm.security12.sun.security.tools.PolicyEntry;
import com.ibm.security12.sun.security.tools.PolicyListListener;
import com.ibm.security12.sun.security.tools.PolicyTool;
import com.ibm.security12.sun.security.tools.StatusOKButtonListener;
import com.ibm.security12.sun.security.tools.ToolDialog;
import com.ibm.security12.sun.security.tools.ToolWindowListener;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;

class ToolWindow
extends Frame {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    public final String NEW_POLICY_FILE = "New";
    public final String OPEN_POLICY_FILE = "Open";
    public final String SAVE_POLICY_FILE = "Save";
    public final String SAVE_AS_POLICY_FILE = "Save As";
    public final String VIEW_WARNINGS = "View Warning Log";
    public final String QUIT = "Exit";
    public final String ADD_POLICY_ENTRY = "Add Policy Entry";
    public final String EDIT_POLICY_ENTRY = "Edit Policy Entry";
    public final String REMOVE_POLICY_ENTRY = "Remove Policy Entry";
    public final String CHANGE_KEYSTORE = "Change KeyStore";
    public final String ADD_PUBKEY_ALIAS = "Add Public Key Alias";
    public final String REMOVE_PUBKEY_ALIAS = "Remove Public Key Alias";
    public final int MW_EMPTY_LABEL1 = 0;
    public final int MW_FILENAME_LABEL = 1;
    public final int MW_FILENAME_TEXTFIELD = 2;
    public final int MW_KEYSTORE_LABEL = 3;
    public final int MW_KEYSTORE_TEXTFIELD = 4;
    public final int MW_EMPTY_LABEL2 = 5;
    public final int MW_PANEL = 6;
    public final int MW_ADD_BUTTON = 0;
    public final int MW_EMPTY_LABEL3 = 1;
    public final int MW_EDIT_BUTTON = 2;
    public final int MW_EMPTY_LABEL4 = 3;
    public final int MW_REMOVE_BUTTON = 4;
    public final int MW_EMPTY_LABEL5 = 7;
    public final int MW_POLICY_LIST = 8;
    private PolicyTool tool;

    ToolWindow(PolicyTool policyTool) {
        this.tool = policyTool;
    }

    private void initWindow() {
        Object object;
        ((Component)this).setBackground(Color.lightGray);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menu.add("New");
        menu.add("Open");
        menu.add("Save");
        menu.add("Save As");
        menu.add("View Warning Log");
        menu.add("Exit");
        menu.addActionListener(new FileMenuListener(this.tool, this));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        menu = new Menu("Edit");
        menu.add("Add Policy Entry");
        menu.add("Edit Policy Entry");
        menu.add("Remove Policy Entry");
        menu.add("Change KeyStore");
        menu.addActionListener(new MainWindowListener(this.tool, this));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        Label label = new Label("");
        this.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        label = new Label("Policy File:");
        this.addNewComponent(this, label, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
        TextField textField = new TextField(50);
        textField.setEditable(false);
        ((Component)textField).setBackground(Color.white);
        this.addNewComponent(this, textField, 2, 1, 1, 1, 1, 0.0, 0.0, 1);
        label = new Label("Keystore:");
        this.addNewComponent(this, label, 3, 0, 2, 1, 1, 0.0, 0.0, 1);
        textField = new TextField(50);
        textField.setEditable(false);
        ((Component)textField).setBackground(Color.white);
        this.addNewComponent(this, textField, 4, 1, 2, 1, 1, 0.0, 0.0, 1);
        label = new Label("");
        this.addNewComponent(this, label, 5, 0, 3, 1, 1, 0.0, 0.0, 1);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Button button = new Button("Add Policy Entry");
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        label = new Label("");
        this.addNewComponent(panel, label, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
        button = new Button("Edit Policy Entry");
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 2, 2, 0, 1, 1, 0.0, 0.0, 1);
        label = new Label("");
        this.addNewComponent(panel, label, 3, 3, 0, 1, 1, 0.0, 0.0, 1);
        button = new Button("Remove Policy Entry");
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 4, 4, 0, 1, 1, 0.0, 0.0, 1);
        this.addNewComponent(this, panel, 6, 0, 4, 2, 1, 0.0, 0.0, 1);
        label = new Label("");
        this.addNewComponent(this, label, 7, 0, 5, 1, 1, 0.0, 0.0, 1);
        String string = this.tool.getPolicyFileName();
        if (string == null) {
            object = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
            string = ((String)object).endsWith(File.separator) ? String.valueOf(object) + "lib" + File.separator + "security" + File.separator + "java.pol" : String.valueOf(object) + File.separator + "lib" + File.separator + "security" + File.separator + "java.pol";
        }
        try {
            this.tool.openPolicy(string);
            object = new List(40, false);
            ((Component)object).setBackground(Color.white);
            ((List)object).addActionListener(new PolicyListListener(this.tool, this));
            PolicyEntry[] policyEntryArray = this.tool.getEntry();
            if (policyEntryArray != null) {
                int n = 0;
                while (n < policyEntryArray.length) {
                    ((List)object).add(policyEntryArray[n].codebaseToString());
                    ++n;
                }
            }
            TextField textField2 = (TextField)this.getComponent(2);
            ((TextComponent)textField2).setText(string);
            TextField textField3 = (TextField)this.getComponent(4);
            if (this.tool.getKeyStoreType() != null && this.tool.getKeyStoreType().length() > 0) {
                ((TextComponent)textField3).setText(String.valueOf(this.tool.getKeyStoreName()) + ", " + this.tool.getKeyStoreType());
            } else {
                ((TextComponent)textField3).setText(this.tool.getKeyStoreName());
            }
            this.initPolicyList((List)object);
            return;
        }
        catch (PolicyParser.ParsingException parsingException) {
            List list = new List(40, false);
            this.initPolicyList(list);
            ((Component)this).setVisible(true);
            this.displayErrorDialog(null, "Error parsing policy file " + string + parsingException.getMessage());
            System.exit(1);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = new List(40, false);
            ((List)object).addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList((List)object);
            this.tool.modified = false;
            ((Component)this).setVisible(true);
            this.displayErrorDialog(null, "Could not find Policy File: " + string);
            return;
        }
        catch (Exception exception) {
            object = new List(40, false);
            ((List)object).addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList((List)object);
            this.tool.modified = false;
            return;
        }
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        container.add(component, n);
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n6;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    void initPolicyList(List list) {
        this.add((Component)list, 8);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(list, gridBagConstraints);
    }

    void replacePolicyList(List list) {
        List list2 = (List)this.getComponent(8);
        list2.removeAll();
        String[] stringArray = list.getItems();
        int n = 0;
        while (n < stringArray.length) {
            list2.add(stringArray[n]);
            ++n;
        }
    }

    void displayToolWindow(String[] stringArray) {
        this.setTitle("Policy Tool");
        this.setResizable(true);
        this.addWindowListener(new ToolWindowListener(this));
        ((Component)this).setBounds(135, 80, 500, 500);
        this.setLayout(new GridBagLayout());
        this.initWindow();
        ((Component)this).setVisible(true);
        if (this.tool.newWarning) {
            this.displayStatusDialog(this, "Errors have occurred while opening the policy configuration.  View the Warning Log for more information.");
        }
    }

    void displayErrorDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog("Error", this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        ((Component)toolDialog).setBounds(point.x + 50, point.y + 50, 600, 100);
        toolDialog.setLayout(new GridBagLayout());
        Label label = new Label(string);
        this.addNewComponent(toolDialog, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Button button = new Button("OK");
        button.addActionListener(new ErrorOKButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        ((Component)toolDialog).setVisible(true);
    }

    void displayErrorDialog(Window window, Exception exception) {
        this.displayErrorDialog(window, exception.toString());
    }

    void displayStatusDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog("Status", this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        ((Component)toolDialog).setBounds(point.x + 50, point.y + 50, 500, 100);
        toolDialog.setLayout(new GridBagLayout());
        Label label = new Label(string);
        this.addNewComponent(toolDialog, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Button button = new Button("OK");
        button.addActionListener(new StatusOKButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        ((Component)toolDialog).setVisible(true);
    }

    void displayWarningLog(Window window) {
        ToolDialog toolDialog = new ToolDialog("Warning", this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        ((Component)toolDialog).setBounds(point.x + 50, point.y + 50, 500, 100);
        toolDialog.setLayout(new GridBagLayout());
        TextArea textArea = new TextArea();
        textArea.setEditable(false);
        int n = 0;
        while (n < this.tool.warnings.size()) {
            textArea.append((String)this.tool.warnings.elementAt(n));
            textArea.append("\n");
            ++n;
        }
        this.addNewComponent(toolDialog, textArea, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        Label label = new Label("");
        this.addNewComponent(toolDialog, label, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        Button button = new Button("OK");
        button.addActionListener(new CancelButtonListener(toolDialog));
        this.addNewComponent(toolDialog, button, 2, 0, 2, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        ((Component)toolDialog).setVisible(true);
    }
}

