/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class CertificateSubjectName
implements CertAttrSet {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    public static final String IDENT = "x509.info.subject";
    public static final String NAME = "subject";
    public static final String DN_NAME = "dname";
    private X500Name dnName;

    public CertificateSubjectName(X500Name x500Name) {
        this.dnName = x500Name;
    }

    public CertificateSubjectName(DerInputStream derInputStream) throws IOException {
        this.dnName = new X500Name(derInputStream);
    }

    public CertificateSubjectName(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.dnName = new X500Name(derValue);
    }

    public String toString() {
        if (this.dnName == null) {
            return "";
        }
        return this.dnName.toString();
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.dnName.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void decode(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.dnName = new X500Name(derValue);
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof X500Name)) {
            throw new IOException("Attribute must be of type X500Name.");
        }
        if (string.equalsIgnoreCase(DN_NAME)) {
            this.dnName = (X500Name)object;
            return;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(DN_NAME)) {
            return this.dnName;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(DN_NAME)) {
            this.dnName = null;
            return;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DN_NAME);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

