/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class SerialNumber {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private BigInt serialNum;

    private void construct(DerValue derValue) throws IOException {
        this.serialNum = derValue.getInteger();
        if (derValue.data.available() != 0) {
            throw new IOException("Excess SerialNumber data");
        }
    }

    public SerialNumber(BigInteger bigInteger) {
        this.serialNum = new BigInt(bigInteger);
    }

    public SerialNumber(int n) {
        this.serialNum = new BigInt(n);
    }

    public SerialNumber(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
    }

    public SerialNumber(DerValue derValue) throws IOException {
        this.construct(derValue);
    }

    public SerialNumber(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.construct(derValue);
    }

    public String toString() {
        return "SerialNumber: [" + this.serialNum.toString() + "]";
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putInteger(this.serialNum);
    }

    public BigInt getNumber() {
        return this.serialNum;
    }
}

