/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.java.security.cert.CRLException;
import com.ibm.security12.java.security.cert.X509CRLEntry;
import com.ibm.security12.java.util.Collection;
import com.ibm.security12.java.util.HashSet;
import com.ibm.security12.java.util.Set;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.CRLExtensions;
import com.ibm.security12.sun.security.x509.Extension;
import com.ibm.security12.sun.security.x509.OIDMap;
import com.ibm.security12.sun.security.x509.SerialNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import sun.misc.HexDumpEncoder;

public class X509CRLEntryImpl
extends X509CRLEntry {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private SerialNumber serialNumber;
    private Date revocationDate;
    private CRLExtensions extensions;
    private byte[] revokedCert;
    private static final boolean isExplicit = false;
    private static final long YR_2050 = 2524636800000L;

    private X509CRLEntryImpl() {
    }

    public X509CRLEntryImpl(BigInteger bigInteger, Date date) {
        this.serialNumber = new SerialNumber(bigInteger);
        this.revocationDate = date;
    }

    public X509CRLEntryImpl(BigInteger bigInteger, Date date, CRLExtensions cRLExtensions) {
        this.serialNumber = new SerialNumber(bigInteger);
        this.revocationDate = date;
        this.extensions = cRLExtensions;
    }

    public X509CRLEntryImpl(byte[] byArray) throws CRLException {
        try {
            this.parse(new DerValue(byArray));
            return;
        }
        catch (IOException iOException) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    public X509CRLEntryImpl(DerValue derValue) throws CRLException {
        try {
            this.parse(derValue);
            return;
        }
        catch (IOException iOException) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public void encode(DerOutputStream derOutputStream) throws CRLException {
        try {
            if (this.revokedCert == null) {
                DerOutputStream derOutputStream2 = new DerOutputStream();
                this.serialNumber.encode(derOutputStream2);
                if (this.revocationDate.getTime() < 2524636800000L) {
                    derOutputStream2.putUTCTime(this.revocationDate);
                } else {
                    derOutputStream2.putGeneralizedTime(this.revocationDate);
                }
                if (this.extensions != null) {
                    this.extensions.encode(derOutputStream2, false);
                }
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream2);
                this.revokedCert = derOutputStream3.toByteArray();
            }
            derOutputStream.write(this.revokedCert);
            return;
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.toString());
        }
    }

    public byte[] getEncoded() throws CRLException {
        if (this.revokedCert == null) {
            this.encode(new DerOutputStream());
        }
        return (byte[])this.revokedCert.clone();
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber.getNumber().toBigInteger();
    }

    public Date getRevocationDate() {
        return new Date(this.revocationDate.getTime());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.serialNumber.toString());
        stringBuffer.append("  On: " + this.revocationDate.toString());
        if (this.extensions != null) {
            Collection collection = this.extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuffer.append("\n    CRL Entry Extensions: " + objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append("\n    [" + (n + 1) + "]: ");
                Extension extension = (Extension)objectArray[n];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuffer.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray != null) {
                            DerOutputStream derOutputStream = new DerOutputStream();
                            derOutputStream.putOctetString(byArray);
                            byArray = derOutputStream.toByteArray();
                            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                            stringBuffer.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        }
                    } else {
                        stringBuffer.append(extension.toString());
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(", Error parsing this extension");
                }
                ++n;
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    public Set getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet hashSet = new HashSet(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        return hashSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet hashSet = new HashSet(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        if (this.extensions == null) {
            return null;
        }
        try {
            Object object;
            Object object2;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            Object object3 = null;
            if (string2 == null) {
                object2 = new ObjectIdentifier(string);
                object = null;
                Enumeration enumeration = this.extensions.getElements();
                while (enumeration.hasMoreElements()) {
                    object = (Extension)enumeration.nextElement();
                    ObjectIdentifier objectIdentifier = ((Extension)object).getExtensionId();
                    if (!objectIdentifier.equals((ObjectIdentifier)object2)) continue;
                    object3 = object;
                    break;
                }
            } else {
                object3 = this.extensions.get(string2);
            }
            if (object3 == null) {
                return null;
            }
            object2 = ((Extension)object3).getExtensionValue();
            if (object2 == null) {
                return null;
            }
            object = new DerOutputStream();
            ((DerOutputStream)object).putOctetString((byte[])object2);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void parse(DerValue derValue) throws CRLException, IOException {
        if (derValue.tag != 48) {
            throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
        }
        if (derValue.data.available() == 0) {
            throw new CRLException("No data encoded for RevokedCertificates");
        }
        this.revokedCert = derValue.toByteArray();
        DerInputStream derInputStream = derValue.toDerInputStream();
        DerValue derValue2 = derInputStream.getDerValue();
        this.serialNumber = new SerialNumber(derValue2);
        int n = derValue.data.peekByte();
        if ((byte)n == 23) {
            this.revocationDate = derValue.data.getUTCTime();
        } else if ((byte)n == 24) {
            this.revocationDate = derValue.data.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for revocation date");
        }
        if (derValue.data.available() == 0) {
            return;
        }
        this.extensions = new CRLExtensions(derValue.toDerInputStream());
    }
}

