/* */
 
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then parse var string "'"BootDrive" "AppServer" "Action"'"
if (string<>"" & BootDrive="") then parse var string BootDrive" "AppServer" "Action
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */
 
  p.Title = "Acrobat"
  p.ThisCMDFileName = "CreateAcrobat.CMD"
  p.ObjectID = "<ACROBAT>"
  p.DirName = "Acrobat"
  p.Location = "<WP_CLIENTAPPSFOLDER>"
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""

  call StartUp
 
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = "ASSOCFILTER=*.PDF,*PDF;ASSOCTYPE=Acrobat Document;EXENAME="p.ExeDir"\ReadOS2\AcroRead.EXE;STARTUPDIR="p.StartDir"\ReadOS2;"
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */

  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = "" /* p.ObjectIDPre || "_Shadow>"  */ /* Set to blank for no desktop shadow */
  p.Doc= "OBJECTID="p.ObjectIDPre"_DOC>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\ReadOS2\READ.ME;STARTUPDIR="p.StartDir";"  /* Set to blank for no readme */
  p.ObjectIDFolder = p.ObjectIDPre || "_FOLDER>" /* Set to blank for no folder */
  if (p.ObjectIDShadow="") then
     p.ObjectIDFolderShadow = p.ObjectIDPre || "_FOLDER_SHODOW>"
  else
     p.ObjectIDFolderShadow = ""
  p.ObjectIDFolderCleanUp = p.ObjectIDPre || "_FOLDER_CLEANUP>"
  p.ObjectIDFolderICON1 = WiseManager"\Acrobat\Adobe.ICO"
  p.ObjectIDFolderICON2 = WiseManager"\Acrobat\Adobe1.ICO"

  p.Class = "WPProgram"
 
  call MyRegisterClasses
  call MyCreateObjects
 
syntax:
signal CMDExit
return 0
 
MyRegisterClasses:

  rc = MySysRegisterObjectClass( 'AApdf', 'reados2\AApdf', 'A' )


return
 
MyCreateObjects:
  if (p.ObjectIDFolder <> "") then do
     rc = CreateObject( "WPFolder",,
         p.Title,,
         p.Location,,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='p.ObjectIDFolderICON1';'||,
        'ICONNFILE=1,'p.ObjectIDFolderICON2';'||,
        'OBJECTID='p.ObjectIDFolder,,
         p.Flag )
 
      if (p.ObjectIDShadow="" & NoShadowMode=0) then do
        rc = CreateObject( 'WPShadow',,
            p.Title,,
            '<WP_DESKTOP>',,
            'SHADOWID='p.ObjectIDFolder';'||,
            'OBJECTID='p.ObjectIDFolderShadow,,
         p.Flag )
      end
 
      p.Location = p.ObjectIDFolder
  end
 
  p.Title = 'Acrobat Reader 3.0'
  rc = CreateObject( p.Class,,
      p.Title,,
      p.Location,,
      p.SetupString ||,
          "NOPRINT=YES;"||,
          "DEFAULTVIEW=RUNNING;"||,
          "OBJECTID="p.ObjectID";",,
      p.Flag )
 
  if (p.ObjectIDShadow<>"") then do
     rc = CreateObject( "WPShadow",,
         p.Title,,
         "<WP_DESKTOP>",,
            "DEFAULTVIEW=UNKNOWN;"||,
            "NOPRINT=YES;"||,
            "HELPPANEL=1277;"||,
            "SHADOWID="p.ObjectID";"||,
            "OBJECTID="p.ObjectIDShadow";",,
         p.Flag )
  end
 
  if (p.doc<>"") then do
       rc = CreateObject( p.Class,"Read ME",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
  end

p.ExeDir'\reados2\aapdfrel ' p.ExeDir'\reados2\acroread.exe "OBJECTID=<ACROBAT_READER_EXE>" >nul'
 
  /* Misc program files goes here */
  PgmFiles = ""     /* ABC.EXE DEF.CMD */
  do while (PgmFiles<>"")
     PgmFiles = strip(PgmFiles)
     parse var PgmFiles p.Title"."suf" "PgmFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     p.SetupString = "EXENAME="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<Acrobat_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title, p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
  end /* do */
 
  /* Misc text files goes here */
  TxtFiles = ""     /* ABC.TXT DEF.TXT */
  do while (TxtFiles<>"")
     TxtFiles = strip(TxtFiles)
     parse var TxtFiles p.Title"."suf" "TxtFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     if (translate(suf)="INF") then prog = "View"
     else prog = "E"
     p.SetupString = "EXENAME="prog".EXE;PARAMETERS="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<Acrobat_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title || "."suf"", p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
     end /* do */
return
 

