/* */
parse arg '"'BootDrive' 'AppServer' 'Action'"'
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  p.Title = "Gu20Lite"
  p.ThisCMDFileName = "CreateGu20Lite.CMD"
  p.DirName = "Gu20Lite"
  p.ObjectID = "<V100_Gu20Lite>"
  p.Location = "<WP_APPSFOLDER>"
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "\OS2"   /* Directory to check to see if this is a fresh install */
  p.FitToCheck = ""
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""   /* Class to check to see if this is a fresh install (classname dllname) */

  call StartUp
 
  /* This REXX is kind of large.   So do a start on itself so WiseClient doesn't have to wait for it to finish */
  parse var Action Action"|"Started
  if (Started<>"STARTED" & substr(RunFrom,2,1)<>":") then do 
     'start /min 'RunFrom'\DeskTop\'p.ThisCMDFileName' "'BootDrive' 'AppServer' 'Action'|STARTED"'
     '@exit'
  end /* do */
 
  /* p.Location = Vendor100_3() */

  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = "EXENAME="p.ExeDir"\Gu20Lite.EXE;STARTUPDIR="p.StartDir";"
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
  p.Doc= "OBJECTID="p.ObjectIDPre"_DOC>;EXENAME=VIEW.EXE;PARAMETERS="p.ExeDir"\graham20.inf;STARTUPDIR="p.StartDir";"  /* Set to blank for no readme */

  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.ObjectIDFolder = p.ObjectIDPre || "_FOLDER>" /* Set to blank for no folder */
  if (p.ObjectIDShadow="") then
     p.ObjectIDFolderShadow = p.ObjectIDPre || "_FOLDER_SHODOW>"
  else
     p.ObjectIDFolderShadow = ""
  p.ObjectIDFolderCleanUp = p.ObjectIDPre || "_FOLDER_CLEANUP>"
  p.ObjectIDFolderICON1 = RunFrom"\WiseManager\"p.DirName"\"p.DirName".ICO"
  p.ObjectIDFolderICON2 = RunFrom"\WiseManager\"p.DirName"\"p.DirName"1.ICO"
 
  call MyRegisterClasses
  call MyCreateObjects
 
syntax:
signal CMDExit
return 0
 
MyRegisterClasses:
return
 
MyCreateObjects:

  if (p.ObjectIDFolder <> "") then do
     rc = CreateObject( "WPFolder",,
         p.Title,,
         p.Location,,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='p.ObjectIDFolderICON1';'||,
        'ICONNFILE=1,'p.ObjectIDFolderICON2';'||,
        'OBJECTID='p.ObjectIDFolder,,
         p.Flag )

      if (p.ObjectIDShadow<>"") then do
        rc = CreateObject( 'WPShadow',,
            p.Title,,
            '<WP_DESKTOP>',,
            'SHADOWID='p.ObjectIDFolder';'||,
            'OBJECTID='p.ObjectIDFolderShadow,,
         p.Flag )
      end
 
      p.Location = p.ObjectIDFolder
      p.Title = "Programs"
      p.ObjectIDPrograms = "<V100_Gu20Lite_Programs>"
     rc = CreateObject( "WPFolder",,
         p.Title,,
         p.Location,,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='p.ObjectIDFolderICON1';'||,
        'ICONNFILE=1,'p.ObjectIDFolderICON2';'||,
        'OBJECTID='p.ObjectIDPrograms,,
         p.Flag )

  end
 
  if (p.ObjectID <> "") then do
  rc = CreateObject( p.Class,,
      p.Title,,
      p.Location,,
      p.SetupString ||,
          "NOPRINT=YES;"||,
          "DEFAULTVIEW=RUNNING;"||,
          "OBJECTID="p.ObjectID";",,
      p.Flag )
   end
 
  if (p.ObjectIDShadow<>"") then do
     rc = CreateObject( "WPShadow",,
         p.Title,,
         "<WP_DESKTOP>",,
            "DEFAULTVIEW=UNKNOWN;"||,
            "NOPRINT=YES;"||,
            "HELPPANEL=1277;"||,
            "SHADOWID="p.ObjectID";"||,
            "OBJECTID="p.ObjectIDShadow";",,
         p.Flag )
  end
 
  if (p.doc<>"") then do
       rc = CreateObject( p.Class,"Read ME",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
  end
 
  /* Misc text files goes here */
  call MakeTxtObj "new-info.txt warpsped.txt"

  /* Misc program files goes here */
  p.Location = p.ObjectIDPrograms
  call MakeExeObj "2lzh.exe be.exe beep.exe case.exe clipbrd.exe"
  call MakeExeObj "config.exe csdinst.exe desvr.exe di.exe diag.exe"
  call MakeExeObj "diskedit.exe diskimg.exe ds.exe dt.exe eabackup.exe"
  call MakeExeObj "eabind.exe eadump.exe earestor.exe fa.exe fat-bad.exe"
  call MakeExeObj "fat-dfrg.exe fat-ext.exe fat-info.exe fat-null.exe fat-ud.exe"
  call MakeExeObj "fat-view.exe fd.exe ff.exe fi.exe fromunix.exe"
  call MakeExeObj "fs.exe gcdprog.exe gi.exe grep.exe group.exe"
  call MakeExeObj "hexdump.exe hexedit.exe hpfs-bad.exe hpfs-ext.exe hpfs-ud.exe"
  call MakeExeObj "hpfsdfrg.exe hpfsinfo.exe hpfsnull.exe hpfsstat.exe hpfsview.ex"
  call MakeExeObj "install.exe ld.exe lh.exe lh2-222.exe midecode.exe"
  call MakeExeObj "miencode.exe nulldisk.exe nullfile.exe restpart.exe sa.exe"
  call MakeExeObj "savepart.exe semmgr.exe si.exe space.exe sum.exe"
  call MakeExeObj "tm.exe tounix.exe uudecode.exe uuencode.exe vl.exe"
  call MakeExeObj "wc.exe xxdecode.exe xxencode.exe"
  call MakeExeObj "be-tasks.cmd betask01.cmd betask02.cmd betask03.cmd betask04.cmd"
  call MakeExeObj "betask05.cmd betask06.cmd betask07.cmd betask08.cmd betask09.cmd"
  call MakeExeObj "betask10.cmd gcd.cmd gu20.cmd resource.cmd"
 
return
 
MakeTxtObj:
  parse arg TxtFiles
  do while (TxtFiles<>"")
     TxtFiles = strip(TxtFiles)
     parse var TxtFiles p.Title"."suf" "TxtFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     if (translate(suf)="INF") then prog = "View"
     else prog = "E"
     p.SetupString = "EXENAME="prog".EXE;PARAMETERS="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<Gu20Lite_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title || "."suf"", p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
     end /* do */
return

MakeExeObj:
  parse arg PgmFiles
  do while (PgmFiles<>"")
     PgmFiles = strip(PgmFiles)
     parse var PgmFiles p.Title"."suf" "PgmFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     p.SetupString = "EXENAME="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<Gu20Lite_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title, p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
  end /* do */
return rc

Vendor100_3:
     p.Location = "<VENDOR_100_3_FOLDER>"
     rc = CreateObject( "WPFolder",,
         "Vendor 100 Group 3",,
         "<WP_APPSFOLDER>",,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID='p.Location,,
         'Update' )
return p.Location

