/* */
 
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */
 
  p.Title = "Halite"  /* Name of this application */
  p.ThisCMDFileName = "CreateHalite.CMD"  /* Name of this command file */
  p.DirName = "Halite"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_Halite>"  /* Object to start (usually the main exe) */
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""   /* Class to check to see if this is a fresh install (classname dllname) */
 
  call StartUp
 
  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = "EXENAME="p.ExeDir"\Halite.EXE;STARTUPDIR="p.StartDir";"
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
 
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= "OBJECTID="p.ObjectIDPre"_DOC>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\README.TXT;STARTUPDIR="p.StartDir";"  /* Set to blank for no readme */
  p.ObjectIDFolder = p.ObjectIDPre || "_FOLDER>" /* Set to blank for no folder */
  if (p.ObjectIDShadow="") then
     p.ObjectIDFolderShadow = p.ObjectIDPre || "_FOLDER_SHODOW>"
  else
     p.ObjectIDFolderShadow = ""
  p.ObjectIDFolderCleanUp = p.ObjectIDPre || "_FOLDER_CLEANUP>"
  p.ObjectIDFolderICON1 = RunFrom"\WiseManager\"p.DirName"\"p.DirName".ICO"
  p.ObjectIDFolderICON2 = RunFrom"\WiseManager\"p.DirName"\"p.DirName"1.ICO"
 
  Call MyRegisterClasses
  Call MyCreateObjects
 
syntax:
signal CMDExit
return 0
 
MyRegisterClasses:
return
 
MyCreateObjects:
  if (p.ObjectIDFolder <> "") then do
     rc = CreateObject( "WPFolder",,
         p.Title,,
         p.Location,,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='p.ObjectIDFolderICON1';'||,
        'ICONNFILE=1,'p.ObjectIDFolderICON2';'||,
        'OBJECTID='p.ObjectIDFolder,,
         p.Flag )
 
      if (p.ObjectIDShadow="") then do
        rc = CreateObject( 'WPShadow',,
            p.Title,,
            '<WP_DESKTOP>',,
            'SHADOWID='p.ObjectIDFolder';'||,
            'OBJECTID='p.ObjectIDFolderShadow,,
         p.Flag )
      end
 
      p.Location = p.ObjectIDFolder
  end
 
  if (p.ObjectID<>"" & p.SetupString<>"") then do
     rc = CreateObject( p.Class,,
         p.Title,,
         p.Location,,
         p.SetupString ||,
             "NOPRINT=YES;"||,
             "DEFAULTVIEW=RUNNING;"||,
             "OBJECTID="p.ObjectID";",,
         p.Flag )
  end
 
  if (p.ObjectIDShadow<>"") then do
     rc = CreateObject( "WPShadow",,
         p.Title,,
         "<WP_DESKTOP>",,
            "DEFAULTVIEW=UNKNOWN;"||,
            "NOPRINT=YES;"||,
            "HELPPANEL=1277;"||,
            "SHADOWID="p.ObjectID";"||,
            "OBJECTID="p.ObjectIDShadow";",,
         p.Flag )
  end
 
  if (p.doc<>"") then do
       rc = CreateObject( p.Class,"Read ME",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
  end
 
  /* Misc program files goes here */
  PgmFiles = ""     /* ABC.EXE DEF.CMD */
  do while (PgmFiles<>"")
     PgmFiles = strip(PgmFiles)
     parse var PgmFiles p.Title"."suf" "PgmFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     p.SetupString = "EXENAME="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<Halite_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title, p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
  end /* do */
 
  /* Misc text files goes here */
  TxtFiles = ""     /* ABC.TXT DEF.TXT */
  do while (TxtFiles<>"")
     TxtFiles = strip(TxtFiles)
     parse var TxtFiles p.Title"."suf" "TxtFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     if (translate(suf)="INF") then prog = "View"
     else if (translate(suf)="HTM" | translate(suf)="HTML") then prog = RunFrom"\NetScape\Program\NetScape"
     else prog = "E"
     p.SetupString = "EXENAME="prog".EXE;PARAMETERS="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<Halite_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title || "."suf"", p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
  end /* do */
return
 
