/* */
 
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */
 
  p.Title = "SmartSuite"  /* Name of this application */
  p.ThisCMDFileName = "CreateSmartSuite.CMD"  /* Name of this command file */
  p.DirName = "SmartSuite"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_SmartSuite>"  /* Object to start (usually the main exe) */
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = "OverrideFlDocEx OVRFLDOC"   /* Class to check to see if this is a fresh install (classname dllname) */

  call StartUp
 
  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
 
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */

  call Transfer_Files

  CreateCollision = p.Flag
  Call RegisterClasses

  Call CreateObjects
 
  if (translate(Action)="LOCALINSTALL") then do
    call SysFileTree p.ExeDir'\lgen.dll', 'files', 'F'
    if (files.0>0) then do
    siz = word(files.1,3)
    if (datatype(siz)='NUM') then do
       if (siz=0) then call VRDeleteFile word(files.1,5)
    end
    drop files.
  end

syntax:
signal CMDExit
return 0
 
 
MySysRegisterObjectClass: procedure expose p.ExeDir
   parse arg className, dllName
   code = SysRegisterObjectClass( className, dllName )
   If code <> 1 Then code = SysRegisterObjectClass( className, p.ExeDir || '\' || dllName || '.DLL' )
   If code <> 1 Then do
      Say 'Can''t register class 'className' with 'dllName'.'
   end
return code
 
CreateObjects:

rc = CreateObject( 'WPFolder',,
        "Lotus SmartSuite^for eCS",,
    p.Location,,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='WiseManager'\'p.DirName'\SS\Lotus SmartSuite for OS!2 Warp 4.ICO;'||,
        'ICONNFILE='WiseManager'\'p.DirName'\SS\Lotus SmartSuite for OS!2 Warp 41.ICO;'||,
        'OBJECTID=<LOTSUITE97>',,
    CreateCollision )

    rc = CreateObject( "WPShadow",,
        "Lotus SmartSuite^for eCS",,
        "<WP_DESKTOP>",,
            "SHADOWID=<LOTSUITE97>;"||,
            "OBJECTID=<LOTSUITE97SHADOW>",,
        "REPLACE" )
 
  rc = CreateObject( 'WPProgram',,
      'Lotus 1-2-3^for eCS',,
      '<LOTSUITE97>',,
      'NOPRINT=YES;'||,
          'CCVIEW=NO;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=27,12;'||,
          'ASSOCFILTER=*.123,*.WK1,*.WK3,*.WK4,*.WG2,*.12M,*.PIC,*.XLS,*.XLT,*.XLW,*.WQ1,*.WB1,*.WB2;'||,
          'ASSOCTYPE=Lotus 1-2-3 Workbook",Lotus 1-2-3 SmartMaster","Lotus 1-2-3 PIC","Excel,"Quattro Pro;'||,
          'EXENAME='RunFrom'\'p.DirName'\123\123W.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<L123STDEN>',,
      CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Lotus^ Accessories',,
      '<LOTSUITE97>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=23,22;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'OBJECTID=<LOTACC97EN>',,
      CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Lotus SmartSuite^ for eCS Uninstall',,
        '<LOTACC97EN>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='RunFrom'\'p.DirName'\INSTALL.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS=/a:d;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\'p.DirName'\SS\Lotus SmartSuite! for OS!2 Warp 4 Uninstall.ICO;'||,
            'OBJECTID=<LOTUNINST97EN>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'ODBC^ Administrator Help',,
        '<LOTACC97EN>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=VIEW.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS=L2DRV12.INF;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<ODBCHELP97EN>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'ODBC^ Administrator',,
        '<LOTACC97EN>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME='RunFrom'\'p.DirName'\COMPNENT\ODBCADM.EXE;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<ODBCADM97EN>',,
        CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Lotus Software^ License Directory',,
        '<LOTACC97EN>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<LSUITELIC99EN>',,
        CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Norwegian License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\NORWEGIA.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99NOEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'English License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\ENGLISH.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99ENEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Spanish License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\SPANISH.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99ESEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'French License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\FRENCH.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99FREN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Italian License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\ITALIAN.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99ITEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Dutch License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\DUTCH.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99NLEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Portuguese License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\PORTUGUE.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99POEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Finnish License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\FINNISH.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99FNEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Swedish License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\SWEDISH.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99SWEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'German License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\GERMAN.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99DEEN>',,
          CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Danish License Agreement',,
          '<LSUITELIC99EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME=E.EXE;'||,
              'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
              'PARAMETERS='RunFrom'\'p.DirName'\DANISH.TXT;'||,
              'PROGTYPE=PM;'||,
              'OBJECTID=<LSUITELIC99DAEN>',,
          CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Lotus Organizer^ for eCS',,
      '<LOTSUITE97>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=65,12;'||,
          'ASSOCFILTER=*.OR4;'||,
          'ASSOCTYPE=Lotus Organizer Database;'||,
          'EXENAME='RunFrom'\'p.DirName'\ORGANIZE\ORG32.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<LORG97OS2EN>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Lotus Word Pro^for eCS',,
      '<LOTSUITE97>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=9,12;'||,
          'ASSOCFILTER=*.LWP;'||,
          'ASSOCTYPE=Word Pro Document;'||,
          'EXENAME='RunFrom'\'p.DirName'\WORDPRO\WORDPRO.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<WordPro97OS2EN>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Lotus Approach ^for eCS',,
      '<LOTSUITE97>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=45,12;'||,
          'ASSOCFILTER=*.APR,*.APT,*.VEW;'||,
          'ASSOCTYPE=Lotus Approach Document;'||,
          'EXENAME='RunFrom'\'p.DirName'\APPROACH\APPROACH.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<APPROACH97OS2EN>',,
      CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Lotus SmartMaster^ Templates',,
      '<LOTSUITE97>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=8,22;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'OBJECTID=<LOTSMC97EN>',,
      CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Lotus 1-2-3^SmartMaster Templates',,
        '<LOTSMC97EN>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<LOT12312M97EN>',,
        CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'shell.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<shell_12m>',,
          CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'purchase.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<purchase_12m>',,
          CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'loantbl.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<loantbl_12m>',,
          CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'loan.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<loan_12m>',,
          CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'invoice.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<invoice_12m>',,
          CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'expense.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<expense_12m>',,
          CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'timesht.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<timesht_12m>',,
          CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'budget.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<budget_12m>',,
          CreateCollision )

      rc = CreateObject( 'Override123DocEx',,
          'sales.12m',,
          '<LOT12312M97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<sales_12m>',,
          CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Lotus Approach ^SmartMaster Templates',,
        '<LOTSMC97EN>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<LOTAPPMPR97EN>',,
        CreateCollision )

      rc = CreateObject( 'OverrideApDocEx',,
          'surfnet.mpr',,
          '<LOTAPPMPR97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<surfnet_mpr>',,
          CreateCollision )

      rc = CreateObject( 'OverrideApDocEx',,
          'orders.mpr',,
          '<LOTAPPMPR97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<orders_mpr>',,
          CreateCollision )

      rc = CreateObject( 'OverrideApDocEx',,
          'survey.mpr',,
          '<LOTAPPMPR97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<survey_mpr>',,
          CreateCollision )

      rc = CreateObject( 'OverrideApDocEx',,
          'schedule.mpr',,
          '<LOTAPPMPR97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<schedule_mpr>',,
          CreateCollision )

      rc = CreateObject( 'OverrideApDocEx',,
          'video.mpr',,
          '<LOTAPPMPR97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<video_mpr>',,
          CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Lotus Freelance Graphics^ SmartMaster Templates',,
        '<LOTSMC97EN>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<LOTFLGSMC97EN>',,
        CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'RECOMMEN.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<RECOMMEN_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'PROPOSAL.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<PROPOSAL_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'ORIENTAT.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<ORIENTAT_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'KOTSTRAT.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<KOTSTRAT_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'ITSTRAT.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<ITSTRAT_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'TEAMMTG.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<TEAMMTG_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'BUSREV.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<BUSREV_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'SALESWAX.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<SALESWAX_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'PSTATUS.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<PSTATUS_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'PLAUNCH.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<PLAUNCH_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'MEET.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<MEET_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'KOTMIX.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<KOTMIX_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'TRAIN.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<TRAIN_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'COMPETE.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<COMPETE_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'SALESZIG.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<SALESZIG_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'BENEFITS.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<BENEFITS_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'PUPDATE.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<PUPDATE_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'POSITION.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<POSITION_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'MKTRES.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<MKTRES_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'KOTPRES.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<KOTPRES_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'CORPOVW.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<CORPOVW_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'SALLNC.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<SALLNC_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'BSTORM.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<BSTORM_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'QUALITY.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<QUALITY_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'PRODCTBR.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<PRODCTBR_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'NEWMKT.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<NEWMKT_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'KOTSEG.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<KOTSEG_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'INDUSTRY.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<INDUSTRY_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'SBUPLAN.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<SBUPLAN_SMC>',,
          CreateCollision )

      rc = CreateObject( 'OverrideFlDocEx',,
          'BUSPLAN.SMC',,
          '<LOTFLGSMC97EN>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'OBJECTID=<BUSPLAN_SMC>',,
          CreateCollision )

    rc = CreateObject( 'WPShadow',,
        'Lotus Word Pro^SmartMaster Templates',,
        '<LOTSMC97EN>',,
        'SHADOWID=<WP97TemplFolder>;'||,
            'OBJECTID=<Lotus_Word_Pro_SmartMaster_Templates>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Lotus^ Assistance Center',,
      '<LOTSUITE97>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONPOS=36,22;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'OBJECTID=<LOTUA97EN>',,
      CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Approach ^Product Updates',,
        '<LOTUA97EN>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS='RunFrom'\'p.DirName'\README.TXT;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<APPREADMEIDEN>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Freelance^ Product Updates',,
        '<LOTUA97EN>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS='RunFrom'\'p.DirName'\README.TXT;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<LFLGTXT97EN>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        '1-2-3^Product Updates',,
        '<LOTUA97EN>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS='RunFrom'\'p.DirName'\123\README.TXT;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<L123TXTEN>',,
        CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Online Books',,
        '<LOTUA97EN>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'OBJECTID=<LOTDOC97EN>',,
        CreateCollision )

      rc = CreateObject( 'WPProgram',,
          'Click here to install^ Adobe Acrobat Reader 3.0',,
          '<LOTDOC97EN>',,
          'NOPRINT=YES;'||,
              'DEFAULTVIEW=RUNNING;'||,
              'EXENAME='RunFrom'\'p.DirName'\ACROREAD\ARO2E30.EXE;'||,
              'PROGTYPE=WINDOWABLEVIO;'||,
              'MINIMIZED=YES;'||,
              'OBJECTID=<LOTACRO97>',,
          CreateCollision )

      rc = CreateObject( 'WPShadow',,
          'Installing and Using^SmartSuite Products',,
          '<LOTDOC97EN>',,
          'SHADOWID='RunFrom'\'p.DirName'\ACROREAD\ssinbook.pdf;'||,
              'OBJECTID=<Installing_and_Using__SmartSuite_Products>',,
          CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Organizer^ Product Updates',,
        '<LOTUA97EN>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS='RunFrom'\'p.DirName'\README.TXT;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<LORGTXTEN>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'SmartSuite^ Product Updates',,
        '<LOTUA97EN>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS='RunFrom'\'p.DirName'\README.TXT;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<L1SUITETXT97EN>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Word Pro^Product Updates',,
        '<LOTUA97EN>',,
        'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'EXENAME=E.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS='RunFrom'\'p.DirName'\README.TXT;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<LWPROTXT97EN>',,
        CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Lotus Freelance Graphics ^ for eCS',,
      '<LOTSUITE97>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=56,22;'||,
          'ASSOCFILTER=*.PRZ,*.PRS,*.PRE,*.SMC,*.MAS,*.DGM,*.SYM,*.PAL;'||,
          'ASSOCTYPE=Lotus Freelance for eCS Presentation;'||,
          'EXENAME='RunFrom'\'p.DirName'\FLG\FLG.EXE;'||,
          'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<LFLGSTD97EN>',,
      CreateCollision )

rc = CreateObject( 'WordProDocObj',,
    'Word Pro Document.LWP',,
    '<WP_TEMPS>',,
    'NOTDEFAULTICON=YES;'||,
        'TEMPLATE=YES;'||,
        'HELPPANEL=15686;'||,
        'ICONPOS=53,65524;'||,
        'OBJECTID=<Word_Pro_Document_LWP>',,
    CreateCollision )

rc = CreateObject( 'WPFolder',,
    'Lotus Word Pro^SmartMaster Templates',,
    '<WP_TEMPS>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=34,65524;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ICONFILE='WiseManager'\'p.DirName'\SS\Lotus Word Pro!SmartMaster Templates.ICO;'||,
        'ICONNFILE='WiseManager'\'p.DirName'\SS\Lotus Word Pro!SmartMaster Tem000.ICO;'||,
        'OBJECTID=<WP97TemplFolder>',,
    CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Calendar',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Calendar.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Calendar1.ICO;'||,
          'OBJECTID=<WP97TemplFolderCalendar>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'MonthCal.LWP',,
        '<WP97TemplFolderCalendar>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\MonthCal.DAT;'||,
            'OBJECTID=<MonthCal_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'DayCal.LWP',,
        '<WP97TemplFolderCalendar>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\DayCal.DAT;'||,
            'OBJECTID=<DayCal_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'WeekCal.LWP',,
        '<WP97TemplFolderCalendar>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\WeekCal.DAT;'||,
            'OBJECTID=<WeekCal_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Form',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Form.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Form1.ICO;'||,
          'OBJECTID=<WP97TemplFolderForm>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Invoice3.LWP',,
        '<WP97TemplFolderForm>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Invoice3.DAT;'||,
            'OBJECTID=<Invoice3_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Invoice2.LWP',,
        '<WP97TemplFolderForm>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Invoice2.DAT;'||,
            'OBJECTID=<Invoice2_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Invoice1.LWP',,
        '<WP97TemplFolderForm>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Invoice1.DAT;'||,
            'OBJECTID=<Invoice1_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Letter',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Letter.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Letter1.ICO;'||,
          'OBJECTID=<WP97TemplFolderLetter>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Letter3.LWP',,
        '<WP97TemplFolderLetter>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Letter3.DAT;'||,
            'OBJECTID=<Letter3_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Letter2.LWP',,
        '<WP97TemplFolderLetter>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Letter2.DAT;'||,
            'OBJECTID=<Letter2_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Letter1.LWP',,
        '<WP97TemplFolderLetter>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Letter1.DAT;'||,
            'OBJECTID=<Letter1_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'PerLettr.LWP',,
        '<WP97TemplFolderLetter>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\PerLettr.DAT;'||,
            'OBJECTID=<PerLettr_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Outline',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Outline.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Outline1.ICO;'||,
          'OBJECTID=<WP97TemplFolderOutline>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Outline.LWP',,
        '<WP97TemplFolderOutline>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Outline.DAT;'||,
            'OBJECTID=<Outline_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Card',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Card.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Card1.ICO;'||,
          'OBJECTID=<WP97TemplFolderCard>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'BusCard2.LWP',,
        '<WP97TemplFolderCard>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\BusCard2.DAT;'||,
            'OBJECTID=<BusCard2_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'PerCard.LWP',,
        '<WP97TemplFolderCard>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\PerCard.DAT;'||,
            'OBJECTID=<PerCard_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'BusCard1.LWP',,
        '<WP97TemplFolderCard>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\BusCard1.DAT;'||,
            'OBJECTID=<BusCard1_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'BusCard3.LWP',,
        '<WP97TemplFolderCard>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\BusCard3.DAT;'||,
            'OBJECTID=<BusCard3_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Internet',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Internet.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Internet1.ICO;'||,
          'OBJECTID=<WP97TemplFolderInternet>',,
      CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Internet - Corporate',,
        '<WP97TemplFolderInternet>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'ICONFILE='WiseManager'\'p.DirName'\SS\Internet - Corporate.ICO;'||,
            'ICONNFILE='WiseManager'\'p.DirName'\SS\Internet - Corporate1.ICO;'||,
            'OBJECTID=<WP97TemplFolderInternetCorp>',,
        CreateCollision )

      rc = CreateObject( 'WordProDocObj',,
          'INews1.LWP',,
          '<WP97TemplFolderInternetCorp>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'READDATAFROM='WiseManager'\'p.DirName'\SS\INews1.DAT;'||,
              'OBJECTID=<INews1_LWP>',,
          CreateCollision )

      rc = CreateObject( 'WordProDocObj',,
          'CoHome1.LWP',,
          '<WP97TemplFolderInternetCorp>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'READDATAFROM='WiseManager'\'p.DirName'\SS\CoHome1.DAT;'||,
              'OBJECTID=<CoHome1_LWP>',,
          CreateCollision )

      rc = CreateObject( 'WordProDocObj',,
          'Produc1.LWP',,
          '<WP97TemplFolderInternetCorp>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'READDATAFROM='WiseManager'\'p.DirName'\SS\Produc1.DAT;'||,
              'OBJECTID=<Produc1_LWP>',,
          CreateCollision )

      rc = CreateObject( 'WordProDocObj',,
          'Catlog1.LWP',,
          '<WP97TemplFolderInternetCorp>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'READDATAFROM='WiseManager'\'p.DirName'\SS\Catlog1.DAT;'||,
              'OBJECTID=<Catlog1_LWP>',,
          CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'HTML.LWP',,
        '<WP97TemplFolderInternet>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\HTML.DAT;'||,
            'OBJECTID=<HTML_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WPFolder',,
        'Internet - Personal',,
        '<WP97TemplFolderInternet>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONFONT=9.WarpSans;'||,
            'DETAILSFONT=9.WarpSans;'||,
            'TREEFONT=9.WarpSans;'||,
            'ICONVIEW=NONGRID,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,MINI;'||,
            'ICONFILE='WiseManager'\'p.DirName'\SS\Internet - Personal.ICO;'||,
            'ICONNFILE='WiseManager'\'p.DirName'\SS\Internet - Personal1.ICO;'||,
            'OBJECTID=<WP97TemplFolderInternetPersonal>',,
        CreateCollision )

      rc = CreateObject( 'WordProDocObj',,
          'Home1.LWP',,
          '<WP97TemplFolderInternetPersonal>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'READDATAFROM='WiseManager'\'p.DirName'\SS\Home1.DAT;'||,
              'OBJECTID=<Home1_LWP>',,
          CreateCollision )

      rc = CreateObject( 'WordProDocObj',,
          'Bio1.LWP',,
          '<WP97TemplFolderInternetPersonal>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'READDATAFROM='WiseManager'\'p.DirName'\SS\Bio1.DAT;'||,
              'OBJECTID=<Bio1_LWP>',,
          CreateCollision )

      rc = CreateObject( 'WordProDocObj',,
          'FavWEB1.LWP',,
          '<WP97TemplFolderInternetPersonal>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'READDATAFROM='WiseManager'\'p.DirName'\SS\FavWEB1.DAT;'||,
              'OBJECTID=<FavWEB1_LWP>',,
          CreateCollision )

      rc = CreateObject( 'WordProDocObj',,
          'KidPg1.LWP',,
          '<WP97TemplFolderInternetPersonal>',,
          'NOTDEFAULTICON=YES;'||,
              'TEMPLATE=YES;'||,
              'HELPPANEL=15686;'||,
              'READDATAFROM='WiseManager'\'p.DirName'\SS\KidPg1.DAT;'||,
              'OBJECTID=<KidPg1_LWP>',,
          CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Memo',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Memo.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Memo1.ICO;'||,
          'OBJECTID=<WP97TemplFolderMemo>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Memo1.LWP',,
        '<WP97TemplFolderMemo>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Memo1.DAT;'||,
            'OBJECTID=<Memo1_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Memo3.LWP',,
        '<WP97TemplFolderMemo>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Memo3.DAT;'||,
            'OBJECTID=<Memo3_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Memo2.LWP',,
        '<WP97TemplFolderMemo>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Memo2.DAT;'||,
            'OBJECTID=<Memo2_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Booklet',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Booklet.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Booklet1.ICO;'||,
          'OBJECTID=<WP97TemplFolderBooklet>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Booklet.LWP',,
        '<WP97TemplFolderBooklet>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Booklet.DAT;'||,
            'OBJECTID=<Booklet_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Fax',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Fax.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Fax1.ICO;'||,
          'OBJECTID=<WP97TemplFolderFax>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Fax2.LWP',,
        '<WP97TemplFolderFax>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Fax2.DAT;'||,
            'OBJECTID=<Fax2_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'PerFax.LWP',,
        '<WP97TemplFolderFax>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\PerFax.DAT;'||,
            'OBJECTID=<PerFax_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Fax1.LWP',,
        '<WP97TemplFolderFax>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Fax1.DAT;'||,
            'OBJECTID=<Fax1_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Fax3.LWP',,
        '<WP97TemplFolderFax>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Fax3.DAT;'||,
            'OBJECTID=<Fax3_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WordProDocObj',,
      'Default.LWP',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'TEMPLATE=YES;'||,
          'HELPPANEL=15686;'||,
          'READDATAFROM='WiseManager'\'p.DirName'\SS\Default.DAT;'||,
          'OBJECTID=<Default_LWP>',,
      CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Label',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Label.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Label1.ICO;'||,
          'OBJECTID=<WP97TemplFolderLabel>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'Label.LWP',,
        '<WP97TemplFolderLabel>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\Label.DAT;'||,
            'OBJECTID=<Label_LWP>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Newsletter',,
      '<WP97TemplFolder>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\SS\Newsletter.ICO;'||,
          'ICONNFILE='WiseManager'\'p.DirName'\SS\Newsletter1.ICO;'||,
          'OBJECTID=<WP97TemplFolderNewsletter>',,
      CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'News1.LWP',,
        '<WP97TemplFolderNewsletter>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\News1.DAT;'||,
            'OBJECTID=<News1_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'News3.LWP',,
        '<WP97TemplFolderNewsletter>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\News3.DAT;'||,
            'OBJECTID=<News3_LWP>',,
        CreateCollision )

    rc = CreateObject( 'WordProDocObj',,
        'News2.LWP',,
        '<WP97TemplFolderNewsletter>',,
        'NOTDEFAULTICON=YES;'||,
            'TEMPLATE=YES;'||,
            'HELPPANEL=15686;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\SS\News2.DAT;'||,
            'OBJECTID=<News2_LWP>',,
        CreateCollision )

return

RegisterClasses:
/*

Say
Say 'Registering classes....'
Say
Say 'The following classes will be registered:'
Say
Say '  OverrideFlDocEx   OverrideApDocEx   WPCDocument       '
Say '  WordProDocObj     Override123DocEx  '
Say '  LSDataFile        MMShadow          LSDirectory       '
Say
Say 'Press enter to register 11 classes for object creation,'
Call CharOut, 'or type any other key and enter to ignore: '
Say
Parse Pull Answer
If Answer <> '' Then return
*/
  rc = MySysRegisterObjectClass( 'OverrideFlDocEx', 'OVRFLDOC' )

  rc = MySysRegisterObjectClass( 'OverrideApDocEx', 'OVRAPDOC' )

  rc = MySysRegisterObjectClass( 'WPCDocument', 'WPCDOC' )

  rc = MySysRegisterObjectClass( 'WordProDocObj', OS2Dir'\DLL\LWPWPS.DLL' )

  rc = MySysRegisterObjectClass( 'Override123DocEx', 'L14WPD' )

return

Transfer_Files:

if (translate(Action)="LOCALINSTALL") then do
   if (VRIsDir(p.ExeDir'\temp')=0) then 'md 'p.ExeDir'\temp >nul:'
   call SysFileTree WiseManager'\smartsuite\main\*.*', 'files', 'FSO'
   /* X:\TVOICE\WISEPROG\WiseManager\smartsuite\main\boot.dat */
   do i = 1 to files.0
      name = translate(files.i)
      parse var name pre"\SMARTSUITE\MAIN\"rest
      call copyIfNeeded rest
   end
   drop files.
end

/* Application: PM_Workplace:Templates */
/* SAY "Writing application: PM_Workplace:Templates" */
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:204170:Outline.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:225121:News3.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:240382:News2.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:237041:News1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:211872:Memo3.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:208968:Memo2.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:230264:Memo1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:198377:PerLettr.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:203644:Letter3.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:205020:Letter2.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:234930:Letter1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:228825:Label.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:247183:HTML.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:247278:KidPg1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:226471:Home1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:230482:FavWEB1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:201068:Bio1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:231162:Produc1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:200367:INews1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:209051:CoHome1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:209655:Catlog1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:239612:Invoice3.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:202687:Invoice2.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:212038:Invoice1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:201095:PerFax.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:243713:Fax3.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:232614:Fax2.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:249720:Fax1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:207996:PerCard.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:237392:BusCard3.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:254682:BusCard2.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:256462:BusCard1.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:226751:MonthCal.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:248429:WeekCal.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:222316:DayCal.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:200005:Booklet.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:231706:Default.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','WordProDocObj:250203:Word Pro Document.LWP',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:254675:benefits.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:236513:bstorm.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:201127:busplan.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:223478:busrev.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:212430:compete.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:204876:corpovw.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:235986:industry.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:224992:itstrat.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:241327:kotmix.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:250103:kotpres.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:230032:kotseg.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:224361:kotstrat.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:225955:meet.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:234266:mktres.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:217604:newmkt.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:251212:orientat.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:201900:plaunch.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:197809:position.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:247810:prodctbr.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:242570:proposal.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:240996:pstatus.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:212537:pupdate.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:204084:quality.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:241793:recommen.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:206686:saleswax.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:206997:saleszig.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:204710:sallnc.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:217202:sbuplan.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:254161:teammtg.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideFlDocEx:220281:train.smc',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideApDocEx:251582:orders.mpr',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideApDocEx:199193:schedule.mpr',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideApDocEx:217653:surfnet.mpr',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideApDocEx:250860:survey.mpr',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','OverrideApDocEx:244482:video.mpr',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:246974:budget.12m',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:228693:expense.12m',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:254187:invoice.12m',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:220084:loan.12m',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:253033:loantbl.12m',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:248547:purchase.12m',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:241450:sales.12m',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:249202:shell.12m',X2C(val_hex)
subval=3100
val_hex=subval
CALL ThisSysIni 'User','PM_Workplace:Templates','Override123DocEx:196646:timesht.12m',X2C(val_hex)
 
/* Application: PMWP_ASSOC_FILTER */
/* SAY "Writing application: PMWP_ASSOC_FILTER" */
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.PRZ',X2C(val_hex)
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.PRS',X2C(val_hex)
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.PRE',X2C(val_hex)
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.SMC',X2C(val_hex)
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.MAS',X2C(val_hex)
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.DGM',X2C(val_hex)
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.SYM',X2C(val_hex)
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.PAL',X2C(val_hex)
subval=00
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.lwp',X2C(val_hex)
subval=00
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.sam',X2C(val_hex)
subval=00
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.mwp',X2C(val_hex)
subval=3230303231300031393031303100
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.LWP',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.123',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.WK1',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.WK3',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.WK4',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.WG2',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.12M',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.PIC',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.XLS',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.XLT',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.XLW',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.WQ1',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.WB1',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.WB2',X2C(val_hex)
subval=31363932303100
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.APR',X2C(val_hex)
subval=31363932303100
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.APT',X2C(val_hex)
subval=31363932303100
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.VEW',X2C(val_hex)
subval=31373239363300
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_FILTER','*.OR4',X2C(val_hex)
 
/* Application: PMWP_ASSOC_TYPE */
/* SAY "Writing application: PMWP_ASSOC_TYPE" */
subval=31383131313500
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','Lotus Freelance for eCS Presentation',X2C(val_hex)
subval=3230303231300031393031303100
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','Word Pro Document',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','Lotus 1-2-3 Workbook"',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','Lotus 1-2-3 SmartMaster"',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','"Lotus 1-2-3 PIC"',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','"Excel',X2C(val_hex)
subval=31363330393200
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','"Quattro Pro',X2C(val_hex)
subval=31363932303100
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','Lotus Approach Document',X2C(val_hex)
subval=31373239363300
val_hex=subval
CALL ThisSysIni 'User','PMWP_ASSOC_TYPE','Lotus Organizer Database',X2C(val_hex)
 
/* Application: PM_Fonts */
/* SAY "Writing application: PM_Fonts" */
subval=5A3A5C4C4F54555357345C464F4E54535C30303131415F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','0011A___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C30303131425F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','0011B___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C30303131435F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','0011C___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C30303131445F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','0011D___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C30303131455F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','0011E___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C414E42495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ANBI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C414E425F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ANB_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C414E495F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ANI_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4E474F495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','NGOI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4E474F5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','NGO_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4E494D42495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','NIMBI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4E494D425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','NIMB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4E494D495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','NIMI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4E494D5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','NIM_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4F4E595F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ONY_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C5043424C5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PCBL____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4354525F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','CTR_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C464745435F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','FGEC____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C47415242495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GARBI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C474152425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GARB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C474152495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GARI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4741525F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GAR_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C47494C42495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GILBI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C47494C425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GILB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C414E5F5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','AN______.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C41524942495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ARIBI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C415249424C5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ARIBL___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C415249425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ARIB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C415249495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ARII____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4152495F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ARI_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C42415342495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','BASBI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C424153425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','BASB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C424153495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','BASI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4241535F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','BAS_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C42475F5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','BG______.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C424F4457495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','BODWI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C424F44575F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','BODW____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4252535F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','BRS_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C434F52425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','CORB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C435452495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','CTRI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C47494C435F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GILC____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C47494C495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GILI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C47494C555F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GILU____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C47494C5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','GIL_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C494D505F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','IMP_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4C4342495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','LCBI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4C43425F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','LCB_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4C43495F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','LCI_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4C435F5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','LC______.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4C595F5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','LY______.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4D415448415F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','MATHA___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4D415448425F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','MATHB___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4D415448435F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','MATHC___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4D535F5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','MS______.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4E474F425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','NGOB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C4E474F435F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','NGOC____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C50455242495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PERBI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C504552425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PERB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C504552495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PERI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C5045525F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PER_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C504843415F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PHCA____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C50484F495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PHOI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C50484F5F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PHO_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C5049425F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PIB_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C504C43435F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','PLCC____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C524F4342495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ROCBI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C524F43425F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ROCB____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C524F43435F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ROCC____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C524F43495F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ROCI____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C524F434C495F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ROCLI___.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C524F434C5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ROCL____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C524F435F5F5F5F5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','ROC_____.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C5454333231395A5F2E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','TT3219Z_.OFM',X2C(val_hex)
subval=5A3A5C4C4F54555357345C464F4E54535C5750504F5354312E4F464D00
val_hex=subval
CALL ThisSysIni 'User','PM_Fonts','WPPOST1.OFM',X2C(val_hex)
 
/* Application: Lotus Applications */
/* SAY "Writing application: Lotus Applications" */
subval=463A5C00
val_hex=subval
CALL ThisSysIni 'User','Lotus Applications','Install Source Directory',X2C(val_hex)
subval=5A3A5C4C4F54555357345C434F4D504E454E5400
val_hex=subval
CALL ThisSysIni 'User','Lotus Applications','Shared Directory',X2C(val_hex)
subval=5A3A5C4C4F54555357345C434F4D504E454E5400
val_hex=subval
CALL ThisSysIni 'User','Lotus Applications','Common Directory',X2C(val_hex)
 
/* Application: LotusSystemServices\4.0 */
/* SAY "Writing application: LotusSystemServices\4.0" */
subval=5A3A5C4C4F54555357345C434F4D504E454E545C4C5453494F34302E444C4C00
val_hex=subval
CALL ThisSysIni 'User','LotusSystemServices\4.0','LSI',X2C(val_hex)
subval=5A3A5C4C4F54555357345C434F4D504E454E545C4C544C524F34302E444C4C00
val_hex=subval
CALL ThisSysIni 'User','LotusSystemServices\4.0','ADPT',X2C(val_hex)
 
/* Application: LotusScriptExtensions\2.0 */
/* SAY "Writing application: LotusScriptExtensions\2.0" */
subval=5A3A5C4C4F54555357345C434F4D504E454E545C4C545352584F32302E444C4C00
val_hex=subval
CALL ThisSysIni 'User','LotusScriptExtensions\2.0','LTSREXX',X2C(val_hex)
 
/* Application: LotusSystemServices\3.0 */
/* SAY "Writing application: LotusSystemServices\3.0" */
subval=5A3A5C4C4F54555357345C434F4D504E454E545C4C544348455232302E444C4C00
val_hex=subval
CALL ThisSysIni 'User','LotusSystemServices\3.0','INFO',X2C(val_hex)
 
/* Application: WordPro */
/* SAY "Writing application: WordPro" */
subval=433A5C4F533200
val_hex=subval
CALL ThisSysIni 'User','WordPro','INIPath',X2C(val_hex)
 
/* Application: LotusGraphicFilters97 */
/* SAY "Writing application: LotusGraphicFilters97" */
subval=5A3A5C4C4F54555357345C434F4D504E454E545C464C54455253393700
val_hex=subval
CALL ThisSysIni 'User','LotusGraphicFilters97','LOCALPATH',X2C(val_hex)
 
/* call FastIniEnd mymkfileHandle */

/*****************************************************************************/
/* Finished on: 21 Nov 2000 at: 13:54:07                                     */
/*****************************************************************************/
return

copyIfNeeded:
   parse arg filename
   dest = OS2Dir'\..\'filename
   src  = WiseManager'\smartsuite\main\'filename
   if (VRFileExists(dest)=0) then do
      if (VRCopyFile(src, dest)<>1) then
         say 'Unable to copy 'src' to 'dest
   end
/*
else say 'Copied 'src' to 'dest
*/
return

ThisSysIni:
   parse arg p1, p2, p3, p4
   /* 'User','PM_Workplace:Templates','WordProDocObj:225121:News3.LWP',X2C(val_hex) */
   if (length(p4)>1) then do
      if (substr(p4,2,1)=":") then do
          if (translate(p4)="C:\OS2") then p4 = OS2Dir
          else if (length(p4)>10) then do
             if (translate(substr(p4,1,10)="Z:\LOTUSW4") then p4 = RunFrom'\'p.DirName || substr(p4,11)
          end
      end
   end
   call SysIni p1, p2, p3, p4
return