/* */
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then parse var string "'"BootDrive" "AppServer" "Action"'"
if (string<>"" & BootDrive="") then parse var string BootDrive" "AppServer" "Action
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  p.Title = "StarOffice"
  p.ThisCMDFileName = "CreateStarOffice.CMD"
  p.ObjectID = "<StarOfficeEXE>"
  p.DirName = "StarOffice"
  p.Class = "WPProgram"
  p.Location = "<WP_CLIENTAPPSFOLDER>"
  p.FitToCheck = ""
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "\Office51"   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""


  call StartUp

  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive"\"p.DirName
  p.SetupString = "EXENAME="p.ExeDir"\DeskTop.EXE;STARTUPDIR="p.StartDir";"
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = p.ObjectIDPre || "_Shadow>"  /* Set to blank for no desktop shadow */
  p.Doc= "OBJECTID="p.ObjectIDPre"_DOC>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\README.TXT;STARTUPDIR="p.StartDir";"  /* Set to blank for no readme */
  p.ObjectIDFolder = p.ObjectIDPre || "_FOLDER>" /* Set to blank for no folder */
  p.ObjectIDFolderShadow = p.ObjectIDPre || "_FOLDER_SHODOW>"
  p.ObjectIDFolderCleanUp = p.ObjectIDPre || "_FOLDER_CLEANUP>"
  p.ObjectIDFolderICON1 = WiseManager"\..\DeskTop\"p.DirName"\"p.DirName".ICO"
  p.ObjectIDFolderICON2 = WiseManager"\..\DeskTop\"p.DirName"\"p.DirName"1.ICO"

  CreateCollision = 'Replace'     /* 'Fail', 'Replace', or 'Update' */

   if (translate(Action)<>"LOCALINSTALL") then p.StartDir = BootDrive"\office51"

rc = CreateObject( 'WPFolder',,
    'StarOffice 5.1',,
    p.Location,,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'ALWAYSSORT=YES;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ICONFILE='WiseManager'\"p.DirName"\SFolder.ICO;'||,
        'ICONNFILE=1,'WiseManager'\"p.DirName"\SFolder1.ICO;'||,
        'OBJECTID=<SOffice>',,
    CreateCollision )

      title1 = "StarOffice 5.1"

   rc = CreateObject( 'WPProgram',,
      title1,,
      '<SOffice>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='RunFrom'\StarOffice\SOffice.EXE;'||,
          'STARTUPDIR='p.StartDir';'||,
          'PARAMETERS=;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<StarOfficeEXE>',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      title1,,
      '<WP_DESKTOP>',,
      'NOPRINT=YES;'||,
         'DEFAULTVIEW=UNKNOWN;'||,
         'HELPPANEL=1277;'||,
         'SHADOWID=<StarOfficeEXE>;'||,
         'OBJECTID=<StarOfficeEXEShadow>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'StarOffice 5.1^Setup',,
      '<SOffice>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='RunFrom'\StarOffice\Setup.EXE;'||,
          'STARTUPDIR='p.StartDir';'||,
          'PARAMETERS=;'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<StarOfficeSetup>',,
      CreateCollision )

   if (translate(Action)="LOCALINSTALL") then do
/*    create StarOffice sversion.ini             */
   file = substr(WiseManager,1,2)'\os2\sversion.ini'
   'del 'file' >nul:'
   iunit=stream(file,"Command","OPEN WRITE")
   call lineout file, "[Versions]"
   call lineout file, "StarOffice 5.1="BootDrive"\Office51"
   call lineout file, " "
   iunit=stream(file,"Command","CLOSE")


/*    add entries to OS2.INI                   */
  "attrib -h -s "substr(WiseManager,1,2)"\os2\os2.ini >nul:"
  WiseManager"\..\Tools\iniMerge "substr(WiseManager,1,2)"\os2\os2.ini "WiseManager"\"p.DirName"\OS2-CHG.INI"
  "attrib +h +s "substr(WiseManager,1,2)"\os2\os2.ini >nul:"

   end
   else do
/*    create StarOffice sversion.ini             */
   file = BootDrive'\os2\sversion.ini'
   'del 'file' >nul:'
   iunit=stream(file,"Command","OPEN WRITE")
   call lineout file, "[Versions]"
   call lineout file, "StarOffice 5.1="BootDrive"\Office51"
   call lineout file, " "
   iunit=stream(file,"Command","CLOSE")


/*    add entries to OS2.INI                   */
  "attrib -h -s "BootDrive"\os2\os2.ini >nul:"
  WiseManager"\..\Tools\iniMerge "BootDrive"\os2\os2.ini "WiseManager"\"p.DirName"\OS2-CHG.INI"
  "attrib +h +s "BootDrive"\os2\os2.ini >nul:"

  end

syntax:
signal cmdExit
return 0


