/* */

parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */

  p.Title = "eCSBasic"  /* Name of this application */
  p.ThisCMDFileName = "CreateeCSBasic.CMD"  /* Name of this command file */
  p.DirName = "eCSBasic"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_eCSBasic>"  /* Object to start (usually the main exe) */
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "\OS2"   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""   /* Class to check to see if this is a fresh install (classname dllname) */

  call StartUp

  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */

  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */

  CreateCollision = "Update"
  Call RegisterClasses
  Call CreateObjects

syntax:
signal CMDExit
return 0


MySysRegisterObjectClass: procedure expose p.ExeDir
   parse arg className, dllName
   code = SysRegisterObjectClass( className, dllName )
   If code <> 1 Then code = SysRegisterObjectClass( className, p.ExeDir || '\' || dllName || '.DLL' )
   If code <> 1 Then do
      Say 'Can''t register class 'className' with 'dllName'.'
   end
return code

CreateObjects:

   rc = SysSetObjectData("<WP_OS2SYS>","TITLE=eCS System")
   rc = SysSetObjectData("<WP_WINCFG>","TITLE=WIN-eCS Setup")
   rc = SysSetObjectData("<WP_TRBLTRA>","TITLE=eCS Trace Guide")
   rc = SysSetObjectData("<WP_OS2UGBK>","TITLE=eCS Desktop Guide")
   rc = SysSetObjectData("<WP_WIN2WIN>","TITLE=WIN-eCS Window")
   rc = SysSetObjectData("<WP_OS2WIN>","TITLE=eCS Window")
   rc = SysSetObjectData("<WP_WINFS>","TITLE=WIN-eCS Full Screen")
   rc = SysSetObjectData("<WP_OS2FS>","TITLE=eCS Full Screen")
   rc = SysSetObjectData("<OS_2_Command_File_CMD>","TITLE=eCS Command File.CMD")
   rc = CreateObject( 'WPShadow','README.IBM','<WP_READMEFOLDER>',,
         'SHADOWID='BootDrive'\README.IBM;'||'OBJECTID=<WP_RDME>','Update' )

   rc = SysSetObjectData( '<WiseMachineLocal>', 'ICONFILE='WiseManager'\ecsBasic\WiseMachine.ico')
   rc = SysSetObjectData( '<WP_OS2SYS>', 'ICONFILE='WiseManager'\ecsBasic\eCSSystem.ico')
   /* rc = SysSetObjectData( '<OS_2_System>', 'ICONFILE='WiseManager'\ecsBasic\eCSSystem.ico') */
   rc = SysSetObjectData( '<WP_ASSISTANCE>', 'ICONFILE='WiseManager'\ecsBasic\AssistanceCenter.ico;ICONNFILE=1,'WiseManager'\ecsBasic\AssistanceCenter2.ICO;')
   rc = SysSetObjectData( '<WP_PROGRAMSFOLDER>', 'ICONFILE='WiseManager'\ecsBasic\Programs.ICO')
   rc = SysSetObjectData( '<WP_SHRED>', 'ICONFILE='WiseManager'\ecsBasic\Shredder.ico')
   rc = SysSetObjectData( '<TCP/IP_SHADOWS>', 'ICONFILE='WiseManager'\ecsBasic\TCP!IP.ICO;ICONNFILE=1,'WiseManager'\ecsBasic\TCP!IP2.ICO;')

return

RegisterClasses:
return

