/* */
 
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */
 
  p.Title = "MFS"  /* Name of this application */
  p.ThisCMDFileName = "CreateMFS.CMD"  /* Name of this command file */
  p.DirName = "MFS"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_MFS>"  /* Object to start (usually the main exe) */
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = ""   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = "{RunFrom}"   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""   /* Class to check to see if this is a fresh install (classname dllname) */

  call StartUp
 
  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
 
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */
 
  CreateCollision = p.Flag
  Call RegisterClasses
  Call CreateObjects
 
syntax:
signal CMDExit
return 0
 
MySysRegisterObjectClass: procedure expose p.ExeDir
   parse arg className, dllName
   code = SysRegisterObjectClass( className, dllName )
   If code <> 1 Then code = SysRegisterObjectClass( className, p.ExeDir || '\' || dllName || '.DLL' )
   If code <> 1 Then do
      Say 'Can''t register class 'className' with 'dllName'.'
   end
return code
 
CreateObjects:
szClass=""
MainObjName = '<WP_CONNECTIONSFOLDER>'
iRetco = WPToolsQueryObject(MainObjName, "szClass", "szTitle", "szSetupString", "szLocation") 
if (szClass="" | szClass="SZCLASS") then MainObjName = '<WP_NETWORK>'

rc = CreateObject( 'WPFolder',,
    'Mobile Office Services',,
    MainObjName,,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=40,12;'||,
        'ICONVIEWPOS=15 61 80 37;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='WiseManager'\'p.DirName'\Mobile Off\Mobile Office Services1.ICO;'||,
        'OBJECTID=<MARSCM1>',,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Start^Mobile File Sync^Mobile Office Services',,
      '<MARSCM1>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=66,20;'||,
          'EXENAME='p.ExeDir'\BIN\MFS.EXE;'||,
          'STARTUPDIR='p.StartDir';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<MCMPROG>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Spy Utility',,
      '<MARSCM1>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=12,20;'||,
          'EXENAME='p.ExeDir'\BIN\HOARD.EXE;'||,
          'STARTUPDIR='p.StartDir';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<MCMSPY>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Stop^Mobile File Sync^Mobile Office Services',,
      '<MARSCM1>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=50,20;'||,
          'EXENAME='p.ExeDir'\BIN\STOPMFS.EXE;'||,
          'STARTUPDIR='p.StartDir';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<MCMSTOP>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Clear Persistence',,
      '<MARSCM1>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=36,20;'||,
          'EXENAME='p.ExeDir'\BIN\CLEARPS.EXE;'||,
          'STARTUPDIR='p.StartDir';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<MFSCP>',,
      CreateCollision )

  rc = CreateObject( 'WPCommandFile',,
      'MFS Status^  :None',,
      '<MARSCM1>',,
      'NOTDEFAULTICON=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=3,20;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Mobile Off\MFS Status!  !None1.ICO;'||,
          'READDATAFROM='WiseManager'\'p.DirName'\Mobile Off\MFS Status!  !None1.DAT;'||,
          'OBJECTID=<MFSOBJECT>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Stashing Database ',,
      '<MARSCM1>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=23,20;'||,
          'EXENAME='p.ExeDir'\BIN\DBSTASH.EXE;'||,
          'STARTUPDIR='p.StartDir';'||,
          'PROGTYPE=PM;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Mobile Off\Stashing Database 1.ICO;'||,
          'OBJECTID=<MFSST>',,
      CreateCollision )

rc = CreateObject( 'WPProgram',,
    'MFS README',,
    '<WP_READMEFOLDER>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'EXENAME=e.exe;'||,
        'STARTUPDIR='p.StartDir';'||,
        'PARAMETERS='p.ExeDir'\README.MFS;'||,
        'PROGTYPE=PM;'||,
        'OBJECTID=<MFSREADME>',,
    CreateCollision )

rc = CreateObject( 'WPProgram',,
    'Mobile Office Services^Guide',,
    '<WP_TASKSINFO>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'EXENAME=view.exe;'||,
        'STARTUPDIR='p.StartDir';'||,
        'PARAMETERS='p.ExeDir'\DOC\A9M05MST.INF;'||,
        'PROGTYPE=PM;'||,
        'OBJECTID=<MCMDOC>',,
    CreateCollision )

return

RegisterClasses:
/*

Say
Say 'Registering classes....'
Say
Say 'The following classes will be registered:'
Say
Say '  PRDirectory       '
Say
Say 'Press enter to register 1 classes for object creation,'
Call CharOut, 'or type any other key and enter to ignore: '
Say
Parse Pull Answer
If Answer <> '' Then return
*/

return

