/* */
 
parse arg string
parse var string '"'BootDrive' 'AppServer' 'Action'"'
if (string<>"" & BootDrive="") then do
   parse var string "'"BootDrive" "AppServer" "Action"'"
end
if (string<>"" & BootDrive="") then do
   parse var string BootDrive" "AppServer" "Action
end
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */
 
  p.Title = "PeerWPSFixUp"  /* Name of this application */
  p.ThisCMDFileName = "CreatePeerWPSFixUp.CMD"  /* Name of this command file */
  p.DirName = "PeerWPSFixUp"  /* Name of main dir */
  p.Location = "<WP_APPSFOLDER>"  /* Location to place main folder */
  p.ObjectID = "<OBJECT_PeerWPSFixUp>"  /* Object to start (usually the main exe) */
  p.FileToCheck = ""  /* File to check to see if this is a fresh install */
  p.DirToCheck = "\OS2"   /* Directory to check to see if this is a fresh install */
  p.PathToCheck = ""   /* Directory to check as part of the path env to see if this is a fresh install */
  p.ClassToCheck = ""   /* Class to check to see if this is a fresh install (classname dllname) */
 
  call StartUp
 
  p.Class = "WPProgram"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive||Apps"\"p.DirName
  p.SetupString = ""
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
 
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
  p.Doc= ""
  p.ObjectIDFolder = "" /* Set to blank for no folder */
 
  CreateCollision = p.Flag
  Call RegisterClasses
  Call CreateObjects
 
syntax:
signal CMDExit
return 0
 
 
MySysRegisterObjectClass: procedure expose p.ExeDir
   parse arg className, dllName
   code = SysRegisterObjectClass( className, dllName )
   If code <> 1 Then code = SysRegisterObjectClass( className, p.ExeDir || '\' || dllName || '.DLL' )
   If code <> 1 Then do
      Say 'Can''t register class 'className' with 'dllName'.'
   end
return code
 
CreateObjects:

rc = CreateObject( 'WPFolder',,
    'Network Services',,
    '<WP_NETWORK>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<WC_NETSERV>',,
    CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Logons',,
      '<WC_NETSERV>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'HELPPANEL=302;'||,
          'HELPLIBRARY='BootDrive'\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
          'ICONVIEWPOS=15 64 80 29;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Network Service\Logons.ICO;'||,
          'OBJECTID=<LS_FOLDER>',,
      CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'LAN Server^Logon',,
        '<LS_FOLDER>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=308;'||,
            'HELPLIBRARY='BootDrive'\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
            'ICONPOS=23,12;'||,
            'EXENAME='RunFrom'\MUGLIB\LOGON.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS=/v:domain /d;'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\'p.DirName'\Network Service\LAN Server!Logon.ICO;'||,
            'OBJECTID=<PEER_LANLOGON>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Logoff',,
        '<LS_FOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=309;'||,
            'HELPLIBRARY='BootDrive'\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
            'ICONPOS=15,12;'||,
            'EXENAME='RunFrom'\MUGLIB\LOGOFF.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS=/L;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<PEER_LOGOFF>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Start^File and Print Client',,
        '<LS_FOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=307;'||,
            'HELPLIBRARY='BootDrive'\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
            'ICONPOS=6,12;'||,
            'EXENAME='BootDrive'\IBMLAN\NETPROG\NETSTCMD.CMD;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS=START PEER;'||,
            'PROGTYPE=WINDOWABLEVIO;'||,
            'OBJECTID=<LS_START>',,
        CreateCollision )

    rc = CreateObject( 'LSPeerUser',,
        'Network User Account',,
        '<LS_FOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=SETTINGS;'||,
            'HELPPANEL=7501;'||,
            'HELPLIBRARY=LSPRWPS.HLP;'||,
            'ICONPOS=50,12;'||,
            'OBJECTID=<PEER_USER>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'File and Print Client^Workstation Logon',,
        '<LS_FOLDER>',,
        'NOPRINT=YES;'||,
            'MINWIN=DESKTOP;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'HELPPANEL=308;'||,
            'HELPLIBRARY='BootDrive'\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
            'ICONPOS=35,12;'||,
            'EXENAME='RunFrom'\MUGLIB\LOGON.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PARAMETERS=/v:local;'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<PEER_LOCALLOGON>',,
        CreateCollision )

  rc = CreateObject( 'WPFolder',,
      'Mobile Office Services',,
      '<WC_NETSERV>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=CONTENTS;'||,
          'ICONVIEWPOS=15 66 80 33;'||,
          'SELFCLOSE=1;'||,
          'ICONFONT=9.WarpSans;'||,
          'DETAILSFONT=9.WarpSans;'||,
          'TREEFONT=9.WarpSans;'||,
          'ICONVIEW=NONGRID,NORMAL;'||,
          'DETAILSVIEW=MINI;'||,
          'TREEVIEW=LINES,MINI;'||,
          'ICONFILE='WiseManager'\'p.DirName'\Network Service\Mobile Office Services.ICO;'||,
          'OBJECTID=<MARSCM1>',,
      CreateCollision )

    rc = CreateObject( 'WPCommandFile',,
        'MFS Status^  :None',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'ICONPOS=70,16;'||,
            'ICONFILE='WiseManager'\'p.DirName'\Network Service\MFS Status!  !None.ICO;'||,
            'READDATAFROM='WiseManager'\'p.DirName'\Network Service\MFS Status!  !None.DAT;'||,
            'OBJECTID=<MFSOBJECT>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Start^Mobile File Sync^Mobile Office Services',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=57,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\MFS.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MCMPROG>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Stop^Mobile File Sync^Mobile Office Services',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=41,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\STOPMFS.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MCMSTOP>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Clear Persistence',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=27,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\CLEARPS.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MFSCP>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Stashing Database ',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=14,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\DBSTASH.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'ICONFILE='WiseManager'\'p.DirName'\Network Service\Stashing Database .ICO;'||,
            'OBJECTID=<MFSST>',,
        CreateCollision )

    rc = CreateObject( 'WPProgram',,
        'Spy Utility',,
        '<MARSCM1>',,
        'NOTDEFAULTICON=YES;'||,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=RUNNING;'||,
            'ICONPOS=3,16;'||,
            'EXENAME='RunFrom'\MFS\BIN\HOARD.EXE;'||,
            'STARTUPDIR='BootDrive||Apps'\'p.DirName';'||,
            'PROGTYPE=PM;'||,
            'OBJECTID=<MCMSPY>',,
        CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'LAN Server^Administration',,
      '<WC_NETSERV>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=321;'||,
          'HELPLIBRARY='BootDrive'\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
          'EXENAME='BootDrive'\IBMLAN\NETPROG\NETGUI.EXE;'||,
          'STARTUPDIR='BootDrive'\IBMLAN\NETPROG';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<LS_ADMIN>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Install/Configure^LAN Services',,
      '<WC_NETSERV>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'HELPPANEL=321;'||,
          'HELPLIBRARY='BootDrive'\IBMLAN\NETPROG\LSIWOBJS.HLP;'||,
          'EXENAME='BootDrive'\IBMLAN\INSTALL\LANINST.EXE;'||,
          'STARTUPDIR='BootDrive'\IBMLAN\INSTALL';'||,
          'PROGTYPE=PM;'||,
          'OBJECTID=<LS_INSTCFG>',,
      CreateCollision )



  rc = CreateObject( 'LSPeerWorkstation',,
      'Shared Resources and^Network Connections',,
      '<WC_NETSERV>',,
      'NOPRINT=YES;'||,
          'MINWIN=DESKTOP;'||,
          'DEFAULTVIEW=SETTINGS;'||,
          'HELPPANEL=8001;'||,
          'HELPLIBRARY=LSPRWPS.HLP;'||,
          'OBJECTID=<PEER_WKST>',,
      CreateCollision )

return

RegisterClasses:
/*

Say
Say 'Registering classes....'
Say
Say 'The following classes will be registered:'
Say
Say '  LSPeerWorkstatio  XFldObject        PRDirectory       LSPeerUser        '
Say '  XFldDataFile      XFolder           SpeechObject      XFldProgramFile   '
Say
Say 'Press enter to register 8 classes for object creation,'
Call CharOut, 'or type any other key and enter to ignore: '
Say
Parse Pull Answer
If Answer <> '' Then return
*/
  rc = MySysRegisterObjectClass( 'LSPeerWorkstation', 'LSPRWPS' )

  rc = MySysRegisterObjectClass( 'PRDirectory', 'LSPRWPS' )

  rc = MySysRegisterObjectClass( 'LSPeerUser', 'LSPRWPS' )
 
return

