/* */
 
parse arg '"'BootDrive' 'AppServer' 'Action'"'
argString = '"'BootDrive' 'AppServer' CLEANUP"'   /* Needed later */
 
  p.Title = "DE99"
  p.ThisCMDFileName = "CreateDE99.CMD"
  p.DirName = "DE99"
  p.ObjectID = "<V100_DE99>"
  p.ObjectIDPre = Strip(p.ObjectID,"T",">")
  p.ObjectIDShadow = ""  /* p.ObjectIDPre || "_Shadow>" */  /* Set to blank for no desktop shadow */
 
  call StartUp
 
  p.Class = "WPProgram"
  p.Location = "<WP_APPSFOLDER>"
  p.ExeDir = RunFrom"\"p.DirName
  p.StartDir = BootDrive"\Apps\"p.DirName
  p.SetupString = "EXENAME="p.ExeDir"\DE99.EXE;STARTUPDIR="p.StartDir";"
  p.Flag = "Replace"     /* "Fail", "Replace", or "Update" */
  p.Doc= "OBJECTID="p.ObjectIDPre"_DOC>;EXENAME=E.EXE;PARAMETERS="p.ExeDir"\README.TXT;STARTUPDIR="p.StartDir";"  /* Set to blank for no readme */
  p.ObjectIDFolder = p.ObjectIDPre || "_FOLDER>" /* Set to blank for no folder */
  if (p.ObjectIDShadow="") then
     p.ObjectIDFolderShadow = p.ObjectIDPre || "_FOLDER_SHODOW>"
  else
     p.ObjectIDFolderShadow = ""
  p.ObjectIDFolderCleanUp = p.ObjectIDPre || "_FOLDER_CLEANUP>"
  p.ObjectIDFolderICON1 = RunFrom"\WiseManager\"p.DirName"\"p.DirName".ICO"
  p.ObjectIDFolderICON2 = RunFrom"\WiseManager\"p.DirName"\"p.DirName"1.ICO"
  p.ObjectID = ""
 
  /*
     Action can be blank, CLEANUP, or START 
     blank means normal create with REBOOT required title
     CLEANUP means create ICON without the REBOOT required title 
     START   means starts up the main program
  */
 
  Action = translate(Action)
  if (Action = "START") then do
     if (p.ObjectID <> "") then rc = SysOpenObject("p.ObjectID", "RUNNING", 0)
     "@exit"
     return
  end /* do */
 
  call MyRegisterClasses
  call MyCreateObjects
 
syntax:
signal CMDExit
return 0
 
MyRegisterClasses:
return
 
MyCreateObjects:
  if (p.ObjectIDFolder <> "") then do
     rc = CreateObject( "WPFolder",,
         p.Title,,
         p.Location,,
        'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'HELPPANEL=22000;'||,
        'HELPLIBRARY=OBJDHELP.HLP;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='p.ObjectIDFolderICON1';'||,
        'ICONNFILE=1,'p.ObjectIDFolderICON2';'||,
        'OBJECTID='p.ObjectIDFolder,,
         p.Flag )
 
      if (p.ObjectIDShadow="") then do
        rc = CreateObject( 'WPShadow',,
            p.Title,,
            '<WP_DESKTOP>',,
            'SHADOWID='p.ObjectIDFolder';'||,
            'OBJECTID='p.ObjectIDFolderShadow,,
         p.Flag )
      end
 
      p.Location = p.ObjectIDFolder
  end
 
  if (p.ObjectID<>"") then do
     rc = CreateObject( p.Class,,
         p.Title,,
         p.Location,,
         p.SetupString ||,
             "NOPRINT=YES;"||,
             "DEFAULTVIEW=RUNNING;"||,
             "OBJECTID="p.ObjectID";",,
         p.Flag )
  end
 
  if (p.ObjectIDShadow<>"") then do
     rc = CreateObject( "WPShadow",,
         p.Title,,
         "<WP_DESKTOP>",,
            "DEFAULTVIEW=UNKNOWN;"||,
            "NOPRINT=YES;"||,
            "HELPPANEL=1277;"||,
            "SHADOWID="p.ObjectID";"||,
            "OBJECTID="p.ObjectIDShadow";",,
         p.Flag )
  end
 
  if (p.doc<>"") then do
       rc = CreateObject( p.Class,"Read ME",p.Location,p.doc||"NOPRINT=YES;"||"DEFAULTVIEW=RUNNING;",p.Flag )
  end
 
  /* Misc program files goes here */
  PgmFiles = ""     /* ABC.EXE DEF.CMD */
  do while (PgmFiles<>"")
     PgmFiles = strip(PgmFiles)
     parse var PgmFiles p.Title"."suf" "PgmFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     p.SetupString = "EXENAME="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<DE99_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title, p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
  end /* do */
 
  /* Misc text files goes here */
  TxtFiles = "UPDATE.DAT REGFORM.TXT DATINFO.TXT"     /* ABC.TXT DEF.TXT */
  do while (TxtFiles<>"")
     TxtFiles = strip(TxtFiles)
     parse var TxtFiles p.Title"."suf" "TxtFiles
     if (Pos(".",p.Title)>0) then parse var p.Title p.Title"."suf
     if (translate(suf)="INF") then prog = "View"
     else if (translate(suf)="HTM" | translate(suf)="HTML") then prog = RunFrom"\NetScape\Program\NetScape"
     else prog = "E"
     p.SetupString = "EXENAME="prog".EXE;PARAMETERS="p.ExeDir"\"p.Title"."suf";STARTUPDIR="p.StartDir";"
     p.ObjectID = "<DE99_"p.Title""suf">"
     rc = CreateObject( p.Class, p.Title || "."suf"", p.Location, p.SetupString || "NOPRINT=YES;"|| "DEFAULTVIEW=RUNNING;"|| "OBJECTID="p.ObjectID";", p.Flag )
     end /* do */
return
 
/* Copy these lines for every ap */
CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    /* Say "Creating ["Title"]" */
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say " > failed to create ["Title" | "Class"] at location ["Location"]"
return rc
 
StartUp: /* Do not make this a procedure */
  signal on Syntax name lab0
  rc = RxFuncAdd( "SysLoadFuncs", "REXXUTIL", "SYSLOADFUNCS" )
  rc = SysLoadFuncs()
lab0:
  signal on Syntax
 
  CRLF = D2C(13)||D2C(10)
  /* Pass value to AppServer.cmd */
   ov  = Value( "APPSERVERCMD", , "OS2ENVIRONMENT" )
   "SET APPSERVERCMD='"AppServer" "BootDrive"'"
   "call "BootDrive"\DeskTopT\AppServer.cmd"
  /* Retrieve value from AppServer.cmd */
   rc  = Value( "APPSERVERCMD", , "OS2ENVIRONMENT" )
   parse var rc AppServer" "RunFrom
   RunFrom = RunFrom || "\Apps"
   "SET APPSERVERCMD="ov
 
   if (IsDir(RunFrom"\"p.DirName)=0) then do  
 
    rc = CreateObject( "WPProgram",,
      p.Title||CRLF||"(Reboot Required)",,
      "<WP_START>",,
      "NOPRINT=YES;"||,
          "DEFAULTVIEW=RUNNING;"||,
          "EXENAME="RunFrom"\DeskTopT\"p.ThisCMDFileName";"||,
          "PARAMETERS="argString";"||,
          "PROGTYPE=PM;"||,
          "OBJECTID=<"p.Title"_FOLDER_CLEANUP>",,
      "REPLACE" )
 
    rc = CreateObject( "WPShadow",,
        p.Title||CRLF||"(Reboot Required)",,
        "<WP_DESKTOP>",,
            "SHADOWID=<"p.Title"_FOLDER_CLEANUP>;"||,
            "OBJECTID=<"p.Title"_FOLDER_CLEANUP_SHADOW>",,
        "REPLACE" )
 
      "@exit"
 
   end /* do */
 
return
 
cmdExit:
   rc = SysDestroyObject( "<"p.Title"_FOLDER_CLEANUP_SHADOW>" )
   rc = SysDestroyObject( "<"p.Title"_FOLDER_CLEANUP>" )
"@exit"
return
 
IsDir: procedure
   parse arg DirName
   DirName=strip(DirName,"B","'")
   if (DirName="") then do
      /* say "IsDir: illegal file spec "DirName */
      return 0
   end
   if stream(DirName"\.","C","QUERY DATETIME")="" then rc = 0
   else rc = 1
return rc
