/* ******************************************* */
/* REXX script to set up Acrobat Reader for    */
/* OS/2 WPS folder and objects, or to          */
/* deregister objects for uninstall.           */
/*                                             */
/* Usage:                                      */
/*    ACROWPS [Acrobat installation directory] */
/*                                             */
/*    to install Workplace shell objects and   */
/* folder;                                     */
/*                                             */
/*    ACROWPS REMOVE                           */
/*                                             */
/*    to uninstall Acrobat objects and folder  */
/*                                             */
/* ******************************************* */

signal on error

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse arg installDir .

className = "AApdf"


/* If we pass "remove", call routine to remove workplace shell info for 
   Acrobat */

parse upper var installDir puArg
if puArg = "REMOVE" then call RemoveAcrobat;
 

/* Test whether install directory provided as argument. */
if installDir = "" then
  do
     /* See if we can find Acrobat using class registered at installation. */
     call SysQueryClassList "classes."
     do i = 1 to classes.0
        if word( classes.i, 1 ) = className then
           do
              installDir = word( classes.i, 2 )
              n = lastPos( '\', installDir )
              installDir = substr( installDir, 1, n-1 )
              leave
           end
     end
  end

if installDir = "" then
   do
      say ' Usage:                                              ';
      say '    ACROWPS [Acrobat installation directory]         ';
      say '                                                     ';
      say '       to install Workplace shell objects and folder ';
      say '                                                     ';
      say '    ACROWPS REMOVE                                   ';
      say '                                                     ';
      say '       to uninstall Acrobat objects and folder       ';
      say ' ';
      exit 0
   end

else

/* Register the WPS class. */
if SysRegisterObjectClass( className, installDir'\aapdf.dll' ) then
  say 'WPS class' className 'was registered.'
else
  say 'Failed to register WPS class' className'.'

/* Create the desktop folder. */
if SysCreateObject( "WPFolder", "Adobe Acrobat", "<WP_DESKTOP>", "OBJECTID=<ACROBAT>", 'R' ) then
  say 'Acrobat folder was created on desktop.'
else
  say 'Failed to create Acrobat folder on desktop.'

/* Create program reference for the reader. */
progSettings = 'PROGTYPE=PM;ASSOCTYPE=Acrobat Document;ASSOCFILTER=*.pdf,*pdf;EXENAME='installDir'/acroread.EXE;STARTUPDIR='installDir';OBJECTID=<ACROBAT_READER>'
if SysCreateObject( "WPProgram", "Acrobat Reader 3.0", "<ACROBAT>", progSettings, 'R' ) then
   say 'Program object for acroread.exe was created.'
else
   say 'Failed to create program object for acroread.exe'

/* Create shadow of read.me file. */
if SysCreateObject( "WPShadow", "Acrobat Reader READ.ME", "<ACROBAT>", "SHADOWID="installDir"\read.me;OBJECTID=<ACROBAT_READER_README>", 'R' ) then
   say 'Shadow for read.me file was created.'
else
   say 'Failed to create shadow for read.me file.'

/* Create program object for uninstaller. */
progSettings = "PROGTYPE=WINDOWABLEVIO;NOAUTOCLOSE=NO;MINIMIZED=YES;EXENAME=CMD.EXE;ICONFILE="installDir"\epfiicis.ico;PARAMETERS=/c" installDir"\uninst.exe;STARTUPDIR="installDir";OBJECTID=<ACROBAT_READER_UNINST>"
if SysCreateObject( "WPProgram", "Acrobat Reader Uninstall", "<ACROBAT>", progSettings, 'R' ) then
   say 'Program object for uninstall utility was created.'
else
   say 'Failed to create program object for uninstall utility.'

/* Give acrobat executable proper object id. */
'@'installDir'\aapdfrel' installDir'\acroread.exe "OBJECTID=<ACROBAT_READER_EXE>" >nul'
say 'Object ID set for acroread.exe.'

say 'Adobe Acrobat for OS/2 WPS folder creation completed.'
exit

/* 
*   RemoveAcrobat
*        Deregisters Workplace shell class ('AApdf'), removes acrobat folder 
* and objects. Also removes Acrobat Document from PMASSOCTtype key in OS2.ini.
*/
RemoveAcrobat:

     /* See if we can find Acrobat using class registered at installation. */

     instDir="."; /* default to current directory*/

     call SysQueryClassList "classes."
     do i = 1 to classes.0
        if word( classes.i, 1 ) = className then
           do
              instDir = word( classes.i, 2 )
              n = lastPos( '\', instDir )
              instDir = substr( instDir, 1, n-1 )
              leave
           end
     end

     /* Now Deregister Workplace shell class */

     if SysDeregisterObjectClass( className ) then
        say "Successfully Deregistered Acrobat Workplace Shell class"
     else
        say "Unable to Deregister Acrobat SOM Class"

     /* Unlock DLL so it can be deleted */

     '@'instDir"\\aapdfrel " instDir"\\aapdf.dll"
     say "Workplace Shell class DLL unlocked";

     /* Now delete Acrobat folder, and all objects within it. */

     '@'instDir"\del_ini";
     
     say "You may now delete the acrobat reader directory."
exit
