{  NTS R3 (Neuron Tropic Sound Release 3) }
{ --------------------------------------- }
{ (c) 1996-1996 Juho Pesonen.             }



uses os2def,use32,os2base,dos,ultradev,strings,vputils;

const
   version: string                  = 'NTS/2 R3 v0.18z                    Neuron Tropic Sound (c) 1996-97 Juho Pesonen';
   hexc: array [0..15] of char =
    ('0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f');
   period:array[0..11] of longint=(1712,1616,1524,1440,1356,1280,1208,1140,1076,1016,0960,0907);
   notes:array[1..12] of string=('C-','C#','D-','D#','E-','F-','F#','G-','G#','A-','A#','B-');
   fx:array[0..26] of string[32]=('            ',
                                  'speed       ',
                                  'jump        ',
                                  'patt. break ',
                                  'volume slide',
                                  'porta down  ',
                                  'porta up    ',
                                  'porta note  ',
                                  'vibrato     ',
                                  'tremor      ',
                                  'arpeggio    ',
                                  'vib&vsld    ',
                                  'prt&vsld    ',
                                  '--          ',
                                  '--          ',
                                  'offset      ',
                                  '--          ',
                                  'retrig note ',
                                  'tremolo     ',
                                  'Sxx command ',
                                  'tempo       ',
                                  'fine vibrato',
                                  'global vol  ',
                                  '--          ',
                                  'unused cmd  ',
                                  '--          ',
                                  '8xx command ');

   end_txt:array[0..8] of string[80]=(
   'NTS/2 R3 -- Neuron Tropic Sound Release 3 v0.18z  (c) 1997 Neuron Productions',
   ' ',
   '  Sources (Virtual Pascal 1.1) available at Image BBS, +358-2-4381720.',
   ' ',
   '  To contact me/us: call Image BBS or send email to jupesone@freenet.hut.fi',
   ' ',
   '  If you have problems with sample downloading try -o parameter !',
   '  (eg. NTSR3.EXE TEST.S3M -o). ',' ');
type
   pattrec = record
                note : array[0..15,0..63] of system.word;
                ins : array[0..15,0..63] of byte;
                vol : array[0..15,0..63] of byte;
                cmd : array[0..15,0..63] of byte;
                arg : array[0..15,0..63] of byte;
             end;
   pattptr = ^pattrec;
   smprec  = record
                len     : word;
                vol     : byte;
                rate    : word;
                loopbeg : word;
                loopend : word;
                guspos  : word;
                lmode   : boolean;
                mempos  : pointer;
             end;
   smpptr  = ^smprec;
var
   c                   : char;
   patt                   : array[0..255] of pattptr;
   smp                    : array[0..255] of smpptr;
   loadf               : file;
   ordnum,insnum,patnum,tempo,speed,otempo,ospeed : word;
   err                    : word;
   orders                 : array[0..256] of byte;
   chan                   : array[0..31] of byte;
   buf                    : array[0..$ffff] of byte;
   ttid                   : tid;
   p_vol               : array[0..15] of byte;
   p_arg               : array[0..15] of byte;
   p_cmd               : array[0..15] of byte;
   p_ins               : array[0..15] of byte;
   p_note                 : array[0..15] of byte;
   fiba_count                : array[0..15] of byte;
   p_per               : array[0..15] of integer;
   p_rate                 : array[0..15] of longint;
   p_foo               : array[0..15] of boolean;
   p_bars                 : array[0..15] of integer;
   p_song                 : string[29];
   p_filetype                : string[16];
   p_insname                 : array[0..127] of string[29];
   p_hilimode                : boolean;
   p_loop                 : word;
   globalvol                 : integer;
   updeittaa                 : boolean;
   p_patt,p_ord,p_row              : byte;
   channels               : byte;
   pbreak                 : boolean;
   main_exit,mode_mono             : boolean;
   play_finished             : boolean;
   p_disabled                : boolean;
   msg_scr1               : word;
   msg_scr2               : word;
   msg_y               : word;
   msg_lines                 : word;
   msg_count                 : word;
   msg_msg                : array[0..127] of string[80];
   alternate_tempo              : boolean;
   debug_var1                : word;
   filtered_out                 : word;
   scrtid,scrtid2            : tid;
   exit_scr               : boolean;
   __exit                 : boolean;
   __memalloc                : boolean;
   __brutalexit                 : boolean;
   filsiz                 : string;
   debugmode                 : boolean;
   sini                   : array[0..4095] of integer;
   sinic               : array[0..15] of word;
   pt_class,pt_delta:integer;

   const sinimax=127;

(* some variables for pattern play thread.. *)
var
   is_volslide : array[0..15] of boolean;
   is_slidedn  : array[0..15] of boolean;
   is_slideup  : array[0..15] of boolean;
   soffs       : array[0..15] of byte;
   notebuf     : array[0..15] of byte;
   notedelay   : array[0..15] of byte;
   portanote   : array[0..15] of boolean;
   portafinal  : array[0..15] of word;
   vibrato     : array[0..15] of boolean;
   vb_inc,vb_depth:array[0..15] of word;
   arp     : array[0..15] of boolean;
   arp_cn,arp_x,arp_y,arp_rate:array[0..15] of word;
   fvibrato     : array[0..15] of boolean;
   fvb_inc,fvb_depth:array[0..15] of word;

(* some variables to scope/sw-mixer *)
var
   sw_inc  : array[0..15] of word;
   sw_buf  : array[0..15,0..320] of word;
   sw_bufc : array[0..15] of word;
   sw_last : array[0..15] of byte;


function hex(w : byte):string; forward;
function readbyte(zz:word):byte; forward;
function readword(zz:word):system.word; forward;
procedure m_addstr(st : string); forward;
procedure gotoxy(x,y : byte);forward;
function getnote(zz:word):string; forward;

{$i comptime.pas}
{$i dbuildnum.pas}
{$i fileutils.pas}
{$i s3mloader.pas}
{$i modloader.pas}
{$i almost_direct_video_interface.pas}


(* Quick and Dirty exception handler *)

var
   PrevXcptProc   : Pointer;
   isused   : boolean;
   exit : boolean;

function CtrlBreakHandler(Report       : PExceptionReportRecord;
           Registration : PExceptionRegistrationRecord;
           Context      : PContextRecord;
           P          : Pointer): Longint; cdecl;
begin
   CtrlBreakHandler := xcpt_Continue_Search;
   if (Report^.ExceptionNum = xcpt_Signal) then
      case Report^.ExceptionInfo[0] of
   xcpt_Signal_Intr,xcpt_Signal_Break:
      begin;
    CtrlBreakHandler:= xcpt_Continue_Execution;
      end;
      end;
   if not (isused) then begin;
      writeln('*** Closing program..');
      globalvol:=0;
      __brutalexit:=true;            {quit whole player}
      ultraunblockall;
      ultrareleaseaccess;
   end;

   isused:=true;

   XcptProc := PrevXcptProc;
end;



(* user interface subroutines *)

var
   curs : viocursorinfo;

procedure hidecursor;
begin;
   viogetcurtype(curs,0);
   curs.attr:=$ffff;
   viosetcurtype(curs,0);
end;

procedure m_reset;
begin;
   msg_count:=0;
   msg_lines:=0;
end; { m_reset }


procedure m_addstr(st : string);
begin;
   msg_msg[msg_count]:=st;
   inc(msg_count);
   inc(msg_lines);
end; { m_addstr }

procedure m_bar;
var
   q,w,e : word;
begin;
   write(#27,'[0;1;37;44m');
   gotoxy(0,msg_scr1);write('');
   gotoxy(0,msg_scr2);write('');
   w:=msg_scr2-1-msg_Scr1+1;
   for q:=msg_scr1+1 to msg_scr2-1 do
   begin;
      gotoxy(0,q);
      if q<>e+msg_scr1+1 then write('') else write('');
   end;
end;

procedure m_disp;
var
   q,w,e : word;
begin;
   write(#27,'[0;37;44m');
   if msg_y>msg_lines-(msg_scr2-msg_scr1)-1 then msg_y:=0;
   for q:=0 to msg_Scr2-msg_scr1 do
   begin;
      gotoxy(1,msg_scr1+q);
      if q+msg_y<msg_lines then write(' ',msg_msg[q+msg_y],#27,'[2K') else write(#27,'[2K');
   end;
   m_bar;
end; { m_disp }

procedure m_incy;
begin;
   if msg_y<msg_lines-(msg_scr2-msg_scr1)-1 then inc(msg_y);
   m_disp;
end; { m_incy }

procedure m_decy;
begin;
   if msg_y>0 then dec(msg_y);
   m_disp;
end; { m_incx }

procedure gotoxy(x,y : byte);
begin;
   viosetcurpos(y,x,0);
end; { gotoxy }

function dummy:integer;
begin;
   dossleep(500000);
end;




var
 db1,db2:word;


(* Calculate note period *)

function calcperiod(note,ins : word):word;
var
   per,oct : word;
begin;
   if smp[ins]^.rate>0 then
   begin;
     note:=note;
     per:=note mod 12;
     oct:=(note div 12);
     calcperiod:=((8363*16*((period[per]*$f) shr oct)) div smp[ins]^.rate) div $f;
   end
   else
   begin;
     calcperiod:=1;
   end;
end;

(* period -> samplerate *)

function calcrate(period:word):word;
var q:word;
begin;
   if period<>0 then
           q:=14317056 div period

      else
           q:=1;
   calcrate:=q;
end;

(* convert volumes *)

function cvol(qq :integer):integer;
var
   z : integer;
begin;
   z:=(globalvol*qq) div 100;
   if z<0 then z:=0;
   if z>511 then z:=511;
   cvol:=z;
end;

function hex(w : byte):string;
begin
   hex:=hexc[w shr 4]+hexc[w and $F];
end;


(* file tools *)

function readbyte(zz:word):byte;
var a :byte;
begin;
   seek(loadf,zz);blockread(loadf,a,1); readbyte:=a;
end; { readbyte }

function readword(zz : word):system.word;
var a : system.word;
begin;
   seek(loadf,zz);blockread(loadf,a,2); readword:=a;
end; { readword }



(* play sample with attributes *)

procedure play(cha,sm,vol,rate,ofz :word );
begin;
   if (smp[sm]^.rate>0) and (rate>0) then
    begin;
      if smp[sm]^.lmode then
      begin; { luuppaa }
        Ultrastopvoice(cha);
         if vol>$3f then
         begin;
            vol:=smp[sm]^.vol;
            p_vol[cha]:=vol;
         end;
         UltraSetAll(cha,chan[cha],rate,cvol(vol*8),$2f,0);
         UltraStartVoice(cha,
                         smp[sm]^.guspos+ofz*$100,
                         smp[sm]^.guspos+smp[sm]^.loopbeg,
                         smp[sm]^.guspos+smp[sm]^.loopend,
                         LoopEnable);
      end
      else
      begin; { ei luuppaa }
        Ultrastopvoice(cha);
         if vol>$3f then
         begin;
            vol:=smp[sm]^.vol;
            p_vol[cha]:=vol;
         end;
         UltraSetAll(cha,chan[cha],rate,cvol(vol*8),$2f,0);
         UltraStartVoice(cha,
                         smp[sm]^.guspos+ofz*$100,
                         smp[sm]^.guspos+ofz*$100,
                         smp[sm]^.guspos+smp[sm]^.len,
                         Voice8Bit);
      end;
    end
    else
    begin;
       Ultrastopvoice(cha); {Invalid note -> stop current voice in channel "cha"}
    end;
end; { play }

var
   dtimer_cnt : word;
   old_t      : word;
   ols_s      : word;


(* initialize timer *)

procedure dtimer_init;
begin;
   if alternate_tempo then
      dtimer_cnt:=(12500000 div (tempo*49*32)) else
         dtimer_cnt:=(12500000 div (tempo*50*32));
   ultrastarttimer(2,dtimer_cnt);
end;

(* block player thread (when called from thread) *)

procedure dtimer_delay;
var
   q : word;
begin;
   ultrablocktimerhandler2;
end; { dtimer_delay }


procedure  clear_all;
var
   q : byte;
begin;
   for q:=0 to channels do
   begin;
      soffs[q]:=0;
      is_volslide[q]:=false;
      is_slidedn[q]:=false;
      is_slideup[q]:=false;
   end;
end;

function upd_scr(parm1:Pointer) : Longint; forward;


(* suspend screen update thread *)

procedure test2_;
begin;
   dossuspendthread(scrtid2);
end; { test2_ }


function scr_stuff(parm1:Pointer) : Longint;
var
   q,w,e,r : word;
begin;
   repeat
      for q:=0 to channels do
      begin;
         if p_foo[q] then p_bars[q]:=p_vol[q];
         drawbar(q,p_bars[q]);
         addscrbuf((240+78+q*80),0,hex(chan[q]));
         VioShowBuf((240+60+q*80)*2,39,0);
         if p_bars[q]>4 then dec(p_bars[q],4) else p_bars[q]:=0;
      end;
      test2_;
   until main_exit;
   dosexit(exit_thread,0);
end;

procedure scr_startupd;
var
   q,w,e,r,t : word;
begin;
   dosresumethread(scrtid);
   dosresumethread(scrtid2);
end; { scr_startupd }

procedure scr_startupd2;
var
   q,w,e,r,t : word;
begin;
   dosresumethread(scrtid2);
end; { scr_startupd }

var
   loopcount:word;
var
   cur_ord,row   : byte;
   tt            : byte;

(* Player thread *)

function playthd(parm1:Pointer) : Longint;       { ** Pattern play thread ** }

var
   q,w,e,ins,note,vol,r : byte;
   frame,cha            : byte;
   new_timer            : boolean;
   arg                  : byte;

begin;
   clear_all;
   play_finished:=false;
   pbreak:=false;
   new_timer:=false;
   otempo:=tempo;ospeed:=speed;
   dtimer_init;
   loopcount:=0;

   repeat
   if loopcount>0 then begin;
     clear_all;
     play_finished:=false;
     pbreak:=false;
     new_timer:=false;
     tempo:=otempo;speed:=ospeed;
     dtimer_init;
   end;

   for cur_ord:=0 to ordnum-3 do
   begin;
      p_ord:=cur_ord;
      tt:=orders[cur_ord];
      p_patt:=tt;
      for row:=0 to 63 do
      begin;
         if __exit then break;
         p_row:=row;
         clear_all;
                                 (* 1st frame -- init -> make frame play data *)
         for cha:=0 to channels do
         begin;
            if __exit then break;
            debug_var1:=cha;
            portanote[cha]:=false;
            vibrato[cha]:=false;
            fvibrato[cha]:=false;
            arp[cha]:=false;
            notedelay[cha]:=0;

            if patt[tt]^.arg[cha,row]<>0 then p_arg[cha]:=patt[tt]^.arg[cha,row];
            p_cmd[cha]:=patt[tt]^.cmd[cha,row];

            if patt[tt]^.ins[cha,row]<>0 then
            begin;
               p_ins[cha]:=patt[tt]^.ins[cha,row];              (* read instrument *)
            end;
            notebuf[cha]:=patt[tt]^.note[cha,row];            (* read note *)


            if patt[tt]^.vol[cha,row]<64 then                (* read volume, if <64 *)
            begin;
               p_vol[cha]:=patt[tt]^.vol[cha,row];
               if (notebuf[cha]>98) then
               begin;
                                                          (* apply new volume, if no new note *)
                  ultravectorlinearvolume(cha,cvol(p_vol[cha]*8),$2f,0);
                  p_foo[cha]:=true;
               end;
            end
            else
            begin;
               if ((notebuf[cha]<254) and (patt[tt]^.ins[cha,row]<>0)) then
                  p_vol[cha]:=smp[p_ins[cha]]^.vol;
            end;

            if (notebuf[cha]<99) and (p_cmd[cha]<>7) {and (p_cmd[cha]<>12)} then
            begin;                                       (* normal noteplay *)
               p_note[cha]:=notebuf[cha];
               p_per[cha]:=calcperiod(p_note[cha],p_ins[cha]);
            end;

            if (notebuf[cha]=99) and (p_cmd[cha]<>7) {and (p_cmd[cha]<>12)}  then  (* retrigger note with new ins *)
            begin;
               p_ins[w]:=ins;
               p_per[cha]:=calcperiod(p_note[cha],p_ins[cha]);
            end;

            (*
             *  Read command row ..
             *)

            if p_cmd[cha]<>0 then
            begin;
               if p_cmd[cha]=8 then
               begin;
                  if patt[tt]^.arg[cha,row]<>0 then
                  begin;
                  fiba_count[cha]:=patt[tt]^.arg[cha,row];
                 { if (fiba_count[cha] shr 4)<>0 then} vb_inc[cha]:=fiba_count[cha] shr 4;
                 { if (fiba_count[cha] and $f)<>0 then} vb_depth[cha]:=fiba_count[cha] and $f;
                 end;
                  vibrato[cha]:=true;
               end;
               if p_cmd[cha]=10 then
               begin;
                  if (p_arg[cha] shr 4)<>0 then arp_x[cha]:=p_arg[cha] shr 4;
                  if (p_arg[cha] and $f)<>0 then arp_y[cha]:=p_arg[cha] and $f;
                  arp[cha]:=true;
               end;
               if p_cmd[cha]=21 then
               begin;
                  if (p_arg[cha] shr 4)<>0 then fvb_inc[cha]:=p_arg[cha] shr 4;
                  if (p_arg[cha] and $f)<>0 then fvb_depth[cha]:=p_arg[cha] and $f;
                  fvibrato[cha]:=true;
               end;
               if p_cmd[cha]=11 then vibrato[cha]:=true;
               if p_cmd[cha]=1 then     (* set speed*)
               begin;
                  speed:=p_arg[cha];
                  dtimer_init;
{                 new_timer:=true;}
               end;
               if p_cmd[cha]=20 then    (* set tempo *)
               begin;
                  tempo:=p_arg[cha];
                  dtimer_init;
{                 new_timer:=true;}
               end;
               if (p_cmd[cha]=7) or (p_cmd[cha]=12) then
               begin;

                  portanote[cha]:=true;
                  if p_cmd[cha]<>12 then
                     if notebuf[cha]<99 then portafinal[cha]:=calcperiod(notebuf[cha],p_ins[cha]);
               end;
               if p_cmd[cha]=3 then pbreak:=true;            (* pattern break *)
               if ((p_cmd[cha]=4) or
                   (p_cmd[cha]=11) or
                   (p_cmd[cha]=12)) then
               begin;
                  is_volslide[cha]:=true;                    (* volume slide *)
                  p_foo[cha]:=true;
                  if p_arg[cha] shr 4=$f then
                     if p_arg[cha] and $f<>0 then
                     begin;
                        if (p_vol[cha]-(p_arg[cha] and $f))>0 then
                           dec(p_vol[cha],p_arg[cha] and $f) else p_vol[cha]:=0;
                        is_volslide[cha]:=false;
                     end;
                  if p_arg[cha] and $f=$f then
                     if p_arg[cha] shr 4<>0 then
                     begin;
                        if (p_vol[cha]+(p_arg[cha] shr 4))<63 then
                           inc(p_vol[cha],p_arg[cha] shr 4) else p_vol[cha]:=63;
                        is_volslide[cha]:=false;
                     end;
                  ultravectorlinearvolume(cha,cvol(p_vol[cha]*8),$2f,0);
               end;
               if p_cmd[cha]=5 then(* slide down *)
               begin;
                  if p_arg[cha] shr 4=$f then
                     inc(p_per[cha],(p_arg[cha] and $f)*4)
                  else
                     if p_arg[cha] shr 4=$e then
                        inc(p_per[cha],(p_arg[cha] and $f))
                     else
                        is_slidedn[cha]:=true;
               end;
               if p_cmd[cha]=6 then(* slide up *)
               begin;
                  if p_arg[cha] shr 4=$f then
                     dec(p_per[cha],(p_arg[cha] and $f)*4)
                  else
                     if p_arg[cha] shr 4=$e then
                        dec(p_per[cha],(p_arg[cha] and $f))
                     else
                  is_slideup[cha]:=true;
               end;

               if p_cmd[cha]=$f then
               begin;
                   soffs[cha]:=p_arg[cha]; (* set sampleoffset *)
                 end;
               if p_cmd[cha]=19 then                         (* Special command ...*)
               begin;
                  if p_arg[cha] shr 4=$d then notedelay[cha]:=p_arg[cha] and $f;
               end;
            end;

            if notebuf[cha]<255 then                            (* new note triggered.. *)
            begin;
               if notebuf[cha]=254 then                         (* noteoff *)
               begin;
                  p_note[cha]:=notebuf[cha];
                  UltraVectorLinearVolume(cha, 0, $2f,0);

               end
               else
               begin;
                  if (notebuf[cha]<>195) and (p_cmd[cha]<>7) and (p_cmd[cha]<>12) then
                  begin;                                       (* normal noteplay *)
                     p_foo[cha]:=true;

                      p_rate[cha]:=calcrate(p_per[cha]);
                       if notedelay[cha]=0 then
                          play(cha,p_ins[cha],p_vol[cha],p_rate[cha],soffs[cha]); (* apply new note *)
                  end;
               end;

            end;
            if (notebuf[cha]=195) and (p_cmd[cha]<>7) and (p_cmd[cha]<>12)  then  (* retrigger note with new ins *)
            begin;
               p_foo[cha]:=true;
               p_rate[cha]:=calcrate(p_per[cha]);
               UltraSetAll(cha,chan[cha],p_rate[cha],cvol(p_vol[cha]*8),$2f,0);
            end
         end;

         scr_startupd;

         ultrablocktimerhandler2;
       (* block thread for one timer tick *)
                                 (* 2nd frame -> xx frame  *)

         for frame:=2 to speed do             (* play frames ...*)
         begin;
            for cha:=0 to channels do
            begin;
               if arp[cha] then
               begin;
                  inc(arp_cn[cha],1);
                  if arp_cn[cha]=3 then arp_cn[cha]:=0;
                  if arp_cn[cha]=0 then p_rate[cha]:=calcrate(calcperiod(p_note[cha],p_ins[cha]));
                  if arp_cn[cha]=1 then p_rate[cha]:=calcrate(calcperiod(p_note[cha]+arp_x[cha],p_ins[cha]));
                  if arp_cn[cha]=2 then p_rate[cha]:=calcrate(calcperiod(p_note[cha]+arp_y[cha],p_ins[cha]));
                  UltraSetAll(cha,chan[cha],p_rate[cha],cvol(p_vol[cha]*8),$2f,0);
               end;
               if vibrato[cha] then
               begin;
                  inc(sinic[cha],vb_inc[cha]);
                  if sinic[cha]>sinimax then sinic[cha]:=sinic[cha] mod sinimax;
                  p_rate[cha]:=calcrate(p_per[cha]+sini[sinic[cha]]*vb_depth[cha]);
                  UltraSetAll(cha,chan[cha],p_rate[cha],cvol(p_vol[cha]*8),$2f,0);
               end;
               if fvibrato[cha] then
               begin;
                  inc(sinic[cha],fvb_inc[cha]);
                  if sinic[cha]>sinimax then sinic[cha]:=sinic[cha] mod sinimax;
                  p_rate[cha]:=calcrate(p_per[cha]+sini[sinic[cha]]*fvb_depth[cha]);
                  UltraSetAll(cha,chan[cha],p_rate[cha],cvol(p_vol[cha]*8),$2f,0);
               end;
               if portanote[cha] then
               begin;
                  p_note[cha]:=notebuf[cha];
                  if portafinal[cha]>p_per[cha] then
                     if p_per[cha]+p_arg[cha]*4>portafinal[cha] then
                     begin;
                        p_per[cha]:=portafinal[cha];
                        portanote[cha]:=false;
                     end
                     else
                        inc(p_per[cha],p_arg[cha]*4);


                  if portafinal[cha]<p_per[cha] then
                     if p_per[cha]-p_arg[cha]*4<portafinal[cha] then
                     begin;
                        p_per[cha]:=portafinal[cha];
                        portanote[cha]:=false;
                     end
                     else
                        dec(p_per[cha],p_arg[cha]*4);

                  p_rate[cha]:=calcrate(p_per[cha]);
                  UltraSetAll(cha,chan[cha],p_rate[cha],cvol(p_vol[cha]*8),$2f,0);
               end;

               if (frame-1)=notedelay[cha] then
                  play(cha,p_ins[cha],p_vol[cha],p_rate[cha],soffs[cha]); (* apply new note, if notedelay *)
               if is_volslide[cha] then
               begin;
                  if p_arg[cha] shr 4=0 then
                     if integer(p_vol[cha]-p_arg[cha] and $f)>0 then
                        dec(p_vol[cha],p_arg[cha] and $f) else p_vol[cha]:=0; {down}
                  if p_arg[cha] and $f=0 then
                     if p_vol[cha]+p_arg[cha] shr 4<63 then
                        inc(p_vol[cha],p_arg[cha] shr 4) else p_vol[cha]:=$3f; {up}

                  UltraVectorLinearVolume(cha, cvol(p_vol[cha]*8), $2f,0);
               end;
               if is_slideup[cha] then
               begin;
                  if integer(p_per[cha]-p_arg[cha]*4)>0 then
                     dec(p_per[cha],p_arg[cha]*4);          {amigaslide-> 4x st3slide}
                  p_rate[cha]:=calcrate(p_per[cha]);
                  UltraSetAll(cha,chan[cha],p_rate[cha],cvol(p_vol[cha]*8),$2f,0);
               end;
               if is_slidedn[cha] then
               begin;
                  inc(p_per[cha],p_arg[cha]*4);          {amigaslide-> 4x st3slide}
                  p_rate[cha]:=calcrate(p_per[cha]);
                  UltraSetAll(cha,chan[cha],p_rate[cha],cvol(p_vol[cha]*8),$2f,0);
               end;
            end;
            scr_startupd2;
            ultrablocktimerhandler2;         (* block thread for one timer tick*)
         end;
         if (pbreak) or (exit) then begin; pbreak:=false; break; end;  {hmmmm.........}
      end;
      if exit then break;
   end;
   inc(loopcount);
   until __brutalexit;
   ultrastoptimer(2);
   ultraunblockall;
   play_finished:=true;
   __exit:=false;

   dosexit(exit_thread,0);
end; { playthd }

function getnote(zz:word):string; (* note -> formatted string *)
var
   q,w,e,r : word;
   ss      : string;
begin;
   if zz<254 then
   begin;
      if zz>0 then
      begin;
      q:=zz div 12;
      w:=zz-q*12;
      str(q,ss);
      if q>9 then ss:='?';
      getnote:=notes[w+1]+ss;
      end
      else
      begin;
      getnote:='---';
      end;

   end;
   if zz=254 then getnote:=('^^^');
   if zz=255 then getnote:=('');
end; { getnote }

procedure wr_stuff; forward;
procedure wr_vol; forward;
procedure wr_row; forward;
procedure wr_stat; forward;
procedure test_;
var
   rc : word;
begin;
   rc:=dossuspendthread(scrtid);
   if rc<>no_error then writeln('rc=',rc);
end;


function upd_scr(parm1:Pointer) : Longint;  (* Screen updating *)
var
   q,w,e,r : word;
   st:string;
   sz      : string;
begin;
   exit_scr:=false;
{   wr_stat;}
   repeat
{      wr_patt;
      wr_vol;
      wr_row;}
      wr_stuff;
      for q:=0 to channels do
      begin;
         if p_foo[q] then
         begin;
            addscrbuf_colorize(80+161+q*80,0,hex(p_ins[q]),$7f);
            p_foo[q]:=false;
         end
         else
         begin;
            addscrbuf_colorize(80+161+q*80,0,hex(p_ins[q]),$78);
            p_foo[q]:=false;
         end;
         if debugmode then
         begin
            str(p_per[q]:6,st);
            sz:='per:';
            sz:=sz+st;
            str(calcrate(p_per[q]):6,st);
            sz:=sz+'  Hz:'+st;
            str(notebuf[q]:3,st);
            sz:=sz+' b:'+st;

            addscrbuf(80+163+q*80,28,': '+sz);
         end
         else
         begin;
            addscrbuf(80+163+q*80,28,': '+p_insname[p_ins[q]]);
         end;
         addscrbuf(80+161+33+q*80,0,getnote(p_note[q]));
         addscrbuf(80+161+38+q*80,0,hex(p_vol[q]));
         addscrbuf(80+161+42+q*80,13,fx[p_cmd[q]]);
         if p_cmd[q]<>8 then
            addscrbuf(79+161+56+q*80,0,' '+hex(p_arg[q]))
         else
            addscrbuf(79+161+56+q*80,0,'~'+hex(fiba_count[q]));
      end;
   for q:=0 to channels do
      VioShowBuf(240*2+q*160,120,0);
   test_;
   until main_exit;
   dosexit(exit_thread,0);
end;

var
   max_x,max_y : word;

procedure check_screen;
var
   foob : viomodeinfo;
begin;
   viogetmode(foob,0);
   max_y:=foob.row;
   max_x:=foob.col;
end; { check_screen }

procedure read_params;     (* read parameters *)
var
   q : word;
   w:longint;
begin;
   p_disabled:=false;
   q:=2;
   while(q<=paramcount) do
   begin;
      if paramstr(q)='-m' then mode_mono:=true;
      if paramstr(q)='-p' then globalvol:=54;
      if paramstr(q)='-d' then p_disabled:=true;
      if paramstr(q)='-t' then alternate_tempo:=true;
      if paramstr(q)='-o' then __memalloc:=false;
      if paramstr(q)='-pc' then
      begin;
         inc(q);
         val(paramstr(q),pt_class,w);
         if w<>0 then begin; writeln('error while parsing args: integer value expected.'); halt; end;
      end;
      if paramstr(q)='-pd' then
      begin;
         inc(q);
         val(paramstr(q),pt_delta,w);
         if w<>0 then begin; writeln('error while parsing args: integer value expected.'); halt; end;
      end;
      inc(q);
   end;
end;


const
  ScanCode: Byte = 0;

function ReadKey: Char;
var
  Key: KbdKeyInfo;
begin
   If ScanCode <> 0 then
   begin
      ReadKey  := Chr(ScanCode);
      ScanCode := 0;
   end
   else
   begin
      KbdCharIn(Key,io_Wait,0);
      case Key.chChar of
        #0   : ScanCode := Key.chScan;
        #$E0 : {   Up, Dn, Left Rt Ins Del Home End PgUp PgDn C-Home C-End C-PgUp C-PgDn C-Left C-Right C-Up C-Dn }
   if Key.chScan in [$48,$50,$4B,$4D,$52,$53,$47, $4F,$49, $51, $77,   $75,  $84,   $76,   $73,   $74,    $8D, $91] then
   begin
      ScanCode := Key.chScan;
      Key.chChar := #0;
   end;
end;
   ReadKey := Key.chChar;
end;
end;

function KeyPressed: Boolean;
var
   Key : KbdKeyInfo;
begin
   KbdPeek(Key,0);
   KeyPressed := (ScanCode <> 0) or ((Key.fbStatus and kbdtrf_Final_Char_In) <> 0);
end; { KeyPressed }


procedure draw_screen;  (* *)
var
   q,w : word;
   f   : file;
begin;
   assign(f,paramstr(1));
   reset(f,1);
   q:=filesize(f) div 1024;
   close(f);
   gotoxy(0,0);
   writeln(#27,'[0;1;37;41m'+version,#27,'[2K');
   write(#27,'[0;0;37;44m');
   write('song:                              t:    s:    type:                 size: ');
   writeln(#27,'[1;33m',q,#27,'[0;0;37;44mK',#27,'[2K');
   writeln('patt:   /   row:       played:     loop:            press h for help!  vol:   ',#27,'[2K');
   for q:=0 to channels+1 do
   begin;
      gotoxy(0,3+q);
      writeln(#27,'[0;1;37;47m                               ',#27,'[1;30m',#27,'[1;37m   ',#27,'[1;30m',#27,'[1;37m  ',#27,'[1;30m',#27,'[1;37m                ',#27,'[1;30m',#27,'[1;37m                  ',#27,'[1;30m');
   end;
end;

procedure wr_stuff;
var
   sz:string;
begin;
   str(((p_ord+(p_row+1)*0.016)/(ordnum-2)*100):2:0,sz);
   mem[vioofs+320+12]:=ord(hexc[p_ord shr 4]);
   mem[vioofs+320+14]:=ord(hexc[p_ord and $f]);
   mem[vioofs+320+18]:=ord(hexc[(ordnum-3) shr 4]);
   mem[vioofs+320+20]:=ord(hexc[(ordnum-3) and $f]);
   mem[vioofs+320+34]:=ord(hexc[p_row shr 4]);
   mem[vioofs+320+36]:=ord(hexc[p_row and $f]);
   mem[vioofs+320+40]:=ord('3');
   mem[vioofs+320+42]:=ord('f');
   mem[vioofs+320+62]:=ord(sz[1]);
   mem[vioofs+320+64]:=ord(sz[2]);
   mem[vioofs+320+66]:=ord('%');
   mem[vioofs+320+82]:=ord(hexc[loopcount shr 4]);
   mem[vioofs+320+84]:=ord(hexc[loopcount and $f]);
   mem[vioofs+160+76]:=ord(hexc[tempo shr 4]);
   mem[vioofs+160+78]:=ord(hexc[tempo and $f]);
   mem[vioofs+160+88]:=ord(hexc[speed shr 4]);
   mem[vioofs+160+90]:=ord(hexc[speed and $f]);
   mem[vioofs+320+150]:=ord(hexc[globalvol div 10]);
   mem[vioofs+320+152]:=ord(hexc[globalvol mod 10]);
   mem[vioofs+320+154]:=ord('%');


   vioshowbuf(160,319,0);
end; { wr_patt }


procedure wr_stuff2;
var
   q,w:word;
begin;
   mem[vioofs+320+12+1]:=$1e;
   mem[vioofs+320+14+1]:=$1e;
   mem[vioofs+320+18+1]:=$1e;
   mem[vioofs+320+20+1]:=$1e;
   mem[vioofs+320+34+1]:=$1e;
   mem[vioofs+320+36+1]:=$1e;
   mem[vioofs+320+40+1]:=$1e;
   mem[vioofs+320+42+1]:=$1e;
   mem[vioofs+320+62+1]:=$1e;
   mem[vioofs+320+64+1]:=$1e;
   mem[vioofs+320+66+1]:=$1e;
   mem[vioofs+320+82+1]:=$1e;
   mem[vioofs+320+84+1]:=$1e;
   mem[vioofs+160+76+1]:=$1e;
   mem[vioofs+160+78+1]:=$1e;
   mem[vioofs+160+88+1]:=$1e;
   mem[vioofs+160+90+1]:=$1e;
   mem[vioofs+320+150+1]:=$1e;
   mem[vioofs+320+152+1]:=$1e;
   mem[vioofs+320+154+1]:=$1e;

   for q:=1 to length(p_song) do
   begin;
      mem[vioofs+160+12+q*2-2]:=ord(p_song[q]);
      mem[vioofs+160+12+1+q*2-2]:=$1e;
   end;
      gotoxy(53,1);
   for q:=1 to length(p_filetype) do
   begin;
      mem[vioofs+160+106+q*2-2]:=ord(p_filetype[q]);
      mem[vioofs+160+106+1+q*2-2]:=$1e;
   end;
   for q:=1 to length(filsiz) do
   begin;
      mem[vioofs+160+148+q*2-2]:=ord(filsiz[q]);
      mem[vioofs+160+148+1+q*2-2]:=$1e;
   end;

   vioshowbuf(160,319,0);
end; { wr_patt }

procedure wr_row;
begin;
{   gotoxy(17,2);
   write(#27,'[0;1;33;44m'+hex(p_row),#27,'[0;0;37;44m/',#27,'[0;1;33;44m3f');}
end; { wr_patt }

procedure wr_stat;
var
   sz : string;
begin;
   str(((p_ord+(p_row+1)*0.016)/(ordnum-2)*100):2:0,sz);
   gotoxy(31,2);
   write(#27,'[0;1;33;44m'+sz,#27,'[0;0;37;44m%');
   gotoxy(41,2);
   write(#27,'[0;1;33;44m',p_loop);
   gotoxy(37,1);
   write(#27,'[0;1;33;44m',tempo);
   gotoxy(43,1);
   write(#27,'[0;1;33;44m',hex(speed));

end; { wr_patt }

procedure wr_vol;
begin;
   gotoxy(75,2);
   write(#27,'[0;1;33;44m',globalvol,#27,'[0;0;37;44m% ');
end; { wr_patt }

procedure wr_songname;
begin;
   gotoxy(6,1);
   write(#27,'[0;1;33;44m',p_song);
end; { wr_patt }

procedure wr_filetype;
begin;
   gotoxy(53,1);
   write(#27,'[0;1;33;44m',p_filetype);
end; { wr_patt }


procedure p_rebuildlist;
var
   q : word;
begin;
   for q:=0 to insnum do
   begin;
      m_addstr(hex(q)+': '+p_insname[q]);
   end;
   msg_scr1:=channels+4;
   msg_scr2:=24;
   m_disp;
end;

procedure build_help;
var
   st : string;
begin;
   str(dbuildnum,st);
   m_reset;
   m_addstr('compiled: '+comptime+' build: '+st+' VP/2 1.1');
   m_addstr('');
   m_addstr('help on keys:');
   m_addstr('  left/right  changes patterns');
   m_addstr('  up/down     move this display up and down ');
   m_addstr('');
   m_addstr('  -/+         dec/inc output volume');
   m_addstr('');
   m_addstr('  m - toggle hilight mode          s - toggle stereo');
   m_addstr('  h - this help text               q - go to main screen');
   m_addstr('  t - toggle debug mode          ESC - exit to OS');
   m_addstr('');
   m_addstr('Press ``q'''' to return to main screen.');
   m_disp;
end;

procedure setcolor(c,r,g,b:byte);
begin;
port[$3c8]:=c;
port[$3c9]:=r;
port[$3c9]:=g;
port[$3c9]:=b;
end;

var
   count:word;

var
   stdout    : text;
   q,w,e,r,t : word;
   playtid   : tid;
   swtid:tid;
   rc        : apiret;
   t1,t2,t3,t4,t5        : word;
   d1,d2,d3,d4,d5        : word;

begin;

   (* global preferences -- default priorites *)
   pt_class:=PRTYC_TIMECRITICAL; 
   pt_delta:=31; 

   (* global preferences -- other stuff *)
   globalvol:=85;
   p_hilimode:=true;
   alternate_tempo:=false;
   mode_mono:=false;
   __exit:=false;
   __memalloc:=true;
   __brutalexit:=false;
   debugmode:=false;


   (* build tables for vibrato *)

   for q:=0 to 15 do
     vb_inc[q]:=1;
   for q:=0 to 15 do
     vb_depth[q]:=1;
   for q:=0 to 4095 do
      sini[q]:=round(sin(pi/32*q)*4);


   (* check parameters *)

   if paramcount=0 then
   begin;
      writeln('usage: ntsR3.exe <s3mfilename> <parameters>');
      writeln('compiled: '+comptime+' build: ',dbuildnum);
      writeln;
      writeln('parameters:');
      writeln('  -m          Mono mode');
      writeln('  -o          Use UltraMODMemAlloc instead of UltraMemAlloc.');
      writeln('  -p          Optimize output for GUS PnP cards');
      writeln('  -d          Disable player. ');
      writeln('  -pc x -pd y Sets player thread priority: x=class, y=delta');
      writeln('              (default: x=3, y=31)');
      halt;
   end;

   (* exception handler *)
   isused:=false;
   PrevXcptProc := XcptProc;
   XcptProc := @CtrlBreakHandler;


   (* open ultrasound *)

   if not(p_disabled) then
      if not openultrasound then
      begin;
         writeln('ULTRA1$: No such file or permission denied.');
         ultrameminit;
         halt;
      end
      else
      begin;
         ultrasetnvoices(14);
         ultraenableoutput;
      end;


   assign(stdout,'');
   rewrite(stdout);
   check_screen;

   if paramcount>1 then read_params;
   if is_s3m(paramstr(1)) then
      s3m_loadfile(paramstr(1))
   else
      if is_mod(paramstr(1)) then mod_loadfile(paramstr(1))
      else
      begin;
         writeln(paramstr(1),': cannot load file.');
         halt;
      end;


   ultrasetnvoices(channels+1);


   (* set up player debugging interface *)
   advi_initscreen;


   (* if there was problems with loading module, report them *)

   if not loaderrors then
   begin;
      m_reset;
      p_rebuildlist
   end
   else
   begin;
      msg_scr1:=channels+4;
      msg_scr2:=24;
      m_disp;
   end;

   hidecursor;
   exit:=false;
   exit_scr:=true;

   (* starts playing thread and *dirty* screen updating threads.. *)

   ttid := VPBeginThread( playthd, 8192, nil );
   DosSetPriority ( PRTYS_THREAD, pt_class,31, ttid );

   scrtid:=vpbeginthread(upd_scr,8192,nil);
   dossetpriority(PRTYS_THREAD,PRTYC_IDLETIME,1,scrtid);
   scrtid2:=vpbeginthread(scr_stuff,8192,nil);
   dossetpriority(PRTYS_THREAD,PRTYC_IDLETIME,2,scrtid2);

   wr_stuff2;


   (* main loop *)

   repeat
      dossleep(1);

      if play_finished then  (* jos soitto loppuu, niin aloitetaan alusta *)
      begin;
         inc(p_loop);
         doswaitthread(ttid,0);
         ultrastoptimer(2);
         exit:=false;
         play_finished:=false;
         ttid := VPBeginThread( playthd, 8192, nil );
         DosSetPriority ( PRTYS_THREAD, PRTYC_TIMECRITICAL,31, ttid );
      end;

      if keypressed then
      begin;
         c:=readkey;
         if c='s' then
         begin;
            mode_mono:=not(mode_mono);
            for q:=0 to 31 do
               if mode_mono then chan[q]:=8 else
               begin;
                  if q mod 2=0 then chan[q]:=3 else chan[q]:=$c;
               end;
         end;

         if c='m' then p_hilimode:=not(p_hilimode);

         if c='h' then build_help;

         if c='d' then     (* OS/2 shell w/ volumebars :) :) *)
         begin;
            dossuspendthread(scrtid);
            gotoxy(1,24);
            writeln(#27,'[0;37m');
            exec(getenv('comspec'),'');
            draw_screen;
            m_disp;
            dosresumethread(scrtid);
         end;

         if c='q' then
         begin;
            m_reset;
            p_rebuildlist;
         end;

         if c=#0 then      (* Elliseni, dynamiikalla kiiman ydin esille!*)
         begin;
            c:=readkey;
            if c=#80 then m_incy;
            if c=#72 then m_decy;
            if c=#75 then if cur_ord>0 then
            begin;
               dec(cur_ord,2);
               row:=63;
            end;
            if c=#77 then if cur_ord<ordnum-2 then
            begin;
               row:=63;
            end;
            if c=#115 then if cur_ord>0 then
            begin;
               dec(cur_ord);
               p_ord:=cur_ord;
               tt:=orders[cur_ord];
               p_patt:=tt;
            end;
            if c=#116 then if cur_ord<ordnum-2 then
            begin;
               inc(cur_ord);
               p_ord:=cur_ord;
               tt:=orders[cur_ord];
               p_patt:=tt;
            end;
         end;

         if c='+' then if globalvol<100 then inc(globalvol);

         if c='-' then if globalvol>0 then dec(globalvol);

         if c='t' then debugmode:=not(debugmode);

         if c=#27 then  (* if ESC pressed fade volume and exit when done *)
         begin;
            for q:=20 downto 0 do
            begin;
               if globalvol>0 then dec(globalvol,5) else globalvol:=0;
               for w:=0 to channels do
                  ultravectorlinearvolume(w,cvol(p_vol[w]*8),$2f,0);
               dossleep(1);
               if keypressed then
               begin;
                  c:=readkey;
                  if c=#27 then break;
               end;
            end;
            main_exit:=true;
            exit:=true;
         end;
         for q:=0 to channels do
            ultravectorlinearvolume(q,cvol(p_vol[q]*8),$2f,0);
      end;

   until main_exit;     (* loop until ESC pressed *)


   (* toggle flags to stop playing module.. *)

   exit:=true;
   __exit:=true;
   __brutalexit:=true;

   gotoxy(0,24);
   writeln(#27,'[0m');
   writeln('ultraunblockall..waiting thread.');

   (* ..wait until it is done.. *)

   repeat dossleep(32); until __exit=false;


   ultradisableoutput;

   dosresumethread(scrtid);
   dosresumethread(scrtid2);
   close(stdout);

   ultrastoptimer(2);
   ultraunblockall;
   ultrareleaseaccess;

   closeultrasound;
   advi_endscreen;
end.




