/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.UnsupportedCommOperationException;

public abstract class CommPort {
    protected String name;

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public CommPort(String string) {
        this.name = string;
    }

    public void close() {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier(this.name);
            commPortIdentifier.InternalClosePort();
        }
        catch (NoSuchPortException noSuchPortException) {
            // empty catch block
        }
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract void enableReceiveThreshold(int var1) throws UnsupportedCommOperationException;

    public abstract void disableReceiveThreshold();

    public abstract boolean isReceiveThresholdEnabled();

    public abstract int getReceiveThreshold();

    public abstract void enableReceiveTimeout(int var1) throws UnsupportedCommOperationException;

    public abstract void disableReceiveTimeout();

    public abstract boolean isReceiveTimeoutEnabled();

    public abstract int getReceiveTimeout();

    public abstract void enableReceiveFraming(int var1) throws UnsupportedCommOperationException;

    public abstract void disableReceiveFraming();

    public abstract boolean isReceiveFramingEnabled();

    public abstract int getReceiveFramingByte();

    public abstract void setInputBufferSize(int var1);

    public abstract int getInputBufferSize();

    public abstract void setOutputBufferSize(int var1);

    public abstract int getOutputBufferSize();
}

