/***************************************************************************
 * 
 * SOCK.CMD  - Modifizierte PIPE.CMD fr Socket-Schnittstelle
 * Stand: 27.4.2001
 *
 * Aenderungen: 06.09.2000  - Tobias.Grimm@gmx.de 
 *              28.09.2000  - Tobias.Grimm@gmx.de (Neue Kommandos)
 *
 ****************************************************************************/

call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs


/* load socket-lib: */

If RxFuncQuery("SockLoadFuncs") Then
Do
  Call RxFuncAdd "SockLoadFuncs","RXSOCK","SockLoadFuncs"
  Call SockLoadFuncs
End


/* socket variable for the connection: */

Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")


/******************************************************************************/
/*                                                                            */
/*      there are some commands which can be send to 'isdnPm' over            */
/*      a named PIPE ("\PIPE\ISDNPM30\CPIPE                                   */
/*                                                                            */
/*      'CMD=AUTH UID=User Pwd=password': Authentificate connection           */
/*                                        must be the first command after     */
/*                                        connection                          */
/*                                                                            */
/*      'CMD=VERSION'                   : query for Version                   */
/*      'CMD=CHANNELS'                  : query numer of channels             */
/*      'CMD=USERLIST                   : query users (only outgoing)         */
/*                                                                            */
/*      'CMD=CONNECT NAME="onnx"'       : connect to 'connx'                  */
/*      'CMD=CALLBYCALL' CONN="xxx"'    : connect to xxx                      */
/*      'CMD=DISCONNECT NAME="connx"'   : disconnect 'connx'                  */
/*      'CMD=DISCONNECT CHANNEL=n'      : disconnect channel n (1,2...)       */
/*      'CMD=DISCONNECT CHANNEL=0'      : disconnect all channels             */
/*      'CMD=STATUSLOW  CHANNEL=n'      : query status of ISDN-Channel n      */
/*      'CMD=STATUSHIGH CHANNEL=n'      : query status of IP-Channel   n      */
/*                                                                            */
/*      'CMD=AUTOMODE'                  : query AUTODIALMODE                  */
/*      'CMD=AUTOMODE LEVEL=0'          : set AUTODIALMODE OFF                */
/*      'CMD=AUTOMODE LEVEL=1'          : set AUTODIALMODE ON                 */
/*      'CMD=MULTIMODE                  : query MULTILINKMODE                 */
/*      'CMD=MULTIMODE LEVEL=0'         : set MULTILINKMODE OFF               */
/*      'CMD=MULTIMODE LEVEL=1'         : set MULTILINKMODE ON                */
/*                                                                            */
/*      'CMD=UPDATE'                    : update all connections from file    */
/*                                                                            */
/*      'CMD=EXIT'                      : disconnect from PIPE                */
/*                                                                            */
/*      'CMD=SHUTDOWN'                  : shutdown Isdnpm (with ExitCode 1)   */
/*      'CMD=RESTART VAL=n'             : shutdown Isdnpm (with 1 + val)      */
/*                                        VAL=1 is ExitCode 2 for example     */
/*                                                                            */
/*      all unknown commands return 'RC=1'                                    */
/*                                                                            */
/*      Version is returned with :                                            */
/*                                                                            */
/*          'RC=0 VERSION="xxxxxxxxx"'                                        */
/*                                                                            */
/*      Channels are returned with :                                          */
/*                                                                            */
/*          'RC=0 CHANNELS=n'                                                 */
/*                                                                            */
/*      Userlist is returned with :                                           */
/*          'RC=0  CN="Name" CI="Info" ON="Number" CN=........'               */
/*                                                                            */
/*      Autodialmode is returned with :                                       */
/*                                                                            */
/*          'RC=0 AUTOMODE=n'                                                 */
/*                                                                            */
/*      Multilinkmode is returned with :                                      */
/*                                                                            */
/*          'RC=0 MULTIMODE=n'                                                */
/*                                                                            */
/*      Channelstatus is returned with :                                      */
/*                                                                            */
/*          'RC=0 STATUS=s NAME="name" MSG="msg" ERR="err"      ...           */
/*          ...     TxB=transbytes RxB=recbytes ....                          */
/*          ...     TxP=transpaket RxP=recpaket ....                          */
/*          ...     TxR=transrate  RxR=recrate  ....                          */
/*          ...     TT=connectiontime                                         */
/*                  IPA="ipaddress"                                           */
/*                                                                            */
/*          Stat 's'  : 0 means DOWN                                          */
/*          Stat 's'  : 1 means CONNECTED (isdn)                              */
/*          Stat 's'  : 2 means OPEN (ip)                                     */
/*          Stat 's'  : 3 means connection established                        */
/*                                                                            */
/******************************************************************************/

CRLF='0d0a'x

    /* Open Socket Connection: */

    rc = Connect("127.0.0.1",4000); 
    if rc < 0 then
    do
        say "Socket Connect Error !!!"
        exit 0
    end

    say SendCommandAndWait("cmd=auth uid=LocalUser pwd=Local"||CRLF)

    say SendCommandAndWait("cmd=version"||CRLF)

    cbc = 'CMD=CALLBYCALL CONN="'
    cbc = cbc || ' \n'
    cbc = cbc || ' Name : c1\n'
    cbc = cbc || ' Cpn  : 076129876543\n'
    cbc = cbc || ' Profile  : PPP_SYNC\n'
    cbc = cbc || ' Userid   : xxxx\n'
    cbc = cbc || ' Password : xxxxxxxx\n'
    cbc = cbc || ' \n"'

    say SendCommandAndWAit(cbc||CRLF)

    count = 0
    do while count < 1
        say SendCommandAndWAit("CMD=STATUSHIGH CHANNEL=1"||CRLF)
        say SendCommandAndWAit("CMD=STATUSLOW  CHANNEL=1"||CRLF)
        count = count + 1
    end

    say SendCommandAndWAit("CMD=EXIT"||CRLF)


    /* Close Socket Connection: */

    rc= Disconnect()

exit 0

/**************************************************************************/
/* connect the socket                                                     */
/**************************************************************************/
Connect:
parse arg ip, port
  Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")
  Call SockGetHostByAddr ip, "Host.!" 
  Host.!family = "AF_INET"
  Host.!port = port
  rc=SockConnect( Socket, "Host.!")
return rc

/**************************************************************************/
/* disconnect the socket                                                  */
/**************************************************************************/
DisConnect:
    Call SockShutDown Socket, 2
    Call SockClose Socket
return 0

/**************************************************************************/
/* send a command to the socket and wait for an answer                    */
/**************************************************************************/
SendCommandAndWait:
parse arg Command
    rc=SockSend(Socket, COMMAND)
    if rc > 0 then
        rc=SockRecv(Socket, "in", 256)
    if rc <= 0 then in =TIMEOUT
return in

