/* */
/*
   This file is an integral part of the WiseTalker package.
   It may be used only in accordance with the terms of agreement
   in the original WiseTalker agreement.
*/
arg begin" "end
if (begin = "" | end = "" | end < begin) then exit
HomeDir = "."
/* call ReadDefault */
do i = begin to end
   mb = i
   if (i < 100) then mb = '0'i
   call lineout "frondesk.dat", i' M'i' 1'mb' 'i' 'i
   call lineout "msg_cent.dat", '1'mb' 1'mb' 0 0 0'
   /* call ConfigUpdate i, mb */
end
call lineout "frondesk.dat"
call lineout "msg_Cent.dat"
exit

ReadDefault: procedure expose Defaults. HomeDir
   source = HomeDir"\station.def"
   iunit = Stream( source , "Command", "OPEN READ" )
   if ( iunit != "READY:" ) then exit 1
   i=0
   do while lines(source)
      i = i + 1
      Defaults.i = linein(source)
   end
   iunit = Stream( source , "Command", "CLOSE" )
   Defaults.0 = i
return

ConfigUpdate: procedure expose Defaults. HomeDir
   arg Station, mb
   if (strip(Station)="") then return
   ConfigFile = HomeDir || "\station." || Station
   tmpFile = SysTempFileName(HomeDir"\PCBX###.CFG","#")
   ounit = Stream( tmpFile, "Command", "OPEN WRITE")
   if ( ounit = "READY:" ) then do
      do i = 1 to Defaults.0
         ibuf = Defaults.i
         parse var ibuf window','obj','value
         if (obj="EF_Station" | obj="EF_AlsoKnownAs") then do
            ibuf = window','obj','Station
         end
         else if (obj="EF_StationMB") then do
            ibuf = window','obj','mb
         end
         call lineout tmpFile, ibuf
         drop ibuf
      end
      ounit = Stream( tmpFile, "Command", "CLOSE" )
      'copy 'tmpFile' 'source' >nul:'
      'del 'tmpFile' >nul:'
   end
return
