/* Custom mainline for macro     ...Do not change the header lines... */

/*
    call RXFuncAdd "VRLoadFuncs", "VROBJ", "VRLoadFuncs"
    call VRLoadFuncs

    _VREVersion = SubWord( VRVersion( "VRObj" ), 1, 1 )
    if( _VREVersion < 2.14 )then do
        call VRMessage "", "This program requires VX-REXX version 2.1d to run.", "Error!"
        return 32000
    end

    signal on SYNTAX name _VRESyntax
*/
    signal _VREMain

/*
_VRESyntax:
    parse source . . _VRESourceSpec
    call VRMessage "", "Syntax error in" _VRESourceSpec "line" SIGL":" ErrorText(rc), "Error!"
    exit 32000
*/
_VREMain:
/*:VRX         Main    ...Do not change these two lines...
*/
Main:
SIGNAL ON SYNTAX
SIGNAL ON ERROR
SIGNAL ON FAILURE
SIGNAL ON HALT
SIGNAL ON NOVALUE
SIGNAL ON NOTREADY
NUMERIC DIGITS 6

arg proc, param
if proc \= "" then do
   say proc" "param
   interpret "rc="||proc||"('"param"')"
end
else do
   rc=9999
end
exit rc
/*:VRX         SYNTAX    ...Do not change these two lines...
*/
SYNTAX:
   /*
   say "Syntax error at line "sigl
   */
   rc = sigl
   signal EXITMacro
return
/*:VRX         ERROR    ...Do not change these two lines...
*/
ERROR:
   say "Error at line "sigl
   rc = sigl
   signal EXITMacro
return
/*:VRX         FAILURE    ...Do not change these two lines...
*/
FAILURE:
   say "Failure at line "sigl
   rc = sigl
   signal EXITMacro
return
/*:VRX         HALT    ...Do not change these two lines...
*/
HALT:
   say "Halted at line "sigl
   rc = sigl
   signal EXITMacro
return
/*:VRX         NOVALUE    ...Do not change these two lines...
*/
NOVALUE:
   say "NoValue detected at line "sigl
   rc = sigl
   signal EXITMacro
return
/*:VRX         NOTREADY    ...Do not change these two lines...
*/
NOTREADY:
   say "NotReady condition detected at line "sigl
   rc = sigl
   signal EXITMacro
return
/*:VRX         EXITMacro    ...Do not change these two lines...
*/
EXITMacro:
exit rc

/*:VRX         MacroMenuJump    ...Do not change these two lines...
*/
MacroMenuJump:
   parse arg name
   interpret "rc="||name||"()"
return rc

/*:VRX         MacroRegister    ...Do not change these two lines...
*/
MacroRegister:
return 0

/*:VRX         MacroReadConfig    ...Do not change these two lines...
*/
MacroReadConfig:
return 0

/*:VRX         MacroLH_Run    ...Do not change these two lines...
*/
MacroLH_Run:
return 0

/*:VRX         MacroInitialize    ...Do not change these two lines...
*/
MacroInitialize:
return 0

/*:VRX         MacroLastCall    ...Do not change these two lines...
*/
MacroLastCall:
return 0

/*:VRX         MacroTransferBusy    ...Do not change these two lines...
*/
MacroTransferBusy:
return 0

/*:VRX         MacroTransferNoAnswer    ...Do not change these two lines...
*/
MacroTransferNoAnswer:
return 0

/*:VRX         MacroTerminate    ...Do not change these two lines...
*/
MacroTerminate:
return 0

/*:VRX         MacroWaitForCall    ...Do not change these two lines...
*/
MacroWaitForCall:
return RC.Continue

/*:VRX         MacroOffHook    ...Do not change these two lines...
*/
MacroOffHook:
return RC.Continue

/*:VRX         MacroCallReceived    ...Do not change these two lines...
*/
MacroCallReceived:
return RC.Continue

/*:VRX         MVU_S_PlayAmount    ...Do not change these two lines...
*/
MVU_S_PlayAmount: procedure
   parse arg amount
   parse var amount dollar'.'cents
   if (datatype(dollar)<>'NUM' | datatype(cents)<>'NUM') then return 9997
   if (dollar>0) then do
      rc = MVU_S_PlayInteger( dollar )
      if (rc<>0) then return rc
      if (dollar=1) then 
         rc = MV_Play( "Prompts.E\Rhetorex\alphanum\dollar.v" )
      else
         rc = MV_Play( "Prompts.E\Rhetorex\number\dollars.v" )
      if (rc<>0) then return rc
   end
   if (cents>0) then do
      rc = MVU_S_PlayInteger( cents )
      if (rc<>0) then return rc
      if (cents=1) then 
         rc = MV_Play( "Prompts.E\Rhetorex\number\cents.v" )
      else
         rc = MV_Play( "Prompts.E\Rhetorex\number\cents.v" )
   end
return rc

/*:VRX         RecordPrompt    ...Do not change these two lines...
*/
RecordPrompt: 
   signal on Syntax name lab11
   rc = RxFuncAdd( "SysLoadFuncs", "REXXUTIL", "SYSLOADFUNCS" )
   rc = SysLoadFuncs()
lab11:
   signal on syntax
   call MV_Say "Recording prompts..."
   call MV_SetPromptDir HomeDir
   file = HomeDir"\mailbox\"SystemPassword"\prompts.lis"
   i = 0
   do while lines(file)
      i = i + 1
      prompts.i = linein(file)
   end
   call lineout file   /* Close it */
   prompts.0 = i
   if (i=0) then do
      call MV_Say file" doesn't exist or it's empty"
      signal RecordPromptExit
   end
   LastOne = 0
   do forever
      call MV_ResetDtmfBuffer
      call MV_Play FileNumber.lang  /* Please enter file number to record, or * for the next one */
      if (MV_AlreadyDisconnect()) then exit RC.HangUp
      mvrc=MV_ReadDtmf('fnum',length(prompts.0));
      if (MV_AlreadyDisconnect()) then exit RC.HangUp
      If (MV.SUCCESS<>mvrc & MV.TIME_OUT<>mvrc) then leave
      if (fnum='*' | fnum='#') then do
         fnum=LastOne+1
      end
      if fnum > prompts.0 then do
         call MV_Play menuErrMessage.lang
         if (MV_AlreadyDisconnect()) then exit RC.HangUp
         iterate
      end
      position = LastPos( "\", prompts.fnum )
      if (position>0) then fname = substr(prompts.fnum,position+1)
      else fname = prompts.fnum
      position = LastPos( ".", fname )
      if (position>0) then fname = substr(fname,1,position-1)
      call MV_SpellString fname, strip(HomeDir,"T","\")"\prompts.e\rhetorex", 500
      if (MV_AlreadyDisconnect()) then exit RC.HangUp
      LastOne = fnum
      call SysFileTree prompts.fnum, 'fileInfo', 'F'
      if (fileInfo.0=0) then do
         tmp=HomeDir"\"strip(prompts.fnum,'L','\')
         drop fileinfo.
         call SysFileTree tmp, 'fileInfo', 'F'
         if (fileInfo.0<>0) then prompts.fnum = tmp
      end
      if (fileInfo.0<>0) then do
         call MV_Play prompts.fnum
         if (MV_AlreadyDisconnect()) then exit RC.HangUp
         call MV_Beep
         if (MV_AlreadyDisconnect()) then exit RC.HangUp
         do until (ans='1' | ans='2')
            call MV_ResetDtmfBuffer
            call MV_Play AreYouSure.lang    /* This file already exists, press 1 to replace it */
            if (MV_AlreadyDisconnect()) then exit RC.HangUp
            mvrc=MV_ReadDtmf('ans',1,'12'); /* 1 if you want to record over it, 2 to cancel */
            if (MV_AlreadyDisconnect()) then exit RC.HangUp
            if MV.SUCCESS<>mvrc then leave
         end
         if (ans = '2') then iterate
      end
      drop fileinfo.
      tmpFile = SysTempFileName(HomeDir'\tmptmp@@@','@')
      do until ans <> '3'
         call DeleteTmpFile
         /* Begin recording at the sound of a beep and press any key when finished */
         call MV_Play BeginRec.lang   
         if (MV_AlreadyDisconnect()) then exit RC.HangUp
         call SysSleep 1
         call MV_Beep
         if (MV_AlreadyDisconnect()) then exit RC.HangUp
         call MV_Record tmpFile
         if (MV_AlreadyDisconnect()) then do
            call DeleteTmpFile
            exit RC.HangUp
         end
         do until ans<>'1'
            /* To play the message, press 1, to accept the message, press 2, to re-record it, press 3, 
               to cancel this one, press 4 */
            do until (ans='1' | ans='2' | ans='3' | ans='4')
               call MV_ResetDtmfBuffer
               call MV_Play AcceptRec.lang
               mvrc=MV_ReadDtmf('ans',1,'1234'); 
               if (MV_AlreadyDisconnect()) then do
                  call DeleteTmpFile
                  exit RC.HangUp
               end
            end
            if (ans='1') then do
               call MV_Play tmpFile
               call MV_Beep
            end
         end  /* '1' stays in the loop */
      end  /* '3' stays in the loop */
      if (ans='2') then 'copy 'tmpFile' 'prompts.fnum' >nul'
      call SysSleep 1
      call SysFileTree tmpFile, 'fileInfo', 'F'
      if (fileinfo.0<>0) then 'del 'tmpFile' >nul'
   end
RecordPromptExit:
   drop prompts.
return RC.HangUp
