/*PMPDF installation script*/
/* parameters:  ghostscript base path,
 *              pdf target directory,
 *              pdr location,
 *              postscript driver location
 */

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
arg errlog gs pdf pdr prdrv
inputfile=pdr'\pdf.rsp'
if gs = "" then do
ErrMsg =  "No Ghostscript directory path entered"
call lineout errlog, ErrMsg
exit 1
end
if pdf = "" then do
ErrMsg =  "No PDF file save directory path entered"
call lineout errlog, ErrMsg
exit 2
end
rc = SysFileTree(pdf,files)
if files.0='0' then do
ErrMsg =  "PDF file save directory not found"
call lineout errlog, ErrMsg
exit 4
end
rc = SysFileTree(pdr'\pdfwrite.pdr',files)
if files.0='0' then do
ErrMsg =  pdr'\pdfwrite.pdr' "PDF driver not found"
call lineout errlog, ErrMsg
exit 5
end
rc = SysFileTree(prdrv'\pscript.drv',files)
if files.0='0' then do
ErrMsg =  prdrv'\pscript.drv' "Postscript driver not found"
call lineout errlog, ErrMsg
exit 6
end
rc = SysFileTree(gs'\bin\gsos2.exe',files)
if files.0='0' then do
ErrMsg =  gs " directory path bad. Can't find \bin\gsos2.exe"
call lineout errlog, ErrMsg
exit 3
end

gs    = Strip(gs)
pdf   = Strip(pdf)
prdrv = Strip(prdrv)

rc = stream(inputfile, 'c', 'open read')
i = 0
DO while lines(inputfile)
 i = i + 1
 line.i = linein(inputfile)
END
line.0 = i
rc = stream(inputfile, 'c', 'close')

/* delete the inputfile */
rc = SysFileDelete(inputfile)
DO i = 1 TO line.0
IF Pos('SRCPATH', line.i) >< 0 THEN
  DO
   IF i = 3 THEN
    DO
     line.i = '      SRCPATH='||pdr
    END
   ELSE IF i = 11 THEN
    DO
     line.i = '      SRCPATH='||prdrv
    END
   END
rc = LineOut(inputfile, line.i)
END /* all lines processed */
rc = stream(inputfile, 'c', 'close')

string = Strip(gs||';'||pdf||"0"x)

call SysIni 'SYSTEM','PM_PDF','INITIALIZATION',string
'@rinstprn /R:'pdr'\pdf.rsp'

exit
