/* Program Name: drvinfo.fnc */

/* This program can be used to output the free space, used space, total space, or volume label of a drive.  It can also be used for network drives, but does not check for floppy drives. To use this program, the proper syntax is:

To output numerical data:   =rexx("drvinfo.fnc",0,2,"drive letter","type of info needed")

	"drive letter" - this is the actual drive that you require the information for.  Enter in just the actual letter, but
			do not include colons or any other symbols.

	"type of info needed" - this is the type of information you require.  Possible choices are:
			
		"free" - calculates the free space of the drive.
		"total" - calculates the total space of the drive.
		"used" - calculates the used space of the drive.

To output the volume label:  =rexx("drvinfo.fnc",1,2,"drive letter","vol")

	"drive letter" - this is the actual drive that you require the information for.  Enter in just the actual letter, but
			do not include colons or any other symbols.

	"vol" - outputs the volume label of the required drive. 

If any incorrect parameters are entered, the program will return a value of -1 */

/* Written by: Raheem Rhemtulla */

/* trace results */

/* This loads the RexxUtil functions SysDriveMap and SysDriveInfo */

call RxFuncAdd 'SysDriveMap', 'RexxUtil', 'SysDriveMap'
call RxFuncAdd 'SysDriveInfo', 'RexxUtil', 'SysDriveInfo'

/* This takes the arguments passed and breaks it down into the required variables. */
arg drive, user_info

invalid_drive = 0
/* This if checks to see if a letter was passed for the drive letter. */
if length(drive) <> 1 then do
  invalid_drive = 1
  return -1
  end

/* This checks what drives are available on the system */
drive_map = SysDriveMap('c:', used)
drive_map = drive_map || " "

/* This manipulates the drive letter entered by the user so that it matches the letters in 'drive_map' */
drive = drive || ":"

/* This loop compares the drive letter to those in 'drive_map', and if it is a valid drive, it calculates the space. If it is invalid, it returns an error message */
valid_drive = 0

do while (valid_drive = 0) & (invalid_drive = 0)
  letter_end = pos(" ", drive_map) /* Checks for a space in 'drive_map */
  /* This if takes the info in 'drive_map' and stores the first available drive in 'drive_letter' */
  if letter_end <> 1 then do 
    drive_letter = strip(substr(drive_map, 1, letter_end-1))
  /* This if removes the first available drive from 'drive_map' */
    drive_map = strip(substr(drive_map,letter_end))
    drive_map = drive_map || " "
    end
  else
    invalid_drive = 1
  /* This if checks the drive info if the drive entered by the user matches an available drive */
  /* If it does, then it uses the function SysDriveInfo to calculate the drive information. */
  if drive = drive_letter then do
    drive_info = SysDriveInfo(drive)
    valid_drive = 1
    end
end

/* This outputs an error message if the user enters an incorrect drive. */
if invalid_drive = 1 then
    return -1
  


/* If it is a valid drive, this if breaks the drive information and stores it into variables. */
if valid_drive = 1 then 
  do
    letter_end = pos(" ", drive_info) /*Checks for a space in 'drive_info' */
    drive_info = strip(substr(drive_info,letter_end))
    letter_end = pos(" ", drive_info)
    free_space = substr(drive_info, 1, letter_end-1)
    drive_info = strip(substr(drive_info,letter_end)) 
    letter_end = pos(" ", drive_info)
    /* This if checks if there is a volume label.  If there is, the volume label is stored in 'drive_label'.  If not, the                    remaining info is stored as 'total_space' */ 
    if letter_end > 0 then
      do
        total_space = substr(drive_info, 1, letter_end-1)
        drive_info = strip(substr(drive_info,letter_end))
        drive_label = substr(drive_info, 1)
        /* This if checks if the user wanted the volume label returned */
        if user_info = "VOL" then
          return drive_label
      end
    else
      total_space = substr(drive_info, 1)

valid_user_info = 0
/* This if checks if the user wanted the free space returned */
  if user_info = "FREE" then
    do
      return free_space
      valid_user_info = 1
    end
/* This if checks if the user wanted the total space returned */
  if user_info = "TOTAL" then
    do
      return total_space
      valid_user_info = 1
    end
/* This if checks if the user wanted the used space returned */
  if user_info = "USED" then
    do
      used_space = total_space - free_space
      return used_space
      valid_user_info = 1
    end
  end

/* This checks to see if the user entered the correct parameters for the drive information needed. */
if valid_user_info = 0 then
  return -1

/* trace off */
