/*
 * Decompiled with CFR 0.152.
 */
import datarep.common.LeftSideLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class AddEditDialog
extends Dialog
implements ActionListener {
    Frame parentFrame;
    String fileMask;
    String comment;
    boolean okExit;
    TextField maskField = new TextField(20);
    TextField commentField = new TextField(40);
    Button browseButton = new Button("Browse...");
    Button okButton = new Button("OK");
    Button cancelButton = new Button("Cancel");
    Panel buttonPanel = new Panel(new FlowLayout(2, 5, 5));

    public AddEditDialog(Frame parent, boolean editMode) {
        super(parent, true);
        this.parentFrame = parent;
        if (editMode) {
            this.setTitle("Edit excludelist entry");
        } else {
            this.setTitle("Add excludelist entry");
        }
        this.setLayout((LayoutManager)new LeftSideLayout(0, 0, true));
        this.add(new Label("File or filemask:"));
        this.add(this.maskField);
        this.add(new Label("Comment:"));
        this.add(this.commentField);
        this.buttonPanel.add(this.browseButton);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.browseButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.add(this.buttonPanel);
        ((Component)this).setSize(300, 160);
        Rectangle myRect = parent.getBounds();
        myRect.x += (myRect.width - 300) / 2;
        myRect.y += (myRect.height - 160) / 2;
        myRect.width = 300;
        myRect.height = 160;
        ((Component)this).setBounds(myRect);
    }

    public void setMask(String mask) {
        ((TextComponent)this.maskField).setText(mask);
    }

    public String getMask() {
        return this.fileMask;
    }

    public void setComment(String comm) {
        ((TextComponent)this.commentField).setText(comm);
    }

    public String getComment() {
        return this.comment;
    }

    public boolean getExitCode() {
        return this.okExit;
    }

    public void actionPerformed(ActionEvent e) {
        Button src = (Button)e.getSource();
        if (src == this.okButton) {
            this.fileMask = this.maskField.getText();
            this.comment = this.commentField.getText();
            this.okExit = true;
            this.dispose();
        } else if (src == this.cancelButton) {
            this.okExit = false;
            this.dispose();
        } else if (src == this.browseButton) {
            FileDialog fileChooser = new FileDialog(this.parentFrame, "Choose file or path to exclude", 0);
            fileChooser.show();
            ((TextComponent)this.maskField).setText(fileChooser.getFile());
        }
    }

    public Insets getInsets() {
        Insets i = super.getInsets();
        i.top += 5;
        i.bottom += 5;
        i.left += 5;
        i.right += 5;
        return i;
    }
}

