/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import norman.NSystem;
import norman.ndf.NDFBlock;

public class ExcludeBlock
extends NvccfBlock {
    public String[] masks;
    public String[] comments;

    public ExcludeBlock() {
        this.size = (short)(this.size + 8);
        this.objectType = NDFBlock.NOBJTYPE_NVCCF_EXCLUDE;
        this.masks = null;
        this.comments = null;
    }

    public void readExternal(DataInput in) throws IOException, ClassNotFoundException {
        int items = 0;
        super.readExternal(in);
        int bufferSize = this.size - 20;
        byte[] buffer = new byte[bufferSize];
        int maskOffset = NSystem.btol((int)in.readInt());
        int commentOffset = NSystem.btol((int)in.readInt());
        if (bufferSize > 0) {
            String tempComments;
            String tempMasks;
            in.readFully(buffer, 0, bufferSize);
            if (maskOffset < commentOffset) {
                tempMasks = new String(buffer, maskOffset, commentOffset - maskOffset - 1);
                tempComments = new String(buffer, commentOffset, bufferSize - commentOffset - 1);
            } else {
                tempMasks = new String(buffer, maskOffset, bufferSize - maskOffset - 1);
                tempComments = new String(buffer, commentOffset, commentOffset - maskOffset - 1);
            }
            StringTokenizer maskTokens = new StringTokenizer(tempMasks, "|");
            StringTokenizer commentTokens = new StringTokenizer(tempComments, "|");
            items = maskTokens.countTokens();
            if (items > 0) {
                this.masks = new String[items];
                this.comments = new String[items];
                items = 0;
                while (maskTokens.hasMoreTokens()) {
                    this.masks[items] = maskTokens.nextToken();
                    this.comments[items] = commentTokens.hasMoreTokens() ? commentTokens.nextToken() : "No description";
                    ++items;
                }
            }
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        String s = "";
        super.writeExternal(out);
        int i = 0;
        while (i < this.masks.length) {
            s = String.valueOf(s) + this.masks[i];
            if (i < this.masks.length - 1) {
                s = String.valueOf(s) + "|";
            }
            ++i;
        }
        out.writeInt(NSystem.btol((int)0));
        out.writeInt(NSystem.btol((int)(s.length() + 1)));
        out.write(s.getBytes());
        out.writeByte(0);
        s = "";
        i = 0;
        while (i < this.comments.length) {
            s = String.valueOf(s) + this.comments[i];
            if (i < this.comments.length - 1) {
                s = String.valueOf(s) + "|";
            }
            ++i;
        }
        out.write(s.getBytes());
        out.writeByte(0);
    }
}

