/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import norman.NSystem;
import norman.ndf.NDFBlock;

public class QtnBlock
extends NvccfBlock {
    public String location;
    public int flags;
    public int minTime;
    public int maxTime;
    public int maxSpace;
    public static final int QUARANTINE_BACKUP = 1;
    public static final int QUARANTINE_MOVE_INFECTED = 2;
    public static final int QUARANTINE_COPY_INTERESTING = 4;
    public static final int QUARANTINE_MOVE_ATTACHMENTS = 8;

    public QtnBlock() {
        this.size = (short)(this.size + 272);
        this.objectType = NDFBlock.NOBJTYPE_NVCCF_QUARANTINE;
        this.flags = 0;
        this.minTime = 0;
        this.maxTime = 0;
        this.maxSpace = 0;
    }

    public void readExternal(DataInput in) throws IOException, ClassNotFoundException {
        int bufferSize = 256;
        byte[] buffer = new byte[bufferSize];
        super.readExternal(in);
        in.readFully(buffer, 0, bufferSize);
        while (bufferSize > 0 && buffer[bufferSize - 1] == 0) {
            --bufferSize;
        }
        this.location = new String(buffer, 0, bufferSize);
        this.location.trim();
        this.flags = NSystem.btol((int)in.readInt());
        this.minTime = NSystem.btol((int)in.readInt());
        this.maxTime = NSystem.btol((int)in.readInt());
        this.maxSpace = NSystem.btol((int)in.readInt());
    }

    public void writeExternal(DataOutput out) throws IOException {
        int padding = 256;
        super.writeExternal(out);
        this.location = this.location.trim();
        out.writeBytes(this.location);
        if ((padding -= this.location.length()) > 0) {
            byte[] pad = new byte[padding];
            out.write(pad);
        }
        out.writeInt(NSystem.btol((int)this.flags));
        out.writeInt(NSystem.btol((int)this.minTime));
        out.writeInt(NSystem.btol((int)this.maxTime));
        out.writeInt(NSystem.btol((int)this.maxSpace));
    }

    public String toString() {
        return "QtnBlock:\n  size         = " + this.size + "\n  objType      = " + this.objectType + "\n  access       = " + this.access + "\n  validFlags   = " + this.validFlags + "\n  Location     = " + this.location + "\n  flags        = " + this.flags + "\n  minTime      = " + this.minTime + "\n  maxTime      = " + this.maxTime + "\n  maxSpace     = " + this.maxSpace;
    }
}

