/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import norman.NSystem;
import norman.ndf.NDFBlock;

public class ScanningBlock
extends NvccfBlock {
    public int hookFlags;
    public int findFlags;
    public int excludeFlags;
    public int unscannedMode;
    public int maxTime;
    public int priority;
    public static final int EXCLUDE_REMOTE = 1;
    public static final int EXCLUDE_XFILES = 2;
    public static final int EXCLUDE_LIST = 4;
    public static final int HOOK_OPEN_FOR_READ = 1;
    public static final int HOOK_CLOSE_AFTER_WRITE = 2;
    public static final int HOOK_RENAME = 4;
    public static final int HOOK_OPEN_FOR_READ_WRITE = 8;
    public static final int QUARANTINE_BACKUP = 1;
    public static final int QUARANTINE_MOVE_INFECTED = 2;
    public static final int QUARANTINE_COPY_INTERESTING = 4;
    public static final int QUARANTINE_MOVE_ATTACHMENTS = 8;

    public ScanningBlock() {
        this.size = (short)(this.size + 24);
        this.objectType = NDFBlock.NOBJTYPE_NVCCF_SCANNING;
        this.hookFlags = 0;
        this.findFlags = 66816;
        this.excludeFlags = 0;
        this.unscannedMode = 0;
        this.maxTime = 0;
        this.priority = 0;
    }

    public void readExternal(DataInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.hookFlags = NSystem.btol((int)in.readInt());
        this.findFlags = NSystem.btol((int)in.readInt());
        this.excludeFlags = NSystem.btol((int)in.readInt());
        this.unscannedMode = NSystem.btol((int)in.readInt());
        this.maxTime = NSystem.btol((int)in.readInt());
        this.priority = NSystem.btol((int)in.readInt());
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(NSystem.btol((int)this.hookFlags));
        out.writeInt(NSystem.btol((int)this.findFlags));
        out.writeInt(NSystem.btol((int)this.excludeFlags));
        out.writeInt(NSystem.btol((int)this.unscannedMode));
        out.writeInt(NSystem.btol((int)this.maxTime));
        out.writeInt(NSystem.btol((int)this.priority));
    }

    public String toString() {
        return "ScanningBlock:\n  size         = " + this.size + "\n  objType      = " + this.objectType + "\n  access       = " + this.access + "\n  validFlags   = " + this.validFlags + "\n  hookFlags    = " + this.hookFlags + "\n  findFlags    = " + this.findFlags + "\n  excludeFlags = " + this.excludeFlags + "\n  unscannedMode= " + this.unscannedMode + "\n  maxTime      = " + this.maxTime + "\n  priority     = " + this.priority;
    }
}

