/*
 * Decompiled with CFR 0.152.
 */
package CoffeeTable.Grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;

public class GridAttributes
implements Serializable,
Cloneable {
    static final long serialVersionUID = 8439969860223502837L;
    Font fFont = null;
    Color fBackColor = null;
    Color fTextColor = null;
    int fJustification = 0;
    int fCellType = 0;
    String[] fItems = null;
    transient FontMetrics fFontMetrics = null;
    transient Component fComponent = null;
    transient Font fOldFont = null;
    transient Color fOldColor = null;

    public GridAttributes(Component component, Font font, Color color, Color color2, int n) {
        this.fFont = font;
        this.fFontMetrics = this.fFont != null && component != null ? component.getFontMetrics(this.fFont) : null;
        this.fBackColor = color2;
        this.fTextColor = color;
        this.fJustification = n;
        this.fComponent = component;
        this.fCellType = 0;
    }

    public GridAttributes(Component component, Font font, Color color, Color color2, int n, int n2) {
        this(component, font, color, color2, n);
        this.fCellType = n2;
    }

    public GridAttributes(Component component, Font font, Color color, Color color2, int n, int n2, String[] stringArray) {
        this(component, font, color, color2, n);
        this.fCellType = n2;
        this.fItems = stringArray;
    }

    protected void finalize() {
        this.fFont = null;
        this.fFontMetrics = null;
        this.fBackColor = null;
        this.fTextColor = null;
        this.fComponent = null;
        this.fItems = null;
    }

    public synchronized Object clone() {
        Font font = null;
        if (this.fFont != null) {
            font = new Font(this.fFont.getName(), this.fFont.getStyle(), this.fFont.getSize());
        }
        Color color = null;
        if (this.fTextColor != null) {
            color = new Color(this.fTextColor.getRGB());
        }
        Color color2 = null;
        if (this.fBackColor != null) {
            color2 = new Color(this.fBackColor.getRGB());
        }
        int n = 0;
        if (this.fJustification != 0) {
            n = this.fJustification;
        }
        int n2 = 0;
        if (this.fCellType != 0) {
            n2 = this.fCellType;
        }
        String[] stringArray = null;
        if (this.fItems != null) {
            stringArray = new String[this.fItems.length];
            int n3 = 0;
            while (n3 < this.fItems.length) {
                stringArray[n3] = this.fItems[n3];
                ++n3;
            }
        }
        return new GridAttributes(this.fComponent, font, color, color2, n, n2, stringArray);
    }

    public final int getHeight() {
        if (this.fFontMetrics != null) {
            return this.fFontMetrics.getHeight();
        }
        return 0;
    }

    public final int getAscent() {
        if (this.fFontMetrics != null) {
            return this.fFontMetrics.getAscent();
        }
        return 0;
    }

    public final int getDescent() {
        if (this.fFontMetrics != null) {
            return this.fFontMetrics.getDescent();
        }
        return 0;
    }

    public final int getLeading() {
        if (this.fFontMetrics != null) {
            return this.fFontMetrics.getLeading();
        }
        return 0;
    }

    public final Font getFont() {
        return this.fFont;
    }

    public final void setFont(Font font) {
        this.fFont = font;
        if (this.fFont != null) {
            this.fFontMetrics = this.fComponent.getFontMetrics(this.fFont);
        }
    }

    final void setFont(Font font, Toolkit toolkit) {
        this.fFont = font;
        if (this.fFont != null) {
            this.fFontMetrics = toolkit.getFontMetrics(this.fFont);
        }
    }

    public final FontMetrics getFontMetrics() {
        if (this.fFontMetrics == null && this.fFont != null) {
            this.fFontMetrics = this.fComponent.getFontMetrics(this.fFont);
        }
        return this.fFontMetrics;
    }

    public final int getJustification() {
        return this.fJustification;
    }

    public final void setJustification(int n) {
        this.fJustification = n;
    }

    public final int getCellType() {
        return this.fCellType;
    }

    public final void setCellType(int n) {
        this.fCellType = n;
    }

    public final Color getBackColor() {
        return this.fBackColor;
    }

    public final void setBackColor(Color color) {
        this.fBackColor = color;
    }

    public final Color getTextColor() {
        return this.fTextColor;
    }

    public final void setTextColor(Color color) {
        this.fTextColor = color;
    }

    public final void setItems(String[] stringArray) {
        this.fItems = stringArray;
    }

    public final String[] getItems() {
        return this.fItems;
    }

    public final void beginDrawing(Graphics graphics) {
        this.fOldFont = graphics.getFont();
        this.fOldColor = graphics.getColor();
    }

    public final void endDrawing(Graphics graphics) {
        graphics.setFont(this.fOldFont);
        graphics.setColor(this.fOldColor);
    }

    final Component getComponent() {
        return this.fComponent;
    }

    final void setComponent(Component component) {
        this.fComponent = component;
        if (this.fFont != null) {
            this.fFontMetrics = this.fComponent.getFontMetrics(this.fFont);
        }
    }

    final GridAttributes getCompositeAttributes(GridAttributes gridAttributes, GridAttributes gridAttributes2, GridAttributes gridAttributes3) {
        GridAttributes gridAttributes4 = this;
        if (gridAttributes3 != null || gridAttributes2 != null || gridAttributes != null) {
            Font font = null;
            Color color = null;
            Color color2 = null;
            int n = 0;
            int n2 = 0;
            String[] stringArray = null;
            font = gridAttributes3 != null && gridAttributes3.fFont != null ? gridAttributes3.fFont : (gridAttributes2 != null && gridAttributes2.fFont != null ? gridAttributes2.fFont : (gridAttributes != null && gridAttributes.fFont != null ? gridAttributes.fFont : this.fFont));
            color = gridAttributes3 != null && gridAttributes3.fTextColor != null ? gridAttributes3.fTextColor : (gridAttributes2 != null && gridAttributes2.fTextColor != null ? gridAttributes2.fTextColor : (gridAttributes != null && gridAttributes.fTextColor != null ? gridAttributes.fTextColor : this.fTextColor));
            color2 = gridAttributes3 != null && gridAttributes3.fBackColor != null ? gridAttributes3.fBackColor : (gridAttributes2 != null && gridAttributes2.fBackColor != null ? gridAttributes2.fBackColor : (gridAttributes != null && gridAttributes.fBackColor != null ? gridAttributes.fBackColor : this.fBackColor));
            n = gridAttributes3 != null && gridAttributes3.fJustification != 0 ? gridAttributes3.fJustification : (gridAttributes2 != null && gridAttributes2.fJustification != 0 ? gridAttributes2.fJustification : (gridAttributes != null && gridAttributes.fJustification != 0 ? gridAttributes.fJustification : this.fJustification));
            n2 = gridAttributes3 != null && gridAttributes3.fCellType != 0 ? gridAttributes3.fCellType : (gridAttributes2 != null && gridAttributes2.fCellType != 0 ? gridAttributes2.fCellType : (gridAttributes != null && gridAttributes.fCellType != 0 ? gridAttributes.fCellType : this.fCellType));
            stringArray = gridAttributes3 != null && gridAttributes3.fItems != null ? gridAttributes3.fItems : (gridAttributes2 != null && gridAttributes2.fItems != null ? gridAttributes2.fItems : (gridAttributes != null && gridAttributes.fItems != null ? gridAttributes.fItems : this.fItems));
            gridAttributes4 = new GridAttributes(this.fComponent, font, color, color2, n, n2, stringArray);
        }
        return gridAttributes4;
    }
}

