/*
 * Decompiled with CFR 0.152.
 */
package CoffeeTable.Grid;

import CoffeeTable.Grid.ColorCanvas;
import CoffeeTable.Grid.GridAttributes;
import CoffeeTable.Grid.GridUtils;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class GridAttributesEditor
extends Panel
implements PropertyEditor,
ItemListener,
TextListener {
    private GridAttributes attributes = null;
    private Choice fontChoice = null;
    private Choice styleChoice = null;
    private Choice sizeChoice = null;
    private Choice justChoice = null;
    private Choice justOptionsChoice = null;
    private Choice typeChoice = null;
    private ColorCanvas textColorCanvas = null;
    private ColorCanvas backColorCanvas = null;
    private TextField textColor = null;
    private TextField backColor = null;
    private Choice textColorChoice = null;
    private Choice backColorChoice = null;
    private String[] colorNames = new String[]{" ", "white", "lightGray", "gray", "darkGray", "black", "red", "pink", "orange", "yellow", "green", "magenta", "cyan", "blue"};
    private Color[] colors = new Color[]{null, Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public GridAttributesEditor() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        Label label = new Label("Font:");
        this.add(label, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        Label label2 = new Label("Text Color:");
        this.add(label2, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        Label label3 = new Label("Background Color:");
        this.add(label3, gridBagLayout, gridBagConstraints, 0, 2, 1, 1);
        Label label4 = new Label("Justification:");
        this.add(label4, gridBagLayout, gridBagConstraints, 0, 3, 1, 1);
        Label label5 = new Label("Cell Type:");
        this.add(label5, gridBagLayout, gridBagConstraints, 0, 4, 1, 1);
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.anchor = 17;
        this.fontChoice = new Choice();
        String[] stringArray = this.getToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            this.fontChoice.addItem(stringArray[n]);
            ++n;
        }
        this.add(this.fontChoice, gridBagLayout, gridBagConstraints, 1, 0, 1, 1);
        this.fontChoice.addItemListener(this);
        this.styleChoice = new Choice();
        this.styleChoice.addItem("PLAIN");
        this.styleChoice.addItem("BOLD");
        this.styleChoice.addItem("ITALIC");
        this.add(this.styleChoice, gridBagLayout, gridBagConstraints, 2, 0, 1, 1);
        this.styleChoice.addItemListener(this);
        this.sizeChoice = new Choice();
        this.sizeChoice.addItem("3");
        this.sizeChoice.addItem("5");
        this.sizeChoice.addItem("7");
        this.sizeChoice.addItem("8");
        this.sizeChoice.addItem("9");
        this.sizeChoice.addItem("10");
        this.sizeChoice.addItem("11");
        this.sizeChoice.addItem("12");
        this.sizeChoice.addItem("14");
        this.sizeChoice.addItem("16");
        this.sizeChoice.addItem("18");
        this.sizeChoice.addItem("20");
        this.sizeChoice.addItem("24");
        this.sizeChoice.addItem("36");
        this.sizeChoice.addItem("48");
        this.add(this.sizeChoice, gridBagLayout, gridBagConstraints, 3, 0, 1, 1);
        this.sizeChoice.addItemListener(this);
        this.textColorCanvas = new ColorCanvas(Color.white);
        this.add(this.textColorCanvas, gridBagLayout, gridBagConstraints, 1, 1, 1, 1);
        this.textColor = new TextField(9);
        this.add(this.textColor, gridBagLayout, gridBagConstraints, 2, 1, 1, 1);
        this.textColor.addTextListener(this);
        this.textColorChoice = new Choice();
        this.setupColorChoice(this.textColorChoice);
        this.add(this.textColorChoice, gridBagLayout, gridBagConstraints, 3, 1, 1, 1);
        this.textColorChoice.addItemListener(this);
        this.backColorCanvas = new ColorCanvas(Color.white);
        this.add(this.backColorCanvas, gridBagLayout, gridBagConstraints, 1, 2, 1, 1);
        this.backColor = new TextField(9);
        this.add(this.backColor, gridBagLayout, gridBagConstraints, 2, 2, 1, 1);
        this.backColor.addTextListener(this);
        this.backColorChoice = new Choice();
        this.setupColorChoice(this.backColorChoice);
        this.add(this.backColorChoice, gridBagLayout, gridBagConstraints, 3, 2, 1, 1);
        this.backColorChoice.addItemListener(this);
        this.justChoice = new Choice();
        this.justChoice.addItem("LEFT");
        this.justChoice.addItem("CENTER");
        this.justChoice.addItem("RIGHT");
        this.add(this.justChoice, gridBagLayout, gridBagConstraints, 1, 3, 1, 1);
        this.justChoice.addItemListener(this);
        this.justOptionsChoice = new Choice();
        this.justOptionsChoice.addItem("");
        this.justOptionsChoice.addItem("TRUNC_STRING");
        this.justOptionsChoice.addItem("WORD_WRAP");
        this.justOptionsChoice.addItem("SPAN_COLUMNS");
        this.add(this.justOptionsChoice, gridBagLayout, gridBagConstraints, 2, 3, 2, 1);
        this.justOptionsChoice.addItemListener(this);
        this.typeChoice = new Choice();
        this.typeChoice.addItem("TEXT");
        this.typeChoice.addItem("EDITTEXT");
        this.typeChoice.addItem("URL");
        this.typeChoice.addItem("MAIL");
        this.add(this.typeChoice, gridBagLayout, gridBagConstraints, 1, 4, 1, 1);
        this.typeChoice.addItemListener(this);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void setupColorChoice(Choice choice) {
        int n = 0;
        while (n < this.colorNames.length) {
            choice.addItem(this.colorNames[n]);
            ++n;
        }
    }

    private String findColorName(Color color) {
        int n = 1;
        while (n < this.colors.length) {
            if (color.equals(this.colors[n])) {
                return this.colorNames[n];
            }
            ++n;
        }
        return " ";
    }

    private Color findColor(String string) {
        int n = 1;
        while (n < this.colorNames.length) {
            if (string.equals(this.colorNames[n])) {
                return this.colors[n];
            }
            ++n;
        }
        return null;
    }

    public Dimension preferredSize() {
        return new Dimension(380, 150);
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new GridAttributes(null, new Font("Dialog", 1, 12), Color.black, Color.white, 1, 1);
        }
        if (((GridAttributes)object).getComponent() == null) {
            ((GridAttributes)object).setComponent(this);
        }
        this.attributes = (GridAttributes)((GridAttributes)object).clone();
        Font font = this.attributes.getFont();
        this.fontChoice.select(font.getName());
        this.styleChoice.select(font.isPlain() ? "PLAIN" : (font.isBold() ? "BOLD" : "ITALIC"));
        this.sizeChoice.select(Integer.toString(font.getSize()));
        int n = this.attributes.getJustification();
        this.justChoice.select((n & 1) != 0 ? "LEFT" : ((n & 2) != 0 ? "CENTER" : "RIGHT"));
        if ((n & 0x800) != 0) {
            this.justOptionsChoice.select("WORD_WRAP");
        } else if ((n & 0x400) != 0) {
            this.justOptionsChoice.select("TRUNC_STRING");
        } else if ((n & 0x200) != 0) {
            this.justOptionsChoice.select("SPAN_COLUMNS");
        } else {
            this.justOptionsChoice.select("");
        }
        int n2 = this.attributes.getCellType();
        if (n2 == 1) {
            this.typeChoice.select("TEXT");
        } else if (n2 == 2) {
            this.typeChoice.select("EDITTEXT");
        } else if (n2 == 3) {
            this.typeChoice.select("URL");
        } else if (n2 == 4) {
            this.typeChoice.select("MAIL");
        }
        Color color = this.attributes.getTextColor();
        this.textColorCanvas.setColor(color);
        if (!this.textColor.getText().equals(this.colorStr(color))) {
            ((TextComponent)this.textColor).setText(this.colorStr(color));
        }
        this.textColorChoice.select(this.findColorName(color));
        color = this.attributes.getBackColor();
        this.backColorCanvas.setColor(color);
        if (!this.backColor.getText().equals(this.colorStr(color))) {
            ((TextComponent)this.backColor).setText(this.colorStr(color));
        }
        this.backColorChoice.select(this.findColorName(color));
    }

    public Object getValue() {
        return this.attributes.clone();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Shape shape = graphics.getClip();
        graphics.setColor(this.attributes.getBackColor());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(-2, -2);
        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.setColor(this.attributes.getTextColor());
        graphics.setFont(this.attributes.getFont());
        GridUtils.drawString(graphics, "This is some text drawn using GridAttributes.", rectangle2, this.attributes.getJustification(), this.attributes.getFontMetrics(), this.attributes.getCellType() == 3 || this.attributes.getCellType() == 4);
        graphics.setColor(color);
        graphics.setFont(font);
        graphics.setClip(shape);
    }

    public String getColorStr(Color color) {
        String string = this.findColorName(color);
        string = string.equals(" ") ? "new java.awt.Color(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")" : "java.awt.Color." + string;
        return string;
    }

    public String getJavaInitializationString() {
        String string;
        Font font = this.attributes.getFont();
        String string2 = "new java.awt.Font(\"" + this.attributes.getFont().getName() + "\", ";
        string2 = font.isBold() ? String.valueOf(string2) + (font.isItalic() ? "java.awt.Font.BOLD | java.awt.Font.ITALIC" : "java.awt.Font.BOLD") : String.valueOf(string2) + (font.isItalic() ? "java.awt.Font.ITALIC" : "java.awt.Font.PLAIN");
        string2 = String.valueOf(string2) + ", " + font.getSize() + ")";
        int n = this.attributes.getJustification();
        String string3 = (n & 1) != 0 ? "CoffeeTable.Grid.GridPanelInterface.JUST_LEFT" : (string = (n & 2) != 0 ? "CoffeeTable.Grid.GridPanelInterface.JUST_CENTER" : "CoffeeTable.Grid.GridPanelInterface.JUST_RIGHT");
        if ((n & 0x800) != 0) {
            string = String.valueOf(string) + "| CoffeeTable.Grid.GridPanelInterface.WORD_WRAP";
        } else if ((n & 0x400) != 0) {
            string = String.valueOf(string) + "| CoffeeTable.Grid.GridPanelInterface.TRUNC_STRING";
        } else if ((n & 0x200) != 0) {
            string = String.valueOf(string) + "| CoffeeTable.Grid.GridPanelInterface.SPAN_COLUMNS";
        }
        int n2 = this.attributes.getCellType();
        String string4 = null;
        if (n2 == 1) {
            string4 = "CoffeeTable.Grid.GridPanelInterface.TEXT";
        } else if (n2 == 2) {
            string4 = "CoffeeTable.Grid.GridPanelInterface.EDIT_TEXT";
        } else if (n2 == 3) {
            string4 = "CoffeeTable.Grid.GridPanelInterface.URL";
        } else if (n2 == 4) {
            string4 = "CoffeeTable.Grid.GridPanelInterface.MAIL";
        }
        return new String("new CoffeeTable.Grid.GridAttributes(null, " + string2 + ", " + this.getColorStr(this.attributes.getTextColor()) + ", " + this.getColorStr(this.attributes.getBackColor()) + ", " + string + ", " + string4 + ")");
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Color color;
        if (itemEvent.getSource() == this.fontChoice || itemEvent.getSource() == this.styleChoice || itemEvent.getSource() == this.sizeChoice) {
            this.attributes.setFont(new Font(this.fontChoice.getSelectedItem(), this.styleChoice.getSelectedItem().equals("PLAIN") ? 0 : (this.styleChoice.getSelectedItem().equals("BOLD") ? 1 : 2), Integer.valueOf(this.sizeChoice.getSelectedItem())), this.getToolkit());
            this.support.firePropertyChange("", null, null);
        } else if (itemEvent.getSource() == this.justChoice || itemEvent.getSource() == this.justOptionsChoice) {
            int n = 0;
            n = this.justChoice.getSelectedItem().equals("LEFT") ? 1 : (this.justChoice.getSelectedItem().equals("CENTER") ? 2 : 4);
            if (this.justOptionsChoice.getSelectedItem().equals("TRUNC_STRING")) {
                n |= 0x400;
            } else if (this.justOptionsChoice.getSelectedItem().equals("WORD_WRAP")) {
                n |= 0x800;
            } else if (this.justOptionsChoice.getSelectedItem().equals("SPAN_COLUMNS")) {
                n |= 0x200;
            }
            this.attributes.setJustification(n);
            this.support.firePropertyChange("", null, null);
        } else if (itemEvent.getSource() == this.typeChoice) {
            int n = 0;
            if (this.typeChoice.getSelectedItem().equals("TEXT")) {
                n = 1;
            } else if (this.typeChoice.getSelectedItem().equals("EDITTEXT")) {
                n = 2;
            } else if (this.typeChoice.getSelectedItem().equals("URL")) {
                n = 3;
            } else if (this.typeChoice.getSelectedItem().equals("MAIL")) {
                n = 4;
            }
            this.attributes.setCellType(n);
            this.support.firePropertyChange("", null, null);
        } else if (itemEvent.getSource() == this.textColorChoice) {
            Color color2;
            if (this.textColorChoice.getSelectedIndex() > 0 && !(color2 = this.findColor(this.textColorChoice.getSelectedItem())).equals(this.attributes.getTextColor())) {
                this.attributes.setTextColor(color2);
                this.textColorCanvas.setColor(color2);
                this.textColorCanvas.repaint();
                ((TextComponent)this.textColor).setText(this.colorStr(color2));
                this.support.firePropertyChange("", null, null);
            }
        } else if (itemEvent.getSource() == this.backColorChoice && this.backColorChoice.getSelectedIndex() > 0 && !(color = this.findColor(this.backColorChoice.getSelectedItem())).equals(this.attributes.getBackColor())) {
            this.attributes.setBackColor(color);
            this.backColorCanvas.setColor(color);
            this.backColorCanvas.repaint();
            ((TextComponent)this.backColor).setText(this.colorStr(color));
            this.support.firePropertyChange("", null, null);
        }
    }

    private String colorStr(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    private Color parseColor(String string) {
        Color color = null;
        int n = string.indexOf(44);
        int n2 = string.indexOf(44, n + 1);
        if (n < 0 || n2 < 0) {
            return null;
        }
        try {
            int n3 = Integer.parseInt(string.substring(0, n));
            int n4 = Integer.parseInt(string.substring(n + 1, n2));
            int n5 = Integer.parseInt(string.substring(n2 + 1));
            color = new Color(n3, n4, n5);
        }
        catch (Exception exception) {
            return null;
        }
        return color;
    }

    public void textValueChanged(TextEvent textEvent) {
        Color color;
        if (textEvent.getSource() == this.textColor) {
            Color color2 = this.parseColor(this.textColor.getText());
            if (color2 != null && !color2.equals(this.attributes.getTextColor())) {
                this.attributes.setTextColor(color2);
                this.textColorCanvas.setColor(color2);
                this.textColorCanvas.repaint();
                this.textColorChoice.select(this.findColorName(color2));
                this.support.firePropertyChange("", null, null);
            }
        } else if (textEvent.getSource() == this.backColor && (color = this.parseColor(this.backColor.getText())) != null && !color.equals(this.attributes.getBackColor())) {
            this.attributes.setBackColor(color);
            this.backColorCanvas.setColor(color);
            this.backColorCanvas.repaint();
            this.backColorChoice.select(this.findColorName(color));
            this.support.firePropertyChange("", null, null);
        }
    }

    private static Component getParent(Component component) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        return component2;
    }
}

