/*
 * Decompiled with CFR 0.152.
 */
package CoffeeTable.Grid;

import CoffeeTable.Grid.Comparable;
import CoffeeTable.Grid.GridDataInterface;
import java.io.Serializable;
import java.util.Vector;

public class GridData
implements GridDataInterface,
Serializable {
    static final long serialVersionUID = -1594757746598060628L;
    int fNumRows = 0;
    int fNumCols = 0;
    Vector fData = null;
    Vector fRowHeaders = null;
    Vector fColHeaders = null;
    private boolean fNeedRowHeaders = true;
    private boolean fNeedColHeaders = true;

    public GridData() {
    }

    public GridData(int n, int n2) {
        this(n, n2, true, true);
    }

    public GridData(int n, int n2, boolean bl, boolean bl2) {
        this.fNumRows = n;
        this.fNumCols = n2;
        this.fNeedRowHeaders = bl;
        this.fNeedColHeaders = bl2;
        if (this.fNeedRowHeaders) {
            this.fRowHeaders = new Vector(this.fNumRows, 20);
            this.fRowHeaders.setSize(this.fNumRows);
        }
        if (this.fNeedColHeaders) {
            this.fColHeaders = new Vector(this.fNumCols, 5);
            this.fColHeaders.setSize(this.fNumCols);
        }
        this.fData = new Vector(this.fNumRows, 20);
        this.fData.setSize(this.fNumRows);
        int n3 = 0;
        while (n3 < this.fNumRows) {
            Vector vector = new Vector(this.fNumCols, 5);
            vector.setSize(this.fNumCols);
            this.fData.setElementAt(vector, n3);
            ++n3;
        }
    }

    protected void finalize() {
        int n = 0;
        while (n < this.fNumRows) {
            ((Vector)this.fData.elementAt(n)).removeAllElements();
            ++n;
        }
        this.fData.removeAllElements();
        if (this.fNeedRowHeaders) {
            this.fRowHeaders.removeAllElements();
        }
        if (this.fNeedColHeaders) {
            this.fColHeaders.removeAllElements();
        }
    }

    public void setNumRows(int n) {
        int n2 = this.fNumRows;
        this.fNumRows = n;
        if (this.fNeedRowHeaders) {
            if (this.fRowHeaders == null) {
                this.fRowHeaders = new Vector(this.fNumRows, 20);
            }
            this.fRowHeaders.setSize(this.fNumRows);
        }
        if (this.fData == null) {
            this.fData = new Vector(this.fNumRows, 20);
        }
        this.fData.setSize(this.fNumRows);
        int n3 = 0;
        while (n3 < this.fNumRows) {
            Vector vector = (Vector)this.fData.elementAt(n3);
            if (vector == null) {
                vector = new Vector(this.fNumCols, 5);
                this.fData.setElementAt(vector, n3);
            }
            vector.setSize(this.fNumCols);
            ++n3;
        }
    }

    public int getNumRows() {
        return this.fNumRows;
    }

    public void setNumCols(int n) {
        int n2 = this.fNumCols;
        this.fNumCols = n;
        if (this.fNeedColHeaders) {
            if (this.fColHeaders == null) {
                this.fColHeaders = new Vector(this.fNumCols, 5);
            } else {
                this.fColHeaders.setSize(this.fNumCols);
            }
        }
        if (this.fNumRows > 0) {
            if (this.fData == null) {
                this.fData = new Vector(this.fNumRows, 20);
            }
            this.fData.setSize(this.fNumRows);
            int n3 = 0;
            while (n3 < this.fNumRows) {
                Vector vector = (Vector)this.fData.elementAt(n3);
                if (vector == null) {
                    vector = new Vector(this.fNumCols, 5);
                    this.fData.setElementAt(vector, n3);
                }
                vector.setSize(this.fNumCols);
                ++n3;
            }
        }
    }

    public int getNumCols() {
        return this.fNumCols;
    }

    public void insertRows(int n, int n2) {
        if (n > 0 && n2 > 0) {
            int n3 = 0;
            n3 = n > 0 && n <= this.fNumRows ? n - 1 : this.fNumRows;
            int n4 = 0;
            while (n4 < n2) {
                Vector vector = new Vector(this.fNumCols, 5);
                this.fData.insertElementAt(vector, n3);
                vector.setSize(this.fNumCols);
                if (this.fNeedRowHeaders) {
                    this.fRowHeaders.insertElementAt(null, n3);
                }
                ++this.fNumRows;
                ++n4;
            }
        }
    }

    public void deleteRows(int n, int n2) {
        if (n > 0 && n <= this.fNumRows && n2 > 0) {
            int n3 = n - 1;
            int n4 = 0;
            while (n4 < n2) {
                Vector vector = (Vector)this.fData.elementAt(n3);
                vector.removeAllElements();
                vector = null;
                this.fData.removeElementAt(n3);
                if (this.fNeedRowHeaders) {
                    this.fRowHeaders.removeElementAt(n3);
                }
                --this.fNumRows;
                ++n4;
            }
        }
    }

    public void insertCols(int n, int n2) {
        if (n > 0 && n2 > 0) {
            int n3 = 0;
            n3 = n > 0 && n <= this.fNumCols ? n - 1 : this.fNumCols;
            int n4 = 0;
            while (n4 < n2) {
                if (this.fNeedColHeaders) {
                    this.fColHeaders.insertElementAt(null, n3);
                }
                ++this.fNumCols;
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.fNumRows) {
                Vector vector = (Vector)this.fData.elementAt(n5);
                if (vector == null) {
                    vector = new Vector(this.fNumCols, 5);
                    this.fData.setElementAt(vector, n5);
                    vector.setSize(this.fNumCols);
                } else {
                    int n6 = 0;
                    while (n6 < n2) {
                        vector.insertElementAt(null, n3);
                        ++n6;
                    }
                }
                ++n5;
            }
        }
    }

    public void deleteCols(int n, int n2) {
        if (n > 0 && n <= this.fNumCols && n2 > 0) {
            int n3 = n - 1;
            int n4 = 0;
            while (n4 < n2) {
                if (this.fNeedColHeaders) {
                    this.fColHeaders.removeElementAt(n3);
                }
                --this.fNumCols;
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.fNumRows) {
                Vector vector = (Vector)this.fData.elementAt(n5);
                if (vector != null) {
                    int n6 = 0;
                    while (n6 < n2) {
                        vector.removeElementAt(n3);
                        ++n6;
                    }
                }
                ++n5;
            }
        }
    }

    public String getCellText(int n, int n2) {
        Object object = null;
        object = this.getCellData(n, n2);
        if (object != null) {
            return object.toString();
        }
        return new String("");
    }

    public Object getCellData(int n, int n2) {
        Vector vector;
        Object var3_3 = null;
        if (this.fData != null && n2 <= this.fNumRows && n <= this.fNumCols && (vector = (Vector)this.fData.elementAt(n2 - 1)) != null) {
            var3_3 = vector.elementAt(n - 1);
        }
        return var3_3;
    }

    public String getRowHeaderText(int n) {
        Object object = null;
        object = this.getRowHeaderData(n);
        if (object != null) {
            return object.toString();
        }
        return new String("");
    }

    public Object getRowHeaderData(int n) {
        Object var2_2 = null;
        if (this.fRowHeaders != null && n <= this.fNumRows) {
            return this.fRowHeaders.elementAt(n - 1);
        }
        return var2_2;
    }

    public String getColHeaderText(int n) {
        Object object = null;
        object = this.getColHeaderData(n);
        if (object != null) {
            return object.toString();
        }
        return new String("");
    }

    public Object getColHeaderData(int n) {
        Object var2_2 = null;
        if (this.fColHeaders != null && n <= this.fNumCols) {
            return this.fColHeaders.elementAt(n - 1);
        }
        return var2_2;
    }

    public void setCellText(int n, int n2, String string) {
        this.setCellData(n, n2, string);
    }

    public void setCellData(int n, int n2, Object object) {
        if (this.fData != null && n2 <= this.fNumRows && n <= this.fNumCols) {
            ((Vector)this.fData.elementAt(n2 - 1)).setElementAt(object, n - 1);
        }
    }

    public void setRowHeaderText(int n, String string) {
        this.setRowHeaderData(n, string);
    }

    public void setRowHeaderData(int n, Object object) {
        if (this.fRowHeaders != null && n <= this.fNumRows) {
            this.fRowHeaders.setElementAt(object, n - 1);
        }
    }

    public void setColHeaderText(int n, String string) {
        this.setColHeaderData(n, string);
    }

    public void setColHeaderData(int n, Object object) {
        if (this.fColHeaders != null && n <= this.fNumCols) {
            this.fColHeaders.setElementAt(object, n - 1);
        }
    }

    public Vector getRowData(int n) {
        return (Vector)this.fData.elementAt(n - 1);
    }

    public void setRowData(int n, Vector vector) {
        this.fData.setElementAt(vector, n - 1);
    }

    public int compare(Object object, Object object2, int n) {
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        return object.toString().compareTo(object2.toString());
    }
}

