/*
 * Decompiled with CFR 0.152.
 */
package CoffeeTable.Grid;

import CoffeeTable.Grid.AttributesMatrix;
import CoffeeTable.Grid.GridAttributes;
import CoffeeTable.Grid.GridData;
import CoffeeTable.Grid.GridDataInterface;
import CoffeeTable.Grid.GridEvent;
import CoffeeTable.Grid.GridListener;
import CoffeeTable.Grid.GridPanelInterface;
import CoffeeTable.Grid.GridSB;
import CoffeeTable.Grid.GridUtils;
import CoffeeTable.Grid.RunVector;
import java.applet.Applet;
import java.awt.Adjustable;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class GridPanel
extends Panel
implements GridPanelInterface,
AdjustmentListener,
KeyListener,
FocusListener,
Serializable {
    static final long serialVersionUID = 3533072781015354029L;
    private static final int DEF_COL_WIDTH = 100;
    private static final int MIN_COL_WIDTH = 3;
    private static final boolean TIME_BOMB = false;
    private static final boolean DEMO = false;
    private static final boolean DEBUG = false;
    private static final boolean EVAL = false;
    private static final int RESIZING_ROW_HEADER = 1;
    private static final int RESIZING_COL_HEADER = 2;
    private static final int MAC = 1;
    private static final int WINDOWS = 2;
    private static final int UNIX = 3;
    private Dimension fGridExtent;
    private Point fScrollOffset;
    private Point fCellInset;
    private Rectangle fGridRect = null;
    private int fVScrollbarDisplayPolicy;
    private int fHScrollbarDisplayPolicy;
    int fDefaultRowHeight = 0;
    private int fNumRows = 0;
    private int fNumCols = 0;
    private int fRowHeight = 0;
    private int fRowHeaderWidth = 0;
    private int fColHeaderHeight = 0;
    private boolean fAutoColHeaderHeight = false;
    private RunVector fGridWidths = null;
    private RunVector fMinColWidths = null;
    private Vector fSortEnable = null;
    private RunVector fGridHeights = null;
    private Vector fRowTags = null;
    private RunVector fSelections = null;
    private Rectangle fSelBounds = null;
    private Color fHighlightColor = null;
    private Color fHighlightTextColor = null;
    private Color fSortColumnColor = null;
    private GridAttributes fGridAttributes = null;
    private GridAttributes fHeaderAttributes = null;
    private AttributesMatrix fCellAttributes = null;
    private int fFlags = 0;
    private Color fLineColor = null;
    private Scrollbar fVScrollbar = null;
    private Scrollbar fHScrollbar = null;
    private int fInset = 0;
    private int fEvalHeight = 0;
    private GridDataInterface fGridData = null;
    private int fColResizeMode = 1;
    private static String fVersion = null;
    private static String fVendor = null;
    private static int fMinorVersion = 0;
    private static int fPlatform = 0;
    private transient boolean fNeedHScrollbar = false;
    private transient boolean fNeedVScrollbar = false;
    private transient int fHScrollbarHeight = 0;
    private transient int fVScrollbarWidth = 0;
    private transient int fHScrollAmount = 0;
    private transient int fVScrollAmount = 0;
    private transient Image fOffscreen = null;
    private transient Image fOffscreen2 = null;
    private transient int fSortColumn = 0;
    private transient int fSortOrder = 1;
    private transient boolean fPartialRow = false;
    private transient boolean fPartialCol = false;
    private transient Point fLastClickedCell = null;
    private transient Point fOldPoint = null;
    private transient Point fEditCell = null;
    private transient Point fAnchorCell = null;
    private transient Point fNextCell = null;
    private transient int fResizingColumn = 0;
    private transient int fResizingRow = 0;
    private transient int fResizingHeader = 0;
    private transient Component fEditor = null;
    private transient Cursor fCursor = null;
    private transient int fOffset = 0;
    private transient Frame fOurFrame;
    private transient Vector fGridListeners = null;
    private transient TextArea fTextArea = null;
    private transient Choice fChoice = null;
    private transient String[] fChoiceItems = null;
    private transient Vector fColRatios = null;
    private transient boolean fInAdjustColWidths = false;
    private transient boolean fInPrint = false;
    transient boolean fInGridPrinter = false;
    transient Rectangle fPrintPageRect = null;
    transient Adjustable fVSB = null;
    transient Adjustable fHSB = null;
    transient Applet fApplet = null;
    private static GridPanel fPreviousFocusGrid = null;

    public GridPanel() {
        this(0, 0);
    }

    public GridPanel(int n, int n2) {
        this(n, n2, -1, 50, -1, null, null, null, 1, 1, 238027583);
    }

    public GridPanel(int n, int n2, int n3, int n4, int n5, int[] nArray, GridAttributes gridAttributes, GridAttributes gridAttributes2, int n6, int n7, int n8) {
        this.setLayout(null);
        this.init();
        this.fGridRect = new Rectangle();
        this.fLineColor = Color.lightGray;
        this.fGridExtent = new Dimension(0, 0);
        this.fFlags = n8;
        this.fInset = this.isThreeDBorder() ? 1 : 0;
        this.fGridHeights = new RunVector(n, 0);
        this.fGridWidths = new RunVector(n2, 0);
        this.fMinColWidths = new RunVector(n2, 0);
        this.fSortEnable = new Vector(n2, 10);
        this.fRowTags = new Vector(n, 10);
        this.fGridAttributes = gridAttributes != null ? (GridAttributes)gridAttributes.clone() : new GridAttributes(this, new Font("SansSerif", 0, 12), Color.black, Color.white, 1, 1);
        this.fHeaderAttributes = gridAttributes2 != null ? (GridAttributes)gridAttributes2.clone() : new GridAttributes(this, new Font("SansSerif", 1, 12), Color.black, Color.lightGray, 1, 1);
        this.fCellAttributes = new AttributesMatrix(n, n2);
        this.doSetNumRows(n);
        this.doSetNumCols(n2);
        this.fCellInset = new Point(2, 2);
        this.fScrollOffset = new Point(0, 0);
        this.fHighlightColor = SystemColor.textHighlight;
        this.fHighlightTextColor = SystemColor.textHighlightText;
        if (n3 < 0) {
            this.fDefaultRowHeight = Math.max(this.fGridAttributes.getHeight() + this.fCellInset.y * 2, this.fHeaderAttributes.getHeight() + this.fCellInset.y * 2);
        } else if (n3 >= 0) {
            this.fDefaultRowHeight = n3;
        }
        this.fRowHeight = n3;
        this.fGridHeights.setItemValues(this.fDefaultRowHeight);
        int n9 = 0;
        while (n9 < n2) {
            if (nArray != null && n9 < nArray.length) {
                this.fGridWidths.setItemValue(n9, nArray[n9]);
            } else {
                this.fGridWidths.setItemValue(n9, 100);
            }
            ++n9;
        }
        this.fMinColWidths.setItemValues(3);
        this.fRowHeaderWidth = n4;
        if (n5 >= 0) {
            this.fColHeaderHeight = n5;
        } else if (n5 < 0) {
            this.fAutoColHeaderHeight = true;
            this.fColHeaderHeight = this.fHeaderAttributes.getHeight() + this.fCellInset.y * 2 + 1;
        }
        this.recalcGridExtent(true, true);
        this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
        this.fSelBounds = new Rectangle();
        switch (n6) {
            case 0: 
            case 1: 
            case 2: {
                this.fVScrollbarDisplayPolicy = n6;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal\tvertical scrollbar display policy");
            }
        }
        switch (n7) {
            case 0: 
            case 1: 
            case 2: {
                this.fHScrollbarDisplayPolicy = n7;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal\thorizontal scrollbar display policy");
            }
        }
        this.enableEvents(511L);
        this.setSize(new Dimension(150, 100));
        this.addFocusListener(this);
        this.createGridData();
    }

    void init() {
        String string = System.getProperty("os.name").toUpperCase();
        fPlatform = string.startsWith("MAC") ? 1 : (string.startsWith("WINDOWS") ? 2 : 3);
        fVersion = System.getProperty("java.version").toUpperCase();
        fVendor = System.getProperty("java.vendor").toUpperCase();
        this.fLastClickedCell = new Point(0, 0);
        this.fOldPoint = new Point(0, 0);
        this.fGridListeners = new Vector();
        this.fCursor = this.getDefaultCursor();
    }

    public void addNotify() {
        super.addNotify();
        this.redoScrollbars(this.getSize().width, this.getSize().height);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.fHScrollbar != null) {
            this.fHScrollbar.setEnabled(bl);
        }
        if (this.fVScrollbar != null) {
            this.fVScrollbar.setEnabled(bl);
        }
        if (bl) {
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public int getNumCols() {
        return this.fNumCols;
    }

    public void setNumCols(int n) {
        this.setNumCols(n, 100, this.isShowing());
    }

    public int getNumRows() {
        return this.fNumRows;
    }

    public void setNumRows(int n) {
        this.setNumRows(n, this.isShowing());
    }

    public int getMinColWidth(int n) {
        int n2 = 0;
        if (n > 0 && n <= this.fNumCols) {
            n2 = this.fMinColWidths.getValue(n - 1);
        }
        return n2;
    }

    public int getColWidth(int n) {
        int n2 = 0;
        if (n > 0 && n <= this.fNumCols) {
            n2 = this.fGridWidths.getValue(n - 1);
        }
        return n2;
    }

    public int getDefaultRowHeight() {
        return this.fDefaultRowHeight;
    }

    public void setSortEnable(boolean bl) {
        int n = 0;
        while (n < this.fNumCols) {
            this.fSortEnable.setElementAt(new Boolean(bl), n);
            ++n;
        }
    }

    public boolean getSortEnable() {
        boolean bl = false;
        int n = 0;
        while (n < this.fNumCols) {
            if (this.fSortEnable.elementAt(n) == null || !((Boolean)this.fSortEnable.elementAt(n)).booleanValue()) {
                bl = false;
                break;
            }
            bl = true;
            ++n;
        }
        return bl;
    }

    public void setSortEnable(int n, boolean bl) {
        if (n <= this.fNumCols) {
            this.fSortEnable.setElementAt(new Boolean(bl), n - 1);
        }
    }

    public boolean getSortEnable(int n) {
        if (n <= this.fNumCols) {
            if (this.fSortEnable.elementAt(n - 1) == null) {
                return false;
            }
            return (Boolean)this.fSortEnable.elementAt(n - 1);
        }
        return false;
    }

    public void setSortColumn(int n) {
        this.setSortColumn(n, this.isShowing());
    }

    public int getSortColumn() {
        return this.fSortColumn;
    }

    public int getSortOrder() {
        return this.fSortOrder;
    }

    public int getFlags() {
        return this.fFlags;
    }

    public void setFlags(int n, boolean bl) {
        this.fFlags = n;
        this.redoScrollbars(this.getSize().width, this.getSize().height);
        if (bl && this.isShowing()) {
            this.repaint();
        }
    }

    public void setFlags(int n) {
        this.setFlags(n, true);
    }

    public void setRowLines(boolean bl) {
        this.setFlag(256, bl);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public boolean isRowLines() {
        return this.getFlag(256);
    }

    public void setColLines(boolean bl) {
        this.setFlag(512, bl);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public boolean isColLines() {
        return this.getFlag(512);
    }

    public void setResizeColumns(boolean bl) {
        this.setFlag(16, bl);
    }

    public boolean getResizeColumns() {
        return this.getFlag(16);
    }

    public void setResizeRows(boolean bl) {
        this.setFlag(32, bl);
    }

    public boolean getResizeRows() {
        return this.getFlag(32);
    }

    public void setResizeColHeaders(boolean bl) {
        this.setFlag(64, bl);
    }

    public boolean getResizeColHeaders() {
        return this.getFlag(64);
    }

    public void setResizeRowHeaders(boolean bl) {
        this.setFlag(128, bl);
    }

    public boolean getResizeRowHeaders() {
        return this.getFlag(128);
    }

    public void setCellSelection(boolean bl) {
        this.setFlag(1, bl);
    }

    public boolean isCellSelection() {
        return this.getFlag(1);
    }

    public void setRowSelection(boolean bl) {
        this.setFlag(2, bl);
    }

    public boolean isRowSelection() {
        return this.getFlag(2);
    }

    public void setColSelection(boolean bl) {
        this.setFlag(4, bl);
    }

    public boolean isColSelection() {
        return this.getFlag(4);
    }

    public void setMultipleSelection(boolean bl) {
        this.setFlag(8, bl);
    }

    public boolean isMultipleSelection() {
        return this.getFlag(8);
    }

    public void setResizeMultiple(boolean bl) {
        this.setFlag(0x100000, bl);
    }

    public boolean isResizeMultiple() {
        return this.getFlag(0x100000);
    }

    public void setAutoResizeRows(boolean bl) {
        this.setFlag(0x800000, bl);
    }

    public boolean isAutoResizeRows() {
        return this.getFlag(0x800000);
    }

    public void setAutoResizeColumns(boolean bl) {
        this.setFlag(1024, bl);
    }

    public boolean isAutoResizeColumns() {
        return this.getFlag(1024);
    }

    public void setSingleClickEditing(boolean bl) {
        this.setFlag(2048, bl);
    }

    public boolean isSingleClickEditing() {
        return this.getFlag(2048);
    }

    public void setColResizeMode(int n) {
        this.fColResizeMode = n;
    }

    public int getColResizeMode() {
        return this.fColResizeMode;
    }

    private void recalcColumnWidths(int n, boolean bl, boolean bl2) {
        if (this.fColRatios == null) {
            this.recalcColRatios();
        }
        if (this.fColRatios.size() == this.getNumCols()) {
            int[] nArray = new int[this.getNumCols()];
            int n2 = 0;
            boolean bl3 = false;
            int n3 = 1;
            while (n3 <= this.getNumCols()) {
                nArray[n3 - 1] = Math.round(((Float)this.fColRatios.elementAt(n3 - 1)).floatValue() * (float)n);
                if (n3 == this.getNumCols() && (n2 += nArray[n3 - 1]) != n) {
                    int n4 = n3 - 1;
                    nArray[n4] = nArray[n4] + (n - n2);
                }
                ++n3;
            }
            this.fInAdjustColWidths = true;
            this.setColWidths(nArray, bl, bl2 && this.isShowing());
            this.fInAdjustColWidths = false;
        }
    }

    public void recalcColumnWidths() {
        this.recalcColumnWidths(this.getGridSize().width - this.getRowHeaderWidth(), true, true);
    }

    public void setDemoText(boolean bl) {
        this.setFlag(0x1000000, bl);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public boolean isDemoText() {
        return this.getFlag(0x1000000);
    }

    public void setThreeDBorder(boolean bl) {
        this.setFlag(0x2000000, bl);
        this.fInset = this.isThreeDBorder() ? 1 : 0;
        this.redoScrollbars(this.getSize().width, this.getSize().height);
        if (this.isShowing()) {
            Graphics graphics = this.getGraphics();
            this.update(graphics);
            graphics.dispose();
            graphics = null;
        }
    }

    public boolean isThreeDBorder() {
        return this.getFlag(0x2000000);
    }

    public void setSortRowHeaders(boolean bl) {
        this.setFlag(0x8000000, bl);
    }

    public boolean isSortRowHeaders() {
        return this.getFlag(0x8000000);
    }

    public void setSortAttributes(boolean bl) {
        this.setFlag(0x4000000, bl);
    }

    public boolean isSortAttributes() {
        return this.getFlag(0x4000000);
    }

    public void setRowNumbers(boolean bl) {
        this.setFlag(0x400000, bl);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public boolean isRowNumbers() {
        return this.getFlag(0x400000);
    }

    public void setDragSelect(boolean bl) {
        this.setFlag(0x200000, bl);
    }

    public boolean isDragSelect() {
        return this.getFlag(0x200000);
    }

    public int getVScrollbarDisplayPolicy() {
        return this.fVScrollbarDisplayPolicy;
    }

    public int getHScrollbarDisplayPolicy() {
        return this.fHScrollbarDisplayPolicy;
    }

    public void setHScrollbarDisplayPolicy(int n) {
        this.fHScrollbarDisplayPolicy = n;
        this.redoScrollbars(this.getSize().width, this.getSize().height);
    }

    public void setVScrollbarDisplayPolicy(int n) {
        this.fVScrollbarDisplayPolicy = n;
        this.redoScrollbars(this.getSize().width, this.getSize().height);
    }

    public void setRowHeight(int n) {
        this.setRowHeight(0, n, true, this.isShowing());
    }

    public Color getLineColor() {
        return this.fLineColor;
    }

    public void setLineColor(Color color) {
        this.setLineColor(color, this.isShowing());
    }

    public Color getSortColumnColor() {
        return this.fSortColumnColor;
    }

    public void setSortColumnColor(Color color) {
        this.fSortColumnColor = color;
        if (this.isShowing() & this.fSortColumn != 0) {
            this.repaint();
        }
    }

    public void setHighlightColor(Color color) {
        this.fHighlightColor = color;
    }

    public Color getHighlightColor() {
        return this.fHighlightColor;
    }

    public void setHighlightTextColor(Color color) {
        this.fHighlightTextColor = color;
    }

    public Color getHighlightTextColor() {
        return this.fHighlightTextColor;
    }

    public void setGridBackground(Color color) {
        this.setGridAttributes(new GridAttributes(this, null, null, color, 0), this.isShowing());
    }

    public Color getGridBackground() {
        return this.getGridAttributes().getBackColor();
    }

    public void setHeaderBackground(Color color) {
        this.setHeaderAttributes(new GridAttributes(this, null, null, color, 0), this.isShowing());
    }

    public Color getHeaderBackground() {
        return this.getHeaderAttributes().getBackColor();
    }

    public void setGridTextColor(Color color) {
        this.setGridAttributes(new GridAttributes(this, null, color, null, 0), this.isShowing());
    }

    public Color getGridTextColor() {
        return this.getGridAttributes().getTextColor();
    }

    public void setHeaderTextColor(Color color) {
        this.setHeaderAttributes(new GridAttributes(this, null, color, null, 0), this.isShowing());
    }

    public Color getHeaderTextColor() {
        return this.getHeaderAttributes().getTextColor();
    }

    public void setGridFont(Font font) {
        this.setGridAttributes(new GridAttributes(this, font, null, null, 0), this.isShowing());
    }

    public Font getGridFont() {
        return this.getGridAttributes().getFont();
    }

    public void setHeaderFont(Font font) {
        this.setHeaderAttributes(new GridAttributes(this, font, null, null, 0), this.isShowing());
    }

    public Font getHeaderFont() {
        return this.getHeaderAttributes().getFont();
    }

    public void setGridJustification(int n) {
        this.setGridAttributes(new GridAttributes(this, null, null, null, n), this.isShowing());
    }

    public int getGridJustification() {
        return this.getGridAttributes().getJustification();
    }

    public void setHeaderJustification(int n) {
        this.setHeaderAttributes(new GridAttributes(this, null, null, null, n), this.isShowing());
    }

    public int getHeaderJustification() {
        return this.getHeaderAttributes().getJustification();
    }

    public Object getRowTag(int n) {
        if (n <= this.fRowTags.size()) {
            return this.fRowTags.elementAt(n - 1);
        }
        return null;
    }

    public void setRowTag(int n, Object object) {
        if (n <= this.fRowTags.size()) {
            this.fRowTags.setElementAt(object, n - 1);
        }
    }

    public synchronized void addGridListener(GridListener gridListener) {
        this.fGridListeners.addElement(gridListener);
    }

    public synchronized void removeGridListener(GridListener gridListener) {
        this.fGridListeners.removeElement(gridListener);
    }

    public void setNumCols(int n, int[] nArray, boolean bl) {
        if (this.fGridData != null) {
            this.fGridData.setNumCols(n);
        }
        this.doSetNumCols(n);
        this.deselectAll(false);
        this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
        this.setColWidths(nArray, false, false);
        this.recalcGridExtent(true, false);
        boolean bl2 = this.redoScrollbars(this.getSize().width, this.getSize().height);
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        if (bl && this.isShowing()) {
            if (bl2) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void setNumCols(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.fNumCols;
        if (this.fGridData != null) {
            this.fGridData.setNumCols(n);
        }
        this.doSetNumCols(n);
        this.deselectAll(false);
        this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
        if (n > n4) {
            n3 = n4 + 1;
            while (n3 <= n) {
                this.doSetColWidth(n3, n2, false, false, true);
                ++n3;
            }
        }
        this.recalcGridExtent(true, false);
        n3 = this.redoScrollbars(this.getSize().width, this.getSize().height) ? 1 : 0;
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        if (bl && this.isShowing()) {
            if (n3 != 0) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void setNumCols(int n, boolean bl) {
        this.setNumCols(n, 100, bl);
    }

    public void setNumCols(int n, String string, boolean bl) {
        if (this.fGridData != null) {
            this.fGridData.setNumCols(n);
        }
        this.doSetNumCols(n);
        this.deselectAll(false);
        this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
        this.setColWidths(string, false, false);
        this.recalcGridExtent(true, false);
        boolean bl2 = this.redoScrollbars(this.getSize().width, this.getSize().height);
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        if (bl && this.isShowing()) {
            if (bl2) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void setNumRows(int n, boolean bl) {
        if (this.fGridData != null) {
            this.fGridData.setNumRows(n);
        }
        int n2 = this.fNumRows;
        this.doSetNumRows(n);
        this.deselectAll(false);
        this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
        this.recalcGridExtent(false, true);
        boolean bl2 = this.redoScrollbars(this.getSize().width, this.getSize().height);
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        if (bl && this.isShowing()) {
            if (bl2) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void setNumRows(int n, boolean bl, boolean bl2) {
        if (this.fGridData != null) {
            this.fGridData.setNumRows(n);
        }
        if (bl2 && this.fVSB != null) {
            this.fVSB.setValue(this.fVSB.getMinimum());
        }
        int n2 = this.fNumRows;
        this.doSetNumRows(n);
        this.deselectAll(false);
        this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
        this.recalcGridExtent(false, true);
        boolean bl3 = this.redoScrollbars(this.getSize().width, this.getSize().height);
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        if (bl && this.isShowing()) {
            if (bl3) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void deleteCol(int n) {
        this.deleteCols(n, 1);
    }

    public void deleteCols(int n, int n2) {
        if (n > 0 && n <= this.fNumCols && n2 > 0) {
            int n3;
            if (this.fEditCell != null) {
                this.endEdit(this.validate(this.getEditorText(), this.fEditCell));
            }
            if (n + n2 - 1 > this.fNumCols) {
                n2 = this.fNumCols - n + 1;
            }
            if (this.fGridData != null) {
                this.fGridData.deleteCols(n, n2);
            }
            if (n + n2 <= this.fNumCols) {
                n3 = n + n2;
                while (n3 <= this.fNumCols) {
                    this.doSetColWidth(n3 - n2, this.getColWidth(n3), false, false, true);
                    ++n3;
                }
                this.fCellAttributes.deleteCols(n, n2);
            }
            this.doSetNumCols(this.fNumCols - n2);
            this.deselectAll(false);
            this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
            this.recalcGridExtent(true, false);
            n3 = this.redoScrollbars(this.getSize().width, this.getSize().height) ? 1 : 0;
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
            if (this.fSortColumn >= n && this.fSortColumn <= n + n2 - 1) {
                this.fSortColumn = 0;
            }
            if (this.isShowing()) {
                if (n3 != 0) {
                    this.repaint();
                } else {
                    this.repaintGrid();
                }
            }
        }
    }

    public void insertCol(int n) {
        this.insertCols(n, 1);
    }

    public void insertCols(int n, int n2) {
        if (n > 0 && n2 > 0) {
            int n3;
            if (this.fEditCell != null) {
                this.endEdit(this.validate(this.getEditorText(), this.fEditCell));
            }
            if (n > this.fNumCols) {
                n = this.fNumCols + 1;
            }
            if (this.fGridData != null) {
                this.fGridData.insertCols(n, n2);
            }
            int n4 = this.fNumCols;
            this.doSetNumCols(n4 + n2);
            this.deselectAll(false);
            this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
            if (n <= n4) {
                n3 = this.fNumCols;
                while (n3 >= n + n2) {
                    this.doSetColWidth(n3, this.getColWidth(n3 - n2), false, false, true);
                    --n3;
                }
                this.fCellAttributes.insertCols(n, n2);
            }
            n3 = n;
            while (n3 < n + n2) {
                this.doSetColWidth(n3, 100, false, false, true);
                ++n3;
            }
            this.recalcGridExtent(true, false);
            boolean bl = this.redoScrollbars(this.getSize().width, this.getSize().height);
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
            if (this.fSortColumn >= n) {
                this.fSortColumn += n2;
            }
            if (this.isShowing()) {
                if (bl) {
                    this.repaint();
                } else {
                    this.repaintGrid();
                }
            }
        }
    }

    public void insertRow(int n) {
        this.insertRows(n, 1);
    }

    public void insertRows(int n, int n2) {
        if (n > 0 && n2 > 0) {
            int n3;
            if (this.fEditCell != null) {
                this.endEdit(this.validate(this.getEditorText(), this.fEditCell));
            }
            if (n > this.fNumRows) {
                n = this.fNumRows + 1;
            }
            if (this.fGridData != null) {
                this.fGridData.insertRows(n, n2);
            }
            int n4 = this.fNumRows;
            this.doSetNumRows(n4 + n2);
            this.deselectAll(false);
            this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
            if (n <= n4) {
                n3 = this.fNumRows;
                while (n3 >= n + n2) {
                    Object e;
                    this.setRowHeight(n3, this.getRowHeight(n3 - n2), false, false);
                    Hashtable hashtable = this.fCellAttributes.remove(n3 - n2);
                    if (hashtable != null) {
                        this.fCellAttributes.put(hashtable, n3);
                    }
                    this.fRowTags.setElementAt((e = this.fRowTags.elementAt(n3 - n2 - 1)) != null ? e : null, n3 - 1);
                    this.fRowTags.setElementAt(null, n3 - n2 - 1);
                    --n3;
                }
            }
            n3 = n;
            while (n3 < n + n2) {
                this.setRowHeight(n3, this.fDefaultRowHeight, false, false);
                this.fRowTags.setElementAt(null, n3 - 1);
                ++n3;
            }
            this.recalcGridExtent(false, true);
            boolean bl = this.redoScrollbars(this.getSize().width, this.getSize().height);
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
            if (this.isShowing()) {
                if (bl) {
                    this.repaint();
                } else {
                    this.repaintGrid();
                }
            }
        }
    }

    public void deleteRow(int n) {
        this.deleteRows(n, 1);
    }

    public void deleteRows(int n, int n2) {
        if (n > 0 && n <= this.fNumRows && n2 > 0) {
            int n3;
            if (this.fEditCell != null) {
                this.endEdit(this.validate(this.getEditorText(), this.fEditCell));
            }
            if (n + n2 - 1 > this.fNumRows) {
                n2 = this.fNumRows - n + 1;
            }
            if (this.fGridData != null) {
                this.fGridData.deleteRows(n, n2);
            }
            if (n + n2 <= this.fNumRows) {
                n3 = n + n2;
                while (n3 <= this.fNumRows) {
                    Object e;
                    this.setRowHeight(n3 - n2, this.getRowHeight(n3), false, false);
                    Hashtable hashtable = this.fCellAttributes.remove(n3);
                    if (hashtable != null) {
                        this.fCellAttributes.put(hashtable, n3 - n2);
                    }
                    this.fRowTags.setElementAt((e = this.fRowTags.elementAt(n3 - 1)) != null ? e : null, n3 - n2 - 1);
                    this.fRowTags.setElementAt(null, n3 - 1);
                    ++n3;
                }
            }
            this.doSetNumRows(this.fNumRows - n2);
            this.deselectAll(false);
            this.fSelections = new RunVector(this.fNumRows * this.fNumCols, 0);
            this.recalcGridExtent(false, true);
            n3 = this.redoScrollbars(this.getSize().width, this.getSize().height) ? 1 : 0;
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
            if (this.isShowing()) {
                if (n3 != 0) {
                    this.repaint();
                } else {
                    this.repaintGrid();
                }
            }
        }
    }

    public synchronized void autoResizeRow(int n, boolean bl) {
        if (n == 0 && (this.getColHeaderAttributes(0).getJustification() & 0x800) != 0) {
            int n2 = this.calcRowHeight(0);
            if (n2 != this.getColHeaderHeight()) {
                this.setColHeaderHeight(n2, bl);
            }
        } else {
            int n3 = this.calcRowHeight(n);
            if (n3 != this.getRowHeight(n)) {
                this.setRowHeight(n, n3, true, false);
                if (bl || this.isShowing()) {
                    this.repaint();
                }
            }
        }
    }

    public synchronized void autoResizeRows(boolean bl, boolean bl2) {
        int n;
        int n2;
        if ((this.getColHeaderAttributes(0).getJustification() & 0x800) != 0 && (n2 = this.calcRowHeight(0)) != this.getColHeaderHeight()) {
            this.setColHeaderHeight(n2, false);
        }
        n2 = 1;
        while (n2 <= this.getNumRows()) {
            n = this.calcRowHeight(n2);
            if (n != this.getRowHeight(n2)) {
                this.setRowHeight(n2, n, false, false);
            }
            ++n2;
        }
        n = 0;
        if (bl) {
            n = this.redoScrollbars(this.getSize().width, this.getSize().height) ? 1 : 0;
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        }
        if ((bl2 || bl) && this.isShowing()) {
            if (n != 0) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public synchronized void autoResizeRows(boolean bl) {
        this.autoResizeRows(true, bl);
    }

    public synchronized void repaint(long l, int n, int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.updateRect(graphics, rectangle);
        graphics.dispose();
        graphics = null;
    }

    public void setPreferredSize(Dimension dimension) {
        this.setSize(dimension);
    }

    public void setVisibleCells(int n, int n2) {
        this.redoScrollbars(this.getSize().width, this.getSize().height);
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        this.setSize(new Dimension(this.getColWidths(1, Math.min(this.fNumCols, n)) + this.fRowHeaderWidth + this.fVScrollbarWidth, this.getRowHeights(1, Math.min(this.fNumRows, n2)) + this.fColHeaderHeight + this.fHScrollbarHeight));
    }

    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void print(Graphics graphics) {
        this.fInPrint = true;
        super.print(graphics);
        super.printComponents(graphics);
        this.fInPrint = false;
    }

    public final String getVersionString() {
        String string = "2.1.3";
        return string;
    }

    public void setInGridPrinter(boolean bl) {
        this.fInGridPrinter = bl;
    }

    public void setPrintPageRect(Rectangle rectangle) {
        this.fPrintPageRect = rectangle;
    }

    public void paint(Graphics graphics) {
        Shape shape = graphics.getClip();
        if (!this.fInPrint && !this.fInGridPrinter) {
            this.prepareOffScreen(new Rectangle(this.fGridRect.x - 1, this.fGridRect.y - 1, this.fGridRect.width + 1, this.fGridRect.height + 1), null, null);
        }
        super.paint(graphics);
        if (!this.fInPrint && !this.fInGridPrinter) {
            graphics.drawImage(this.fOffscreen, this.fInset, this.fInset, null);
        } else {
            this.doPaint(graphics, new Rectangle(this.fGridRect.x - 1, this.fGridRect.y - 1, this.fGridRect.width + 1, this.fGridRect.height + 1));
        }
        graphics.setClip(shape);
        if (this.fHScrollbarHeight > 0 && this.fVScrollbarWidth > 0) {
            graphics.setColor(fPlatform == 3 ? Color.lightGray : this.getBackground());
            graphics.fillRect(this.fGridRect.width + this.fInset + 1, this.fGridRect.height + this.fInset + 1, this.fVScrollbarWidth, this.fHScrollbarHeight);
        }
        if (this.isThreeDBorder()) {
            graphics.setColor(fPlatform == 3 ? Color.gray : SystemColor.controlShadow);
            graphics.drawLine(0, 0, 0, this.getSize().height - 1);
            graphics.drawLine(1, 0, this.getSize().width - 2, 0);
            graphics.setColor(fPlatform == 3 ? new Color(224, 224, 224) : SystemColor.controlLtHighlight);
            graphics.drawLine(1, this.getSize().height - 1, this.getSize().width - 1, this.getSize().height - 1);
            graphics.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height - 2);
            graphics.setColor(Color.black);
        }
        graphics.setColor(this.isThreeDBorder() ? (fPlatform == 3 ? Color.black : SystemColor.controlDkShadow) : Color.black);
        graphics.drawLine(this.fInset, this.fInset, this.fInset, this.fInset + this.getSize().height - 1 - 2 * this.fInset);
        graphics.drawLine(this.fInset, this.fInset, this.fInset + this.getSize().width - 1 - 2 * this.fInset, this.fInset);
        graphics.setColor(this.isThreeDBorder() ? this.getBackground() : Color.black);
        graphics.drawLine(this.fInset + 1, this.fInset + this.getSize().height - 1 - 2 * this.fInset, this.fInset + this.getSize().width - 1 - 2 * this.fInset, this.fInset + this.getSize().height - 1 - 2 * this.fInset);
        graphics.drawLine(this.fInset + this.getSize().width - 1 - 2 * this.fInset, this.fInset + 1, this.fInset + this.getSize().width - 1 - 2 * this.fInset, this.fInset + this.getSize().height - 1 - 2 * this.fInset);
        graphics.setColor(Color.black);
        graphics.setClip(shape);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.doScroll(adjustmentEvent);
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        if (this.fEditCell != null) {
            this.endEdit(this.validate(this.getEditorText(), this.fEditCell));
        }
        super.setBounds(n, n2, n3, n4);
        if ((this.fFlags & 0x400) != 0 && this.getNumCols() > 0) {
            int n5 = n3 - this.fRowHeaderWidth - this.fInset * 2 - 1 - 16;
            this.recalcColumnWidths(n5, false, false);
        }
        this.redoScrollbars(n3, n4);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void revealRow(int n) {
        this.scrollCellVisible(new Point(1, n), false);
        if (this.fVSB != null) {
            this.setVPageIncrement();
        }
    }

    public void revealCol(int n) {
        this.scrollCellVisible(new Point(n, 1), true);
        if (this.fHSB != null) {
            this.setHPageIncrement();
        }
    }

    public void revealCell(int n, int n2) {
        this.scrollCellVisible(new Point(n, n2), true);
        if (this.fHSB != null) {
            this.setHPageIncrement();
        }
        this.scrollCellVisible(new Point(n, n2), false);
        if (this.fVSB != null) {
            this.setVPageIncrement();
        }
    }

    public final void doKeySelect(KeyEvent keyEvent) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = this.getVisSelection();
            Point point = null;
            Point point2 = null;
            if (!keyEvent.isShiftDown()) {
                point = keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37 ? this.getFirstSelectedCell() : this.getLastSelectedCell();
                this.deselectAll(false, false);
            } else {
                Rectangle rectangle = this.getSelBounds();
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37) {
                    point = new Point(rectangle.x, rectangle.y);
                    point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                } else {
                    point2 = new Point(rectangle.x, rectangle.y);
                    point = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                }
            }
            boolean bl = false;
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (point != null && point.y != 0) {
                        point.y = Math.max(point.y - 1, 1);
                        break;
                    }
                    point = new Point(1, this.fNumRows);
                    break;
                }
                case 40: {
                    if (point != null && point.y != 0) {
                        point.y = Math.min(point.y + 1, this.fNumRows);
                        break;
                    }
                    point = new Point(1, 1);
                    break;
                }
                case 37: {
                    if (point != null && point.x != 0) {
                        point.x = Math.max(point.x - 1, 1);
                    } else {
                        point = new Point(this.fNumCols, 1);
                    }
                    bl = true;
                    break;
                }
                case 39: {
                    if (point != null && point.x != 0) {
                        point.x = Math.min(point.x + 1, this.fNumCols);
                    } else {
                        point = new Point(1, 1);
                    }
                    bl = true;
                    break;
                }
            }
            if (!keyEvent.isShiftDown()) {
                if ((this.fFlags & 1) != 0) {
                    this.selectCell(point.x, point.y, false);
                } else if ((this.fFlags & 2) != 0) {
                    this.selectRow(point.y, false);
                } else if ((this.fFlags & 4) != 0) {
                    this.selectCol(point.x, false);
                }
            } else if ((this.fFlags & 8) != 0) {
                this.selectRange(point, point2, true, false);
            }
            this.fLastClickedCell = new Point(point.x, point.y);
            BitSet bitSet2 = this.getVisSelection();
            BitSet bitSet3 = (BitSet)bitSet.clone();
            bitSet3.xor(bitSet2);
            this.highlightSelection(bitSet3);
            if (bl && !this.isColVisible(point.x) || !this.isCellVisible(point)) {
                this.scrollCellVisible(point, bl);
            }
        }
    }

    public boolean handleURLClick(MouseEvent mouseEvent, int n, int n2) {
        try {
            String string = this.getURLText(this.getCellText(n, n2));
            if (string.length() > 0) {
                this.goToURL(string);
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return false;
        }
    }

    public void goToURL(String string) {
        URL uRL = null;
        try {
            if (!string.startsWith("http://") && !string.startsWith("https://")) {
                string = "http://" + string;
            }
            uRL = new URL(string);
            this.getApplet().getAppletContext().showDocument(uRL, "_blank");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
        }
    }

    public boolean handleMailClick(MouseEvent mouseEvent, int n, int n2) {
        try {
            String string = this.getURLText(this.getCellText(n, n2));
            if (string.length() > 0) {
                if (!string.startsWith("mailto:")) {
                    string = "mailto:" + string;
                }
                URL uRL = new URL(string);
                this.getApplet().getAppletContext().showDocument(uRL);
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return false;
        }
    }

    public boolean handleCellClick(MouseEvent mouseEvent, int n, int n2) {
        boolean bl = false;
        if (mouseEvent.getClickCount() == 1) {
            this.processGridEvent(new GridEvent(this, 1001, mouseEvent.getModifiers(), n, n2));
            if (n > 0 && n2 > 0) {
                if (this.isURL(n, n2)) {
                    bl = this.handleURLClick(mouseEvent, n, n2);
                } else if (this.isMail(n, n2)) {
                    bl = this.handleMailClick(mouseEvent, n, n2);
                }
            }
        }
        return bl;
    }

    public void processGridEvent(GridEvent gridEvent) {
        int n = 0;
        while (n < this.fGridListeners.size()) {
            switch (gridEvent.getID()) {
                case 1001: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridCellsClicked(gridEvent);
                    break;
                }
                case 1002: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridDoubleClicked(gridEvent);
                    break;
                }
                case 1003: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridCellsReleased(gridEvent);
                    break;
                }
                case 1004: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridStartEdit(gridEvent);
                    break;
                }
                case 1005: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridCommitEdit(gridEvent);
                    break;
                }
                case 1006: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridCancelEdit(gridEvent);
                    break;
                }
                case 1007: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridResizeRow(gridEvent);
                    break;
                }
                case 1008: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridResizeCol(gridEvent);
                    break;
                }
                case 1009: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridSortColumn(gridEvent);
                    break;
                }
                case 1010: {
                    ((GridListener)this.fGridListeners.elementAt(n)).gridSelChanged(gridEvent);
                    break;
                }
            }
            ++n;
        }
    }

    public boolean handleDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        this.processGridEvent(new GridEvent(this, 1002, mouseEvent.getModifiers(), n, n2));
        return n > 0 && n2 > 0 && this.canEditCell(n, n2) && this.handleEditClick(mouseEvent, n, n2);
    }

    public boolean handleEditClick(MouseEvent mouseEvent, int n, int n2) {
        if (this.fEditCell != null && (n != this.fEditCell.x || n2 != this.fEditCell.y)) {
            if (!this.endEdit(true)) {
                return false;
            }
            return false;
        }
        if (this.isCellSelected(n, n2) && this.canEditCell(n, n2) && this.fEditCell == null) {
            this.startEdit(n, n2);
            return true;
        }
        return false;
    }

    public Component createEditor(int n, int n2) {
        int n3 = this.getCellType(n, n2);
        if (n3 == 2) {
            if (this.fTextArea == null) {
                this.fTextArea = new TextArea("", 1, 1, 3);
                ((Component)this.fTextArea).setBackground(Color.white);
                this.fTextArea.setBounds(0, 0, 0, 0);
                this.fTextArea.setVisible(false);
            }
            return this.fTextArea;
        }
        if (n3 == 5) {
            if (this.fChoice == null) {
                this.fChoice = new Choice();
                this.fChoiceItems = this.getCellItems(n, n2);
                if (this.fChoiceItems != null && this.fChoiceItems.length > 0) {
                    int n4 = 0;
                    while (n4 < this.fChoiceItems.length) {
                        this.fChoice.addItem(this.fChoiceItems[n4]);
                        ++n4;
                    }
                }
                this.fChoice.setBounds(0, 0, 0, 0);
                this.fChoice.setVisible(false);
            } else {
                String[] stringArray = this.getCellItems(n, n2);
                if (this.fChoiceItems != stringArray) {
                    this.fChoiceItems = stringArray;
                    this.fChoice.removeAll();
                    if (this.fChoiceItems != null && this.fChoiceItems.length > 0) {
                        int n5 = 0;
                        while (n5 < this.fChoiceItems.length) {
                            this.fChoice.addItem(this.fChoiceItems[n5]);
                            ++n5;
                        }
                    }
                }
            }
            return this.fChoice;
        }
        return null;
    }

    public void startEdit(int n, int n2) {
        this.fEditCell = new Point(n, n2);
        this.fAnchorCell = null;
        this.revealCell(this.fEditCell.x, this.fEditCell.y);
        GridAttributes gridAttributes = this.getCellAttributes(n, n2);
        Rectangle rectangle = this.cellToRect(this.fEditCell);
        rectangle.translate(-this.fScrollOffset.x, -this.fScrollOffset.y);
        if (fPlatform == 3 && rectangle.height < gridAttributes.getHeight() + 14) {
            rectangle.height += gridAttributes.getHeight() + 14 - rectangle.height;
        }
        this.repaintCell(this.fEditCell);
        this.fEditor = this.createEditor(n, n2);
        this.fEditor.addKeyListener(this);
        this.fEditor.setBounds(rectangle.x - 1 + this.fInset, rectangle.y - 1 + this.fInset, rectangle.width + 1, rectangle.height + 1);
        this.fEditor.setFont(gridAttributes.getFont());
        this.setEditorText(new String(this.getCellText(n, n2)));
        this.add(this.fEditor);
        this.fEditor.setVisible(true);
        this.fEditor.requestFocus();
        this.fEditor.addFocusListener(this);
        this.processGridEvent(new GridEvent(this, 1004, 0, this.fEditCell.x, this.fEditCell.y));
    }

    public void focusGained(FocusEvent focusEvent) {
        GridPanel gridPanel = null;
        gridPanel = focusEvent.getSource() instanceof GridPanel ? (GridPanel)focusEvent.getSource() : (GridPanel)((Component)focusEvent.getSource()).getParent();
        if (fPreviousFocusGrid != gridPanel) {
            if (fPreviousFocusGrid != null && GridPanel.fPreviousFocusGrid.fEditCell != null) {
                fPreviousFocusGrid.endEdit(true);
            }
            fPreviousFocusGrid = gridPanel;
            if (!(focusEvent.getSource() instanceof GridPanel)) {
                ((Component)focusEvent.getSource()).requestFocus();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public synchronized boolean endEdit(boolean bl) {
        Point point = this.fEditCell;
        String string = null;
        string = this.getEditorText();
        if (!bl || this.validate(string, point)) {
            this.fEditCell = null;
            this.fEditor.removeKeyListener(this);
            this.setEditorText("");
            this.fEditor.removeFocusListener(this);
            this.remove(this.fEditor);
            this.requestFocus();
            this.fEditor.setVisible(false);
            this.fEditor.setBounds(-1000, 0, 0, 0);
            if (bl) {
                GridAttributes gridAttributes;
                int n = point.x;
                if (n > 1) {
                    while (--n > 1 && this.getCellText(n, point.y).equals("")) {
                    }
                }
                int n2 = this.getSpanColumns(n, point.y);
                boolean bl2 = this.isCellSelected(point.x, point.y);
                if (bl2) {
                    this.deselectCell(point.x, point.y, true);
                }
                this.setCellText(point.x, point.y, string, false);
                if (bl2) {
                    this.selectCell(point.x, point.y, false);
                }
                if ((n = point.x) > 1) {
                    while (--n > 1 && this.getCellText(n, point.y).equals("")) {
                    }
                }
                n2 = Math.max(n2, this.getSpanColumns(n, point.y));
                int n3 = this.getSpanColumns(point.x, point.y);
                int n4 = point.x;
                int n5 = point.x + n3 - 1;
                if (n2 > 1 && ((gridAttributes = this.getCellAttributes(n, point.y)).getJustification() & 0x200) != 0) {
                    n4 = n;
                    n5 = Math.max(n5, n + n2 - 1);
                }
                int n6 = n4;
                while (n6 <= n5) {
                    this.repaintCell(new Point(n6, point.y));
                    ++n6;
                }
                this.processGridEvent(new GridEvent(this, 1005, 0, point.x, point.y));
            } else {
                this.processGridEvent(new GridEvent(this, 1006, 0, point.x, point.y));
                this.repaintCell(point);
            }
            return true;
        }
        return false;
    }

    public boolean validate(String string, Point point) {
        return true;
    }

    public void drawIntersection(Graphics graphics, Rectangle rectangle) {
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        GridAttributes gridAttributes = this.getColHeaderAttributes(0);
        if (!this.isEnabled()) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.darkGray);
        } else {
            graphics.setColor(gridAttributes.getBackColor());
            graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, true);
            graphics.setColor(Color.black);
        }
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
    }

    public void drawHeaderCol(Graphics graphics, int n, Rectangle rectangle) {
        Rectangle rectangle2 = null;
        rectangle2 = this.fInGridPrinter && this.fPrintPageRect != null ? this.fPrintPageRect : graphics.getClipBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        GridAttributes gridAttributes = this.getColHeaderAttributes(n);
        if (!this.isEnabled()) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.darkGray);
            graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width, rectangle.height);
            graphics.setColor(Color.white);
        } else if (this.fSortColumn != 0 && n == this.fSortColumn) {
            graphics.setColor(gridAttributes.getBackColor().darker());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(gridAttributes.getBackColor().darker().darker());
            graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, false);
            graphics.setColor(Color.black);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(gridAttributes.getBackColor());
            graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, true);
            graphics.setColor(Color.black);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
            graphics.setColor(gridAttributes.getTextColor());
        }
        rectangle.grow(-1, 0);
        rectangle3 = rectangle.intersection(rectangle2);
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle.grow(-this.fCellInset.x, -this.fCellInset.y);
        graphics.setFont(gridAttributes.getFont());
        GridUtils.drawString(graphics, this.getColHeaderText(n), rectangle, gridAttributes.getJustification(), gridAttributes.getFontMetrics(), false);
        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public void drawHeaderRow(Graphics graphics, int n, Rectangle rectangle) {
        Rectangle rectangle2 = null;
        rectangle2 = this.fInGridPrinter && this.fPrintPageRect != null ? this.fPrintPageRect : graphics.getClipBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        GridAttributes gridAttributes = this.getRowHeaderAttributes(n);
        if (!this.isEnabled()) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.darkGray);
            graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width, rectangle.height);
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(gridAttributes.getBackColor());
            graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, true);
            graphics.setColor(Color.black);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
            graphics.setColor(gridAttributes.getTextColor());
        }
        rectangle.grow(-1, 0);
        rectangle3 = rectangle.intersection(rectangle2);
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle.grow(-this.fCellInset.x, -this.fCellInset.y);
        graphics.setFont(gridAttributes.getFont());
        GridUtils.drawString(graphics, this.getRowHeaderText(n), rectangle, gridAttributes.getJustification(), gridAttributes.getFontMetrics(), false);
        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public void drawCell(Graphics graphics, Point point, Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = null;
        rectangle2 = this.fInGridPrinter && this.fPrintPageRect != null ? this.fPrintPageRect : graphics.getClipBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        GridAttributes gridAttributes = this.getCellAttributes(point.x, point.y);
        graphics.setColor(Color.black);
        if (bl && this.isEnabled()) {
            graphics.setColor(this.getHighlightColor());
        } else if (this.fSortColumn != 0 && point.x == this.fSortColumn && this.fSortColumnColor != null) {
            graphics.setColor(this.fSortColumnColor);
        } else {
            graphics.setColor(gridAttributes.getBackColor());
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.fEditCell == null || !point.equals(this.fEditCell)) {
            rectangle.grow(0, 0);
            rectangle3 = rectangle.intersection(rectangle2);
            graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            String string = this.getCellText(point.x, point.y);
            int n = gridAttributes.getCellType();
            if (n == 6) {
                Object object = this.getCellData(point.x, point.y);
                if (object != null && object instanceof Image) {
                    this.drawCellImage(graphics, (Image)object, point, rectangle);
                }
            } else {
                rectangle.grow(-this.fCellInset.x, -this.fCellInset.y);
                if (!string.equals("")) {
                    boolean bl2;
                    if (bl && this.isEnabled()) {
                        graphics.setColor(this.getHighlightTextColor());
                    } else {
                        graphics.setColor(this.isEnabled() ? gridAttributes.getTextColor() : Color.lightGray);
                    }
                    graphics.setFont(gridAttributes.getFont());
                    boolean bl3 = bl2 = n == 3 || n == 4;
                    if (bl2) {
                        string = this.getDisplayText(string);
                    }
                    GridUtils.drawString(graphics, string, rectangle, gridAttributes.getJustification(), gridAttributes.getFontMetrics(), bl2);
                }
                rectangle.grow(this.fCellInset.x, this.fCellInset.y);
            }
        }
        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.setColor(this.fLineColor);
        if (this.isColLines()) {
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
        if (this.isRowLines()) {
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
        if (gridAttributes != this.getGridAttributes()) {
            gridAttributes = null;
        }
    }

    public void drawCellImage(Graphics graphics, Image image, Point point, Rectangle rectangle) {
        graphics.drawImage(image, rectangle.x, rectangle.y, this);
    }

    public void drawSpannedCell(Graphics graphics, Point point, int n, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = graphics.getClipBounds();
        Rectangle rectangle4 = rectangle.intersection(rectangle3);
        graphics.setClip(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
        GridAttributes gridAttributes = this.getCellAttributes(n, point.y);
        graphics.setColor(Color.black);
        if (bl) {
            graphics.setColor(this.getHighlightColor());
        } else if (this.fSortColumn != 0 && point.x == this.fSortColumn && this.fSortColumnColor != null) {
            graphics.setColor(this.fSortColumnColor);
        } else {
            graphics.setColor(gridAttributes.getBackColor());
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (point.x == n || point.x == n + n2 - 1) {
            rectangle.grow(-this.fCellInset.x, -this.fCellInset.y);
            rectangle.width += this.fCellInset.x;
            if (point.x == n + n2 - 1) {
                rectangle.x -= this.fCellInset.x;
            }
        }
        rectangle4 = rectangle.intersection(rectangle3);
        graphics.setClip(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
        String string = this.getCellText(n, point.y);
        if (!string.equals("")) {
            boolean bl2;
            if (bl) {
                graphics.setColor(this.getHighlightTextColor());
            } else {
                graphics.setColor(gridAttributes.getTextColor());
            }
            graphics.setFont(gridAttributes.getFont());
            rectangle2.grow(-this.fCellInset.x, -this.fCellInset.y);
            boolean bl3 = bl2 = gridAttributes.getCellType() == 3 || gridAttributes.getCellType() == 4;
            if (bl2) {
                string = this.getDisplayText(string);
            }
            GridUtils.drawString(graphics, string, rectangle2, gridAttributes.getJustification(), gridAttributes.getFontMetrics(), bl2);
        }
        if (point.x == n || point.x == n + n2 - 1) {
            rectangle.width -= this.fCellInset.x;
            if (point.x == n + n2 - 1) {
                rectangle.x += this.fCellInset.x;
            }
            rectangle.grow(this.fCellInset.x, this.fCellInset.y);
        }
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        graphics.setColor(this.fLineColor);
        if (this.isColLines() && n + n2 - 1 == point.x) {
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
        if (this.isRowLines()) {
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
        if (gridAttributes != this.getGridAttributes()) {
            gridAttributes = null;
        }
    }

    private void privateDrawCell(Graphics graphics, Point point, Rectangle rectangle, boolean bl) {
    }

    public Point getEditCell() {
        return this.fEditCell;
    }

    public Component getEditor() {
        if (this.fEditCell != null) {
            return this.fEditor;
        }
        return null;
    }

    private String getEditorText() {
        if (this.fEditor != null) {
            if (this.fEditor instanceof Choice) {
                return ((Choice)this.fEditor).getSelectedItem();
            }
            return ((TextComponent)this.fEditor).getText();
        }
        return "";
    }

    private void setEditorText(String string) {
        if (this.fEditor != null) {
            if (this.fEditor instanceof Choice) {
                ((Choice)this.fEditor).select(string);
            } else {
                ((TextComponent)this.fEditor).setText(string);
                ((TextComponent)this.fEditor).selectAll();
            }
        }
    }

    public TextArea getEditTextArea() {
        return (TextArea)this.getEditor();
    }

    public Point getCellInset() {
        return this.fCellInset;
    }

    public void setCellInset(Point point) {
        this.fCellInset = point;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public Dimension getGridSize() {
        return new Dimension(this.fGridRect.width, this.fGridRect.height);
    }

    public int xToCol(int n) {
        int n2 = this.fHSB != null ? -this.fScrollOffset.x : 0;
        int n3 = 0;
        if (n >= this.fRowHeaderWidth + this.fInset && n - n2 - this.fRowHeaderWidth - 1 <= this.fGridExtent.width) {
            int n4 = 0;
            n3 = n4 == n - n2 - this.fRowHeaderWidth - 1 && this.fNumCols >= 1 ? ++n3 : this.fGridWidths.findItemContains(n - n2 - this.fRowHeaderWidth - 1);
        }
        return n3;
    }

    public Point xyToCell(int n, int n2) {
        return new Point(this.xToCol(n), this.yToRow(n2));
    }

    public int yToRow(int n) {
        int n2 = this.fVSB != null ? -this.fScrollOffset.y : 0;
        int n3 = 0;
        if (n >= this.fColHeaderHeight + this.fInset && n - n2 - this.fColHeaderHeight - 1 <= this.fGridExtent.height) {
            int n4 = 0;
            n3 = n4 == n - n2 - this.fColHeaderHeight - 1 && this.fNumRows >= 1 ? ++n3 : this.fGridHeights.findItemContains(n - n2 - this.fColHeaderHeight - 1);
        }
        return n3;
    }

    public GridAttributes getGridAttributes() {
        return this.fGridAttributes;
    }

    public GridAttributes getHeaderAttributes() {
        return this.fHeaderAttributes;
    }

    public void setRowHeaderAttributes(GridAttributes gridAttributes) {
        this.setRowHeaderAttributes(0, gridAttributes);
    }

    public void setRowHeaderAttributes(int n, GridAttributes gridAttributes) {
        this.fCellAttributes.set(-1, n, gridAttributes != null ? gridAttributes : null);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setColHeaderAttributes(GridAttributes gridAttributes) {
        this.setColHeaderAttributes(0, gridAttributes);
    }

    public void setColHeaderAttributes(int n, GridAttributes gridAttributes) {
        this.fCellAttributes.set(n, -1, gridAttributes != null ? gridAttributes : null);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public GridAttributes getRowHeaderAttributes(int n) {
        return this.getHeaderAttributes().getCompositeAttributes(null, this.cellAttributes(-1, 0), n > 0 ? this.cellAttributes(-1, n) : null);
    }

    public GridAttributes getColHeaderAttributes(int n) {
        return this.getHeaderAttributes().getCompositeAttributes(this.cellAttributes(0, -1), null, n > 0 ? this.cellAttributes(n, -1) : null);
    }

    public GridAttributes getCellAttributes(int n, int n2) {
        return this.getGridAttributes().getCompositeAttributes(n > 0 ? this.getColAttributes(n) : null, n2 > 0 ? this.getRowAttributes(n2) : null, n > 0 && n2 > 0 ? this.cellAttributes(n, n2) : null);
    }

    public int getColWidths(int n, int n2) {
        int n3 = 0;
        if (n > 0 && this.fNumCols > 0 && n2 > 0) {
            if (n2 == 1) {
                n3 = this.fGridWidths.getValue(n - 1);
            } else if (n > 0 && n + n2 - 1 <= this.fGridWidths.getItemCount()) {
                n3 = this.fGridWidths.getCumItemValue(n + n2 - 2);
                if (n > 1) {
                    n3 -= this.fGridWidths.getCumItemValue(n - 2);
                }
            }
        }
        return n3;
    }

    public int getRowHeight(int n) {
        if (n == 0) {
            if (this.fRowHeight < 0) {
                return Math.max(this.fGridAttributes.getHeight() + this.fCellInset.y * 2, this.fHeaderAttributes.getHeight() + this.fCellInset.y * 2);
            }
            return this.fDefaultRowHeight;
        }
        if (n > 0 && n <= this.fNumRows) {
            return this.fGridHeights.getValue(n - 1);
        }
        return 0;
    }

    public int getRowHeight() {
        return this.getRowHeight(0);
    }

    public int getRowHeights(int n, int n2) {
        int n3 = 0;
        if (n > 0 && this.fNumRows > 0 && n2 > 0) {
            if (n2 == 1) {
                n3 = this.fGridHeights.getValue(n - 1);
            } else if (n > 0 && n + n2 - 1 <= this.fGridHeights.getItemCount()) {
                n3 = this.fGridHeights.getCumItemValue(n + n2 - 2);
                if (n > 1) {
                    n3 -= this.fGridHeights.getCumItemValue(n - 2);
                }
            }
        }
        return n3;
    }

    public void createGridData() {
        if (this.fGridData == null) {
            this.fGridData = new GridData(this.fNumRows, this.fNumCols);
        }
    }

    public void disposeGridData() {
        this.fGridData = null;
    }

    public void setGridData(GridDataInterface gridDataInterface, boolean bl) {
        if (this.fGridData != null) {
            this.fGridData = null;
        }
        this.fGridData = gridDataInterface;
        if (bl && this.isShowing()) {
            this.repaint();
        }
    }

    public void setGridData(GridDataInterface gridDataInterface) {
        this.setGridData(gridDataInterface, this.isShowing());
    }

    public GridDataInterface getGridData() {
        return this.fGridData;
    }

    public String getColHeaderText(int n) {
        String string = null;
        if (this.fGridData != null) {
            string = this.fGridData.getColHeaderText(n);
        }
        if ((this.fFlags & 0x1000000) != 0 && (string == null || string.equals(""))) {
            return new String("Col: " + n);
        }
        if (string != null) {
            return string;
        }
        return new String("");
    }

    public String[] getColHeaders() {
        String[] stringArray = new String[this.getNumCols()];
        int n = 0;
        while (n < this.getNumCols()) {
            stringArray[n] = this.getColHeaderText(n + 1);
            ++n;
        }
        return stringArray;
    }

    public void setColHeaderText(int n, String string, boolean bl) {
        if (this.fGridData != null) {
            this.fGridData.setColHeaderText(n, string);
            if (bl && this.isShowing()) {
                this.repaintColHeader(n);
            }
        }
    }

    public void setColHeaderText(int n, String string) {
        this.setColHeaderText(n, string, this.isShowing());
    }

    public void setColHeaders(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (n < this.getNumCols()) {
                this.setColHeaderText(n + 1, stringArray[n], this.isShowing());
            }
            ++n;
        }
    }

    public void setRowHeaderText(int n, String string, boolean bl) {
        if (this.fGridData != null) {
            this.fGridData.setRowHeaderText(n, string);
            if (bl && this.isShowing()) {
                this.repaintRowHeader(n);
            }
        }
    }

    public String getRowHeaderText(int n) {
        String string = null;
        if ((this.fFlags & 0x400000) != 0) {
            return String.valueOf(n);
        }
        if (this.fGridData != null) {
            string = this.fGridData.getRowHeaderText(n);
        }
        if ((this.fFlags & 0x1000000) != 0 && (string == null || string.equals(""))) {
            return new String("Row: " + n);
        }
        if (string != null) {
            return string;
        }
        return new String("");
    }

    public String getCellText(int n, int n2) {
        String string = null;
        if (this.fGridData != null) {
            string = this.fGridData.getCellText(n, n2);
        }
        if ((this.fFlags & 0x1000000) != 0 && (string == null || string.equals(""))) {
            return new String("Col: " + n + ", Row: " + n2);
        }
        if (string != null) {
            return string;
        }
        return new String("");
    }

    public Vector getRowData(int n) {
        Vector vector = null;
        if (this.fGridData != null) {
            vector = this.fGridData.getRowData(n);
        }
        return vector;
    }

    public Object getCellData(int n, int n2) {
        Object object = null;
        if (this.fGridData != null) {
            object = this.fGridData.getCellData(n, n2);
        }
        return object;
    }

    public void setCellText(int n, int n2, String string, boolean bl) {
        if (this.fGridData != null) {
            GridAttributes gridAttributes;
            this.fGridData.setCellText(n, n2, string);
            if (bl && this.isShowing()) {
                this.repaintCell(new Point(n, n2));
            }
            if ((this.fFlags & 0x800000) != 0 && ((gridAttributes = this.getCellAttributes(n, n2)).getJustification() & 0x800) != 0) {
                this.autoResizeRow(n2, bl);
            }
        }
    }

    public void setRowData(int n, Vector vector, boolean bl) {
        if (this.fGridData != null) {
            this.fGridData.setRowData(n, vector);
            if (bl && this.isShowing()) {
                this.repaintRow(n);
            }
        }
    }

    public void setCellData(int n, int n2, Object object, boolean bl) {
        if (this.fGridData != null) {
            GridAttributes gridAttributes;
            this.fGridData.setCellData(n, n2, object);
            if (bl && this.isShowing()) {
                this.repaintCell(new Point(n, n2));
            }
            if ((this.fFlags & 0x800000) != 0 && ((gridAttributes = this.getCellAttributes(n, n2)).getJustification() & 0x800) != 0) {
                this.autoResizeRow(n2, bl);
            }
        }
    }

    public Point getFirstSelectedCell() {
        int n;
        if (this.fNumRows > 0 && this.fNumCols > 0 && (n = this.fSelections.findValueFirstItem(1)) >= 0) {
            return new Point(n / this.fNumRows + 1, n % this.fNumRows + 1);
        }
        return new Point(0, 0);
    }

    public Point getLastSelectedCell() {
        int n;
        if (this.fNumRows > 0 && this.fNumCols > 0 && (n = this.fSelections.findValueLastItem(1)) >= 0) {
            return new Point(n / this.fNumRows + 1, n % this.fNumRows + 1);
        }
        return new Point(0, 0);
    }

    public Vector getSelectedCells() {
        Vector<Point> vector = null;
        Point point = this.getFirstSelectedCell();
        Point point2 = this.getLastSelectedCell();
        if (point != null && !point.equals(new Point(0, 0))) {
            vector = new Vector<Point>(0, 10);
            int n = 1;
            while (n <= this.getNumCols()) {
                int n2 = point.y;
                while (n2 <= point2.y) {
                    if (this.isCellSelected(n, n2)) {
                        vector.addElement(new Point(n, n2));
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return vector;
    }

    public int getFirstSelectedCol() {
        if (this.fNumRows > 0 && this.fNumCols > 0) {
            int n = 1;
            while (n <= this.fNumCols) {
                if (this.isColSelected(n)) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    public int getLastSelectedCol() {
        if (this.fNumRows > 0 && this.fNumCols > 0) {
            int n = this.fNumCols;
            while (n >= 1) {
                if (this.isColSelected(n)) {
                    return n;
                }
                --n;
            }
        }
        return 0;
    }

    public Vector getSelectedCols() {
        Vector<Integer> vector = null;
        int n = this.getFirstSelectedCol();
        int n2 = this.getLastSelectedCol();
        if (n > 0) {
            vector = new Vector<Integer>(0, 5);
            int n3 = n;
            while (n3 <= n2) {
                if (this.isColSelected(n3)) {
                    vector.addElement(new Integer(n3));
                }
                ++n3;
            }
        }
        return vector;
    }

    public int getFirstSelectedRow() {
        if (this.fNumRows > 0 && this.fNumCols > 0) {
            int n = 1;
            while (n <= this.fNumRows) {
                if (this.isRowSelected(n)) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    public int getLastSelectedRow() {
        if (this.fNumRows > 0 && this.fNumCols > 0) {
            int n = this.fNumRows;
            while (n >= 1) {
                if (this.isRowSelected(n)) {
                    return n;
                }
                --n;
            }
        }
        return 0;
    }

    public Vector getSelectedRows() {
        Vector<Integer> vector = null;
        int n = this.getFirstSelectedRow();
        int n2 = this.getLastSelectedRow();
        if (n > 0) {
            vector = new Vector<Integer>(0, 10);
            int n3 = n;
            while (n3 <= n2) {
                if (this.isRowSelected(n3)) {
                    vector.addElement(new Integer(n3));
                }
                ++n3;
            }
        }
        return vector;
    }

    public Point getFirstVisibleCell() {
        Rectangle rectangle = this.getVisRect(false, false);
        return this.xyToCell(rectangle.x + 1, rectangle.y + 1);
    }

    public Point getLastVisibleCell() {
        Rectangle rectangle = this.getVisRect(false, false);
        Point point = this.xyToCell(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        if (point.x == 0) {
            point.x = this.fNumCols;
        }
        if (point.y == 0) {
            point.y = this.fNumRows;
        }
        return point;
    }

    public synchronized void repaintCell(Point point) {
        if (this.isShowing()) {
            Rectangle rectangle = this.cellToRect(point);
            rectangle.translate(-this.fScrollOffset.x, -this.fScrollOffset.y);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public synchronized void repaintCol(int n) {
        if (this.isShowing()) {
            Rectangle rectangle = this.colToRect(n);
            rectangle.translate(-this.fScrollOffset.x, -this.fScrollOffset.y);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public synchronized void repaintRow(int n) {
        if (this.isShowing()) {
            Rectangle rectangle = this.rowToRect(n);
            rectangle.translate(-this.fScrollOffset.x, -this.fScrollOffset.y);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public synchronized void repaintColHeader(int n) {
        if (this.isShowing()) {
            Rectangle rectangle = this.colHeaderToRect(n);
            rectangle.translate(-this.fScrollOffset.x, -this.fScrollOffset.y);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public synchronized void repaintRowHeader(int n) {
        if (this.isShowing()) {
            Rectangle rectangle = this.rowHeaderToRect(n);
            rectangle.translate(-this.fScrollOffset.x, -this.fScrollOffset.y);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void repaintGrid() {
        if (this.isShowing()) {
            this.repaint(this.fGridRect.x - 1 - this.fInset, this.fGridRect.y - 1 - this.fInset, this.fGridRect.width + 1 + this.fInset * 2, this.fGridRect.height + 1 + this.fInset * 2);
        }
    }

    public int getHScrollAmount() {
        return this.fHScrollAmount;
    }

    public void setHScrollAmount(int n) {
        this.fHScrollAmount = n;
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
    }

    public int getVScrollAmount() {
        return this.fVScrollAmount;
    }

    public void setVScrollAmount(int n) {
        this.fVScrollAmount = n;
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
    }

    public Point getScrollOffset() {
        return this.fScrollOffset;
    }

    public Rectangle headerColToRect(int n) {
        Rectangle rectangle = this.getColHeaderRect();
        int n2 = 0;
        if (n > 1) {
            n2 = this.getColWidths(1, n - 1);
        }
        return new Rectangle(rectangle.x + n2, rectangle.y, this.getColWidth(n), rectangle.height);
    }

    public Rectangle cellToRect(Point point) {
        Rectangle rectangle = this.getGridRect(false, false);
        int n = 0;
        if (point.x > 1) {
            n = this.getColWidths(1, point.x - 1);
        }
        int n2 = 0;
        if (point.y > 1) {
            n2 = this.getRowHeights(1, point.y - 1);
        }
        return new Rectangle(rectangle.x + n, rectangle.y + n2, this.getColWidth(point.x), this.getRowHeight(point.y));
    }

    public Rectangle colToRect(int n) {
        Rectangle rectangle = this.getGridRect(true, false);
        int n2 = 0;
        if (n > 1) {
            n2 = this.getColWidths(1, n - 1);
        }
        return new Rectangle(rectangle.x + n2, rectangle.y, this.getColWidth(n), rectangle.height);
    }

    public Rectangle rowToRect(int n) {
        Rectangle rectangle = this.getGridRect(false, true);
        int n2 = 0;
        if (n > 1) {
            n2 = this.getRowHeights(1, n - 1);
        }
        return new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, this.getRowHeight(n));
    }

    public Rectangle colHeaderToRect(int n) {
        Rectangle rectangle = this.getColHeaderRect();
        int n2 = 0;
        if (n > 1) {
            n2 = this.getColWidths(1, n - 1);
        }
        return new Rectangle(rectangle.x + n2, rectangle.y, this.getColWidths(n, 1), rectangle.height);
    }

    public Rectangle rowHeaderToRect(int n) {
        Rectangle rectangle = this.getRowHeaderRect();
        int n2 = 0;
        if (n > 1) {
            n2 = this.getRowHeights(1, n - 1);
        }
        return new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, this.getRowHeight(n));
    }

    public Rectangle getColHeaderRect() {
        return new Rectangle(1 + this.fRowHeaderWidth, 1, this.fGridExtent.width, this.fColHeaderHeight);
    }

    public Rectangle getRowHeaderRect() {
        return new Rectangle(1, 1 + this.fColHeaderHeight, this.fRowHeaderWidth, this.fGridExtent.height);
    }

    public void setSortColumn(int n, boolean bl, int n2) {
        this.fSortColumn = n;
        this.fSortOrder = n2;
        if (n > 0) {
            this.deselectAll(false, this.getFirstSelectedCell().equals(new Point(0, 0)) ^ true);
            if (this.getGridData() != null) {
                this.sortRows(this.fSortColumn, this.fSortOrder);
            }
        }
        if (bl) {
            this.repaintGrid();
        }
    }

    public void setSortColumn(int n, boolean bl) {
        this.setSortColumn(n, bl, 1);
    }

    public void sortRows(int n, int n2) {
        if (this.getNumRows() > 0 && this.getNumCols() > 0) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            Object object = null;
            GridDataInterface gridDataInterface = this.getGridData();
            boolean bl = this.getFlag(0x4000000);
            boolean bl2 = this.getFlag(0x8000000);
            while ((n5 = 3 * n5 + 1) <= gridDataInterface.getNumRows()) {
            }
            do {
                n3 = (n5 /= 3) + 1;
                while (n3 <= gridDataInterface.getNumRows()) {
                    Vector vector = gridDataInterface.getRowData(n3);
                    Object object2 = null;
                    if (bl2) {
                        object2 = gridDataInterface.getRowHeaderData(n3);
                    }
                    Hashtable hashtable = bl ? this.fCellAttributes.remove(n3) : null;
                    Object object3 = this.getRowTag(n3);
                    int n6 = this.fGridHeights.getValue(n3 - 1);
                    object = gridDataInterface.getCellData(n, n3);
                    n4 = n3;
                    boolean bl3 = false;
                    while (!bl3 && gridDataInterface.compare(gridDataInterface.getCellData(n, n4 - n5), object, n) * n2 > 0) {
                        Vector vector2 = gridDataInterface.getRowData(n4 - n5);
                        Object object4 = null;
                        if (bl2) {
                            object4 = gridDataInterface.getRowHeaderData(n4 - n5);
                        }
                        Hashtable hashtable2 = bl ? this.fCellAttributes.remove(n4 - n5) : null;
                        Object object5 = this.getRowTag(n4 - n5);
                        int n7 = this.fGridHeights.getValue(n4 - n5 - 1);
                        gridDataInterface.setRowData(n4, vector2);
                        if (bl2) {
                            gridDataInterface.setRowHeaderData(n4, object4);
                        }
                        if (bl) {
                            this.fCellAttributes.put(hashtable2, n4);
                        }
                        this.setRowTag(n4, object5);
                        this.fGridHeights.setItemValue(n4 - 1, n7);
                        if ((n4 -= n5) > n5) continue;
                        bl3 = true;
                    }
                    gridDataInterface.setRowData(n4, vector);
                    if (bl2) {
                        gridDataInterface.setRowHeaderData(n4, object2);
                    }
                    if (bl) {
                        this.fCellAttributes.put(hashtable, n4);
                    }
                    this.setRowTag(n4, object3);
                    this.fGridHeights.setItemValue(n4 - 1, n6);
                    ++n3;
                }
            } while (n5 != 1);
            boolean bl4 = this.redoScrollbars(this.getSize().width, this.getSize().height);
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        }
    }

    public void sortRows(int n) {
        this.sortRows(n, 1);
    }

    public void highlightCell(Graphics graphics, Point point, Rectangle rectangle, boolean bl) {
        this.drawCell(graphics, point, rectangle, bl);
    }

    public void highlightSpannedCell(Graphics graphics, Point point, int n, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        this.drawSpannedCell(graphics, point, n, n2, rectangle, rectangle2, bl);
    }

    public boolean isCellSelected(int n, int n2) {
        if (n <= this.fNumCols && n2 <= this.fNumRows) {
            int n3 = (n - 1) * this.fNumRows + n2 - 1;
            return this.fSelections.getValue(n3) == 1;
        }
        return false;
    }

    public boolean isColSelected(int n) {
        int n2 = 1;
        while (n2 <= this.fNumRows) {
            if (!this.isCellSelected(n, n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Rectangle getSelBounds() {
        return new Rectangle(this.fSelBounds);
    }

    public boolean isRowSelected(int n) {
        int n2 = 1;
        while (n2 <= this.fNumCols) {
            if (!this.isCellSelected(n2, n)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void selectCell(int n, int n2, boolean bl) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = null;
            if (bl && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            int n3 = (n - 1) * this.fNumRows + n2 - 1;
            this.fSelections.setItemValue(n3, 1);
            this.addSelBounds(n, n2);
            this.processGridEvent(new GridEvent(this, 1010, 0, n, n2));
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    public void selectCol(int n, boolean bl) {
        this.selectCols(n, n, true, bl);
    }

    void selectCols(int n, int n2, boolean bl, boolean bl2) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = null;
            if (bl2 && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            if (!bl) {
                this.fSelections.setItemValues(0);
            }
            int n3 = n;
            while (n3 <= n2) {
                int n4 = (n3 - 1) * this.fNumRows;
                while (n4 < n3 * this.fNumRows) {
                    this.fSelections.setItemValue(n4, 1);
                    ++n4;
                }
                ++n3;
            }
            this.addSelBounds(n, 1, n2 - n + 1, this.fNumRows);
            this.processGridEvent(new GridEvent(this, 1010, 0, n, 0));
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl2 && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    public void selectRow(int n, boolean bl) {
        this.selectRows(n, n, true, bl);
    }

    void selectRows(int n, int n2, boolean bl, boolean bl2) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = null;
            if (bl2 && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            if (!bl) {
                this.fSelections.setItemValues(0);
            }
            int n3 = n;
            while (n3 <= n2) {
                this.fSelections.setEveryNItems(n3 - 1, this.fNumRows, this.fNumCols, 1);
                ++n3;
            }
            this.addSelBounds(1, n, this.fNumCols, n2 - n + 1);
            this.processGridEvent(new GridEvent(this, 1010, 0, 0, n));
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl2 && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    public void selectRange(Point point, Point point2, boolean bl, boolean bl2) {
        if (this.fSelections.getItemCount() > 0) {
            int n;
            Point point3 = new Point(point.x, point.y);
            Point point4 = new Point(point2.x, point2.y);
            BitSet bitSet = null;
            if (bl2 && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            if (point3.x == 0) {
                point3.x = point4.x;
            } else if (point3.x > point4.x) {
                n = point3.x;
                point3.x = point4.x;
                point4.x = n;
            }
            if (point3.y == 0) {
                point3.y = point4.y;
            } else if (point3.y > point4.y) {
                n = point3.y;
                point3.y = point4.y;
                point4.y = n;
            }
            if (!bl) {
                this.fSelections.setItemValues(0);
            }
            n = point3.x;
            while (n <= point4.x) {
                int n2 = point3.y;
                while (n2 <= point4.y) {
                    int n3 = (n - 1) * this.fNumRows + n2 - 1;
                    this.fSelections.setItemValue(n3, 1);
                    ++n2;
                }
                ++n;
            }
            this.addSelBounds(point3.x, point3.y, point4.x - point3.x + 1, point4.y - point3.y + 1);
            this.processGridEvent(new GridEvent(this, 1010, 0, point3.x, point3.y));
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl2 && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    public void selectAll(boolean bl) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = null;
            if (bl && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            this.fSelections.setItemValues(1);
            this.setSelBounds(1, 1, this.fNumCols, this.fNumRows);
            this.processGridEvent(new GridEvent(this, 1010, 0, 1, 1));
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    public void deselectCell(int n, int n2, boolean bl) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = null;
            if (bl && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            int n3 = (n - 1) * this.fNumRows + n2 - 1;
            this.fSelections.setItemValue(n3, 0);
            this.remSelBounds(n, n2);
            this.processGridEvent(new GridEvent(this, 1010, 0, 0, 0));
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    public void deselectCol(int n, boolean bl) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = null;
            if (bl && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            int n2 = (n - 1) * this.fNumRows;
            while (n2 < n * this.fNumRows) {
                this.fSelections.setItemValue(n2, 0);
                ++n2;
            }
            this.remSelBounds(n, 1, 1, this.fNumRows);
            this.processGridEvent(new GridEvent(this, 1010, 0, 0, 0));
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    public void deselectRow(int n, boolean bl) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = null;
            if (bl && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            this.fSelections.setEveryNItems(n - 1, this.fNumRows, this.fNumCols, 0);
            this.remSelBounds(1, n, this.fNumCols, 1);
            this.processGridEvent(new GridEvent(this, 1010, 0, 0, 0));
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    public void deselectAll(boolean bl) {
        this.deselectAll(bl, true);
    }

    public void setRowHeight(int n, int n2, boolean bl, boolean bl2) {
        int n3 = 0;
        if (n2 < 0) {
            n3 = Math.max(this.fGridAttributes.getHeight() + this.fCellInset.y * 2, this.fHeaderAttributes.getHeight() + this.fCellInset.y * 2);
        } else if (n2 >= 0) {
            n3 = n2;
        }
        if (n <= this.fNumRows) {
            int n4;
            if (n == 0) {
                if (n2 >= 0) {
                    this.fRowHeight = n3;
                }
                this.fDefaultRowHeight = n3;
                this.fGridHeights.setItemValues(n3);
                this.recalcGridExtent(false, true);
            } else {
                n4 = this.fGridHeights.getValue(n - 1);
                this.fGridExtent.height -= n4;
                this.fGridHeights.setItemValue(n - 1, n3);
                this.fGridExtent.height += n3;
            }
            if (bl) {
                n4 = this.redoScrollbars(this.getSize().width, this.getSize().height) ? 1 : 0;
                this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
                if (bl2 && this.isShowing()) {
                    if (n4 != 0) {
                        this.repaint();
                    } else {
                        this.repaintGrid();
                    }
                }
            }
        }
    }

    private void doSetColWidth(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        if (n <= this.fNumCols && (n3 = this.fGridWidths.getValue(n - 1)) != n2) {
            this.fGridExtent.width -= n3;
            this.fGridWidths.setItemValue(n - 1, n2);
            this.fGridExtent.width += n2;
            if ((this.fFlags & 0x800000) != 0 && bl3) {
                this.autoResizeRows(bl2);
            }
            if (bl) {
                boolean bl4 = this.redoScrollbars(this.getSize().width, this.getSize().height);
                this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
                if (bl2 && this.isShowing()) {
                    if (bl4) {
                        this.repaint();
                    } else {
                        this.repaintGrid();
                    }
                }
            }
        }
    }

    public void setMinColWidth(int n, int n2) {
        if (this.getMinColWidth(n) != n2) {
            this.fMinColWidths.setItemValue(n - 1, n2);
            if (this.getColWidth(n) < n2) {
                this.setColWidth(n, n2, true, this.isShowing());
            }
        }
    }

    public void setColWidth(int n, int n2, boolean bl, boolean bl2) {
        int n3 = this.getColWidth(n);
        if ((this.fFlags & 0x400) != 0 && !this.fInAdjustColWidths && n < this.getNumCols()) {
            if (this.fColResizeMode == 1) {
                this.doSetColWidth(n + 1, this.getColWidth(n + 1) - (n2 - n3), false, false, false);
            } else if (this.fColResizeMode == 2) {
                this.doSetColWidth(this.getNumCols(), this.getColWidth(this.getNumCols()) - (n2 - n3), false, false, false);
            } else if (this.fColResizeMode == 3) {
                int n4 = n2 - n3;
                int n5 = 1;
                while (n5 <= this.getNumCols()) {
                    if (n5 != n) {
                        int n6 = 0;
                        n6 = n5 == this.getNumCols() || n == this.getNumCols() && n5 == this.getNumCols() - 1 ? n4 : Math.round((float)(n2 - n3) * ((Float)this.fColRatios.elementAt(n5 - 1)).floatValue());
                        this.doSetColWidth(n5, this.getColWidth(n5) - n6, false, false, false);
                        n4 -= n6;
                    }
                    ++n5;
                }
            }
            this.doSetColWidth(n, n2, bl, bl2, true);
            this.recalcColRatios();
        } else {
            this.doSetColWidth(n, n2, bl, bl2, true);
        }
    }

    public void setColWidths(int[] nArray, boolean bl, boolean bl2) {
        int n;
        if (nArray != null) {
            if (this.fNumCols < nArray.length) {
                this.setNumCols(nArray.length, false);
            }
            n = 1;
            while (n <= this.fNumCols) {
                if (n <= nArray.length) {
                    this.doSetColWidth(n, nArray[n - 1], false, false, false);
                } else {
                    this.doSetColWidth(n, 100, false, false, false);
                }
                ++n;
            }
        }
        if ((this.fFlags & 0x800000) != 0) {
            this.autoResizeRows(false, false);
        }
        n = 0;
        if (bl) {
            n = this.redoScrollbars(this.getSize().width, this.getSize().height) ? 1 : 0;
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        }
        if (bl2 && this.isShowing()) {
            if (n != 0) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void setColWidths(String string, boolean bl, boolean bl2) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            if (this.fNumCols < stringTokenizer.countTokens()) {
                this.setNumCols(stringTokenizer.countTokens(), false);
            }
            int n = 1;
            while (n <= this.fNumCols) {
                if (stringTokenizer.hasMoreTokens()) {
                    this.doSetColWidth(n, Integer.parseInt(stringTokenizer.nextToken()), false, false, false);
                } else {
                    this.doSetColWidth(n, 100, false, false, false);
                }
                ++n;
            }
        }
        if ((this.fFlags & 0x800000) != 0) {
            this.autoResizeRows(false, false);
        }
        boolean bl3 = false;
        if (bl) {
            bl3 = this.redoScrollbars(this.getSize().width, this.getSize().height);
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        }
        if (bl2 && this.isShowing()) {
            if (bl3) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void setColWidths(String string) {
        this.setColWidths(string, true, this.isShowing());
    }

    public String getColWidths() {
        String string = "";
        if (this.fNumCols > 0) {
            string = String.valueOf(string) + this.getColWidth(1);
            int n = 2;
            while (n <= this.fNumCols) {
                string = String.valueOf(string) + "," + this.getColWidth(n);
                ++n;
            }
        }
        return string;
    }

    public void setMinColWidths(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            int n = 3;
            int n2 = 1;
            while (n2 <= this.fNumCols) {
                if (stringTokenizer.hasMoreTokens()) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    this.setMinColWidth(n2, n);
                } else {
                    this.setMinColWidth(n2, 3);
                }
                ++n2;
            }
        }
    }

    public String getMinColWidths() {
        String string = "";
        if (this.fNumCols > 0) {
            string = String.valueOf(string) + this.getMinColWidth(1);
            int n = 2;
            while (n <= this.fNumCols) {
                string = String.valueOf(string) + "," + this.getMinColWidth(n);
                ++n;
            }
        }
        return string;
    }

    public void setColHeaderHeight(int n, boolean bl) {
        if (n >= 0) {
            this.fAutoColHeaderHeight = false;
            this.fColHeaderHeight = n;
        } else if (n < 0) {
            this.fAutoColHeaderHeight = true;
            this.fColHeaderHeight = this.fHeaderAttributes.getHeight() + this.fCellInset.y * 2 + 1;
        }
        boolean bl2 = this.redoScrollbars(this.getSize().width, this.getSize().height);
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        if (bl && this.isShowing()) {
            if (bl2) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void setColHeaderHeight(int n) {
        this.setColHeaderHeight(n, this.isShowing());
    }

    public int getColHeaderHeight() {
        return this.fColHeaderHeight;
    }

    public void setRowHeaderWidth(int n, boolean bl) {
        this.fRowHeaderWidth = n;
        boolean bl2 = this.redoScrollbars(this.getSize().width, this.getSize().height);
        this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        if (bl && this.isShowing()) {
            if (bl2) {
                this.repaint();
            } else {
                this.repaintGrid();
            }
        }
    }

    public void setRowHeaderWidth(int n) {
        this.setRowHeaderWidth(n, this.isShowing());
    }

    public int getRowHeaderWidth() {
        return this.fRowHeaderWidth;
    }

    public void setGridAttributes(GridAttributes gridAttributes, boolean bl) {
        if (gridAttributes.getTextColor() != null) {
            this.fGridAttributes.setTextColor(gridAttributes.getTextColor());
        }
        if (gridAttributes.getBackColor() != null) {
            this.fGridAttributes.setBackColor(gridAttributes.getBackColor());
        }
        if (gridAttributes.getFont() != null) {
            this.fGridAttributes.setFont(gridAttributes.getFont());
        }
        if (gridAttributes.getJustification() != 0) {
            this.fGridAttributes.setJustification(gridAttributes.getJustification());
        }
        if (gridAttributes.getCellType() != 0) {
            this.fGridAttributes.setCellType(gridAttributes.getCellType());
        }
        if (this.fNumRows > 0) {
            if ((this.fFlags & 0x800000) != 0) {
                this.autoResizeRows(false);
            } else {
                this.setRowHeight(0, this.fRowHeight, true, false);
            }
        }
        if (bl && this.isShowing()) {
            this.repaintGrid();
        }
    }

    public void setGridAttributes(GridAttributes gridAttributes) {
        this.setGridAttributes(gridAttributes, this.isShowing());
    }

    public void setHeaderAttributes(GridAttributes gridAttributes, boolean bl) {
        if (gridAttributes.getTextColor() != null) {
            this.fHeaderAttributes.setTextColor(gridAttributes.getTextColor());
        }
        if (gridAttributes.getBackColor() != null) {
            this.fHeaderAttributes.setBackColor(gridAttributes.getBackColor());
        }
        if (gridAttributes.getFont() != null) {
            this.fHeaderAttributes.setFont(gridAttributes.getFont());
        }
        if (gridAttributes.getJustification() != 0) {
            this.fHeaderAttributes.setJustification(gridAttributes.getJustification());
        }
        if (gridAttributes.getCellType() != 0) {
            this.fHeaderAttributes.setCellType(gridAttributes.getCellType());
        }
        if (this.fNumRows > 0) {
            this.setRowHeight(0, this.fRowHeight, true, false);
        }
        this.setColHeaderHeight(this.fAutoColHeaderHeight ? -1 : this.fColHeaderHeight, false);
        if (bl && this.isShowing()) {
            this.repaintGrid();
        }
    }

    public void setHeaderAttributes(GridAttributes gridAttributes) {
        this.setHeaderAttributes(gridAttributes, this.isShowing());
    }

    public void setCellAttributes(int n, int n2, GridAttributes gridAttributes, boolean bl) {
        this.fCellAttributes.set(n, n2, gridAttributes != null ? gridAttributes : null);
        if ((this.fFlags & 0x800000) != 0) {
            this.autoResizeRows(false);
        }
        if (bl && this.isShowing()) {
            this.repaint();
        }
    }

    public void setColAttributes(int n, GridAttributes gridAttributes, boolean bl) {
        this.fCellAttributes.set(n, 0, gridAttributes != null ? gridAttributes : null);
        if ((this.fFlags & 0x800000) != 0) {
            this.autoResizeRows(false);
        }
        if (bl && this.isShowing()) {
            this.repaintGrid();
        }
    }

    public void setColAttributes(int n, GridAttributes gridAttributes) {
        this.setColAttributes(n, gridAttributes, this.isShowing());
    }

    public void setRowAttributes(int n, GridAttributes gridAttributes, boolean bl) {
        this.fCellAttributes.set(0, n, gridAttributes != null ? gridAttributes : null);
        if ((this.fFlags & 0x800000) != 0) {
            this.autoResizeRow(n, false);
        }
        if (bl && this.isShowing()) {
            this.repaintGrid();
        }
    }

    public void setRowAttributes(int n, GridAttributes gridAttributes) {
        this.setRowAttributes(n, gridAttributes, this.isShowing());
    }

    public void setLineColor(Color color, boolean bl) {
        this.fLineColor = color;
        if (bl && this.isShowing()) {
            this.repaintGrid();
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && keyEvent.getID() == 401) {
            this.doKeyPressed(keyEvent);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            int n = mouseEvent.getID();
            switch (n) {
                case 501: {
                    this.doMousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.doMouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    this.doMouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    this.doMouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    this.doMouseEntered(mouseEvent);
                    break;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        int n = mouseEvent.getID();
        if (!mouseEvent.isConsumed()) {
            switch (n) {
                case 503: {
                    this.doMouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    this.doMouseDragged(mouseEvent);
                    break;
                }
            }
        }
    }

    public void doMouseClicked(MouseEvent mouseEvent) {
    }

    public void doMousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.requestFocus();
        this.doMouseDown(mouseEvent);
        if (mouseEvent.getClickCount() > 1 && this.getVisRect(this.hasColHeader(), this.hasRowHeader()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            Point point;
            if (this.fEditCell != null && !(point = this.xyToCell(mouseEvent.getX(), mouseEvent.getY())).equals(this.fEditCell) && !this.endEdit(true)) {
                return;
            }
            this.handleDoubleClick(mouseEvent, this.xToCol(mouseEvent.getX()), this.yToRow(mouseEvent.getY()));
        }
    }

    public void doMouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.doMouseRelease(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
    }

    public void doMouseEntered(MouseEvent mouseEvent) {
    }

    public void doMouseExited(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.fCursor = this.getDefaultCursor();
        this.getFrame().setCursor(this.fCursor);
    }

    public void doMouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.doMouseDrag(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
    }

    public void doMouseMoved(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.doSetCursor(mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (this.fEditCell == null || keyEvent.isControlDown()) break;
                this.endEdit(true);
                keyEvent.consume();
                this.requestFocus();
                break;
            }
            case 27: {
                if (this.fEditCell == null) break;
                this.endEdit(false);
                keyEvent.consume();
                this.requestFocus();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void doKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                switch (keyEvent.getKeyCode()) {
                    case 36: {
                        if (this.fVSB == null) break;
                        this.fVSB.setValue(this.fVSB.getMinimum());
                        break;
                    }
                    case 35: {
                        if (this.fVSB == null) break;
                        this.fVSB.setValue(this.fVSB.getMaximum());
                        break;
                    }
                    case 33: {
                        if (this.fVSB == null) break;
                        this.fVSB.setValue(this.fVSB.getValue() - this.fVSB.getBlockIncrement());
                        break;
                    }
                    case 34: {
                        if (this.fVSB == null) break;
                        this.fVSB.setValue(this.fVSB.getValue() + this.fVSB.getBlockIncrement());
                        break;
                    }
                }
                this.doVScroll();
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.doKeySelect(keyEvent);
                break;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
        if (this.fGridAttributes != null) {
            this.fGridAttributes.fComponent = this;
            this.fGridAttributes.fFontMetrics = this.fGridAttributes.fFont != null ? this.getFontMetrics(this.fGridAttributes.fFont) : null;
        }
        if (this.fHeaderAttributes != null) {
            this.fHeaderAttributes.fComponent = this;
            this.fHeaderAttributes.fFontMetrics = this.fHeaderAttributes.fFont != null ? this.getFontMetrics(this.fHeaderAttributes.fFont) : null;
        }
        this.fVSB = this.fVScrollbar == null ? new GridSB(1) : this.fVScrollbar;
        this.fHSB = this.fHScrollbar == null ? new GridSB(0) : this.fHScrollbar;
    }

    private final GridAttributes cellAttributes(int n, int n2) {
        if (this.fCellAttributes.size() > 0) {
            return (GridAttributes)this.fCellAttributes.get(n, n2);
        }
        return null;
    }

    private void clearSelBounds() {
        this.fSelBounds.setBounds(0, 0, 0, 0);
    }

    private void setSelBounds(int n, int n2, int n3, int n4) {
        this.fSelBounds.setBounds(n, n2, n3, n4);
    }

    private void addSelBounds(int n, int n2, int n3, int n4) {
        if (this.fSelBounds.x == 0 && this.fSelBounds.y == 0 && this.fSelBounds.width == 0 && this.fSelBounds.height == 0) {
            this.fSelBounds.setBounds(n, n2, n3, n4);
        } else {
            this.fSelBounds = this.fSelBounds.union(new Rectangle(n, n2, n3, n4));
        }
    }

    private void addSelBounds(int n, int n2) {
        if (this.fSelBounds.x == 0 && this.fSelBounds.y == 0 && this.fSelBounds.width == 0 && this.fSelBounds.height == 0) {
            this.fSelBounds.setBounds(n, n2, 1, 1);
        } else {
            this.fSelBounds = this.fSelBounds.union(new Rectangle(n, n2, 1, 1));
        }
    }

    private Rectangle recalcSelBounds(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        if (rectangle == null) {
            rectangle = this.fSelBounds;
        }
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.x + rectangle.width - 1;
        int n8 = rectangle.y + rectangle.height - 1;
        int n9 = n5;
        while (n9 <= n7) {
            n4 = 0;
            n3 = n6;
            while (n3 <= n8) {
                if (this.isCellSelected(n9, n3)) {
                    n4 = 1;
                    break;
                }
                ++n3;
            }
            if (n4 != 0) break;
            ++n5;
            ++n9;
        }
        n4 = n7;
        while (n4 >= n5) {
            n3 = 0;
            n2 = n6;
            while (n2 <= n8) {
                if (this.isCellSelected(n4, n2)) {
                    n3 = 1;
                    break;
                }
                ++n2;
            }
            if (n3 != 0) break;
            --n7;
            --n4;
        }
        n3 = n6;
        while (n3 <= n8) {
            n2 = 0;
            n = n5;
            while (n <= n7) {
                if (this.isCellSelected(n, n3)) {
                    n2 = 1;
                    break;
                }
                ++n;
            }
            if (n2 != 0) break;
            ++n6;
            ++n3;
        }
        n2 = n8;
        while (n2 >= n6) {
            n = 0;
            int n10 = n5;
            while (n10 <= n7) {
                if (this.isCellSelected(n10, n2)) {
                    n = 1;
                    break;
                }
                ++n10;
            }
            if (n != 0) break;
            --n8;
            --n2;
        }
        if (n5 > n7 || n6 > n8) {
            return new Rectangle();
        }
        return new Rectangle(n5, n6, n7 - n5 + 1, n8 - n6 + 1);
    }

    private void remSelBounds(int n, int n2) {
        if (this.fSelBounds.contains(n, n2)) {
            if (this.fSelBounds.x == n && this.fSelBounds.y == n2 && this.fSelBounds.width == 1 && this.fSelBounds.height == 1) {
                this.fSelBounds.setBounds(0, 0, 0, 0);
            } else {
                this.fSelBounds = this.recalcSelBounds(null);
            }
        }
    }

    private void remSelBounds(int n, int n2, int n3, int n4) {
        if (this.fSelBounds.contains(n, n2)) {
            if (this.fSelBounds.x == n && this.fSelBounds.y == n2 && this.fSelBounds.width == n3 && this.fSelBounds.height == n4) {
                this.fSelBounds.setBounds(0, 0, 0, 0);
            } else {
                this.fSelBounds = this.recalcSelBounds(null);
            }
        }
    }

    private void addHScrollbar() {
        if (this.fHScrollbar == null && this.fHScrollbarDisplayPolicy != 2) {
            this.fHScrollbar = new Scrollbar(0);
            this.add(this.fHScrollbar);
            this.fHScrollbar.addAdjustmentListener(this);
        }
    }

    private void removeHScrollbar() {
        if (this.fHScrollbar != null) {
            this.fHScrollbar.removeAdjustmentListener(this);
            this.remove(this.fHScrollbar);
            this.fHScrollbar = null;
        }
    }

    private void addVScrollbar() {
        if (this.fVScrollbar == null && this.fVScrollbarDisplayPolicy != 2) {
            this.fVScrollbar = new Scrollbar(1);
            this.add(this.fVScrollbar);
            this.fVScrollbar.addAdjustmentListener(this);
        }
    }

    private void removeVScrollbar() {
        if (this.fVScrollbar != null) {
            this.fVScrollbar.removeAdjustmentListener(this);
            this.remove(this.fVScrollbar);
            this.fVScrollbar = null;
        }
    }

    private synchronized void updateRect(Graphics graphics, Rectangle rectangle) {
        if (this.fGridRect.width > 0 && this.fGridRect.height > 0) {
            Rectangle rectangle2 = new Rectangle(this.fGridRect.x - 1, this.fGridRect.y - 1, this.fGridRect.width + 1, this.fGridRect.height + 1);
            if (this.fOffscreen == null || this.fGridRect.x + this.fGridRect.width != this.fOffscreen.getWidth(this) || this.fGridRect.y + this.fGridRect.height != this.fOffscreen.getHeight(this)) {
                boolean bl = fVersion.compareTo("1.2") >= 0;
                this.fOffscreen = this.createImage(this.fGridRect.x + this.fGridRect.width, this.fGridRect.y + this.fGridRect.height);
                Graphics graphics2 = this.fOffscreen.getGraphics();
                this.doPaint(graphics2, rectangle2);
                graphics2.dispose();
                graphics2 = null;
                if (bl) {
                    this.fOffscreen2 = this.createImage(this.fGridRect.x + this.fGridRect.width, this.fGridRect.y + this.fGridRect.height);
                }
            } else {
                Graphics graphics3 = this.fOffscreen.getGraphics();
                this.doPaint(graphics3, rectangle);
                graphics3.dispose();
                graphics3 = null;
            }
            graphics.setClip(this.fGridRect.x, this.fGridRect.y, this.fGridRect.width, this.fGridRect.height);
            graphics.drawImage(this.fOffscreen, this.fInset, this.fInset, null);
        }
    }

    private final synchronized void prepareOffScreen(Rectangle rectangle, Rectangle rectangle2, Point point) {
        Graphics graphics;
        boolean bl;
        boolean bl2 = bl = fVersion.compareTo("1.2") >= 0;
        if (this.fOffscreen == null || this.fGridRect.x + this.fGridRect.width != this.fOffscreen.getWidth(this) || this.fGridRect.y + this.fGridRect.height != this.fOffscreen.getHeight(this)) {
            this.fOffscreen = this.createImage(this.fGridRect.x + this.fGridRect.width, this.fGridRect.y + this.fGridRect.height);
            graphics = this.fOffscreen.getGraphics();
            this.doPaint(graphics, rectangle);
            graphics.dispose();
            graphics = null;
            if (bl) {
                this.fOffscreen2 = this.createImage(this.fGridRect.x + this.fGridRect.width, this.fGridRect.y + this.fGridRect.height);
            }
        }
        if (point != null) {
            graphics = bl && rectangle2 != null ? this.fOffscreen2.getGraphics() : this.fOffscreen.getGraphics();
            if (rectangle2 != null) {
                if (bl) {
                    graphics.drawImage(this.fOffscreen, 0, 0, null);
                    graphics.drawImage(this.fOffscreen, rectangle2.x + point.x, rectangle2.y + point.y, rectangle2.x + rectangle2.width + point.x, rectangle2.y + rectangle2.height + point.y, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, null);
                } else {
                    graphics.copyArea(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, point.x, point.y);
                }
            }
            this.doPaint(graphics, rectangle);
            graphics.dispose();
            graphics = null;
            if (bl && rectangle2 != null) {
                Image image = this.fOffscreen;
                this.fOffscreen = this.fOffscreen2;
                this.fOffscreen2 = image;
            }
        }
    }

    private final void scrollCellVisible(Point point, boolean bl) {
        if (bl && this.fHSB != null) {
            if (this.fHScrollAmount > 0) {
                Rectangle rectangle = this.getVisRect(false, false);
                Rectangle rectangle2 = this.getColHeaderRect(point.x);
                if (rectangle2.x + rectangle2.width > this.fScrollOffset.x + rectangle.x + rectangle.width) {
                    if (rectangle.width - rectangle2.width > this.fHScrollAmount) {
                        this.fHSB.setValue(rectangle2.x + rectangle2.width - rectangle.width);
                    } else {
                        this.fHSB.setValue(rectangle2.x - rectangle.x);
                    }
                } else if (rectangle2.x < this.fScrollOffset.x + rectangle.x) {
                    this.fHSB.setValue(rectangle2.x - rectangle.x);
                }
                this.doHScroll();
            } else if (point.x - 1 <= this.fHSB.getValue()) {
                this.fHSB.setValue(point.x - 1);
                this.doHScroll();
            } else {
                int n;
                Rectangle rectangle = this.getVisRect(false, false);
                int n2 = this.xToCol(rectangle.x);
                int n3 = point.x;
                if (n3 == 0) {
                    n3 = this.fNumCols;
                }
                if ((n = this.getColWidths(n2, n3 - n2 + 1) - rectangle.width) > 0) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n) {
                        n5 += this.getColWidths(n2 + n4, 1);
                        ++n4;
                    }
                    this.fHSB.setValue(this.fHSB.getValue() + n4);
                    this.doHScroll();
                }
            }
        } else if (!bl && this.fVSB != null) {
            if (this.fVScrollAmount > 0) {
                Rectangle rectangle = this.getVisRect(false, false);
                Rectangle rectangle3 = this.getRowHeaderRect(point.y);
                if (rectangle3.y + rectangle3.height > this.fScrollOffset.y + rectangle.y + rectangle.height) {
                    if (rectangle.height - rectangle3.height > this.fVScrollAmount) {
                        this.fVSB.setValue(rectangle3.y + rectangle3.height - (rectangle.y + rectangle.height));
                    } else {
                        this.fVSB.setValue(rectangle3.y - rectangle.y);
                    }
                } else if (rectangle3.y < this.fScrollOffset.y + rectangle.y) {
                    this.fVSB.setValue(rectangle3.y - rectangle.y);
                }
                this.doVScroll();
            } else {
                if (point.y - 1 <= this.fVSB.getValue()) {
                    this.fVSB.setValue(point.y - 1);
                } else if (this.fPartialRow && point.y > this.fVSB.getValue() + this.fVSB.getBlockIncrement()) {
                    this.fVSB.setValue(point.y - this.fVSB.getBlockIncrement());
                } else if (point.y - 1 > this.fVSB.getValue() + this.fVSB.getBlockIncrement()) {
                    this.fVSB.setValue(point.y - 1 - this.fVSB.getBlockIncrement());
                }
                this.doVScroll();
            }
        }
    }

    private final boolean isCellVisible(Point point) {
        Rectangle rectangle = this.getVisRect(false, false);
        int n = this.yToRow(rectangle.y);
        int n2 = this.yToRow(rectangle.y + rectangle.height);
        if (n2 == 0) {
            n2 = this.fNumRows;
        }
        int n3 = this.xToCol(rectangle.x);
        int n4 = this.xToCol(rectangle.x + rectangle.width);
        if (n4 == 0) {
            n4 = this.fNumCols;
        }
        if (point.x >= n3 && point.x <= n4 && point.y >= n && point.y <= n2) {
            return (point.y != n2 || !this.fPartialRow) && (point.x != n4 || !this.fPartialCol);
        }
        return false;
    }

    private final boolean isColVisible(int n) {
        Rectangle rectangle = this.getVisRect(false, false);
        Rectangle rectangle2 = this.getColHeaderRect(n);
        if (rectangle2.x + rectangle2.width > this.fScrollOffset.x + rectangle.width) {
            return false;
        }
        return rectangle2.x >= this.fScrollOffset.x + rectangle.x;
    }

    private final void drawColResizer(int n, int n2) {
        Rectangle rectangle = this.getVisRect(true, false);
        rectangle.x = n + this.fOffset;
        rectangle.width = 2;
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.gray);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setPaintMode();
        graphics.dispose();
        graphics = null;
    }

    private final void drawRowResizer(int n, int n2) {
        Rectangle rectangle = this.getVisRect(false, true);
        rectangle.y = n2 + this.fOffset;
        rectangle.height = 2;
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.gray);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setPaintMode();
        graphics.dispose();
        graphics = null;
    }

    private final synchronized int calcRowHeight(int n) {
        int n2 = this.fDefaultRowHeight;
        String string = null;
        GridAttributes gridAttributes = null;
        if (n == 0) {
            gridAttributes = this.getColHeaderAttributes(0);
            int n3 = 1;
            while (n3 <= this.getNumCols()) {
                string = this.getColHeaderText(n3);
                if (!string.equals("") && (gridAttributes.getJustification() & 0x800) != 0) {
                    int n4 = GridUtils.getNumLines(gridAttributes.getFontMetrics(), string, this.getColWidth(n3) - this.fCellInset.x * 2);
                    n2 = Math.max(n2, n4 * this.fDefaultRowHeight - (n4 - 1) * (this.fCellInset.y * 2));
                }
                ++n3;
            }
        } else {
            int n5;
            string = this.getRowHeaderText(n);
            gridAttributes = this.getRowHeaderAttributes(n);
            if (!string.equals("") && (gridAttributes.getJustification() & 0x800) != 0) {
                n5 = GridUtils.getNumLines(gridAttributes.getFontMetrics(), string, this.getRowHeaderWidth() - this.fCellInset.x * 2);
                n2 = Math.max(n2, n5 * this.fDefaultRowHeight - (n5 - 1) * (this.fCellInset.y * 2));
            }
            n5 = 1;
            while (n5 <= this.getNumCols()) {
                string = this.getCellText(n5, n);
                gridAttributes = this.getCellAttributes(n5, n);
                if (!string.equals("") && (gridAttributes.getJustification() & 0x800) != 0) {
                    int n6 = GridUtils.getNumLines(gridAttributes.getFontMetrics(), string, this.getColWidth(n5) - this.fCellInset.x * 2);
                    n2 = Math.max(n2, n6 * this.fDefaultRowHeight - (n6 - 1) * (this.fCellInset.y * 2));
                }
                ++n5;
            }
        }
        return n2;
    }

    private boolean doMouseDown(MouseEvent mouseEvent) {
        int n = this.getRowHeaderWidth() + (this.fGridExtent.width - this.fScrollOffset.x) + 3;
        int n2 = this.getColHeaderHeight() + (this.fGridExtent.height - this.fScrollOffset.y) + 3;
        if (mouseEvent.getX() > n || mouseEvent.getY() > n2) {
            return false;
        }
        Rectangle rectangle = this.fGridRect;
        Rectangle rectangle2 = this.getColHeaderRect();
        rectangle2.width = this.getSize().width;
        if (this.getResizeRowHeaders()) {
            rectangle2.x -= 3;
            rectangle2.width += 3;
        }
        Rectangle rectangle3 = this.getRowHeaderRect();
        rectangle3.height = this.getSize().height;
        if (this.getResizeColHeaders()) {
            rectangle3.y -= 3;
            rectangle3.height += 3;
        }
        if (rectangle2.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.fEditCell != null) {
                this.endEdit(this.validate(this.getEditorText(), this.fEditCell));
            }
            if (this.getResizeColHeaders() && mouseEvent.getY() >= rectangle2.y + rectangle2.height - 3 && mouseEvent.getY() <= rectangle2.y + rectangle2.height) {
                this.fResizingHeader = 2;
                this.fOffset = rectangle2.y + rectangle2.height - mouseEvent.getY();
                this.drawRowResizer(mouseEvent.getX(), mouseEvent.getY());
                this.fOldPoint.x = mouseEvent.getX();
                this.fOldPoint.y = mouseEvent.getY();
                return true;
            }
            int n3 = this.getColEdge(mouseEvent.getX(), mouseEvent.getY());
            if (n3 > 0 && this.canResizeCol(n3)) {
                this.fResizingColumn = n3;
                Rectangle rectangle4 = this.getColHeaderRect(n3);
                int n4 = 0;
                if (this.fHSB != null && (n4 = -this.fScrollOffset.x) != 0) {
                    rectangle4.translate(n4, 0);
                }
                this.fOffset = rectangle4.x + rectangle4.width - mouseEvent.getX();
                this.drawColResizer(mouseEvent.getX(), mouseEvent.getY());
                this.fOldPoint.x = mouseEvent.getX();
                this.fOldPoint.y = mouseEvent.getY();
                return true;
            }
            if (this.getResizeRowHeaders() && n3 == 0) {
                this.fResizingHeader = 1;
                this.fOffset = rectangle3.x + rectangle3.width - mouseEvent.getX();
                this.drawColResizer(mouseEvent.getX(), mouseEvent.getY());
                this.fOldPoint.x = mouseEvent.getX();
                this.fOldPoint.y = mouseEvent.getY();
                return true;
            }
        } else if (rectangle3.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.fEditCell != null) {
                this.endEdit(this.validate(this.getEditorText(), this.fEditCell));
            }
            if (this.getResizeRowHeaders() && mouseEvent.getX() >= rectangle3.x + rectangle3.width - 3 && mouseEvent.getX() <= rectangle3.x + rectangle3.width) {
                this.fResizingHeader = 1;
                this.fOffset = rectangle3.x + rectangle3.width - mouseEvent.getX();
                this.drawColResizer(mouseEvent.getX(), mouseEvent.getY());
                this.fOldPoint.x = mouseEvent.getX();
                this.fOldPoint.y = mouseEvent.getY();
                return true;
            }
            int n5 = this.getRowEdge(mouseEvent.getX(), mouseEvent.getY());
            if (n5 > 0 && this.canResizeRow()) {
                this.fResizingRow = n5;
                Rectangle rectangle5 = this.getRowHeaderRect(n5);
                int n6 = 0;
                if (this.fVSB != null) {
                    n6 = -this.fScrollOffset.y;
                }
                if (n6 != 0) {
                    rectangle5.translate(0, n6);
                }
                this.fOffset = rectangle5.y + rectangle5.height - mouseEvent.getY();
                this.drawRowResizer(mouseEvent.getX(), mouseEvent.getY());
                this.fOldPoint.x = mouseEvent.getX();
                this.fOldPoint.y = mouseEvent.getY();
                return true;
            }
            if (this.getResizeColHeaders() && n5 == 0) {
                this.fResizingHeader = 2;
                this.fOffset = rectangle2.y + rectangle2.height - mouseEvent.getY();
                this.drawRowResizer(mouseEvent.getX(), mouseEvent.getY());
                this.fOldPoint.x = mouseEvent.getX();
                this.fOldPoint.y = mouseEvent.getY();
                return true;
            }
        }
        if (this.getVisRect(this.hasColHeader(), this.hasRowHeader()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            return this.handleMouseDown(mouseEvent);
        }
        return false;
    }

    private Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    public void doSetCursor(MouseEvent mouseEvent) {
        Cursor cursor = this.getDefaultCursor();
        Rectangle rectangle = this.getColHeaderRect();
        int n = 0;
        if (this.fHSB != null) {
            n = -this.fScrollOffset.x;
        }
        rectangle.width = Math.min(this.getSize().width - rectangle.x, rectangle.width + n + 3);
        if (this.getResizeColHeaders()) {
            rectangle.height += 3;
        }
        Rectangle rectangle2 = this.getRowHeaderRect();
        int n2 = 0;
        if (this.fVSB != null) {
            n2 = -this.fScrollOffset.y;
        }
        rectangle2.height = Math.min(this.getSize().height - rectangle2.y, rectangle2.height + n2 + 3);
        if (this.getResizeRowHeaders()) {
            rectangle2.width += 3;
        }
        if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.getResizeColHeaders() && mouseEvent.getY() >= rectangle.y + rectangle.height - 5 && mouseEvent.getY() <= rectangle.y + rectangle.height) {
                cursor = Cursor.getPredefinedCursor(9);
            } else {
                int n3 = this.getColEdge(mouseEvent.getX(), mouseEvent.getY());
                if (n3 > 0 && this.canResizeCol(n3) || this.getResizeRowHeaders() && n3 == 0 && mouseEvent.getX() <= rectangle2.x + rectangle2.width) {
                    cursor = Cursor.getPredefinedCursor(11);
                }
            }
        } else if (rectangle2.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.getResizeRowHeaders() && mouseEvent.getX() >= rectangle2.x + rectangle2.width - 5 && mouseEvent.getX() <= rectangle2.x + rectangle2.width) {
                cursor = Cursor.getPredefinedCursor(11);
            } else {
                int n4 = this.getRowEdge(mouseEvent.getX(), mouseEvent.getY());
                if (n4 > 0 && this.canResizeRow() || this.getResizeColHeaders() && n4 == 0 && mouseEvent.getY() <= rectangle.y + rectangle.height) {
                    cursor = Cursor.getPredefinedCursor(9);
                }
            }
        }
        if (cursor != this.fCursor) {
            this.getFrame().setCursor(cursor);
            this.fCursor = cursor;
        }
    }

    private boolean doMouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.fEditCell != null) {
            return true;
        }
        if (this.fResizingColumn != 0) {
            Rectangle rectangle = this.getColHeaderRect(this.fResizingColumn);
            int n3 = 0;
            if (this.fHSB != null && (n3 = -this.fScrollOffset.x) != 0) {
                rectangle.translate(n3, 0);
            }
            if ((n = Math.min(Math.max(n, rectangle.x - this.fOffset), this.getSize().width - 2)) != this.fOldPoint.x) {
                this.drawColResizer(this.fOldPoint.x, this.fOldPoint.y);
                this.drawColResizer(n, n2);
                this.fOldPoint.x = n;
                this.fOldPoint.y = n2;
            }
            return true;
        }
        if (this.fResizingRow != 0) {
            Rectangle rectangle = this.getRowHeaderRect(this.fResizingRow);
            int n4 = 0;
            if (this.fVSB != null) {
                n4 = -this.fScrollOffset.y;
            }
            if (n4 != 0) {
                rectangle.translate(0, n4);
            }
            if ((n2 = Math.min(Math.max(n2, rectangle.y - this.fOffset), this.getSize().height - 2)) != this.fOldPoint.y) {
                this.drawRowResizer(this.fOldPoint.x, this.fOldPoint.y);
                this.drawRowResizer(n, n2);
                this.fOldPoint.x = n;
                this.fOldPoint.y = n2;
            }
            return true;
        }
        if (this.fResizingHeader != 0) {
            if (this.fResizingHeader == 2) {
                if ((n2 = Math.min(Math.max(n2, this.fOffset), this.getSize().height - 2)) != this.fOldPoint.y) {
                    this.drawRowResizer(this.fOldPoint.x, this.fOldPoint.y);
                    this.drawRowResizer(n, n2);
                    this.fOldPoint.x = n;
                    this.fOldPoint.y = n2;
                }
            } else if (this.fResizingHeader == 1 && (n = Math.min(Math.max(n, this.fOffset), this.getSize().width - 2)) != this.fOldPoint.x) {
                this.drawColResizer(this.fOldPoint.x, this.fOldPoint.y);
                this.drawColResizer(n, n2);
                this.fOldPoint.x = n;
                this.fOldPoint.y = n2;
            }
            return true;
        }
        if (this.canDragSelect() && this.getVisRect(this.hasColHeader(), this.hasRowHeader()).contains(n, n2) && this.fAnchorCell != null && (this.fEditCell == null || this.fAnchorCell.x != this.fEditCell.x || this.fAnchorCell.y != this.fEditCell.y)) {
            if (!(this.fAnchorCell.x == 0 && this.fAnchorCell.y == 0 || this.fEditCell == null || this.fAnchorCell.x == this.fEditCell.x && this.fAnchorCell.y == this.fEditCell.y)) {
                return this.endEdit(true);
            }
            if (this.fAnchorCell.x != 0 && this.fAnchorCell.y != 0) {
                Point point = this.xyToCell(n, n2);
                if (point.x != 0 && point.y != 0) {
                    if (this.multipleSelection()) {
                        if (this.fNextCell == null || !this.fNextCell.equals(point)) {
                            this.fNextCell = point;
                            Point point2 = new Point(this.fAnchorCell.x > this.fNextCell.x ? this.fNextCell.x : this.fAnchorCell.x, this.fAnchorCell.y > this.fNextCell.y ? this.fNextCell.y : this.fAnchorCell.y);
                            Point point3 = new Point(this.fAnchorCell.x > this.fNextCell.x ? this.fAnchorCell.x : this.fNextCell.x, this.fAnchorCell.y > this.fNextCell.y ? this.fAnchorCell.y : this.fNextCell.y);
                            this.selectRange(point2, point3, mouseEvent.isControlDown(), true);
                        }
                    } else if (!this.fAnchorCell.equals(point)) {
                        this.deselectCell(this.fAnchorCell.x, this.fAnchorCell.y, true);
                        this.selectCell(point.x, point.y, true);
                        this.fAnchorCell = point;
                    }
                    return true;
                }
                return false;
            }
            if (this.fAnchorCell.y != 0 && this.fAnchorCell.x == 0) {
                Point point = new Point(0, this.yToRow(n2));
                if (point.y != 0) {
                    if (this.multipleSelection()) {
                        if (this.fNextCell == null || this.fNextCell.y != point.y) {
                            this.fNextCell = point;
                            Point point4 = new Point(1, this.fAnchorCell.y > this.fNextCell.y ? this.fNextCell.y : this.fAnchorCell.y);
                            Point point5 = new Point(this.fNumCols, this.fAnchorCell.y > this.fNextCell.y ? this.fAnchorCell.y : this.fNextCell.y);
                            this.selectRows(point4.y, point5.y, mouseEvent.isControlDown(), true);
                        }
                    } else if (this.fAnchorCell.y != point.y) {
                        this.deselectRow(this.fAnchorCell.y, true);
                        this.selectRow(point.y, true);
                        this.fAnchorCell = point;
                    }
                    return true;
                }
                return false;
            }
            if (this.fAnchorCell.x != 0 && this.fAnchorCell.y == 0) {
                Point point = new Point(this.xToCol(n), 0);
                if (point.x != 0) {
                    if (this.multipleSelection()) {
                        if (this.fNextCell == null || this.fNextCell.x != point.x) {
                            this.fNextCell = point;
                            Point point6 = new Point(this.fAnchorCell.x > this.fNextCell.x ? this.fNextCell.x : this.fAnchorCell.x, 1);
                            Point point7 = new Point(this.fAnchorCell.x > this.fNextCell.x ? this.fAnchorCell.x : this.fNextCell.x, this.fNumRows);
                            this.selectCols(point6.x, point7.x, mouseEvent.isControlDown(), true);
                        }
                    } else if (this.fAnchorCell.x != point.x) {
                        this.deselectCol(this.fAnchorCell.x, true);
                        this.selectCol(point.x, true);
                        this.fAnchorCell = point;
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private boolean doMouseRelease(MouseEvent mouseEvent, int n, int n2) {
        int n3;
        if (this.fResizingColumn != 0) {
            Rectangle rectangle = this.getColHeaderRect(this.fResizingColumn);
            int n4 = 0;
            if (this.fHSB != null && (n4 = -this.fScrollOffset.x) != 0) {
                rectangle.translate(n4, 0);
            }
            this.drawColResizer(this.fOldPoint.x, this.fOldPoint.y);
            int n5 = Math.max(n + this.fOffset - rectangle.x, this.fMinColWidths.getValue(this.fResizingColumn - 1));
            int n6 = this.getFirstSelectedCol();
            int n7 = this.getLastSelectedCol();
            if (this.isResizeMultiple() && !this.isAutoResizeColumns() && n6 != 0 && this.fResizingColumn >= n6 && this.fResizingColumn <= n7) {
                int n8 = n6;
                while (n8 <= n7) {
                    if (this.isColSelected(n8)) {
                        this.setColWidth(n8, n5, false, false);
                        this.processGridEvent(new GridEvent(this, 1008, mouseEvent.getModifiers(), n8, 0));
                    }
                    ++n8;
                }
                boolean bl = this.redoScrollbars(this.getSize().width, this.getSize().height);
                this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
                this.repaint();
            } else {
                this.setColWidth(this.fResizingColumn, n5, true, true);
                this.processGridEvent(new GridEvent(this, 1008, mouseEvent.getModifiers(), this.fResizingColumn, 0));
            }
            this.fResizingColumn = 0;
            this.fOffset = 0;
            this.doSetCursor(mouseEvent);
            return true;
        }
        if (this.fResizingRow != 0) {
            Rectangle rectangle = this.getRowHeaderRect(this.fResizingRow);
            int n9 = 0;
            if (this.fVSB != null) {
                n9 = -this.fScrollOffset.y;
            }
            if (n9 != 0) {
                rectangle.translate(0, n9);
            }
            this.drawRowResizer(this.fOldPoint.x, this.fOldPoint.y);
            int n10 = Math.max(n2 + this.fOffset - rectangle.y, this.fDefaultRowHeight);
            int n11 = this.getFirstSelectedRow();
            int n12 = this.getLastSelectedRow();
            if (this.isResizeMultiple() && n11 != 0 && this.fResizingRow >= n11 && this.fResizingRow <= n12) {
                int n13 = n11;
                while (n13 <= n12) {
                    if (this.isRowSelected(n13)) {
                        this.setRowHeight(n13, n10, false, false);
                        this.processGridEvent(new GridEvent(this, 1007, mouseEvent.getModifiers(), 0, n13));
                    }
                    ++n13;
                }
                boolean bl = this.redoScrollbars(this.getSize().width, this.getSize().height);
                this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
                this.repaint();
            } else {
                this.setRowHeight(this.fResizingRow, n10, true, true);
                this.processGridEvent(new GridEvent(this, 1007, mouseEvent.getModifiers(), 0, this.fResizingRow));
            }
            this.fResizingRow = 0;
            this.fOffset = 0;
            this.doSetCursor(mouseEvent);
            return true;
        }
        if (this.fResizingHeader != 0) {
            if (this.fResizingHeader == 1) {
                this.drawColResizer(this.fOldPoint.x, this.fOldPoint.y);
                int n14 = Math.max(n + this.fOffset, 10);
                this.setRowHeaderWidth(n14);
            } else if (this.fResizingHeader == 2) {
                this.drawRowResizer(this.fOldPoint.x, this.fOldPoint.y);
                int n15 = Math.max(n2 + this.fOffset, 10);
                this.setColHeaderHeight(n15);
            }
            this.fResizingHeader = 0;
            this.fOffset = 0;
            this.doSetCursor(mouseEvent);
            return true;
        }
        int n16 = this.xToCol(mouseEvent.getX());
        int n17 = this.yToRow(mouseEvent.getY());
        if (n16 > 0 && n17 > 0 && this.isSingleClickEditing() && this.getFirstSelectedCell().equals(this.getLastSelectedCell()) && this.canEditCell(n16, n17) && this.handleEditClick(mouseEvent, n16, n17)) {
            return true;
        }
        if (n16 > 0 && n17 == 0 && this.getSortEnable(n16) && this.fLastClickedCell.x == n16 && this.fLastClickedCell.y == n17) {
            n3 = 1;
            if (n16 == this.fSortColumn) {
                n3 = this.fSortOrder * -1;
            }
            this.setSortColumn(n16, true, n3);
            this.processGridEvent(new GridEvent(this, 1009, mouseEvent.getModifiers(), n16, 0));
        }
        n3 = this.getRowHeaderWidth() + this.fGridExtent.width;
        int n18 = this.getColHeaderHeight() + this.fGridExtent.height;
        if (mouseEvent.getX() + this.fScrollOffset.x <= n3 && mouseEvent.getY() + this.fScrollOffset.y <= n18) {
            this.processGridEvent(new GridEvent(this, 1003, mouseEvent.getModifiers(), n16, n17));
        } else if (this.fNextCell != null) {
            this.processGridEvent(new GridEvent(this, 1003, mouseEvent.getModifiers(), this.fNextCell.x, this.fNextCell.y));
        }
        if (this.fAnchorCell != null) {
            this.fAnchorCell = null;
            this.fNextCell = null;
        }
        return false;
    }

    public boolean handleMouseDown(MouseEvent mouseEvent) {
        int n = this.xToCol(mouseEvent.getX());
        int n2 = this.yToRow(mouseEvent.getY());
        if ((this.fFlags & 7) != 0 && this.fNumRows > 0 && this.fNumCols > 0) {
            BitSet bitSet = null;
            if ((this.fFlags & 1) != 0 && this.getVisRect(false, false).contains(mouseEvent.getX(), mouseEvent.getY()) && n2 != 0 && n != 0) {
                if (this.fEditCell != null) {
                    if (n != this.fEditCell.x || n2 != this.fEditCell.y) {
                        if (!this.endEdit(true)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                bitSet = this.getVisSelection();
                if (!this.multipleSelection() || !mouseEvent.isControlDown()) {
                    this.deselectAll(false, false);
                }
                this.fAnchorCell = this.multipleSelection() && mouseEvent.isShiftDown() && this.fLastClickedCell.x != 0 && this.fLastClickedCell.y != 0 ? new Point(this.fLastClickedCell.x, this.fLastClickedCell.y) : new Point(n, n2);
                this.doSelectCell(n, n2, mouseEvent);
            } else if ((this.fFlags & 2) != 0 && (this.getRowHeaderRect().contains(mouseEvent.getX(), mouseEvent.getY()) || this.getVisRect(false, false).contains(mouseEvent.getX(), mouseEvent.getY())) && n2 != 0) {
                if (this.fEditCell != null) {
                    if (n != this.fEditCell.x || n2 != this.fEditCell.y) {
                        if (!this.endEdit(true)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                bitSet = this.getVisSelection();
                if (!this.multipleSelection() || !mouseEvent.isControlDown()) {
                    this.deselectAll(false, false);
                }
                this.fAnchorCell = this.multipleSelection() && mouseEvent.isShiftDown() && this.fLastClickedCell.x != 0 && this.fLastClickedCell.y != 0 ? new Point(0, this.fLastClickedCell.y) : new Point(0, n2);
                this.doSelectRow(n2, mouseEvent);
            } else if (n != 0 && (this.getColHeaderRect().contains(mouseEvent.getX(), mouseEvent.getY()) || (this.fFlags & 4) != 0 && this.getVisRect(false, false).contains(mouseEvent.getX(), mouseEvent.getY()))) {
                if (this.fEditCell != null) {
                    if (n != this.fEditCell.x || n2 != this.fEditCell.y) {
                        if (!this.endEdit(true)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                bitSet = this.getVisSelection();
                if (this.getSortEnable(n)) {
                    this.fLastClickedCell.x = n;
                    this.fLastClickedCell.y = 0;
                } else if ((this.fFlags & 4) != 0) {
                    if (!this.multipleSelection() || !mouseEvent.isControlDown()) {
                        this.deselectAll(false, false);
                    }
                    this.fAnchorCell = this.multipleSelection() && mouseEvent.isShiftDown() && this.fLastClickedCell.x != 0 && this.fLastClickedCell.y != 0 ? new Point(this.fLastClickedCell.x, 0) : new Point(n, 0);
                    this.doSelectCol(n, mouseEvent);
                }
            } else if (this.multipleSelection() && this.getSelectAllRect().contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (this.fEditCell != null && !this.endEdit(true)) {
                    return false;
                }
                bitSet = this.getVisSelection();
                this.selectAll(false);
            }
            if (bitSet == null) {
                bitSet = this.getVisSelection();
            }
            BitSet bitSet2 = this.getVisSelection();
            BitSet bitSet3 = (BitSet)bitSet.clone();
            bitSet3.xor(bitSet2);
            this.highlightSelection(bitSet3);
        }
        if (n > 0 || n2 > 0) {
            this.handleCellClick(mouseEvent, n, n2);
        }
        return true;
    }

    private String getDisplayText(String string) {
        int n = string.indexOf(60);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private String getURLText(String string) {
        int n = string.indexOf(60);
        int n2 = string.indexOf(62);
        if (n >= 0 && n2 > n) {
            return string.substring(n + 1, n2);
        }
        return string;
    }

    protected int getVScrollbarValue() {
        return this.fVSB.getValue();
    }

    protected void vScrollTo(int n) {
        this.fVSB.setValue(n);
        this.doVScroll();
    }

    protected int getHScrollbarValue() {
        return this.fHSB.getValue();
    }

    protected void hScrollTo(int n) {
        this.fHSB.setValue(n);
        this.doHScroll();
    }

    protected void doVScroll() {
        Point point = new Point(0, 0);
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisRect(false, true);
        Rectangle rectangle2 = new Rectangle(rectangle);
        Rectangle rectangle3 = new Rectangle(rectangle);
        int n = 0;
        n = this.fVScrollAmount > 0 ? this.fVSB.getValue() : Math.min(this.getRowHeights(1, this.fVSB.getValue()), this.fGridExtent.height - rectangle.height + 1);
        if (this.fScrollOffset.y != n) {
            point.y = this.fScrollOffset.y - n;
            if (point.y < 1) {
                rectangle2.y -= point.y;
                rectangle2.height += point.y;
                rectangle3.y = rectangle.y + rectangle2.height;
                rectangle3.height = rectangle.height - rectangle2.height;
            } else {
                rectangle2.height -= point.y;
                rectangle3.height = rectangle.height - rectangle2.height;
            }
            this.fScrollOffset.y = n;
        }
        if (point.y != 0) {
            int n2;
            int n3 = n2 = point.y < 0 ? -point.y : point.y;
            if (n2 <= rectangle.height) {
                this.prepareOffScreen(rectangle3, rectangle2, point);
                graphics.setClip(this.fGridRect.x, this.fGridRect.y, this.fGridRect.width, this.fGridRect.height);
                graphics.drawImage(this.fOffscreen, this.fInset, this.fInset, null);
            } else {
                this.prepareOffScreen(rectangle, null, point);
                graphics.setClip(this.fGridRect.x, this.fGridRect.y, this.fGridRect.width, this.fGridRect.height);
                graphics.drawImage(this.fOffscreen, this.fInset, this.fInset, null);
            }
            if (this.fVScrollAmount == 0) {
                this.setVPageIncrement();
            }
        }
        graphics.dispose();
        graphics = null;
    }

    protected void doHScroll() {
        Point point = new Point(0, 0);
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisRect(true, false);
        Rectangle rectangle2 = new Rectangle(rectangle);
        Rectangle rectangle3 = new Rectangle(rectangle);
        int n = 0;
        n = this.fHScrollAmount > 0 ? this.fHSB.getValue() : Math.min(this.getColWidths(1, this.fHSB.getValue()), this.fGridExtent.width - rectangle.width + 1);
        if (this.fScrollOffset.x != n) {
            point.x = this.fScrollOffset.x - n;
            if (point.x < 1) {
                rectangle2.x -= point.x;
                rectangle2.width += point.x;
                rectangle3.x = rectangle.x + rectangle2.width;
                rectangle3.width = rectangle.width - rectangle2.width;
            } else {
                rectangle2.width -= point.x;
                rectangle3.width = rectangle.width - rectangle2.width;
            }
            this.fScrollOffset.x = n;
        }
        if (point.x != 0) {
            int n2;
            int n3 = n2 = point.x < 0 ? -point.x : point.x;
            if (n2 <= rectangle.width) {
                this.prepareOffScreen(rectangle3, rectangle2, point);
                graphics.setClip(this.fGridRect.x, this.fGridRect.y, this.fGridRect.width, this.fGridRect.height);
                graphics.drawImage(this.fOffscreen, this.fInset, this.fInset, null);
            } else {
                this.prepareOffScreen(rectangle, null, point);
                graphics.setClip(this.fGridRect.x, this.fGridRect.y, this.fGridRect.width, this.fGridRect.height);
                graphics.drawImage(this.fOffscreen, this.fInset, this.fInset, null);
            }
        }
        graphics.dispose();
        graphics = null;
    }

    private final void doScroll(AdjustmentEvent adjustmentEvent) {
        if (this.fEditCell != null) {
            this.endEdit(this.validate(this.getEditorText(), this.fEditCell));
        }
        if (this.fOffscreen == null) {
            this.prepareOffScreen(this.fGridRect, null, null);
        }
        if (this.fVScrollbar != null && adjustmentEvent.getAdjustable() == this.fVScrollbar) {
            if (this.fVScrollAmount > 0 && this.fScrollOffset.y != this.fVScrollbar.getValue() || this.fVScrollAmount == 0 && this.fScrollOffset.y != this.getRowHeights(1, this.fVScrollbar.getValue())) {
                this.doVScroll();
            }
        } else if (this.fHScrollbar != null && adjustmentEvent.getAdjustable() == this.fHScrollbar && (this.fHScrollAmount > 0 && this.fScrollOffset.x != this.fHScrollbar.getValue() || this.fHScrollAmount == 0 && this.fScrollOffset.x != this.getColWidths(1, this.fHScrollbar.getValue()))) {
            this.doHScroll();
        }
    }

    private Rectangle getGridRect(boolean bl, boolean bl2) {
        Rectangle rectangle = new Rectangle(1, 1, this.fGridExtent.width + this.fRowHeaderWidth, this.fGridExtent.height + this.fColHeaderHeight);
        if (!bl && this.hasColHeader()) {
            rectangle.y += this.fColHeaderHeight;
            rectangle.height -= this.fColHeaderHeight;
        }
        if (!bl2 && this.hasRowHeader()) {
            rectangle.x += this.fRowHeaderWidth;
            rectangle.width -= this.fRowHeaderWidth;
        }
        return rectangle;
    }

    private Rectangle getVisRect(boolean bl, boolean bl2) {
        Rectangle rectangle = new Rectangle(this.fGridRect.x - this.fInset, this.fGridRect.y - this.fInset, this.fGridRect.width + this.fInset, this.fGridRect.height + this.fInset);
        rectangle.width = Math.min(rectangle.width, this.fRowHeaderWidth + this.fGridExtent.width);
        rectangle.height = Math.min(rectangle.height, this.fColHeaderHeight + this.fGridExtent.height);
        if (!bl && this.hasColHeader()) {
            rectangle.y += this.fColHeaderHeight;
            rectangle.height -= this.fColHeaderHeight;
        }
        if (!bl2 && this.hasRowHeader()) {
            rectangle.x += this.fRowHeaderWidth;
            rectangle.width -= this.fRowHeaderWidth;
        }
        return rectangle;
    }

    private final void drawColHeader(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = this.getColHeaderRect();
        int n = 0;
        if (this.fHSB != null) {
            n = -this.fScrollOffset.x;
        }
        if (n != 0) {
            rectangle2.translate(n, 0);
        }
        int n2 = this.xToCol(rectangle.x);
        int n3 = this.xToCol(rectangle.x + rectangle.width);
        if (n3 == 0) {
            n3 = this.fNumCols;
        }
        Rectangle rectangle3 = null;
        Object var8_8 = null;
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = 0;
            if (n4 > 1) {
                n5 = this.getColWidths(1, n4 - 1);
            }
            if ((rectangle3 = new Rectangle(rectangle2.x + n5, rectangle2.y, this.getColWidths(n4, 1), this.fColHeaderHeight)).intersects(rectangle)) {
                this.drawHeaderCol(graphics, n4, rectangle3);
            }
            ++n4;
        }
    }

    private final void drawRowHeader(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = this.getRowHeaderRect();
        Dimension dimension = this.getSize();
        int n = this.yToRow(rectangle.y);
        int n2 = this.yToRow(rectangle.y + rectangle.height);
        if (n2 == 0) {
            n2 = this.fNumRows;
        }
        Rectangle rectangle3 = null;
        int n3 = n;
        while (n3 <= n2) {
            rectangle3 = new Rectangle(rectangle2.x, rectangle2.y + this.getRowHeights(1, n3 - 1), rectangle2.width, this.getRowHeight(n3));
            if (this.fVSB != null) {
                rectangle3.translate(0, -this.fScrollOffset.y);
            }
            if (rectangle3.intersects(rectangle)) {
                this.drawHeaderRow(graphics, n3, rectangle3);
            }
            ++n3;
        }
    }

    private int getSpanColumns(int n, int n2) {
        GridAttributes gridAttributes = this.getCellAttributes(n, n2);
        int n3 = 1;
        if ((gridAttributes.getJustification() & 0x200) != 0) {
            int n4 = gridAttributes.getFontMetrics().stringWidth(this.getCellText(n, n2));
            while (n4 > this.getColWidths(n, n3) - this.fCellInset.x * 2 && n + n3 - 1 < this.fNumCols && this.getCellText(n + n3, n2).equals("")) {
                ++n3;
            }
        }
        return n3;
    }

    private void drawRow(Graphics graphics, int n, Rectangle rectangle) {
        Color color = graphics.getColor();
        int n2 = 0;
        if (this.fHSB != null) {
            n2 = -this.fScrollOffset.x;
        }
        Rectangle rectangle2 = this.getRowRect(n);
        if (this.fVSB != null) {
            rectangle2.translate(0, -this.fScrollOffset.y);
        }
        int n3 = this.xToCol(rectangle.x);
        int n4 = this.xToCol(rectangle.x + rectangle.width);
        if (n4 == 0) {
            n4 = this.fNumCols;
        }
        Rectangle rectangle3 = null;
        int n5 = n3;
        while (n5 <= n4) {
            Rectangle rectangle4 = new Rectangle(rectangle2.x + this.getColWidths(1, n5 - 1), rectangle2.y, this.getColWidths(n5, 1), this.getRowHeight(n));
            if (n2 != 0) {
                rectangle4.translate(n2, 0);
            }
            if ((rectangle3 = new Rectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height)).intersects(rectangle)) {
                int n6;
                int n7 = n5;
                if (n7 > 1 && this.getCellText(n7, n).equals("")) {
                    while (--n7 > 1 && this.getCellText(n7, n).equals("")) {
                    }
                }
                if ((n6 = this.getSpanColumns(n7, n)) > 1 & n7 + n6 - 1 >= n5) {
                    Rectangle rectangle5 = new Rectangle(rectangle2.x + this.getColWidths(1, n7 - 1), rectangle2.y, this.getColWidths(n7, n6), this.getRowHeight(n));
                    if (n2 != 0) {
                        rectangle5.translate(n2, 0);
                    }
                    this.drawSpannedCell(graphics, new Point(n5, n), n7, n6, rectangle3, rectangle5, this.isCellSelected(n5, n));
                } else {
                    this.drawCell(graphics, new Point(n5, n), rectangle3, this.isCellSelected(n5, n));
                }
            }
            ++n5;
        }
        graphics.setColor(color);
    }

    private void doPaint(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2;
        Shape shape = graphics.getClip();
        GridAttributes gridAttributes = this.getGridAttributes();
        gridAttributes.beginDrawing(graphics);
        graphics.setColor(gridAttributes.getBackColor());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        gridAttributes.endDrawing(graphics);
        if (this.hasRowHeader() && this.hasColHeader() && (rectangle2 = new Rectangle(1, 1, this.fRowHeaderWidth, this.fColHeaderHeight)).intersects(rectangle)) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.drawIntersection(graphics, rectangle2);
        }
        if (this.hasColHeader() && this.fNumCols > 0 && (rectangle2 = this.getColHeaderRect()).intersects(rectangle)) {
            rectangle2 = rectangle2.intersection(rectangle);
            graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.drawColHeader(graphics, rectangle2);
        }
        if (this.hasRowHeader() && this.fNumRows > 0 && (rectangle2 = this.getRowHeaderRect()).intersects(rectangle)) {
            rectangle2 = rectangle2.intersection(rectangle);
            graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.drawRowHeader(graphics, rectangle2);
        }
        if (this.fNumRows > 0 && this.fNumCols > 0) {
            rectangle2 = this.getVisRect(false, false);
            rectangle2 = rectangle2.intersection(rectangle);
            graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            int n = this.yToRow(rectangle2.y);
            int n2 = this.yToRow(rectangle2.y + rectangle2.height);
            if (n2 == 0) {
                n2 = this.fNumRows;
            }
            int n3 = n;
            while (n3 <= n2) {
                Rectangle rectangle4 = this.getRowRect(n3);
                if (this.fVSB != null) {
                    rectangle4.translate(0, -this.fScrollOffset.y);
                }
                if (rectangle4.intersects(rectangle2)) {
                    this.drawRow(graphics, n3, rectangle2);
                }
                ++n3;
            }
        }
        graphics.setClip(shape);
    }

    private void deselectAll(boolean bl, boolean bl2) {
        if (this.fSelections.getItemCount() > 0) {
            BitSet bitSet = null;
            if (bl && this.isShowing()) {
                bitSet = this.getVisSelection();
            }
            this.fSelections.setItemValues(0);
            this.clearSelBounds();
            if (bl2) {
                this.processGridEvent(new GridEvent(this, 1010, 0, 0, 0));
            }
            BitSet bitSet2 = null;
            BitSet bitSet3 = null;
            if (bl && this.isShowing()) {
                bitSet2 = this.getVisSelection();
                bitSet3 = (BitSet)bitSet.clone();
                bitSet3.xor(bitSet2);
                this.highlightSelection(bitSet3);
            }
        }
    }

    private final void highlightSelection(BitSet bitSet) {
        Object object;
        Rectangle rectangle = this.getVisRect(false, false);
        int n = 0;
        if (this.fHSB != null) {
            n = -this.fScrollOffset.x;
        }
        if (this.fOffscreen == null) {
            this.prepareOffScreen(this.fGridRect, null, null);
        }
        Graphics graphics = this.fOffscreen.getGraphics();
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n2 = this.yToRow(rectangle.y);
        int n3 = this.yToRow(rectangle.y + rectangle.height);
        if (n3 == 0) {
            n3 = this.fNumRows;
        }
        int n4 = this.xToCol(rectangle.x);
        int n5 = this.xToCol(rectangle.x + rectangle.width);
        if (n5 == 0) {
            n5 = this.fNumCols;
        }
        Color color = graphics.getColor();
        int n6 = n2;
        while (n6 <= n3) {
            object = this.getRowRect(n6);
            if (this.fVSB != null) {
                ((Rectangle)object).translate(0, -this.fScrollOffset.y);
            }
            Rectangle rectangle2 = null;
            int n7 = n4;
            while (n7 <= n5) {
                int n8 = (n6 - n2) * (n5 - n4 + 1) + (n7 - n4);
                if (bitSet.get(n8)) {
                    int n9;
                    Rectangle rectangle3 = new Rectangle(((Rectangle)object).x + this.getColWidths(1, n7 - 1), ((Rectangle)object).y, this.getColWidths(n7, 1), this.getRowHeight(n6));
                    if (n != 0) {
                        rectangle3.translate(n, 0);
                    }
                    rectangle2 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    int n10 = n7;
                    if (n10 > 1 && this.getCellText(n10, n6).equals("")) {
                        while (--n10 > 1 && this.getCellText(n10, n6).equals("")) {
                        }
                    }
                    if ((n9 = this.getSpanColumns(n10, n6)) > 1 & n10 + n9 - 1 >= n7) {
                        Rectangle rectangle4 = new Rectangle(((Rectangle)object).x + this.getColWidths(1, n10 - 1), ((Rectangle)object).y, this.getColWidths(n10, n9), this.getRowHeight(n6));
                        if (n != 0) {
                            rectangle4.translate(n, 0);
                        }
                        this.highlightSpannedCell(graphics, new Point(n7, n6), n10, n9, rectangle2, rectangle4, this.isCellSelected(n7, n6));
                    } else {
                        this.highlightCell(graphics, new Point(n7, n6), rectangle2, this.isCellSelected(n7, n6));
                    }
                }
                ++n7;
            }
            graphics.setColor(color);
            ++n6;
        }
        object = this.getGraphics();
        ((Graphics)object).setClip(this.fGridRect.x, this.fGridRect.y, this.fGridRect.width, this.fGridRect.height);
        ((Graphics)object).drawImage(this.fOffscreen, this.fInset, this.fInset, null);
        graphics.dispose();
        graphics = null;
        ((Graphics)object).dispose();
        object = null;
    }

    private final void adjustScrollBars(int n, int n2) {
        if (n > 0 && n2 > 0) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            Rectangle rectangle = this.getVisRect(false, false);
            if (this.fHSB != null) {
                n8 = 1;
                if (n - this.fRowHeaderWidth > this.fGridExtent.width || !this.isEnabled()) {
                    this.fHSB.setValue(0);
                    this.fHSB.setMinimum(0);
                    this.fHSB.setMaximum(0);
                    this.fHSB.setVisibleAmount(1);
                    this.fScrollOffset.x = 0;
                    n8 = 0;
                } else if (this.fHScrollAmount > 0) {
                    if (fVendor.startsWith("MICROSOFT") && fVersion.compareTo("1.1.4") < 0) {
                        this.fHSB.setValue(this.fHSB.getValue());
                        this.fHSB.setMinimum(0);
                        this.fHSB.setMaximum(this.fGridExtent.width - (n - this.fRowHeaderWidth));
                        this.fHSB.setVisibleAmount(n - this.fRowHeaderWidth);
                        n8 = this.fGridExtent.width - (n - this.fRowHeaderWidth) <= 0 ? 0 : 1;
                    } else {
                        this.fHSB.setValue(this.fHSB.getValue());
                        this.fHSB.setMinimum(0);
                        this.fHSB.setMaximum(this.fGridExtent.width);
                        this.fHSB.setVisibleAmount(n - this.fRowHeaderWidth);
                        n8 = this.fGridExtent.width <= 0 ? 0 : 1;
                    }
                    this.fScrollOffset.x = this.fHSB.getValue();
                    this.fHSB.setBlockIncrement(n - this.fRowHeaderWidth);
                    this.fHSB.setUnitIncrement(this.fHScrollAmount);
                } else {
                    n7 = 0;
                    n6 = 0;
                    n5 = this.fNumCols;
                    while (n5 > 0) {
                        if ((n6 += this.fGridWidths.getValue(n5 - 1)) > n - this.fRowHeaderWidth) break;
                        ++n7;
                        --n5;
                    }
                    if (fVendor.startsWith("MICROSOFT") && fVersion.compareTo("1.1.4") < 0) {
                        this.fHSB.setValue(this.fHSB.getValue());
                        this.fHSB.setMinimum(0);
                        this.fHSB.setMaximum(this.fNumCols - n7);
                        this.fHSB.setVisibleAmount(n7);
                        n8 = this.fNumCols - n7 <= 0 ? 0 : 1;
                    } else {
                        this.fHSB.setValue(this.fHSB.getValue());
                        this.fHSB.setMinimum(0);
                        this.fHSB.setMaximum(this.fNumCols);
                        this.fHSB.setVisibleAmount(n7);
                        n8 = this.fNumCols <= 0 ? 0 : 1;
                    }
                    this.fScrollOffset.x = Math.min(this.getColWidths(1, this.fHSB.getValue()), this.fGridExtent.width - rectangle.width + 1);
                    this.setHPageIncrement();
                    this.fHSB.setUnitIncrement(1);
                }
                if (this.fHScrollbar != null) {
                    this.fHScrollbar.setEnabled(this.isEnabled() && n8 != 0);
                }
            }
            n8 = this.xToCol(rectangle.x);
            n7 = this.xToCol(rectangle.x + rectangle.width);
            if (n7 == 0) {
                n7 = this.fNumCols;
            }
            boolean bl = this.fPartialCol = rectangle.width < (n6 = this.getColWidths(n8, n7 - n8 + 1));
            if (this.fVSB != null) {
                n5 = 1;
                if (n2 - this.fColHeaderHeight > this.fGridExtent.height || !this.isEnabled()) {
                    this.fVSB.setValue(0);
                    this.fVSB.setMinimum(0);
                    this.fVSB.setMaximum(0);
                    this.fVSB.setVisibleAmount(1);
                    this.fScrollOffset.y = 0;
                    n5 = 0;
                } else {
                    n4 = 0;
                    if (this.fVScrollAmount > 0) {
                        if (fVendor.startsWith("MICROSOFT") && fVersion.compareTo("1.1.4") < 0) {
                            this.fVSB.setValue(this.fVSB.getValue());
                            this.fVSB.setMinimum(0);
                            this.fVSB.setMaximum(this.fGridExtent.height - (n2 - this.fColHeaderHeight));
                            this.fVSB.setVisibleAmount(n2 - this.fColHeaderHeight);
                            n5 = this.fGridExtent.height - (n2 - this.fColHeaderHeight) <= 0 ? 0 : 1;
                        } else {
                            this.fVSB.setValue(this.fVSB.getValue());
                            this.fVSB.setMinimum(0);
                            this.fVSB.setMaximum(this.fGridExtent.height);
                            this.fVSB.setVisibleAmount(n2 - this.fColHeaderHeight);
                            n5 = this.fGridExtent.height <= 0 ? 0 : 1;
                        }
                        this.fScrollOffset.y = this.fVSB.getValue();
                        this.fVSB.setBlockIncrement(n2 - this.fColHeaderHeight);
                        this.fVSB.setUnitIncrement(this.fVScrollAmount);
                    } else {
                        n3 = 0;
                        int n9 = 0;
                        int n10 = this.fNumRows;
                        while (n10 > 0) {
                            if ((n9 += this.fGridHeights.getValue(n10 - 1)) > n2 - this.fColHeaderHeight) break;
                            ++n3;
                            --n10;
                        }
                        if (fVendor.startsWith("MICROSOFT") && fVersion.compareTo("1.1.4") < 0) {
                            this.fVSB.setValue(this.fVSB.getValue());
                            this.fVSB.setMinimum(0);
                            this.fVSB.setMaximum(this.fNumRows - n3);
                            this.fVSB.setVisibleAmount(n3);
                            n5 = this.fNumRows - n3 <= 0 ? 0 : 1;
                        } else {
                            this.fVSB.setValue(this.fVSB.getValue());
                            this.fVSB.setMinimum(0);
                            this.fVSB.setMaximum(this.fNumRows);
                            this.fVSB.setVisibleAmount(n3);
                            n5 = this.fNumRows <= 0 ? 0 : 1;
                        }
                        this.fScrollOffset.y = Math.min(this.getRowHeights(1, this.fVSB.getValue()), this.fGridExtent.height - rectangle.height + 1);
                        this.fVSB.setUnitIncrement(1);
                        this.setVPageIncrement();
                    }
                }
                if (this.fVScrollbar != null) {
                    this.fVScrollbar.setEnabled(this.isEnabled() && n5 != 0);
                }
            }
            n5 = this.yToRow(rectangle.y);
            n4 = this.yToRow(rectangle.y + rectangle.height);
            if (n4 == 0) {
                n4 = this.fNumRows;
            }
            this.fPartialRow = rectangle.height < (n3 = this.getRowHeights(n5, n4 - n5 + 1));
        }
    }

    private void setHPageIncrement() {
        int n = 0;
        int n2 = 0;
        int n3 = this.fHSB.getValue() + 1;
        while (n3 <= this.fNumCols) {
            if ((n += this.fGridWidths.getValue(n3 - 1)) > this.fGridRect.width - this.fRowHeaderWidth) break;
            ++n2;
            ++n3;
        }
        this.fHSB.setBlockIncrement(Math.max(n2, 1));
    }

    private void setVPageIncrement() {
        int n = 0;
        int n2 = 0;
        int n3 = this.fVSB.getValue() + 1;
        while (n3 <= this.fNumRows) {
            if ((n += this.fGridHeights.getValue(n3 - 1)) > this.fGridRect.height - this.fColHeaderHeight) break;
            ++n2;
            ++n3;
        }
        this.fVSB.setBlockIncrement(Math.max(n2, 1));
    }

    private void recalcColRatios() {
        if (this.fColRatios == null) {
            this.fColRatios = new Vector(0, 5);
        }
        this.fColRatios.setSize(this.getNumCols());
        int n = 0;
        int n2 = 1;
        while (n2 <= this.getNumCols()) {
            n += this.getColWidth(n2);
            ++n2;
        }
        int n3 = 1;
        while (n3 <= this.getNumCols()) {
            this.fColRatios.setElementAt(new Float((float)this.getColWidth(n3) / (float)n), n3 - 1);
            ++n3;
        }
    }

    private boolean redoScrollbars(int n, int n2) {
        boolean bl = false;
        boolean bl2 = this.fNeedHScrollbar;
        boolean bl3 = this.fNeedVScrollbar;
        Rectangle rectangle = this.fGridRect;
        this.fNeedHScrollbar = false;
        this.fNeedVScrollbar = false;
        this.fVScrollbarWidth = 0;
        this.fHScrollbarHeight = 0;
        if (this.fVScrollbarDisplayPolicy != 2 && (this.fGridExtent.height > n2 - this.fColHeaderHeight - this.fHScrollbarHeight - 2 || this.fVScrollbarDisplayPolicy == 0 || this.isAutoResizeColumns()) && n - this.fRowHeaderWidth - 2 >= 16 && n2 >= 32) {
            this.fNeedVScrollbar = true;
            if (this.fVScrollbar == null) {
                this.addVScrollbar();
                this.fVSB = this.fVScrollbar;
            }
            this.fVScrollbarWidth = 16;
        }
        int n3 = this.getColWidths(1, this.fNumCols);
        if (this.fHScrollbarDisplayPolicy != 2 && (n3 > n - this.fRowHeaderWidth - this.fVScrollbarWidth - 2 || this.fHScrollbarDisplayPolicy == 0) && n2 - this.fColHeaderHeight - 2 >= 16 && n >= 32) {
            this.fNeedHScrollbar = true;
            if (this.fHScrollbar == null) {
                this.addHScrollbar();
                this.fHSB = this.fHScrollbar;
            }
            this.fHScrollbarHeight = 16;
        }
        if (this.fNeedHScrollbar && !this.fNeedVScrollbar && this.fVScrollbarDisplayPolicy != 2 && (this.fGridExtent.height > n2 - this.fColHeaderHeight - this.fHScrollbarHeight - 2 || this.fVScrollbarDisplayPolicy == 0) && n - this.fRowHeaderWidth - 2 >= 16 && n2 - this.fHScrollbarHeight >= 32) {
            this.fNeedVScrollbar = true;
            if (this.fVScrollbar == null) {
                this.addVScrollbar();
                this.fVSB = this.fVScrollbar;
            }
            this.fVScrollbarWidth = 16;
        }
        if (this.fHScrollbar != null && (bl2 != this.fNeedHScrollbar || this.fHScrollbarDisplayPolicy == 2)) {
            if (this.fNeedHScrollbar) {
                this.fHScrollbar.setVisible(true);
            } else if (this.fHScrollbar != null) {
                this.removeHScrollbar();
                this.fHSB = null;
                this.fScrollOffset.x = 0;
            }
            bl = true;
        }
        if (this.fVScrollbar != null && (bl3 != this.fNeedVScrollbar || this.fVScrollbarDisplayPolicy == 2)) {
            if (this.fNeedVScrollbar) {
                this.fVScrollbar.setVisible(this.fNeedVScrollbar);
            } else if (this.fVScrollbar != null) {
                this.removeVScrollbar();
                this.fVSB = null;
                this.fScrollOffset.y = 0;
            }
            bl = true;
        }
        if (this.fHScrollbar != null) {
            this.fHScrollbar.setBounds(1 + this.fInset - (this.fVScrollbar != null && fPlatform == 1 ? 1 : 0), Math.max(0, n2 - this.fHScrollbarHeight - this.fInset), Math.max(0, n - this.fVScrollbarWidth - 2 * this.fInset - 1 + (this.fVScrollbar != null && fPlatform == 1 ? 2 : 0)), this.fHScrollbarHeight);
        }
        if (this.fVScrollbar != null) {
            this.fVScrollbar.setBounds(Math.max(0, n - this.fVScrollbarWidth - this.fInset), 1 + this.fInset - (this.fHScrollbar != null && fPlatform == 1 ? 1 : 0), this.fVScrollbarWidth, Math.max(0, n2 - this.fHScrollbarHeight - 2 * this.fInset - 1 + (this.fHScrollbar != null && fPlatform == 1 ? 2 : 0)));
        }
        this.fGridRect = new Rectangle(1 + this.fInset, 1 + this.fInset, Math.max(0, n - this.fVScrollbarWidth - 1 - 2 * this.fInset - (this.fVScrollbar == null ? 1 : 0)), Math.max(0, n2 - this.fHScrollbarHeight - 1 - 2 * this.fInset - (this.fHScrollbar == null ? 1 : 0)));
        if (this.fVSB == null && this.fVScrollbar == null) {
            this.fVSB = new GridSB(1);
        }
        if (this.fHSB == null && this.fHScrollbar == null) {
            this.fHSB = new GridSB(0);
        }
        if (!this.fGridRect.equals(rectangle)) {
            this.adjustScrollBars(this.fGridRect.width, this.fGridRect.height);
        }
        return bl;
    }

    private final GridAttributes getColAttributes(int n) {
        if (this.fCellAttributes.size() > 0) {
            return (GridAttributes)this.fCellAttributes.get(n, 0);
        }
        return null;
    }

    private final GridAttributes getRowAttributes(int n) {
        if (this.fCellAttributes.size() > 0) {
            return (GridAttributes)this.fCellAttributes.get(0, n);
        }
        return null;
    }

    private int getColEdge(int n, int n2) {
        int n3 = -1;
        Rectangle rectangle = this.getColHeaderRect(0);
        int n4 = 0;
        if (this.fHSB != null) {
            n4 = -this.fScrollOffset.x;
        }
        rectangle.width = Math.min(this.getSize().width - rectangle.x, rectangle.width + n4 + 3);
        if (rectangle.contains(n, n2)) {
            int n5 = 1;
            while (n5 <= this.fNumCols) {
                Rectangle rectangle2 = this.getColHeaderRect(n5);
                if (n5 == this.fNumCols) {
                    rectangle2.width += 3;
                }
                if (n4 != 0) {
                    rectangle2.translate(n4, 0);
                }
                if (rectangle2.contains(n, n2)) {
                    if (n <= rectangle2.x + 3) {
                        n3 = n5 - 1;
                    } else if (n5 == this.fNumCols && n >= rectangle2.x + rectangle2.width - 6 || n >= rectangle2.x + rectangle2.width - 3) {
                        n3 = n5;
                    }
                }
                ++n5;
            }
        } else if (n >= rectangle.x - 3) {
            n3 = 0;
        }
        return n3;
    }

    private int getRowEdge(int n, int n2) {
        int n3 = -1;
        Rectangle rectangle = this.getRowHeaderRect();
        int n4 = 0;
        if (this.fVSB != null) {
            n4 = -this.fScrollOffset.y;
        }
        rectangle.height = Math.min(this.getSize().height - rectangle.y, rectangle.height + n4 + 3);
        if (rectangle.contains(n, n2)) {
            int n5 = this.yToRow(n2);
            if (n5 == 0 && this.fNumRows > 0 && n2 <= this.getRowHeaderRect((int)n5).height + 3) {
                n5 = this.fNumRows;
            }
            Rectangle rectangle2 = this.getRowHeaderRect(n5);
            if (n5 == this.fNumRows) {
                rectangle2.height += 3;
            }
            if (n4 != 0) {
                rectangle2.translate(0, n4);
            }
            if (rectangle2.contains(n, n2)) {
                if (n2 <= rectangle2.y + 3) {
                    n3 = n5 - 1;
                } else if (n5 == this.fNumRows && n2 >= rectangle2.y + rectangle2.height - 6 || n2 >= rectangle2.y + rectangle2.height - 3) {
                    n3 = n5;
                }
            }
        } else if (n2 >= rectangle.y - 3) {
            n3 = 0;
        }
        return n3;
    }

    private final boolean hasRowHeader() {
        return this.fRowHeaderWidth != 0;
    }

    private final boolean hasColHeader() {
        return this.fColHeaderHeight != 0;
    }

    private final int cellToIndex(int n, int n2) {
        return (n2 - 1) * this.fNumCols + n - 1;
    }

    private boolean canResizeCol(int n) {
        return (this.fFlags & 0x10) != 0;
    }

    private boolean canResizeRow() {
        return (this.fFlags & 0x20) != 0;
    }

    private final boolean multipleSelection() {
        return (this.fFlags & 8) != 0;
    }

    private final boolean canDragSelect() {
        return (this.fFlags & 0x200000) != 0;
    }

    private boolean canEditCell(int n, int n2) {
        return this.getCellType(n, n2) == 2 || this.getCellType(n, n2) == 5;
    }

    private final int getCellType(int n, int n2) {
        GridAttributes gridAttributes = this.getCellAttributes(n, n2);
        int n3 = gridAttributes.getCellType();
        if (gridAttributes != this.getGridAttributes()) {
            gridAttributes = null;
        }
        return n3;
    }

    private final String[] getCellItems(int n, int n2) {
        GridAttributes gridAttributes = this.getCellAttributes(n, n2);
        String[] stringArray = gridAttributes.getItems();
        if (gridAttributes != this.getGridAttributes()) {
            gridAttributes = null;
        }
        return stringArray;
    }

    private boolean isURL(int n, int n2) {
        return this.getCellType(n, n2) == 3;
    }

    private boolean isMail(int n, int n2) {
        return this.getCellType(n, n2) == 4;
    }

    private Rectangle getSelectAllRect() {
        return new Rectangle(this.fGridRect.x - 1, this.fGridRect.y - 1, this.fRowHeaderWidth, this.fColHeaderHeight);
    }

    private boolean getFlag(int n) {
        return (this.fFlags & n) != 0;
    }

    private void setFlag(int n, boolean bl) {
        int n2 = this.fFlags;
        n2 = bl ? (n2 |= n) : (n2 &= ~n);
        this.fFlags = n2;
    }

    private final void doSelectCell(int n, int n2, MouseEvent mouseEvent) {
        Point point = new Point(n, n2);
        if (this.multipleSelection() && mouseEvent.isShiftDown() && this.fLastClickedCell.x != 0 && this.fLastClickedCell.y != 0) {
            this.selectRange(this.fLastClickedCell, point, true, false);
        } else if (this.multipleSelection() && mouseEvent.isControlDown()) {
            if (this.isCellSelected(point.x, point.y)) {
                this.deselectCell(point.x, point.y, false);
            } else {
                this.selectCell(point.x, point.y, false);
                this.fLastClickedCell.x = point.x;
                this.fLastClickedCell.y = point.y;
            }
        } else {
            this.selectCell(point.x, point.y, false);
            this.fLastClickedCell.x = point.x;
            this.fLastClickedCell.y = point.y;
        }
    }

    private final void doSelectCol(int n, MouseEvent mouseEvent) {
        if (this.multipleSelection() && mouseEvent.isShiftDown() && this.fLastClickedCell.x != 0 && this.fLastClickedCell.y != 0) {
            this.selectRange(new Point(this.fLastClickedCell.x, 1), new Point(n, this.fNumRows), true, false);
        } else if (this.multipleSelection() && mouseEvent.isControlDown()) {
            if (this.isColSelected(n)) {
                this.deselectCol(n, false);
            } else {
                this.selectCol(n, false);
                this.fLastClickedCell.x = n;
                this.fLastClickedCell.y = 1;
            }
        } else {
            this.selectCol(n, false);
            this.fLastClickedCell.x = n;
            this.fLastClickedCell.y = 1;
        }
    }

    private final void doSelectRow(int n, MouseEvent mouseEvent) {
        if (this.multipleSelection() && mouseEvent.isShiftDown() && this.fLastClickedCell.x != 0 && this.fLastClickedCell.y != 0) {
            this.selectRange(new Point(1, this.fLastClickedCell.y), new Point(this.fNumCols, n), true, false);
        } else if (this.multipleSelection() && mouseEvent.isControlDown()) {
            if (this.isRowSelected(n)) {
                this.deselectRow(n, false);
            } else {
                this.selectRow(n, false);
                this.fLastClickedCell.x = 1;
                this.fLastClickedCell.y = n;
            }
        } else {
            this.selectRow(n, false);
            this.fLastClickedCell.x = 1;
            this.fLastClickedCell.y = n;
        }
    }

    private final BitSet getVisSelection() {
        BitSet bitSet = null;
        if (this.fNumRows > 0) {
            Rectangle rectangle = this.getVisRect(false, false);
            int n = this.yToRow(rectangle.y);
            int n2 = this.yToRow(rectangle.y + rectangle.height);
            if (n2 == 0) {
                n2 = this.fNumRows;
            }
            int n3 = this.xToCol(rectangle.x);
            int n4 = this.xToCol(rectangle.x + rectangle.width);
            if (n4 == 0) {
                n4 = this.fNumCols;
            }
            bitSet = new BitSet((n2 - n + 1) * (n4 - n3 + 1));
            int n5 = 0;
            while (n5 < n2 - n + 1) {
                int n6 = 0;
                while (n6 < n4 - n3 + 1) {
                    if (this.isCellSelected(n6 + n3, n5 + n)) {
                        bitSet.set(n5 * (n4 - n3 + 1) + n6);
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        return bitSet;
    }

    private void doSetNumRows(int n) {
        int n2 = this.fNumRows;
        this.fNumRows = n;
        this.fGridHeights.setItemCount(n, this.fDefaultRowHeight);
        this.fCellAttributes.setNumRows(this.fNumRows);
        this.fRowTags.ensureCapacity(this.fNumRows);
        this.fRowTags.setSize(this.fNumRows);
    }

    private void doSetNumCols(int n) {
        int n2 = this.fNumCols;
        this.fNumCols = n;
        this.fGridWidths.setItemCount(n, 100);
        this.fMinColWidths.setItemCount(n, 3);
        this.fSortEnable.ensureCapacity(this.fNumCols);
        this.fSortEnable.setSize(this.fNumCols);
        if (this.fNumCols > n2) {
            int n3 = n2;
            while (n3 < this.fNumCols) {
                if (this.fSortEnable.elementAt(n3) == null) {
                    this.fSortEnable.setElementAt(new Boolean(false), n3);
                }
                ++n3;
            }
        }
        this.fCellAttributes.setNumCols(this.fNumCols);
    }

    void recalcGridExtent(boolean bl, boolean bl2) {
        if (bl2) {
            this.fGridExtent.height = this.fGridHeights.getCumItemValues();
        }
        if (bl) {
            this.fGridExtent.width = this.fGridWidths.getCumItemValues();
        }
    }

    private Rectangle getColHeaderRect(int n) {
        Rectangle rectangle = this.getColHeaderRect();
        if (n != 0) {
            rectangle.x += this.getColWidths(1, n - 1);
            rectangle.width = this.getColWidths(n, 1);
        } else {
            rectangle.width = this.getColWidths(1, this.fNumCols);
        }
        return rectangle;
    }

    private Rectangle getRowHeaderRect(int n) {
        Rectangle rectangle = this.getRowHeaderRect();
        if (n != 0) {
            rectangle.y += this.getRowHeights(1, n - 1);
            rectangle.height = this.getRowHeight(n);
        } else {
            rectangle.height = this.getRowHeights(1, this.fNumRows);
        }
        return rectangle;
    }

    private Rectangle getRowRect(int n) {
        Rectangle rectangle = this.getGridRect(false, false);
        return new Rectangle(rectangle.x, rectangle.y + this.getRowHeights(1, n - 1), rectangle.width, this.getRowHeight(n));
    }

    public void setApplet(Applet applet) {
        this.fApplet = applet;
    }

    private Applet getApplet() {
        Container container;
        Applet applet = this.fApplet;
        if (applet == null && (container = this.getParent()) != null) {
            while (!(container instanceof Applet)) {
                container = ((Component)container).getParent();
            }
            if (container instanceof Applet) {
                applet = (Applet)container;
            }
        }
        return applet;
    }

    private synchronized Frame getFrame() {
        if (this.fOurFrame != null) {
            return this.fOurFrame;
        }
        Container container = this;
        while (container != null) {
            if (container instanceof Frame) {
                this.fOurFrame = (Frame)container;
                return this.fOurFrame;
            }
            container = container.getParent();
        }
        throw new Error("Couldn't find frame ?!?");
    }
}

