/*
 * Decompiled with CFR 0.152.
 */
package CoffeeTable.Grid;

import CoffeeTable.Grid.GridPanelInterface;
import CoffeeTable.Grid.GridPrinterBase;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;

public class GridPrinter
extends GridPrinterBase {
    private PrintJob fJob = null;

    public GridPrinter(PrintJob printJob, String string) {
        this(printJob, string, null);
    }

    public GridPrinter(PrintJob printJob, String string, GridPanelInterface gridPanelInterface) {
        super(string, gridPanelInterface);
        this.fJob = printJob;
        this.fScreenRes = 72;
        this.fHeaderHeight = this.fScreenRes / 2;
        this.fFooterHeight = this.fScreenRes / 2;
        this.fPageSize = new Dimension(this.fJob.getPageDimension());
        this.fPrintArea = new Rectangle(0, 0, this.fPageSize.width - this.fScreenRes, this.fPageSize.height - this.fScreenRes);
    }

    public void print() {
        this.calcPageAreas();
        this.calcColWidths();
        this.calcRowHeights();
        this.calcPages();
        int n = 1;
        int n2 = 0;
        int n3 = 1;
        while (n3 <= this.fPages.height) {
            n2 = this.calcRowRange(n);
            int n4 = 1;
            int n5 = 0;
            int n6 = 1;
            while (n6 <= this.fPages.width) {
                n5 = this.calcColRange(n4);
                int n7 = (n3 - 1) * this.fPages.width + n6;
                if (this.fStartPage == 0 || n7 >= this.fStartPage && n7 <= this.fEndPage) {
                    Graphics graphics = this.fJob.getGraphics();
                    this.fGrid.setInGridPrinter(true);
                    this.fGrid.setPrintPageRect(new Rectangle(0, 0, this.fJob.getPageDimension().width, this.fJob.getPageDimension().height));
                    if (this.fHeaderHeight > 0) {
                        this.printHeader(graphics, n7, new Rectangle(this.fPrintArea.x, this.fPrintArea.y, this.fPrintArea.width, this.fHeaderHeight));
                    }
                    Rectangle rectangle = new Rectangle(this.fPageArea.x, this.fPageArea.y, this.fPageArea.width, this.fPageArea.height);
                    if (this.fPrintAlignment != GridPrinterBase.TOP_LEFT) {
                        int n8;
                        Point point = new Point();
                        if (this.fPrintAlignment == GridPrinterBase.CENTER || this.fPrintAlignment == GridPrinterBase.TOP_CENTER) {
                            n8 = this.getColWidths(n4, n5 - n4 + 1);
                            if (this.getPrintRowHeaders()) {
                                n8 += this.fGrid.getRowHeaderWidth();
                            }
                            point.x = (this.fPageArea.width - n8) / 2;
                        }
                        if (this.fPrintAlignment == GridPrinterBase.CENTER || this.fPrintAlignment == GridPrinterBase.CENTER_LEFT) {
                            n8 = this.getRowHeights(n, n2 - n + 1);
                            if (this.getPrintColHeaders()) {
                                n8 += this.fGrid.getColHeaderHeight();
                            }
                            point.y = (this.fPageArea.height - n8) / 2;
                        }
                        rectangle.translate(point.x, point.y);
                    }
                    this.printPage(graphics, n7, n, n2, n4, n5, rectangle);
                    if (this.fFooterHeight > 0) {
                        this.printFooter(graphics, n7, new Rectangle(this.fPrintArea.x, this.fPrintArea.y + this.fPrintArea.height - this.fFooterHeight, this.fPrintArea.width, this.fFooterHeight));
                    }
                    graphics.setClip(this.fPrintArea.x, this.fPrintArea.y, this.fPrintArea.width, this.fPrintArea.height);
                    if (this.fPrintBorder) {
                        graphics.drawRect(this.fPrintArea.x, this.fPrintArea.y, this.fPrintArea.width - 1, this.fPrintArea.height - 1);
                    }
                    this.fGrid.setPrintPageRect(null);
                    this.fGrid.setInGridPrinter(false);
                    graphics.dispose();
                }
                n4 = n5 + 1;
                ++n6;
            }
            n = n2 + 1;
            ++n3;
        }
    }
}

