/*
 * Decompiled with CFR 0.152.
 */
package CoffeeTable.Grid;

import CoffeeTable.Grid.GridAttributes;
import CoffeeTable.Grid.GridPanelInterface;
import CoffeeTable.Grid.GridUtils;
import CoffeeTable.Grid.RunVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class GridPrinterBase {
    public static int TOP_LEFT = 0;
    public static int CENTER = 1;
    public static int TOP_CENTER = 2;
    public static int CENTER_LEFT = 3;
    protected Dimension fPageSize = null;
    protected int fScreenRes = 0;
    protected GridPanelInterface fGrid = null;
    protected Rectangle fPrintArea = null;
    protected Rectangle fPageArea = null;
    protected int fStartPage = 0;
    protected int fEndPage = 0;
    protected Dimension fPages = new Dimension(1, 1);
    protected boolean fPrintBorder = false;
    protected Boolean fPrintColHeaders = null;
    protected Boolean fPrintRowHeaders = null;
    protected Boolean fPrintRowLines = null;
    protected Boolean fPrintColLines = null;
    protected int fHeaderHeight = 36;
    protected int fFooterHeight = 36;
    protected String fTitle = null;
    protected Point fStartCell;
    protected Point fEndCell;
    protected int fPrintAlignment = TOP_LEFT;
    protected boolean fAutoResizeColumns = false;
    protected Boolean fAutoResizeRows = null;
    protected Vector fGridWidths = null;
    protected RunVector fGridHeights = null;
    protected Vector fColRatios = null;

    public GridPrinterBase(String string) {
        this(string, null);
    }

    public GridPrinterBase(String string, GridPanelInterface gridPanelInterface) {
        this.fTitle = string;
        this.fGrid = gridPanelInterface;
    }

    public void setGrid(GridPanelInterface gridPanelInterface) {
        this.fGrid = gridPanelInterface;
    }

    public GridPanelInterface getGrid() {
        return this.fGrid;
    }

    public void setPrintBorder(boolean bl) {
        this.fPrintBorder = bl;
    }

    public boolean getPrintBorder() {
        return this.fPrintBorder;
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setAutoResizeColumns(boolean bl) {
        this.fAutoResizeColumns = bl;
    }

    public boolean isAutoResizeColumns() {
        return this.fAutoResizeColumns;
    }

    public void setAutoResizeRows(boolean bl) {
        this.fAutoResizeRows = new Boolean(bl);
    }

    public boolean isAutoResizeRows() {
        if (this.fAutoResizeRows != null) {
            return this.fAutoResizeRows;
        }
        return this.fGrid.isAutoResizeRows();
    }

    public void setPrintColHeaders(boolean bl) {
        this.fPrintColHeaders = new Boolean(bl);
    }

    public boolean getPrintColHeaders() {
        if (this.fGrid != null) {
            if (this.fPrintColHeaders == null) {
                return this.fGrid.getColHeaderHeight() != 0;
            }
            return this.fPrintColHeaders;
        }
        return false;
    }

    public void setPrintRowHeaders(boolean bl) {
        this.fPrintRowHeaders = new Boolean(bl);
    }

    public boolean getPrintRowHeaders() {
        if (this.fGrid != null) {
            if (this.fPrintRowHeaders == null) {
                return this.fGrid.getRowHeaderWidth() != 0;
            }
            return this.fPrintRowHeaders;
        }
        return false;
    }

    public void setPrintColLines(boolean bl) {
        this.fPrintColLines = new Boolean(bl);
    }

    public boolean getPrintColLines() {
        if (this.fGrid != null) {
            if (this.fPrintColLines == null) {
                return this.fGrid.isColLines();
            }
            return this.fPrintColLines;
        }
        return false;
    }

    public void setPrintRowLines(boolean bl) {
        this.fPrintRowLines = new Boolean(bl);
    }

    public boolean getPrintRowLines() {
        if (this.fGrid != null) {
            if (this.fPrintRowLines == null) {
                return this.fGrid.isRowLines();
            }
            return this.fPrintRowLines;
        }
        return false;
    }

    public void setPrintAlignment(int n) {
        this.fPrintAlignment = n;
    }

    public int getPrintAlignment() {
        return this.fPrintAlignment;
    }

    public void setPageHeaderHeight(int n) {
        this.fHeaderHeight = n;
    }

    public int getPageHeaderHeight() {
        return this.fHeaderHeight;
    }

    public void setPageFooterHeight(int n) {
        this.fFooterHeight = n;
    }

    public int getPageFooterHeight() {
        return this.fFooterHeight;
    }

    public void setPageRange(int n, int n2) {
        this.fStartPage = n;
        this.fEndPage = n2;
    }

    public int getNumPages() {
        int n = this.fPages.width * this.fPages.height;
        return n;
    }

    public Rectangle getPrintableArea() {
        return this.fPrintArea;
    }

    public void setPrintableArea(Rectangle rectangle) {
        this.fPrintArea = rectangle;
    }

    public void setColWidths(int[] nArray) {
        this.fGridWidths = new Vector(this.fGrid.getNumCols(), 5);
        this.fGridWidths.setSize(this.fGrid.getNumCols());
        int n = 0;
        while (n < this.fGrid.getNumCols()) {
            if (n < nArray.length) {
                this.fGridWidths.setElementAt(new Integer(nArray[n]), n);
            } else {
                this.fGridWidths.setElementAt(new Integer(this.fGrid.getColWidth(n + 1)), n);
            }
            ++n;
        }
    }

    public Rectangle getPageArea() {
        this.calcPageAreas();
        return this.fPageArea;
    }

    public int getColWidth(int n) {
        if (this.fGridWidths != null) {
            return (Integer)this.fGridWidths.elementAt(n - 1);
        }
        return this.fGrid.getColWidth(n);
    }

    public int getRowHeight(int n) {
        if (this.fGridHeights != null) {
            return this.fGridHeights.getValue(n - 1);
        }
        return this.fGrid.getRowHeight(n);
    }

    protected int getColWidths(int n, int n2) {
        if (this.fGridWidths != null) {
            int n3 = 0;
            if (n > 0 && this.fGrid.getNumCols() > 0 && n2 > 0) {
                int n4 = n;
                while (n4 <= n + n2 - 1) {
                    n3 += ((Integer)this.fGridWidths.elementAt(n4 - 1)).intValue();
                    ++n4;
                }
            }
            return n3;
        }
        return this.fGrid.getColWidths(n, n2);
    }

    protected int getRowHeights(int n, int n2) {
        if (this.fGridHeights != null) {
            int n3 = 0;
            if (n > 0 && this.fGrid.getNumRows() > 0 && n2 > 0) {
                int n4 = n;
                while (n4 <= n + n2 - 1) {
                    n3 += this.getRowHeight(n4);
                    ++n4;
                }
            }
            return n3;
        }
        return this.fGrid.getRowHeights(n, n2);
    }

    protected void calcPageAreas() {
        this.fPageArea = new Rectangle(this.fPrintArea.x + 1, this.fPrintArea.y + 1 + this.fHeaderHeight, this.fPrintArea.width - 2, this.fPrintArea.height - 2 - this.fHeaderHeight - this.fFooterHeight);
    }

    protected void calcPages() {
        int n = this.getPrintRowHeaders() && this.fGrid.getRowHeaderWidth() > 0 ? this.fGrid.getRowHeaderWidth() : 0;
        int n2 = 1;
        while (n2 <= this.fGrid.getNumCols()) {
            if (n + this.getColWidth(n2) <= this.fPageArea.width) {
                n += this.getColWidth(n2);
            } else {
                n = (this.getPrintRowHeaders() && this.fGrid.getRowHeaderWidth() > 0 ? this.fGrid.getRowHeaderWidth() : 0) + this.getColWidth(n2);
                ++this.fPages.width;
            }
            ++n2;
        }
        int n3 = this.getPrintColHeaders() && this.fGrid.getColHeaderHeight() > 0 ? this.fGrid.getColHeaderHeight() : 0;
        int n4 = 1;
        while (n4 <= this.fGrid.getNumRows()) {
            if (n3 + this.getRowHeight(n4) <= this.fPageArea.height) {
                n3 += this.getRowHeight(n4);
            } else {
                n3 = (this.getPrintColHeaders() && this.fGrid.getColHeaderHeight() > 0 ? this.fGrid.getColHeaderHeight() : 0) + this.getRowHeight(n4);
                ++this.fPages.height;
            }
            ++n4;
        }
    }

    private void recalcColRatios() {
        if (this.fColRatios == null) {
            this.fColRatios = new Vector(0, 5);
        }
        this.fColRatios.setSize(this.fGridWidths.size());
        int n = 0;
        int n2 = 1;
        while (n2 <= this.fGridWidths.size()) {
            n += ((Integer)this.fGridWidths.elementAt(n2 - 1)).intValue();
            ++n2;
        }
        int n3 = 1;
        while (n3 <= this.fGridWidths.size()) {
            this.fColRatios.setElementAt(new Float((float)this.getColWidth(n3) / (float)n), n3 - 1);
            ++n3;
        }
    }

    protected final synchronized int calcRowHeight(int n) {
        int n2 = this.fGrid.getDefaultRowHeight();
        int n3 = 1;
        while (n3 <= this.fGrid.getNumCols()) {
            String string = this.fGrid.getCellText(n3, n);
            GridAttributes gridAttributes = this.fGrid.getCellAttributes(n3, n);
            if (!string.equals("") && (gridAttributes.getJustification() & 0x800) != 0) {
                int n4 = GridUtils.getNumLines(gridAttributes.getFontMetrics(), string, this.getColWidth(n3) - this.fGrid.getCellInset().x * 2);
                n2 = Math.max(n2, n4 * this.fGrid.getDefaultRowHeight() - (n4 - 1) * (this.fGrid.getCellInset().y * 2));
            }
            ++n3;
        }
        return n2;
    }

    protected void calcColWidths() {
        int n = this.fPageArea.width;
        if (this.getPrintRowHeaders() && this.fGrid.getRowHeaderWidth() > 0) {
            n -= this.fGrid.getRowHeaderWidth();
        }
        if (this.isAutoResizeColumns()) {
            int n2;
            if (this.fGridWidths == null) {
                this.fGridWidths = new Vector(this.fGrid.getNumCols(), 5);
                this.fGridWidths.setSize(this.fGrid.getNumCols());
                n2 = 1;
                while (n2 <= this.fGrid.getNumCols()) {
                    this.fGridWidths.setElementAt(new Integer(this.fGrid.getColWidth(n2)), n2 - 1);
                    ++n2;
                }
            }
            this.recalcColRatios();
            if (this.fColRatios.size() == this.fGridWidths.size()) {
                n2 = 0;
                boolean bl = false;
                int n3 = 1;
                while (n3 <= this.fGridWidths.size()) {
                    int n4 = Math.round(((Float)this.fColRatios.elementAt(n3 - 1)).floatValue() * (float)n);
                    if (n3 == this.fGridWidths.size() && (n2 += n4) != n) {
                        n4 += n - n2;
                    }
                    this.fGridWidths.setElementAt(new Integer(n4), n3 - 1);
                    ++n3;
                }
            }
        }
    }

    protected void calcRowHeights() {
        if (this.isAutoResizeRows() && (!this.fGrid.isAutoResizeRows() || this.isAutoResizeColumns())) {
            if (this.fGridHeights == null) {
                this.fGridHeights = new RunVector(this.fGrid.getNumRows(), 0);
            }
            int n = 1;
            while (n <= this.fGrid.getNumRows()) {
                int n2 = this.calcRowHeight(n);
                if (n2 != this.getRowHeight(n)) {
                    this.fGridHeights.setItemValue(n - 1, n2);
                }
                ++n;
            }
        }
    }

    protected int calcColRange(int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.getPrintRowHeaders() && this.fGrid.getRowHeaderWidth() > 0) {
            n3 += this.fGrid.getRowHeaderWidth();
        }
        int n4 = n;
        while (n4 <= this.fGrid.getNumCols()) {
            if (n3 + this.getColWidth(n4) > this.fPageArea.width) break;
            n3 += this.getColWidth(n4);
            n2 = n4++;
        }
        return n2;
    }

    protected int calcRowRange(int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.getPrintColHeaders() && this.fGrid.getColHeaderHeight() > 0) {
            n3 += this.fGrid.getColHeaderHeight();
        }
        int n4 = n;
        while (n4 <= this.fGrid.getNumRows()) {
            if (n3 + this.getRowHeight(n4) > this.fPageArea.height) break;
            n3 += this.getRowHeight(n4);
            n2 = n4++;
        }
        return n2;
    }

    public void printHeader(Graphics graphics, int n, Rectangle rectangle) {
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setFont(new Font("SansSerif", 0, 10));
        graphics.drawString(this.fTitle, rectangle.x + (rectangle.width - graphics.getFontMetrics().stringWidth(this.fTitle)) / 2, rectangle.y + graphics.getFontMetrics().getHeight());
    }

    public void printFooter(Graphics graphics, int n, Rectangle rectangle) {
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setFont(new Font("SansSerif", 0, 10));
        graphics.drawString("Page " + n, rectangle.x + (rectangle.width - graphics.getFontMetrics().stringWidth("Page " + n)) / 2, rectangle.y + rectangle.height - graphics.getFontMetrics().getMaxDescent());
    }

    public void printPage(Graphics graphics, int n, int n2, int n3, int n4, int n5, Rectangle rectangle) {
        int n6;
        int n7;
        this.fStartCell = new Point(n4, n2);
        this.fEndCell = new Point(n5, n3);
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.getPrintColHeaders()) {
            n7 = rectangle.x;
            if (this.getPrintRowHeaders()) {
                n7 += this.fGrid.getRowHeaderWidth();
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, this.fGrid.getRowHeaderWidth(), this.fGrid.getColHeaderHeight());
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                this.drawIntersection(graphics, rectangle2);
            }
            n6 = n4;
            while (n6 <= n5) {
                Rectangle rectangle3 = new Rectangle(n7, rectangle.y, this.getColWidth(n6), this.fGrid.getColHeaderHeight());
                this.drawHeaderCol(graphics, n6, rectangle3);
                n7 += this.getColWidth(n6);
                ++n6;
            }
        }
        n7 = rectangle.y;
        if (this.getPrintColHeaders()) {
            n7 += this.fGrid.getColHeaderHeight();
        }
        int n8 = n6 = this.fGrid.getFlags();
        if (this.fPrintRowLines != null) {
            n8 = this.fPrintRowLines.booleanValue() ? (n8 |= 0x100) : (n8 &= 0xFFFFFEFF);
        }
        if (this.fPrintColLines != null) {
            n8 = this.fPrintColLines.booleanValue() ? (n8 |= 0x200) : (n8 &= 0xFFFFFDFF);
        }
        this.fGrid.setFlags(n8, false);
        int n9 = n2;
        while (n9 <= n3) {
            int n10 = rectangle.x;
            if (this.getPrintRowHeaders()) {
                Rectangle rectangle4 = new Rectangle(rectangle.x, n7, this.fGrid.getRowHeaderWidth(), this.getRowHeight(n9));
                this.drawHeaderRow(graphics, n9, rectangle4);
                n10 += this.fGrid.getRowHeaderWidth();
            }
            int n11 = n4;
            while (n11 <= n5) {
                Rectangle rectangle5 = new Rectangle(n10, n7, this.getColWidth(n11), this.getRowHeight(n9));
                this.drawCell(graphics, new Point(n11, n9), rectangle5);
                if (this.getPrintColLines() && !this.getPrintRowHeaders() && n11 == n4) {
                    graphics.setColor(this.fGrid.getLineColor());
                    graphics.setClip(rectangle5.x - 1, rectangle5.y - 1, rectangle5.width + 1, rectangle5.height + 1);
                    graphics.drawLine(rectangle5.x - 1, rectangle5.y, rectangle5.x - 1, rectangle5.y + rectangle5.height);
                }
                if (this.getPrintRowLines() && !this.getPrintColHeaders() && n9 == n2) {
                    graphics.setColor(this.fGrid.getLineColor());
                    graphics.setClip(rectangle5.x - 1, rectangle5.y - 1, rectangle5.width + 1, rectangle5.height + 1);
                    if (this.getPrintColLines() && !this.getPrintRowHeaders()) {
                        graphics.drawLine(rectangle5.x - 1, rectangle5.y - 1, rectangle5.x + rectangle5.width + 1, rectangle5.y - 1);
                    } else {
                        graphics.drawLine(rectangle5.x, rectangle5.y - 1, rectangle5.x + rectangle5.width, rectangle5.y - 1);
                    }
                }
                n10 += this.getColWidth(n11);
                ++n11;
            }
            n7 += this.getRowHeight(n9);
            ++n9;
        }
        this.fGrid.setFlags(n6, false);
        graphics.setColor(Color.black);
        this.fStartCell = null;
        this.fEndCell = null;
    }

    public void drawIntersection(Graphics graphics, Rectangle rectangle) {
        this.fGrid.drawIntersection(graphics, rectangle);
        graphics.setClip(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
        graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x - 1, rectangle.y + rectangle.height + 1);
        graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x + rectangle.width + 1, rectangle.y - 1);
    }

    public void drawHeaderCol(Graphics graphics, int n, Rectangle rectangle) {
        this.fGrid.drawHeaderCol(graphics, n, rectangle);
        graphics.setClip(rectangle.x - 4, rectangle.y - 3, rectangle.width + 7, rectangle.height + 6);
        graphics.drawLine(rectangle.x - 3, rectangle.y - 3, rectangle.x + rectangle.width + 6, rectangle.y - 3);
        if (!this.getPrintRowHeaders() && n == this.fStartCell.x) {
            graphics.drawLine(rectangle.x - 4, rectangle.y - 3, rectangle.x - 4, rectangle.y + rectangle.height + 1);
        }
    }

    public void drawHeaderRow(Graphics graphics, int n, Rectangle rectangle) {
        this.fGrid.drawHeaderRow(graphics, n, rectangle);
        graphics.setClip(rectangle.x - 4, rectangle.y - 4, rectangle.width + 7, rectangle.height + 7);
        graphics.drawLine(rectangle.x - 4, rectangle.y - 3, rectangle.x - 4, rectangle.y + rectangle.height + 1);
        if (!this.getPrintColHeaders() && n == this.fStartCell.y) {
            graphics.drawLine(rectangle.x - 3, rectangle.y - 3, rectangle.x + rectangle.width + 6, rectangle.y - 3);
        }
    }

    public void drawCell(Graphics graphics, Point point, Rectangle rectangle) {
        this.fGrid.drawCell(graphics, point, rectangle, false);
    }
}

