/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import datarep.common.FlyoutHelpManager;
import datarep.common.Helpable;
import datarep.common.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.Vector;

public class ImageButton
extends Component
implements MouseListener,
AdjustmentListener,
FocusListener,
Helpable {
    private transient Image image;
    String label;
    String actionCommand;
    Vector actionListeners = new Vector(2, 1);
    int w;
    int h;
    boolean pushed = false;
    boolean hasFocus = false;
    private transient Image up;
    private transient Image down;
    boolean tryLoadingAsResource = false;
    String filename;

    public ImageButton() {
        FlyoutHelpManager.add(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.enableEvents(8L);
    }

    public ImageButton(String string) {
        this();
        this.setImage(string);
    }

    public ImageButton(File file) {
        this();
        this.setImage(file);
    }

    public ImageButton(URL uRL) {
        this();
        this.setImage(uRL);
    }

    public ImageButton(Image image) {
        this();
        this.setImage(image);
    }

    public ImageButton(String string, String string2) {
        this();
        this.setImage(string);
        this.setLabel(string2);
    }

    public ImageButton(File file, String string) {
        this();
        this.setImage(file);
        this.setLabel(string);
    }

    public ImageButton(URL uRL, String string) {
        this();
        this.setImage(uRL);
        this.setLabel(string);
    }

    public ImageButton(Image image, String string) {
        this();
        this.setImage(image);
        this.setLabel(string);
    }

    public void setImage(String string) {
        File file;
        try {
            file = new File(string);
            if (file.exists()) {
                this.image = this.getToolkit().getImage(file.getAbsolutePath());
                this.setupImage();
                return;
            }
        }
        catch (Exception exception) {}
        try {
            file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + string);
            if (file.exists()) {
                this.image = this.getToolkit().getImage(file.getAbsolutePath());
                this.setupImage();
                return;
            }
        }
        catch (Exception exception) {}
        this.tryLoadingAsResource = true;
        this.filename = string;
        this.setupImage();
    }

    public void setImage(URL uRL) {
        this.image = this.getToolkit().getImage(uRL);
        this.setupImage();
        this.tryLoadingAsResource = false;
    }

    public void setImage(File file) {
        this.image = this.getToolkit().getImage(file.getAbsolutePath());
        this.setupImage();
        this.tryLoadingAsResource = false;
    }

    public void setImage(Image image) {
        this.image = image;
        this.setupImage();
        this.tryLoadingAsResource = false;
    }

    private void setupImage() {
        if (this.image == null) {
            this.image = this.createImage(20, 20);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            return;
        }
        this.h = this.image.getHeight(this);
        this.w = this.image.getWidth(this);
        this.setSize(this.getPreferredSize());
        try {
            this.invalidate();
            this.getParent().validate();
            this.repaint();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        if (this.image == null) {
            this.setupImage();
        }
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().addAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().addAdjustmentListener(this);
        }
    }

    public void removeNotify() {
        Component component = this;
        while (component != null) {
            if (!((component = component.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)component).getHAdjustable().removeAdjustmentListener(this);
            ((ScrollPane)component).getVAdjustable().removeAdjustmentListener(this);
        }
        super.removeNotify();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }

    public void update(Graphics graphics) {
        if (this.tryLoadingAsResource) {
            try {
                URL uRL = Util.getTopPanel(this).getClass().getResource(this.filename);
                this.image = this.getToolkit().getImage(uRL);
                this.tryLoadingAsResource = false;
                this.setupImage();
            }
            catch (Exception exception) {}
        }
        super.update(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (!this.isEnabled()) {
            graphics.drawImage(this.image, (n - this.w) / 2, (n2 - this.h) / 2, this);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawRect(1, 1, n - 1, n2 - 2);
            graphics.setColor(this.getBackground().darker());
            graphics.drawRect(0, 0, n - 1, n2 - 2);
            return;
        }
        if (this.pushed) {
            graphics.drawImage(this.image, (n - this.w) / 2 + 2, (n2 - this.h) / 2 + 2, this);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(1, 1, n, 1);
            graphics.drawLine(1, 1, 1, n2);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            return;
        }
        graphics.drawImage(this.image, (n - this.w) / 2, (n2 - this.h) / 2, this);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(0, 0, n, 0);
        graphics.drawLine(0, 0, 0, n2);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(1, 1, n, 1);
        graphics.drawLine(1, 1, 1, n2);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
        graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
        if (this.hasFocus) {
            graphics.setXORMode(Color.white);
            graphics.drawRoundRect(2, 2, n - 5, n2 - 5, 5, 5);
            graphics.setPaintMode();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.w + 4, this.h + 4);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.w + 4, this.h + 4);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.pushed) {
            this.pushed = false;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.pushed) {
            this.postAction(mouseEvent.getModifiers());
        }
        this.pushed = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.pushed = true;
        this.requestFocus();
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
            this.postAction(keyEvent.getModifiers());
        }
    }

    private void postAction(int n) {
        int n2 = 0;
        while (n2 < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(n2)).actionPerformed(new ActionEvent(this, 1001, this.actionCommand, n));
            ++n2;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener != null && !this.actionListeners.contains(actionListener)) {
            this.actionListeners.addElement(actionListener);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListeners.removeElement(actionListener);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public String getHelpMessage() {
        return this.label;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }
}

