/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TemplateProcessor {
    Vector nodes;
    Hashtable replacement;
    boolean processed = false;

    public TemplateProcessor(File file) {
        this(file, null);
    }

    public TemplateProcessor(File file, Hashtable hashtable) {
        String string = "";
        try {
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            string = String.valueOf(cArray);
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Warning: File not found.");
        }
        catch (IOException iOException) {
            System.out.println("Warning: IO Exception.");
        }
        this.nodes = new Vector();
        this.nodes.addElement(new Node(string));
        this.replacement = hashtable;
    }

    public TemplateProcessor(String string) {
        this(string, null);
    }

    public TemplateProcessor(String string, Hashtable hashtable) {
        this.nodes = new Vector();
        this.nodes.addElement(new Node(string, false));
        this.replacement = hashtable;
    }

    private void process() {
        if (this.replacement == null) {
            return;
        }
        Enumeration enumeration = this.replacement.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.replacement.get(string);
            int n = 0;
            while (n < this.nodes.size()) {
                Node node = (Node)this.nodes.elementAt(n);
                int n2 = node.indexOf(string);
                if (n2 >= 0) {
                    Node node2 = new Node(node.getString().substring(0, n2));
                    Node node3 = new Node(string2, true);
                    int n3 = n2 + string.length();
                    Node node4 = new Node(node.getString().substring(n3));
                    this.nodes.removeElementAt(n);
                    this.nodes.insertElementAt(node4, n);
                    this.nodes.insertElementAt(node3, n);
                    this.nodes.insertElementAt(node2, n);
                    ++n;
                }
                ++n;
            }
        }
        this.processed = true;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    private String generateString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    public String getProcessedString() {
        if (!this.isProcessed()) {
            this.process();
        }
        return this.generateString();
    }

    public void addValue(String string, String string2) {
        this.processed = false;
        if (this.replacement == null) {
            this.replacement = new Hashtable();
        }
        this.replacement.put(string, string2);
    }

    public void setReplacement(Hashtable hashtable) {
        this.processed = false;
        this.replacement = hashtable;
    }

    public Hashtable getReplacement() {
        return this.replacement;
    }

    public static void main(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("$A", "Apple");
        hashtable.put("$O", "Orange");
        hashtable.put("$C", "Compar");
        hashtable.put("you ", "you should be ");
        hashtable.put("$he", "he said");
        hashtable.put("$J", "juice");
        String string = "But, Sir, $he, you're $Cing $As to $Os, when you $Cing $O$J to $A$J. You ashamed to work at $O";
        System.out.println("original string: " + string);
        TemplateProcessor templateProcessor = new TemplateProcessor(string, hashtable);
        hashtable.put("Sir", "Ma'am");
        hashtable.put("to work at", "to eat an");
        hashtable.put("You ", "You should be ");
        System.out.println(templateProcessor.getProcessedString());
        String string2 = "There are five $As here: $A and $Asauce, $O pre$A and embedded$A. And another $O";
        TemplateProcessor templateProcessor2 = new TemplateProcessor(string2, hashtable);
        System.out.println(templateProcessor2.getProcessedString());
    }

    class Node {
        String s;
        boolean locked = false;

        public Node(String string) {
            TemplateProcessor.this = TemplateProcessor.this;
            this.s = string;
        }

        public Node(String string, boolean bl) {
            this(string);
            this.setLocked(bl);
        }

        public void setLocked(boolean bl) {
            this.locked = bl;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public String getString() {
            return this.s;
        }

        public String toString() {
            return this.s;
        }

        int indexOf(String string) {
            if (this.locked) {
                return -1;
            }
            return this.s.indexOf(string);
        }
    }
}

