/*
 * Decompiled with CFR 0.152.
 */
package datarep.common.database;

import datarep.common.database.ActionMapping;
import datarep.common.database.ColumnMapping;
import datarep.common.database.Command;
import datarep.common.database.Mapping;
import datarep.common.database.Query;
import datarep.common.database.QueryList;
import datarep.common.database.SelectionMapping;
import java.awt.Choice;
import java.awt.Component;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DatabaseManager
implements Runnable {
    public static final String EXECUTE = "< Execute Statement >";
    public static final String FIRST = "< Goto First Record >";
    public static final String LAST = "< Goto Last Record >";
    public static final String NEXT = "< Goto Next Record >";
    public static final String PREVIOUS = "< Goto Previous Record >";
    public static final String ROWSELECTION = "< Goto Specific Record >";
    public static final String CLEAR = "< Clear All Fields >";
    public static final String OPEN = "< Open Connection >";
    public static final String CLOSE = "< Close Connection >";
    public static final String COMMIT = "< Commit Changes >";
    public static final String ROLLBACK = "< Rollback Changes >";
    String driverString;
    String url;
    boolean readonly = false;
    boolean autocommit = true;
    private Driver driver;
    private Connection connection;
    QueryList queryList = new QueryList();
    Vector itemParts = new Vector();
    Vector actionParts = new Vector();
    Vector commandQueue = new Vector();
    private Properties properties = new Properties();
    private Hashtable substitutes = new Hashtable();
    private SelectionCommandListener selectionCommandListener = new SelectionCommandListener();
    private ActionCommandListener actionCommandListener = new ActionCommandListener();
    private boolean busy = false;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public DatabaseManager(String string, String string2) {
        this.driverString = string;
        this.url = string2;
        new Thread(this).start();
    }

    public void setReadOnly(boolean bl) {
        this.readonly = bl;
    }

    public void setAutoCommit(boolean bl) {
        this.autocommit = bl;
    }

    public void addProperty(String string, String string2) {
        ((Hashtable)this.properties).put(string, string2);
    }

    public void addProperty(String string, Component component) {
        this.substitutes.put(string, component);
    }

    public void addQuery(String string, String string2) {
        Query query = new Query();
        query.name = string;
        query.sql = string2;
        this.queryList.addQuery(query);
    }

    public void addMapping(String string, String string2, Component component) {
        Query query = this.queryList.getQuery(string);
        if (query == null) {
            return;
        }
        Mapping mapping = query.addMapping(string2, component);
        if (mapping instanceof ActionMapping && !this.actionParts.contains(component)) {
            try {
                this.actionParts.addElement(component);
                Method method = component.getClass().getMethod("addActionListener", class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = DatabaseManager.class$("java.awt.event.ActionListener")));
                method.invoke((Object)component, this.actionCommandListener);
                return;
            }
            catch (Exception exception) {}
        }
        if (mapping instanceof SelectionMapping && !this.itemParts.contains(component)) {
            this.itemParts.addElement(component);
            if (component instanceof List) {
                ((List)component).addItemListener(this.selectionCommandListener);
                return;
            }
            if (component instanceof Choice) {
                ((Choice)component).addItemListener(this.selectionCommandListener);
                return;
            }
            if (component instanceof JComboBox) {
                ((JComboBox)component).addActionListener(this.selectionCommandListener);
                return;
            }
            if (component instanceof JList) {
                ((JList)component).addListSelectionListener(this.selectionCommandListener);
                return;
            }
            if (component instanceof JTable) {
                ((JTable)component).getSelectionModel().addListSelectionListener(this.selectionCommandListener);
            }
        }
    }

    public void run() {
        while (true) {
            Object object;
            if (!this.commandQueue.isEmpty()) {
                this.busy = true;
                try {
                    object = (Command)this.commandQueue.elementAt(0);
                    this.commandQueue.removeElementAt(0);
                    if (((Command)object).command.equals(EXECUTE)) {
                        this.processExecute(((Command)object).query);
                    } else if (((Command)object).command.equals(ROWSELECTION)) {
                        this.processGotoRow(((Command)object).query, ((Command)object).row);
                    } else if (((Command)object).command.equals(FIRST)) {
                        this.processFirst(((Command)object).query);
                    } else if (((Command)object).command.equals(LAST)) {
                        this.processLast(((Command)object).query);
                    } else if (((Command)object).command.equals(NEXT)) {
                        this.processNext(((Command)object).query);
                    } else if (((Command)object).command.equals(PREVIOUS)) {
                        this.processPrevious(((Command)object).query);
                    } else if (((Command)object).command.equals(CLEAR)) {
                        this.clear(((Command)object).query);
                    } else if (((Command)object).command.equals(OPEN)) {
                        this.open();
                    } else if (((Command)object).command.equals(CLOSE)) {
                        this.close();
                    } else if (((Command)object).command.equals(COMMIT)) {
                        this.commit();
                    } else if (((Command)object).command.equals(ROLLBACK)) {
                        this.rollback();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.busy = false;
                continue;
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void postCommand(Command command) {
        if (this.busy) {
            return;
        }
        this.commandQueue.addElement(command);
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            this.notify();
            return;
        }
    }

    public void openConnection() {
        this.postCommand(new Command(OPEN));
    }

    public void closeConnection() {
        this.postCommand(new Command(CLOSE));
    }

    private Properties createProperties() {
        Properties properties = (Properties)((Hashtable)this.properties).clone();
        Enumeration enumeration = this.substitutes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Mapping mapping = new Mapping();
            mapping.component = (Component)this.substitutes.get(string);
            ((Hashtable)properties).put(string, mapping.getText());
        }
        return properties;
    }

    private void open() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {}
        try {
            Class.forName(this.driverString).newInstance();
        }
        catch (Exception exception) {
            this.error("Could not load JDBC driver: " + this.driverString);
        }
        try {
            this.connection = DriverManager.getConnection(this.url, this.createProperties());
            if (this.connection == null) {
                this.error("Could not connect to " + this.url);
                return;
            }
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
            return;
        }
        try {
            this.connection.setReadOnly(this.readonly);
        }
        catch (SQLException sQLException) {
            this.error(sQLException.getMessage());
        }
        try {
            this.connection.setAutoCommit(this.autocommit);
            return;
        }
        catch (SQLException sQLException) {
            this.error(sQLException.getMessage());
            return;
        }
    }

    private void close() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
        }
        this.connection = null;
    }

    public void dispose() {
        this.closeConnection();
        this.removeAllMappings();
    }

    public void removeAllMappings() {
        Enumeration enumeration = this.actionParts.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Object e = enumeration.nextElement();
                Method method = e.getClass().getMethod("removeActionListener", class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : DatabaseManager.class$("java.awt.event.ActionListener"));
                method.invoke(e, this);
            }
            catch (Exception exception) {}
        }
        this.itemParts.removeAllElements();
        this.actionParts.removeAllElements();
        ((Hashtable)this.properties).clear();
        this.substitutes.clear();
        this.queryList.removeAllElements();
    }

    private void commit() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.commit();
            return;
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
            return;
        }
    }

    private void rollback() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.rollback();
            return;
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
            return;
        }
    }

    public void error(String string) {
        if (string != null && !string.trim().equals("")) {
            System.out.println(string);
        }
    }

    private void processExecute(Query query) {
        Statement statement = null;
        try {
            if (this.connection == null || this.connection.isClosed()) {
                throw new Exception("Database connection is closed");
            }
            if (query.sql == null) {
                throw new Exception("Empty SQL statement");
            }
            this.clear(query);
            statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query.getModifiedQuery());
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            query.columnNames = new String[n];
            int n2 = 0;
            while (n2 < n) {
                query.columnNames[n2] = resultSetMetaData.getColumnName(n2 + 1);
                ++n2;
            }
            Vector<String[]> vector = new Vector<String[]>();
            while (resultSet.next()) {
                String[] stringArray = new String[n];
                int n3 = 0;
                while (n3 < n) {
                    stringArray[n3] = resultSet.getString(n3 + 1);
                    ++n3;
                }
                vector.addElement(stringArray);
            }
            query.data = new String[vector.size()][];
            vector.copyInto((Object[])query.data);
            query.adjustColumnNumbers();
            this.processFirst(query);
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
            query.data = null;
            query.columnNames = null;
            this.clear(query);
        }
        try {
            statement.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void processFirst(Query query) {
        if (query.data == null) {
            return;
        }
        query.row = 0;
        this.displayData(query);
    }

    private void processLast(Query query) {
        if (query.data == null) {
            return;
        }
        query.row = query.data.length - 1;
        this.displayData(query);
    }

    private void processNext(Query query) {
        if (query.data == null) {
            return;
        }
        ++query.row;
        if (query.row > query.data.length - 1) {
            query.row = query.data.length - 1;
        }
        this.displayData(query);
    }

    private void processPrevious(Query query) {
        if (query.data == null) {
            return;
        }
        --query.row;
        if (query.row < 0) {
            query.row = 0;
        }
        this.displayData(query);
    }

    private void processGotoRow(Query query, int n) {
        if (query.data == null) {
            return;
        }
        if (n < 0 || n >= query.data.length) {
            return;
        }
        query.row = n;
        this.displayData(query);
    }

    private void clear(Query query) {
        Enumeration enumeration = query.mappings.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ColumnMapping)) continue;
            ((ColumnMapping)e).clearText();
        }
    }

    private void displayData(Query query) {
        if (query.data == null) {
            return;
        }
        Enumeration enumeration = query.mappings.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ColumnMapping)) continue;
            ((ColumnMapping)e).setText(query, query.row, ((ColumnMapping)e).column);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SelectionCommandListener
    implements ItemListener,
    ActionListener,
    ListSelectionListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            this.rowSelected(itemEvent.getSource());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.rowSelected(listSelectionEvent.getSource());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.rowSelected(actionEvent.getSource());
        }

        private void rowSelected(Object object) {
            Enumeration enumeration = DatabaseManager.this.queryList.elements();
            while (enumeration.hasMoreElements()) {
                Query query = (Query)enumeration.nextElement();
                Enumeration enumeration2 = query.mappings.elements();
                while (enumeration2.hasMoreElements()) {
                    Object e = enumeration2.nextElement();
                    if (!(e instanceof SelectionMapping)) continue;
                    if (((SelectionMapping)e).component == object) {
                        DatabaseManager.this.postCommand(new Command(query, ((SelectionMapping)e).name, ((SelectionMapping)e).getSelectedRow()));
                    }
                    if (!(((SelectionMapping)e).component instanceof JTable) || ((JTable)((SelectionMapping)e).component).getSelectionModel() != object) continue;
                    DatabaseManager.this.postCommand(new Command(query, ((SelectionMapping)e).name, ((SelectionMapping)e).getSelectedRow()));
                }
            }
        }

        SelectionCommandListener() {
            DatabaseManager.this = DatabaseManager.this;
        }
    }

    class ActionCommandListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Enumeration enumeration = DatabaseManager.this.queryList.elements();
            while (enumeration.hasMoreElements()) {
                Query query = (Query)enumeration.nextElement();
                Enumeration enumeration2 = query.mappings.elements();
                while (enumeration2.hasMoreElements()) {
                    Object e = enumeration2.nextElement();
                    if (!(e instanceof ActionMapping) || ((ActionMapping)e).component != actionEvent.getSource()) continue;
                    DatabaseManager.this.postCommand(new Command(query, ((ActionMapping)e).name));
                }
            }
        }

        ActionCommandListener() {
            DatabaseManager.this = DatabaseManager.this;
        }
    }
}

