/*
 * Decompiled with CFR 0.152.
 */
package norman.ndf;

import java.io.FileNotFoundException;
import norman.ndf.BlockNotFoundException;

public class NDFFile {
    public static final int ACCESS_READWRITE = 4096;
    public static final int ACCESS_READONLY = 8192;
    public static final int ACCESS_NONE = 12288;
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_NVCTASK = 1;
    public static final int TYPE_NVCCONFIG = 2;
    public static final int TYPE_NVCOEMCONFIG = 3;
    public static final int TYPE_NVCDESCRIPTION = 4;
    public static final int TYPE_NVCSTATE = 5;
    public static final int TYPE_FB4X_LOCALINFO = 6;
    public static final int TYPE_FBCONFIG = 7;
    private int fileHandle;
    private String fileName;

    public NDFFile() {
        this.fileHandle = 0;
        this.fileName = null;
    }

    public NDFFile(int handle, String name) {
        this.fileHandle = handle;
        this.fileName = name;
    }

    public native byte[] readBlock(String var1, int var2) throws FileNotFoundException, BlockNotFoundException;

    public native void writeBlock(String var1, int var2, byte[] var3) throws FileNotFoundException;

    public native void deleteBlock(String var1) throws FileNotFoundException, BlockNotFoundException;

    public native boolean testFileType(int var1) throws FileNotFoundException;

    public native void createFile(int var1);

    public static void main(String[] args) {
        NDFFile myNdf = new NDFFile(0, "d:\\apps\\norman\\nvc\\config\\nvccf.ndf");
        System.out.println("readBlock(Scanning)");
        try {
            byte[] myByteArray = myNdf.readBlock("Scanning", 0);
            int i = 0;
            while (i < myByteArray.length) {
                System.out.print("  " + Byte.toString(myByteArray[i]));
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found");
        }
        catch (BlockNotFoundException blockNotFoundException) {
            System.out.println("Block not found");
        }
    }

    static {
        System.loadLibrary("NJNI");
    }
}

