/*
 * Decompiled with CFR 0.152.
 */
package norman.nplg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.StringTokenizer;

public class NIcon
extends Component
implements ImageObserver {
    Image myImage;
    String myLabel;
    Thread sizeThread;
    Thread paintThread;
    int waitFlags;
    static int WAIT_SIZE = 1;
    static int WAIT_BITS = 2;

    NIcon() {
        this.setFont(Font.decode("Dialog"));
    }

    NIcon(Image img, String label) {
        this.myImage = img;
        this.myLabel = label;
        this.setFont(Font.decode("Dialog"));
    }

    NIcon(String filename, String label) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.myImage = tk.getImage(filename);
        this.myLabel = label;
        this.setFont(Font.decode("Dialog"));
    }

    NIcon(URL url, String label) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.myImage = tk.getImage(url);
        this.myLabel = label;
        this.setFont(Font.decode("Dialog"));
    }

    public synchronized Dimension getPreferredSize() {
        int width;
        int height = this.myImage.getHeight(this);
        if (height == -1) {
            this.sizeThread = Thread.currentThread();
            this.waitFlags += WAIT_SIZE;
            this.sizeThread.suspend();
            this.waitFlags -= WAIT_SIZE;
            height = this.myImage.getHeight(this);
        }
        if ((width = this.myImage.getWidth(this)) == -1) {
            this.sizeThread = Thread.currentThread();
            this.waitFlags += WAIT_SIZE;
            this.sizeThread.suspend();
            this.waitFlags -= WAIT_SIZE;
            width = this.myImage.getWidth(this);
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        StringTokenizer strtok = new StringTokenizer(this.myLabel, "\n");
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            int txtWidth = fm.stringWidth(token);
            height += fm.getHeight();
            if (txtWidth <= width) continue;
            width = txtWidth;
        }
        return new Dimension(width, height);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getName() {
        return this.myLabel;
    }

    public boolean contains(int x, int y) {
        Dimension myDim = this.getSize();
        return x > 0 && y > 0 && x < myDim.width && y < myDim.height;
    }

    public synchronized void paint(Graphics g) {
        Dimension dim = this.getSize();
        Rectangle myRect = this.getBounds();
        if (!g.drawImage(this.myImage, (dim.width - this.myImage.getWidth(this)) / 2, myRect.y, this.getBackground(), this)) {
            this.paintThread = Thread.currentThread();
            this.waitFlags += WAIT_BITS;
            this.paintThread.suspend();
            this.waitFlags -= WAIT_BITS;
            g.drawImage(this.myImage, (dim.width - this.myImage.getWidth(this)) / 2, myRect.y, this.getBackground(), this);
        }
        FontMetrics fm = g.getFontMetrics();
        StringTokenizer strtok = new StringTokenizer(this.myLabel, "\n");
        int y = myRect.y + dim.height - strtok.countTokens() * fm.getHeight() + fm.getAscent();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            g.drawString(token, (dim.width - fm.stringWidth(token)) / 2, y);
            y += fm.getHeight();
        }
    }

    public boolean imageUpdate(Image img, int infoFlags, int x, int y, int width, int height) {
        boolean rc = true;
        if ((this.waitFlags & WAIT_BITS) != 0 && (infoFlags & 0x20) != 0) {
            this.paintThread.resume();
        }
        if ((this.waitFlags & WAIT_SIZE) != 0 && (infoFlags & 1) != 0 && (infoFlags & 2) != 0) {
            this.sizeThread.resume();
        }
        return rc;
    }
}

