/*
 * Decompiled with CFR 0.152.
 */
package norman.nplg;

import datarep.common.TabbedCardPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import norman.NSystem;
import norman.nplg.NIcon;
import norman.nplg.NPage;
import norman.nplg.NPluginErr;
import norman.nplg.NPluginHost;

public abstract class NPlugin
extends TabbedCardPanel {
    public NPluginHost myHost;
    private NIcon myIcon;
    private String myName = "Default Plugin";
    private String myIconFile = "Plugin.gif";
    private String myHelpPanel = "Plugin Help";

    public int createPlugin(NPluginHost host) {
        int numberOfPages = this.getNumberOfPages();
        this.myHost = host;
        int i = 0;
        while (i < numberOfPages) {
            NPage p = this.createPage(i);
            this.add((Component)p, p.getName());
            ++i;
        }
        return NPluginErr.OK;
    }

    public abstract NPage createPage(int var1);

    public abstract int getPluginType();

    public abstract int getLoadOrder();

    public abstract int getNumberOfPages();

    public boolean getModified() {
        int pages = this.getComponentCount();
        boolean bool = false;
        int i = 0;
        while (!bool && i < pages) {
            NPage myPage = (NPage)this.getComponent(i);
            bool = myPage.getModified();
            ++i;
        }
        return bool;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public NIcon getIcon() {
        return this.myIcon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIcon(String iconFile, String name) {
        ZipFile pluginJar = null;
        String className = this.getClass().getName();
        int startPos = className.indexOf(32) + 1;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            try {
                pluginJar = new ZipFile(String.valueOf(NSystem.queryNormanPath(NSystem.NPATH_NVC_BIN)) + File.separator + className.substring(startPos) + ".plg");
                ZipEntry entry = pluginJar.getEntry(iconFile);
                InputStream input = pluginJar.getInputStream(entry);
                int imgSize = (int)entry.getSize();
                if (imgSize > 0) {
                    byte[] imgData = new byte[imgSize];
                    input.read(imgData, 0, imgSize);
                    this.myIcon = new NIcon(tk.createImage(imgData), name);
                }
            }
            catch (IOException e) {
                System.out.println("NPlugin: " + e);
            }
            Object var12_12 = null;
            if (pluginJar == null) return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (pluginJar == null) throw throwable;
            try {
                pluginJar.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            pluginJar.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public String getIconFile() {
        return this.myIconFile;
    }

    public void setIconFile(String fileName) {
        this.myIconFile = fileName;
    }

    public String getHelp() {
        return this.myHelpPanel;
    }

    public void setHelp(String helpPanel) {
        this.myHelpPanel = helpPanel;
    }

    public Dimension getPreferredSize() {
        int numComponents = this.getComponentCount();
        int cx = 0;
        int cy = 0;
        int i = 0;
        while (i < numComponents) {
            Container comp = (Container)this.getComponent(i);
            LayoutManager layout = comp.getLayout();
            Dimension d = layout.preferredLayoutSize(comp);
            if (d.width > cx) {
                cx = d.width;
            }
            if (d.height > cy) {
                cy = d.height;
            }
            ++i;
        }
        Insets insets = this.getInsets();
        return new Dimension(cx + insets.left + insets.right, cy + insets.top + insets.bottom);
    }

    public void initPlugin() {
        this.setIcon(this.myIconFile, this.myName);
    }

    public void newFile() {
        int pages = this.getComponentCount();
        int i = 0;
        while (i < pages) {
            NPage myPage = (NPage)this.getComponent(i);
            myPage.reset(-1);
            ++i;
        }
    }

    public void openFile(File file, InputStream stream) {
        int pages = this.getComponentCount();
        int i = 0;
        while (i < pages) {
            NPage myPage = (NPage)this.getComponent(i);
            myPage.openFile(file, stream);
            ++i;
        }
    }

    public void postOpenFile() {
        int pages = this.getComponentCount();
        int i = 0;
        while (i < pages) {
            NPage myPage = (NPage)this.getComponent(i);
            myPage.postOpenFile();
            ++i;
        }
    }

    public void postSaveFile() {
        int pages = this.getComponentCount();
        int i = 0;
        while (i < pages) {
            NPage myPage = (NPage)this.getComponent(i);
            myPage.postSaveFile();
            ++i;
        }
    }

    public void preOpenFile() {
        int pages = this.getComponentCount();
        int i = 0;
        while (i < pages) {
            NPage myPage = (NPage)this.getComponent(i);
            myPage.preOpenFile();
            ++i;
        }
    }

    public void preSaveFile() {
        int pages = this.getComponentCount();
        int i = 0;
        while (i < pages) {
            NPage myPage = (NPage)this.getComponent(i);
            myPage.preSaveFile();
            ++i;
        }
    }

    public void saveFile(File file, OutputStream stream) {
        int pages = this.getComponentCount();
        int i = 0;
        while (i < pages) {
            NPage myPage = (NPage)this.getComponent(i);
            myPage.saveFile(file, stream);
            ++i;
        }
    }
}

