/*
 * Decompiled with CFR 0.152.
 */
package norman.nplg;

import CoffeeTable.Grid.GridAdapter;
import CoffeeTable.Grid.GridEvent;
import CoffeeTable.Grid.GridPanel;
import datarep.common.MessageBox;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import norman.NSystem;
import norman.nplg.NClassLoader;
import norman.nplg.NIcon;
import norman.nplg.NPlugin;
import norman.nplg.NStackedLayout;

public class NPluginHost
extends Frame
implements WindowListener,
FilenameFilter,
ActionListener {
    Button closeButton;
    Button saveButton;
    Button helpButton;
    Panel buttonPanel;
    IconPanel iconPanel;
    Panel cardPanel;
    Vector pluginList;
    String pluginMask = "Test";
    int pluginType = 1;
    int i;

    public NPluginHost(String title) {
        super(title);
        ((Component)this).setSize(600, 500);
        this.setResizable(false);
        ((Component)this).setBackground(SystemColor.control);
        this.buttonPanel = new Panel(new NStackedLayout(2, true));
        this.iconPanel = new IconPanel();
        this.iconPanel.addGridListener(new GridHandler());
        this.cardPanel = new Panel(new CardLayout());
        this.closeButton = new Button("Close");
        this.saveButton = new Button("Save...");
        this.helpButton = new Button("Help");
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.helpButton);
        this.add((Component)this.buttonPanel, "East");
        this.add((Component)this.iconPanel, "West");
        this.add((Component)this.cardPanel, "Center");
        this.add((Component)new Label("\u00a9 2000 Norman ASA"), "South");
        this.addWindowListener(this);
        this.closeButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.pluginList = new Vector();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenDim = tk.getScreenSize();
        Rectangle myRect = this.getBounds();
        myRect.x = (screenDim.width - myRect.width) / 2;
        myRect.y = (screenDim.height - myRect.height) / 2;
        ((Component)this).setBounds(myRect);
    }

    public void loadPlugins(String fileStem, int pluginType) {
        NClassLoader myLoader = new NClassLoader();
        this.pluginMask = fileStem;
        File myDirectory = new File(String.valueOf(NSystem.queryNormanPath(NSystem.NPATH_NVC_BIN)) + "\\");
        String[] fileList = myDirectory.list(this);
        int i = 0;
        while (i < fileList.length) {
            fileList[i] = fileList[i].substring(0, fileList[i].indexOf(".plg"));
            try {
                Class pluginClass = myLoader.loadClass(fileList[i]);
                NPlugin newPlugin = (NPlugin)pluginClass.newInstance();
                if (newPlugin.getPluginType() == pluginType) {
                    this.addPlugin(newPlugin);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (NoSuchMethodError noSuchMethodError) {}
            ++i;
        }
    }

    public void createPlugins() {
        NPlugin myPlugin;
        int i = 0;
        while (i < this.pluginList.size()) {
            myPlugin = (NPlugin)this.pluginList.elementAt(i);
            myPlugin.createPlugin(this);
            ++i;
        }
        if (this.pluginList.size() == 1) {
            this.remove(this.iconPanel);
        }
        i = 0;
        while (i < this.pluginList.size()) {
            myPlugin = (NPlugin)this.pluginList.elementAt(i);
            myPlugin.initPlugin();
            NIcon myIcon = myPlugin.getIcon();
            this.iconPanel.insertRow(i + 1);
            this.iconPanel.setCellData(1, i + 1, myIcon, true);
            this.iconPanel.setRowHeight(i, myIcon.getPreferredSize().height + 2 * this.iconPanel.getCellInset().y, true, false);
            this.cardPanel.add((Component)myPlugin, myIcon.getName());
            ++i;
        }
        this.iconPanel.setSize(this.iconPanel.getColWidth(1), this.iconPanel.getSize().width);
        this.iconPanel.selectRow(1, false);
    }

    public void destroyPlugins() {
    }

    public void addPlugin(NPlugin plugin) {
        int i = 0;
        int nPlugins = this.pluginList.size();
        boolean bDone = false;
        while (i < nPlugins && !bDone) {
            NPlugin entry = (NPlugin)this.pluginList.elementAt(i);
            if (entry.getLoadOrder() > plugin.getLoadOrder()) {
                this.pluginList.insertElementAt(plugin, i);
                bDone = true;
            }
            ++i;
        }
        if (!bDone) {
            this.pluginList.addElement(plugin);
        }
    }

    public int getNumberOfPlugins() {
        return this.pluginList.size();
    }

    public NPlugin getPlugin(int n) {
        return (NPlugin)this.pluginList.elementAt(n);
    }

    public Insets getInsets() {
        Insets myInsets = super.getInsets();
        myInsets.left += 5;
        myInsets.right += 5;
        myInsets.top += 5;
        return myInsets;
    }

    public Dimension getPreferredSize() {
        int cx = 0;
        int cy = 0;
        int i = 0;
        while (i < this.pluginList.size()) {
            NPlugin myPlugin = (NPlugin)this.pluginList.elementAt(i);
            Dimension d = myPlugin.getPreferredSize();
            if (d.width > cx) {
                cx = d.width;
            }
            if (d.height > cy) {
                cy = d.height;
            }
            ++i;
        }
        Dimension iconSize = this.iconPanel.getSize();
        Dimension buttonSize = this.buttonPanel.getPreferredSize();
        return new Dimension(cx + iconSize.width + buttonSize.width, cy);
    }

    public Frame getFrame() {
        return this;
    }

    public boolean getModified() {
        int i = 0;
        while (i < this.pluginList.size()) {
            NPlugin myPlugin = (NPlugin)this.pluginList.elementAt(i);
            if (myPlugin.getModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void newFile() {
        int i = 0;
        while (i < this.pluginList.size()) {
            NPlugin myPlugin = (NPlugin)this.pluginList.elementAt(i);
            myPlugin.newFile();
            ++i;
        }
    }

    public void openFile(File file, InputStream stream) {
        int numberOfPlugins = this.getNumberOfPlugins();
        if (file.exists()) {
            NPlugin myPlugin;
            int i = 0;
            while (i < numberOfPlugins) {
                myPlugin = this.getPlugin(i);
                myPlugin.preOpenFile();
                ++i;
            }
            i = 0;
            while (i < numberOfPlugins) {
                myPlugin = this.getPlugin(i);
                myPlugin.openFile(file, stream);
                ++i;
            }
            i = 0;
            while (i < numberOfPlugins) {
                myPlugin = this.getPlugin(i);
                myPlugin.postOpenFile();
                ++i;
            }
        } else {
            int i = 0;
            while (i < numberOfPlugins) {
                NPlugin myPlugin = this.getPlugin(i);
                myPlugin.newFile();
                ++i;
            }
        }
    }

    public void saveFile(File file, OutputStream stream) {
        NPlugin myPlugin;
        int pluginCount = this.getNumberOfPlugins();
        int i = 0;
        while (i < pluginCount) {
            myPlugin = (NPlugin)this.pluginList.elementAt(i);
            myPlugin.preSaveFile();
            ++i;
        }
        i = 0;
        while (i < pluginCount) {
            myPlugin = (NPlugin)this.pluginList.elementAt(i);
            myPlugin.saveFile(file, null);
            ++i;
        }
        i = 0;
        while (i < pluginCount) {
            myPlugin = (NPlugin)this.pluginList.elementAt(i);
            myPlugin.postSaveFile();
            ++i;
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.destroyPlugins();
    }

    public void windowClosed(WindowEvent e) {
        System.exit(0);
    }

    public void actionPerformed(ActionEvent e) {
        boolean modified = false;
        Object src = e.getSource();
        if (src == this.closeButton) {
            this.destroyPlugins();
        } else if (src == this.helpButton) {
            String[] buttonArray = new String[]{"", "OK"};
            Runtime rt = Runtime.getRuntime();
            try {
                rt.exec("view.exe " + NSystem.queryNormanPath(NSystem.NPATH_NVC_BIN) + "\\nvcecs.inf Configuration editor");
            }
            catch (IOException iOException) {
                MessageBox msgBox = new MessageBox(this.getFrame(), "No help", "Help is not available for this application.", buttonArray);
            }
        } else if (src == this.saveButton) {
            this.saveFile(null, null);
        }
    }

    public boolean accept(File dir, String name) {
        return name.indexOf(this.pluginMask) >= 0 && name.indexOf(".plg") > 0;
    }

    class IconPanel
    extends GridPanel {
        public IconPanel() {
            NPluginHost.this = NPluginHost.this;
            this.setFlags(2);
            this.setColHeaderHeight(0, false);
            this.setRowHeaderWidth(0, false);
            this.setNumCols(1);
            this.setHScrollbarDisplayPolicy(2);
            this.setCellInset(new Point(5, 5));
            this.setAutoResizeColumns(true);
        }

        public void drawCell(Graphics g, Point cell, Rectangle aRect, boolean highlight) {
            NIcon myComp = (NIcon)this.getCellData(cell.x, cell.y);
            Point inset = this.getCellInset();
            if (highlight) {
                g.setColor(this.getHighlightColor());
                g.fillRect(aRect.x, aRect.y, aRect.width, aRect.height);
                g.setColor(this.getHighlightTextColor());
            } else {
                g.setColor(this.getGridBackground());
                g.fillRect(aRect.x, aRect.y, aRect.width, aRect.height);
                g.setColor(this.getGridTextColor());
            }
            aRect.y += inset.y;
            aRect.height -= 2 * inset.y;
            myComp.setBounds(aRect);
            ((Component)myComp).paint(g);
        }
    }

    class GridHandler
    extends GridAdapter {
        public void gridSelChanged(GridEvent e) {
            NIcon myIcon;
            GridPanel myGrid = (GridPanel)e.getSource();
            int row = myGrid.getFirstSelectedRow();
            if (row != 0 && (myIcon = (NIcon)NPluginHost.this.iconPanel.getCellData(1, row)) != null) {
                CardLayout myLayout = (CardLayout)NPluginHost.this.cardPanel.getLayout();
                myLayout.show(NPluginHost.this.cardPanel, myIcon.getName());
            }
        }

        GridHandler() {
            NPluginHost.this = NPluginHost.this;
        }
    }
}

